/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.actions.newFile;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.DialogUtil;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.cidr.lang.CidrLangBundle;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCUsageTriggerCollector;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileHelperUtil;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileLangBackendHandlerProvider;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileWithSelectedExtensionAction;
import com.jetbrains.cidr.lang.settings.FileExtensionPair;
import com.jetbrains.cidr.lang.settings.NamingConventionStyle;
import icons.CidrLangIcons;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.annotations.VisibleForTesting;

public class OCNewCppClassAction
extends OCNewFileWithSelectedExtensionAction<MyCreateClassDialog> {
    @NonNls
    protected static final String NAMESPACES_OPEN_PROPERTY = "NAMESPACES_OPEN";
    @NonNls
    protected static final String NAMESPACES_CLOSE_PROPERTY = "NAMESPACES_CLOSE";
    @NonNls
    protected static final String NAMESPACES_OPEN_CPP_PROPERTY = "NAMESPACES_OPEN_CPP";
    @NonNls
    protected static final String NAMESPACES_CLOSE_CPP_PROPERTY = "NAMESPACES_CLOSE_CPP";
    @Nullable
    private final String myDefaultNamespaceOpenText;
    @NonNls
    protected Ref<String> myEnclosingNamespace = new Ref((Object)"");

    public OCNewCppClassAction() {
        super((FileType)OCNewFileLangBackendHandlerProvider.getHandler().getFileType(), CidrLangBundle.message("create.cpp.class.title", new Object[0]), CidrLangBundle.message("create.cpp.class.description", new Object[0]), CidrLangIcons.CodeAssistantStruct);
        this.myDefaultNamespaceOpenText = null;
    }

    public OCNewCppClassAction(@Nullable String namespaceOpenText) {
        super((FileType)OCNewFileLangBackendHandlerProvider.getHandler().getFileType(), CidrLangBundle.message("create.cpp.class.title", new Object[0]), CidrLangBundle.message("create.cpp.class.description", new Object[0]), CidrLangIcons.CodeAssistantStruct);
        this.myDefaultNamespaceOpenText = namespaceOpenText;
    }

    @Override
    @NotNull
    protected OCNewFileActionBase.NewFileNames getNewFileNames(String selectedName) {
        LOG.assertTrue(this.getState() != null, (Object)"state");
        LOG.assertTrue(selectedName != null, (Object)"name");
        MyCreateClassDialog dialog = (MyCreateClassDialog)((Object)this.getState().dialogPeer);
        FileExtensionPair extensionPair = dialog.myFileExtensionPair;
        LOG.assertTrue(extensionPair != null, (Object)"extension pair");
        return OCNewCppClassAction.getNewFileNames(selectedName, extensionPair, dialog.myHeaderOnly);
    }

    @Override
    @NotNull
    protected OCNewFileActionBase.NewFileNames getNewFileNames(String selectedName, @NotNull PsiFile sampleFile) {
        if (sampleFile == null) {
            OCNewCppClassAction.$$$reportNull$$$0(0);
        }
        Couple<String> detectedEp = this.determineExtensions(sampleFile, null, null);
        FileExtensionPair extensionPair = null;
        for (FileExtensionPair ep : this.getExtensions(sampleFile.getProject())) {
            if (!ep.mySourceExt.equals(detectedEp.first) || !ep.myHeaderExt.equals(detectedEp.second)) continue;
            extensionPair = ep;
            break;
        }
        if (extensionPair == null) {
            extensionPair = new FileExtensionPair((String)detectedEp.first, (String)detectedEp.second, NamingConventionStyle.NONE);
        }
        LOG.assertTrue(selectedName != null, (Object)"name");
        return OCNewCppClassAction.getNewFileNames(selectedName, extensionPair, false);
    }

    @NotNull
    private static OCNewFileActionBase.NewFileNames getNewFileNames(@NotNull String selectedName, @NotNull FileExtensionPair extensionPair, boolean headerOnly) {
        if (selectedName == null) {
            OCNewCppClassAction.$$$reportNull$$$0(1);
        }
        if (extensionPair == null) {
            OCNewCppClassAction.$$$reportNull$$$0(2);
        }
        NamingConventionStyle convention = extensionPair.myFileNamingConvention;
        String name = convention.apply(selectedName);
        return new OCNewFileActionBase.NewFileNames(headerOnly ? null : name + "." + extensionPair.mySourceExt, name + "." + extensionPair.myHeaderExt);
    }

    @Override
    protected boolean isValidName(@NotNull String selectedName) {
        if (selectedName == null) {
            OCNewCppClassAction.$$$reportNull$$$0(3);
        }
        return StringUtil.isJavaIdentifier((String)selectedName);
    }

    @Override
    protected void setAdditionalProperties(Properties properties, String fileName, PsiFile sampleFile, Project project) {
        String headerName;
        if (this.getState() != null) {
            headerName = this.getNewFileNames(this.mySelectedName).getHeaderName();
        } else {
            assert (sampleFile != null);
            headerName = this.getNewFileNames(this.mySelectedName, sampleFile).getHeaderName();
        }
        properties.setProperty("HEADER_FILENAME", headerName);
        String enclosingNamespace = !((String)this.myEnclosingNamespace.get()).isEmpty() ? (String)this.myEnclosingNamespace.get() : StringUtil.notNullize((String)this.myDefaultNamespaceOpenText);
        StringBuilder allNamespacesOpenText = new StringBuilder();
        StringBuilder allNamespacesCloseText = new StringBuilder();
        if (!enclosingNamespace.isEmpty()) {
            @NotNull List subNamespaces = StringUtil.split((String)enclosingNamespace, (String)"::", (boolean)true, (boolean)false);
            boolean first = true;
            for (String namespace : subNamespaces) {
                if (!first) {
                    allNamespacesOpenText.append('\n');
                    allNamespacesCloseText.insert(0, '\n');
                }
                allNamespacesOpenText.append("namespace ").append(namespace).append(" {");
                allNamespacesCloseText.insert(0, "} // " + namespace);
                first = false;
            }
        }
        properties.setProperty(NAMESPACES_OPEN_PROPERTY, allNamespacesOpenText.toString());
        properties.setProperty(NAMESPACES_CLOSE_PROPERTY, allNamespacesCloseText.toString());
        properties.setProperty(NAMESPACES_OPEN_CPP_PROPERTY, ((String)this.myEnclosingNamespace.get()).isEmpty() ? "" : allNamespacesOpenText.toString());
        properties.setProperty(NAMESPACES_CLOSE_CPP_PROPERTY, ((String)this.myEnclosingNamespace.get()).isEmpty() ? "" : allNamespacesCloseText.toString());
    }

    @Override
    protected String getFileTemplate(String fileName) {
        if (OCFileTypeHelpers.isSourceFile(fileName)) {
            return "C++ Class.cc";
        }
        if (OCFileTypeHelpers.isHeaderFile(fileName)) {
            return "C++ Class Header.h";
        }
        assert (false);
        return null;
    }

    @Override
    @NotNull
    protected MyCreateClassDialog createDialog(@NlsContexts.Label @NotNull String defaultName) {
        if (defaultName == null) {
            OCNewCppClassAction.$$$reportNull$$$0(4);
        }
        return new MyCreateClassDialog(defaultName, this.getHelpId());
    }

    @Override
    @NotNull
    protected @Unmodifiable List<FileExtensionPair> getExtensions(@NotNull Project project) {
        if (project == null) {
            OCNewCppClassAction.$$$reportNull$$$0(5);
        }
        List list = ContainerUtil.filter(super.getExtensions(project), pair -> OCNewFileLangBackendHandlerProvider.getHandler().isCppFileExtension("." + pair.mySourceExt, project));
        if (list == null) {
            OCNewCppClassAction.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sampleFile";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPair";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/actions/newFile/OCNewCppClassAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/actions/newFile/OCNewCppClassAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNewFileNames";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isValidName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createDialog";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getExtensions";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }

    @ApiStatus.Internal
    public final class MyCreateClassDialog
    extends OCNewFileWithSelectedExtensionAction.CreateFileDialog {
        @VisibleForTesting
        public boolean myHeaderOnly;

        public MyCreateClassDialog(@Nullable String defaultName, String helpId) {
            super(OCNewCppClassAction.this, CidrLangBundle.message("create.cpp.class.dialog.title", new Object[0]), defaultName, helpId);
            OCNewCppClassAction.this.myEnclosingNamespace.set((Object)"");
        }

        @Override
        @NlsContexts.DialogMessage
        @Nullable
        protected String collectOkActionErrors() {
            if (!OCNewFileHelperUtil.isValidNamespaceName((String)OCNewCppClassAction.this.myEnclosingNamespace.get())) {
                return CidrLangBundle.message("create.cpp.invalid.namespace.name.message", new Object[0]);
            }
            return super.collectOkActionErrors();
        }

        @Override
        public void fillGenericControls(FormBuilder formBuilder) {
            super.fillGenericControls(formBuilder);
            OCNewFileHelperUtil.addTextEdit(this, formBuilder, OCNewCppClassAction.this.myEnclosingNamespace, "", CidrLangBundle.message("create.cpp.enclosing.namespace.title", new Object[0]));
            NonFocusableCheckBox headerCheckBox = new NonFocusableCheckBox(CidrLangBundle.message("create.checkbox.cpp.class.header", new Object[0]));
            DialogUtil.registerMnemonic((AbstractButton)headerCheckBox, (char)'&');
            headerCheckBox.addItemListener(new ItemListener(){
                final /* synthetic */ JCheckBox val$headerCheckBox;
                {
                    this.val$headerCheckBox = jCheckBox;
                }

                @Override
                public void itemStateChanged(ItemEvent e) {
                    MyCreateClassDialog.this.myHeaderOnly = this.val$headerCheckBox.isSelected();
                    if (MyCreateClassDialog.this.myKindCombo != null) {
                        MyCreateClassDialog.this.reloadExtensions();
                    }
                    MyCreateClassDialog.this.validateOkAction();
                }
            });
            OCNewCppClassAction.this.addAuxAction(createdElements -> OCUsageTriggerCollector.CREATE_CPP_CLASS.log((Object)this.myHeaderOnly));
            formBuilder.addComponent((JComponent)headerCheckBox);
        }

        @Override
        @NotNull
        protected String getPresentableName(@NotNull FileExtensionPair pair) {
            if (pair == null) {
                MyCreateClassDialog.$$$reportNull$$$0(0);
            }
            Object name = this.myHeaderOnly ? "." + pair.myHeaderExt : super.getPresentableName(pair);
            NamingConventionStyle nc = pair.myFileNamingConvention;
            Object object = nc == NamingConventionStyle.NONE ? name : (String)name + "  [" + String.valueOf((Object)nc) + "]";
            if (object == null) {
                MyCreateClassDialog.$$$reportNull$$$0(1);
            }
            return object;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pair";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/actions/newFile/OCNewCppClassAction$MyCreateClassDialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/actions/newFile/OCNewCppClassAction$MyCreateClassDialog";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentableName";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

