/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.splitter.solver;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import uk.me.parabola.splitter.Area;
import uk.me.parabola.splitter.Utils;
import uk.me.parabola.splitter.solver.EnhancedDensityMap;
import uk.me.parabola.splitter.solver.TileMetaInfo;

class Tile
extends Rectangle {
    private final EnhancedDensityMap densityInfo;
    private final long count;

    public Tile(EnhancedDensityMap densityInfo) {
        this(densityInfo, 0, 0, densityInfo.getDensityMap().getWidth(), densityInfo.getDensityMap().getHeight(), densityInfo.getNodeCount());
    }

    public Tile(EnhancedDensityMap densityInfo, Rectangle r) {
        super(r);
        if (r.x < 0 || r.y < 0 || r.x + r.width > densityInfo.getDensityMap().getWidth() || r.y + r.height > densityInfo.getDensityMap().getHeight()) {
            throw new IllegalArgumentException("Rectangle doesn't fit into density map");
        }
        this.densityInfo = densityInfo;
        this.count = this.calcCount();
    }

    private Tile(EnhancedDensityMap densityInfo, int x, int y, int width, int height, long count) {
        super(x, y, width, height);
        this.densityInfo = densityInfo;
        this.count = count;
    }

    public long getCount() {
        return this.count;
    }

    public boolean verify() {
        return this.getCount() == this.calcCount();
    }

    public static IntArrayList genTests(int start, int end) {
        if (end - start < 0) {
            return new IntArrayList(0);
        }
        int mid = (start + end) / 2;
        int toAdd = end - start + 1;
        IntArrayList list = new IntArrayList(toAdd);
        list.add(mid);
        for (int i = 1; i < toAdd / 2; ++i) {
            list.add(mid + i);
            list.add(mid - i);
        }
        if (list.size() < toAdd) {
            list.add(end);
        }
        if (list.size() < toAdd) {
            list.add(start);
        }
        return list;
    }

    private long calcCount() {
        long sum = 0L;
        for (int i = 0; i < this.height; ++i) {
            sum += this.getRowSum(i);
        }
        return sum;
    }

    public long getRowSum(int row) {
        assert (row >= 0 && row < this.height);
        int mapRow = row + this.y;
        long sum = 0L;
        int[] vector = this.densityInfo.getMapRow(mapRow);
        if (vector != null) {
            int lastX = this.x + this.width;
            for (int i = this.x; i < lastX; ++i) {
                sum += (long)vector[i];
            }
        }
        return sum;
    }

    private long getRowSum(int row, long[] rowSums) {
        if (rowSums[row] < 0L) {
            rowSums[row] = this.getRowSum(row);
        }
        return rowSums[row];
    }

    public long getColSum(int col) {
        assert (col >= 0 && col < this.width);
        int mapCol = col + this.x;
        long sum = 0L;
        int[] vector = this.densityInfo.getMapCol(mapCol);
        if (vector != null) {
            int lastY = this.y + this.height;
            for (int i = this.y; i < lastY; ++i) {
                sum += (long)vector[i];
            }
        }
        return sum;
    }

    private long getColSum(int col, long[] colSums) {
        if (colSums[col] < 0L) {
            colSums[col] = this.getColSum(col);
        }
        return colSums[col];
    }

    public int findHorizontalMiddle(TileMetaInfo smi) {
        if (this.getCount() == 0L || this.width < 2) {
            smi.setHorMidPos(0);
        } else if (smi.getHorMidPos() < 0) {
            int start = smi.getFirstNonZeroX() > 0 ? smi.getFirstNonZeroX() : 0;
            long sum = 0L;
            long lastSum = 0L;
            long target = this.getCount() / 2L;
            for (int pos = start; pos <= this.width; ++pos) {
                lastSum = sum;
                if ((sum += this.getColSum(pos, smi.getColSums())) == 0L) continue;
                if (lastSum <= 0L) {
                    smi.setFirstNonZeroX(pos);
                }
                if (sum <= target) continue;
                if (sum - target < target - lastSum && pos + 1 < this.width) {
                    smi.setHorMidPos(pos + 1);
                    smi.setHorMidSum(sum);
                    break;
                }
                smi.setHorMidPos(pos);
                smi.setHorMidSum(lastSum);
                break;
            }
        }
        return smi.getHorMidPos();
    }

    public int findVerticalMiddle(TileMetaInfo smi) {
        if (this.getCount() == 0L || this.height < 2) {
            smi.setVertMidPos(0);
        } else if (smi.getVertMidPos() < 0) {
            int start;
            long sum = 0L;
            long target = this.getCount() / 2L;
            for (int pos = start = smi.getFirstNonZeroY() > 0 ? smi.getFirstNonZeroY() : 0; pos <= this.height; ++pos) {
                long lastSum = sum;
                if ((sum += this.getRowSum(pos, smi.getRowSums())) == 0L) continue;
                if (lastSum <= 0L) {
                    smi.setFirstNonZeroY(pos);
                }
                if (sum <= target) continue;
                if (sum - target < target - lastSum && pos + 1 < this.height) {
                    smi.setVertMidPos(pos + 1);
                    smi.setVertMidSum(sum);
                    break;
                }
                smi.setVertMidPos(pos);
                smi.setVertMidSum(lastSum);
                break;
            }
        }
        return smi.getVertMidPos();
    }

    public boolean splitHoriz(int splitX, TileMetaInfo smi) {
        if (splitX <= 0 || splitX >= this.width) {
            return false;
        }
        long sum = 0L;
        if (splitX <= this.width / 2) {
            int start;
            for (int pos = start = smi.getFirstNonZeroX() > 0 ? smi.getFirstNonZeroX() : 0; pos < splitX; ++pos) {
                sum += this.getColSum(pos, smi.getColSums());
            }
        } else {
            int end = smi.getLastNonZeroX() > 0 ? smi.getLastNonZeroX() + 1 : this.width;
            for (int pos = splitX; pos < end; ++pos) {
                sum += this.getColSum(pos, smi.getColSums());
            }
            sum = this.getCount() - sum;
        }
        if (sum < smi.getMinNodes() || this.getCount() - sum < smi.getMinNodes()) {
            return false;
        }
        assert (splitX > 0 && splitX < this.width);
        Tile[] parts = smi.getParts();
        parts[0] = new Tile(this.densityInfo, this.x, this.y, splitX, this.height, sum);
        parts[1] = new Tile(this.densityInfo, this.x + splitX, this.y, this.width - splitX, this.height, this.getCount() - sum);
        assert (smi.getParts()[0].width + smi.getParts()[1].width == this.width);
        return true;
    }

    public boolean splitVert(int splitY, TileMetaInfo smi) {
        if (splitY <= 0 || splitY >= this.height) {
            return false;
        }
        long sum = 0L;
        if (splitY <= this.height / 2) {
            int start;
            for (int pos = start = smi.getFirstNonZeroY() > 0 ? smi.getFirstNonZeroY() : 0; pos < splitY; ++pos) {
                sum += this.getRowSum(pos, smi.getRowSums());
            }
        } else {
            int end = smi.getLastNonZeroY() > 0 ? smi.getLastNonZeroY() + 1 : this.height;
            for (int pos = splitY; pos < end; ++pos) {
                sum += this.getRowSum(pos, smi.getRowSums());
            }
            sum = this.getCount() - sum;
        }
        if (sum < smi.getMinNodes() || this.getCount() - sum < smi.getMinNodes()) {
            return false;
        }
        assert (splitY > 0 && splitY < this.height);
        Tile[] parts = smi.getParts();
        parts[0] = new Tile(this.densityInfo, this.x, this.y, this.width, splitY, sum);
        parts[1] = new Tile(this.densityInfo, this.x, this.y + splitY, this.width, this.height - splitY, this.getCount() - sum);
        assert (parts[0].height + parts[1].height == this.height);
        return true;
    }

    public int findValidStartX(TileMetaInfo smi) {
        int start;
        if (smi.getValidStartX() >= 0) {
            return smi.getValidStartX();
        }
        long sum = 0L;
        for (int i = start = smi.getFirstNonZeroX() > 0 ? smi.getFirstNonZeroX() : 0; i < this.width; ++i) {
            if ((sum += this.getColSum(i, smi.getColSums())) == 0L) continue;
            if (smi.getFirstNonZeroX() < 0) {
                smi.setFirstNonZeroX(i);
            }
            if (sum < smi.getMinNodes()) continue;
            int splitPos = i + 1;
            smi.setValidStartX(splitPos);
            return splitPos;
        }
        smi.setValidStartX(this.width);
        return this.width;
    }

    public int findValidEndX(TileMetaInfo smi) {
        if (smi.getValidEndX() < 0) {
            int end = smi.getLastNonZeroX() > 0 ? smi.getLastNonZeroX() : this.width - 1;
            long sum = 0L;
            for (int i = end; i >= 0; --i) {
                if ((sum += this.getColSum(i, smi.getColSums())) > 0L && smi.getLastNonZeroX() < 0) {
                    smi.setLastNonZeroX(i);
                }
                if (sum < smi.getMinNodes()) continue;
                smi.setValidEndX(i);
                break;
            }
        }
        return smi.getValidEndX();
    }

    public int findValidStartY(TileMetaInfo smi) {
        int start;
        if (smi.getValidStartY() > 0) {
            return smi.getValidStartY();
        }
        long sum = 0L;
        for (int i = start = smi.getFirstNonZeroY() > 0 ? smi.getFirstNonZeroY() : 0; i < this.height; ++i) {
            if ((sum += this.getRowSum(i, smi.getRowSums())) == 0L) continue;
            if (smi.getFirstNonZeroY() < 0) {
                smi.setFirstNonZeroY(i);
            }
            if (sum < smi.getMinNodes()) continue;
            int splitPos = i + 1;
            smi.setValidStartY(splitPos);
            return splitPos;
        }
        smi.setValidStartY(this.height);
        return this.height;
    }

    public int findValidEndY(TileMetaInfo smi) {
        if (smi.getValidEndY() < 0) {
            int end = smi.getLastNonZeroY() > 0 ? smi.getLastNonZeroY() : this.height - 1;
            long sum = 0L;
            for (int i = end; i >= 0; --i) {
                if ((sum += this.getRowSum(i, smi.getRowSums())) > 0L && smi.getLastNonZeroY() < 0) {
                    smi.setLastNonZeroY(i);
                }
                if (sum < smi.getMinNodes()) continue;
                smi.setValidEndY(i);
                break;
            }
        }
        return smi.getValidEndY();
    }

    public int findFirstXHigher(TileMetaInfo smi, long limit) {
        int start;
        long sum = 0L;
        for (int i = start = smi.getFirstNonZeroX() > 0 ? smi.getFirstNonZeroX() : 0; i < this.width; ++i) {
            if ((sum += this.getColSum(i, smi.getColSums())) == 0L) continue;
            if (smi.getFirstNonZeroX() < 0) {
                smi.setFirstNonZeroX(i);
            }
            if (sum <= limit) continue;
            return i;
        }
        return this.height;
    }

    public int findFirstYHigher(TileMetaInfo smi, long limit) {
        int start;
        long sum = 0L;
        for (int i = start = smi.getFirstNonZeroY() > 0 ? smi.getFirstNonZeroY() : 0; i < this.height; ++i) {
            if ((sum += this.getRowSum(i, smi.getRowSums())) == 0L) continue;
            if (smi.getFirstNonZeroY() < 0) {
                smi.setFirstNonZeroY(i);
            }
            if (sum <= limit) continue;
            return i;
        }
        return this.height;
    }

    public int findFirstHigher(int axis, TileMetaInfo smi, long limit) {
        return axis == 0 ? this.findFirstXHigher(smi, limit) : this.findFirstYHigher(smi, limit);
    }

    public double getAspectRatio() {
        return this.densityInfo.getAspectRatio(this);
    }

    public Tile trim() {
        long sumRemovedColCounts = 0L;
        long sumRemovedRowCounts = 0L;
        int minX = -1;
        for (int i = 0; i < this.width; ++i) {
            boolean needed;
            long colSum = this.getColSum(i);
            boolean bl = this.densityInfo.getPolygonArea() == null ? colSum > 0L : (needed = !this.colOutsidePolygon(i));
            if (needed) {
                minX = this.x + i;
                break;
            }
            sumRemovedColCounts += colSum;
        }
        int maxX = -1;
        for (int i = this.width - 1; i >= 0; --i) {
            boolean needed;
            long colSum = this.getColSum(i);
            boolean bl = this.densityInfo.getPolygonArea() == null ? colSum > 0L : (needed = !this.colOutsidePolygon(i));
            if (needed) {
                maxX = this.x + i;
                break;
            }
            sumRemovedColCounts += colSum;
        }
        int minY = -1;
        for (int i = 0; i < this.height; ++i) {
            boolean needed;
            long rowSum = this.getRowSum(i);
            boolean bl = this.densityInfo.getPolygonArea() == null ? rowSum > 0L : (needed = !this.rowOutsidePolygon(i));
            if (needed) {
                minY = this.y + i;
                break;
            }
            sumRemovedRowCounts += rowSum;
        }
        int maxY = -1;
        for (int i = this.height - 1; i >= 0; --i) {
            boolean needed;
            long rowSum = this.getRowSum(i);
            boolean bl = this.densityInfo.getPolygonArea() == null ? rowSum > 0L : (needed = !this.rowOutsidePolygon(i));
            if (needed) {
                maxY = this.y + i;
                break;
            }
            sumRemovedRowCounts += rowSum;
        }
        if (minX > maxX || minY > maxY || maxX < 0 || maxY < 0) {
            return new Tile(this.densityInfo, this.x, this.y, 0, 0, 0L);
        }
        long newCount = this.getCount();
        int modWidth = maxX - minX + 1;
        int modHeight = maxY - minY + 1;
        if (this.densityInfo.getPolygonArea() != null && (modWidth != this.width || modHeight != this.height)) {
            if (this.width == modWidth) {
                newCount = this.getCount() - sumRemovedRowCounts;
            } else if (this.height == modHeight) {
                newCount = this.getCount() - sumRemovedColCounts;
            } else {
                return new Tile(this.densityInfo, new Rectangle(minX, minY, modWidth, modHeight));
            }
        }
        return new Tile(this.densityInfo, minX, minY, modWidth, modHeight, newCount);
    }

    private boolean rowOutsidePolygon(int row) {
        if (this.densityInfo.getPolygonArea() == null) {
            return false;
        }
        if (this.densityInfo.isGridElemInPolygon(this.x, this.y + row) || this.densityInfo.isGridElemInPolygon(this.x + this.width - 1, this.y + row)) {
            return false;
        }
        for (int i = 1; i < this.width - 1; ++i) {
            if (!this.densityInfo.isGridElemInPolygon(this.x + i, this.y + row)) continue;
            return false;
        }
        return true;
    }

    private boolean colOutsidePolygon(int col) {
        if (this.densityInfo.getPolygonArea() == null) {
            return false;
        }
        if (this.densityInfo.isGridElemInPolygon(this.x + col, this.y) || this.densityInfo.isGridElemInPolygon(this.x + col, this.y + this.height - 1)) {
            return false;
        }
        for (int i = 1; i < this.height - 1; ++i) {
            if (!this.densityInfo.isGridElemInPolygon(this.x + col, this.y + i)) continue;
            return false;
        }
        return true;
    }

    public boolean outsidePolygon() {
        java.awt.geom.Area polygonArea = this.densityInfo.getPolygonArea();
        return polygonArea != null && !polygonArea.intersects(this.getRealBBox());
    }

    public boolean outsideRatioIsOK(double maxOutsideRatio) {
        Rectangle polyBBox;
        if (this.densityInfo.allInsidePolygon()) {
            return true;
        }
        Rectangle realBBox = this.getRealBBox();
        if (realBBox.contains(polyBBox = this.densityInfo.getPolygonArea().getBounds())) {
            return true;
        }
        long maxOutsde = (long)(maxOutsideRatio * (double)(this.width * this.height));
        long neededInside = (long)(this.width * this.height) - maxOutsde;
        int countInside = 0;
        int countOutside = 0;
        for (int i = this.x; i < this.x + this.width; ++i) {
            for (int j = this.y; j < this.y + this.height; ++j) {
                if (this.densityInfo.isGridElemInPolygon(i, j)) {
                    if ((long)(++countInside) < neededInside) continue;
                    return true;
                }
                if ((long)(++countOutside) < maxOutsde) continue;
                return false;
            }
        }
        return false;
    }

    public Rectangle getRealBBox() {
        int shift = this.densityInfo.getDensityMap().getShift();
        int polyYPos = this.densityInfo.getDensityMap().getBounds().getMinLat() + (this.y << shift);
        int polyXPos = this.densityInfo.getDensityMap().getBounds().getMinLong() + (this.x << shift);
        return new Rectangle(polyXPos, polyYPos, this.width << shift, this.height << shift);
    }

    @Override
    public int hashCode() {
        return this.x << 24 | this.y << 16 | this.width << 8 | this.height;
    }

    @Override
    public String toString() {
        Area area = this.densityInfo.getDensityMap().getArea(this.x, this.y, this.width, this.height);
        return area.toString() + " with " + Utils.format(this.getCount()) + " nodes";
    }

    public int getMinParts(long maxNodes) {
        long minCount = this.countInside();
        int nMin = (int)(minCount / maxNodes);
        if ((long)nMin * maxNodes < minCount) {
            ++nMin;
        }
        return nMin;
    }

    public long countInside() {
        long minCount = 0L;
        if (this.densityInfo.getPolygonArea() == null || this.densityInfo.allInsidePolygon()) {
            return this.count;
        }
        for (int i = 0; i < this.width; ++i) {
            int[] col = this.densityInfo.getMapCol(this.x + i);
            if (col == null) continue;
            for (int k = 0; k < this.height; ++k) {
                if (!this.densityInfo.isGridElemInPolygon(this.x + i, this.y + k)) continue;
                minCount += (long)col[this.y + k];
            }
        }
        return minCount;
    }

    public int countElemsOutside() {
        if (this.densityInfo.getPolygonArea() == null || this.densityInfo.allInsidePolygon()) {
            return 0;
        }
        int num = 0;
        for (int i = 0; i < this.width; ++i) {
            for (int k = 0; k < this.height; ++k) {
                if (this.densityInfo.isGridElemInPolygon(this.x + i, this.y + k)) continue;
                ++num;
            }
        }
        return num;
    }

    public List<Tile> divide(long maxNodes) {
        int mid;
        int end;
        int start;
        if (this.getCount() < maxNodes) {
            return Arrays.asList(this);
        }
        ArrayList<Tile> parts = new ArrayList<Tile>(2);
        TileMetaInfo smi = new TileMetaInfo(this, null, null);
        smi.setMinNodes(1L);
        boolean ok = false;
        if (this.width > this.height) {
            start = this.findValidStartX(smi);
            end = this.findValidEndX(smi);
            mid = (start + end) / 2;
            ok = this.splitHoriz(mid, smi);
        } else {
            start = this.findValidStartY(smi);
            end = this.findValidEndY(smi);
            mid = (start + end) / 2;
            ok = this.splitVert(mid, smi);
        }
        if (ok) {
            for (Tile part : smi.getParts()) {
                parts.addAll(part.divide(maxNodes));
            }
        } else {
            parts.add(this);
        }
        return parts;
    }

    public double getFillRatio() {
        return (double)this.getCount() / (double)(this.width * this.height);
    }

    int getLargestInfo() {
        int largest = 0;
        for (int i = 0; i < this.width; ++i) {
            int[] col = this.densityInfo.getMapCol(this.x + i);
            if (col == null) continue;
            for (int k = 0; k < this.height; ++k) {
                int n = col[this.y + k];
                if (n <= largest) continue;
                largest = n;
            }
        }
        return largest;
    }
}

