/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm.boundary;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import uk.me.parabola.imgfmt.FormatException;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.reader.osm.boundary.BoundaryQuadTree;
import uk.me.parabola.mkgmap.reader.osm.boundary.BoundarySaver;
import uk.me.parabola.mkgmap.reader.osm.boundary.BoundaryUtil;
import uk.me.parabola.mkgmap.reader.osm.boundary.OsmBoundaryDataSource;

public class BoundaryPreprocessor
implements Runnable {
    private static final Logger log = Logger.getLogger(BoundaryPreprocessor.class);
    private String boundaryFilename;
    private String outDir;
    private ExecutorService threadPool;
    private final BlockingQueue<Future<Object>> remainingTasks = new LinkedBlockingQueue<Future<Object>>();

    private BoundaryPreprocessor(String boundaryFilename, String out) {
        this.boundaryFilename = boundaryFilename;
        this.outDir = out;
        int maxJobs = Runtime.getRuntime().availableProcessors();
        this.threadPool = maxJobs > 1 ? Executors.newFixedThreadPool(maxJobs) : null;
    }

    public void setMaxThreads(int maxThreads) {
        this.threadPool = maxThreads > 1 ? Executors.newFixedThreadPool(maxThreads) : null;
    }

    @Override
    public void run() {
        long t1 = System.currentTimeMillis();
        boolean prepOK = this.createRawData();
        long t2 = System.currentTimeMillis();
        log.info("BoundaryPreparer pass 1 took", t2 - t1, "ms");
        if (!prepOK) {
            System.err.println("Boundary creation failed.");
            return;
        }
        this.workoutBoundaryRelations();
    }

    private boolean createRawData() {
        File boundsDirectory = new File(this.outDir);
        BoundarySaver saver = new BoundarySaver(boundsDirectory, "RAW");
        OsmBoundaryDataSource dataSource = new OsmBoundaryDataSource();
        dataSource.setBoundarySaver(saver);
        log.info("Started loading", this.boundaryFilename);
        try {
            dataSource.load(this.boundaryFilename, false);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        catch (FormatException e) {
            e.printStackTrace();
            return false;
        }
        saver.setBbox(dataSource.getBounds());
        log.info("Finished loading", this.boundaryFilename);
        saver.end();
        return true;
    }

    public static void main(String[] args) {
        if ("--help".equals(args[0]) || args.length != 2) {
            System.err.println("Usage:");
            System.err.println("java -cp mkgmap.jar uk.me.parabola.mkgmap.reader.osm.boundary.BoundaryPreprocessor <inputfile> <boundsdir>");
            System.err.println(" <inputfile>: File containing boundary data (OSM, PBF or O5M format)");
            System.err.println(" <boundsdir>: Directory in which the preprocessed bounds files are created");
            System.exit(-1);
        }
        String inputFile = args[0];
        String outputDir = args[1];
        long t1 = System.currentTimeMillis();
        BoundaryPreprocessor p = new BoundaryPreprocessor(inputFile, outputDir);
        try {
            p.runPreprocessing();
        }
        catch (InterruptedException exp) {
            exp.printStackTrace();
        }
        catch (ExecutionException exp) {
            System.err.println(exp);
            exp.printStackTrace();
        }
        System.out.println("Bnd files converted in " + (System.currentTimeMillis() - t1) + " ms");
        log.info("Bnd files converted in", System.currentTimeMillis() - t1, "ms");
    }

    private void workoutBoundaryRelations() {
        List<String> boundsFileNames = BoundaryUtil.getBoundaryDirContent(this.outDir);
        for (String boundsFileName : boundsFileNames) {
            this.addWorker(new QuadTreeWorker(this.outDir, boundsFileName));
        }
    }

    protected <V> Future<V> addWorker(Callable<V> worker) {
        if (this.threadPool == null) {
            FutureTask<V> future = new FutureTask<V>(worker);
            future.run();
            return future;
        }
        Future<V> task = this.threadPool.submit(worker);
        this.remainingTasks.add(task);
        return task;
    }

    public void runPreprocessing() throws InterruptedException, ExecutionException {
        if (this.threadPool == null) {
            this.run();
        } else {
            Future task;
            Future<Object> prepTask = this.threadPool.submit(this, new Object());
            prepTask.get();
            while ((task = (Future)this.remainingTasks.poll()) != null) {
                task.get();
            }
            this.threadPool.shutdown();
        }
    }

    class QuadTreeWorker
    implements Callable<String> {
        private final String boundsDir;
        private final String boundsFilename;

        public QuadTreeWorker(String boundsDir, String boundsFilename) {
            this.boundsDir = boundsDir;
            this.boundsFilename = boundsFilename;
        }

        @Override
        public String call() throws Exception {
            log.info("Workout boundary relations in", this.boundsDir, this.boundsFilename);
            long t1 = System.currentTimeMillis();
            BoundaryQuadTree bqt = BoundaryUtil.loadQuadTree(this.boundsDir, this.boundsFilename);
            long dt = System.currentTimeMillis() - t1;
            log.info("splitting", this.boundsFilename, "took", dt, "ms");
            if (bqt != null) {
                BoundarySaver saver = new BoundarySaver(new File(this.boundsDir), "QUADTREE");
                saver.setCreateEmptyFiles(false);
                saver.saveQuadTree(bqt, this.boundsFilename);
                saver.end();
            }
            return this.boundsFilename;
        }
    }
}

