/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.imgfmt.app.net.AccessTagsAndBits;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.osmstyle.ConvertedWay;
import uk.me.parabola.mkgmap.reader.osm.GType;
import uk.me.parabola.mkgmap.reader.osm.RestrictionRelation;
import uk.me.parabola.mkgmap.reader.osm.Way;
import uk.me.parabola.util.MultiIdentityHashMap;

public class RoadMerger {
    private static final Logger log = Logger.getLogger(RoadMerger.class);
    private static final double WARN_MERGE_ANGLE = 130.0;
    private final boolean reverseAllowed;
    private final MultiIdentityHashMap<Coord, Long> restrictions = new MultiIdentityHashMap();
    private final MultiIdentityHashMap<Coord, ConvertedWay> sharedPoints = new MultiIdentityHashMap();
    private static final Set<String> mergeTagsEqualValue = new HashSet<String>(Arrays.asList("mkgmap:label:1", "mkgmap:label:2", "mkgmap:label:3", "mkgmap:label:4", "mkgmap:postal_code", "mkgmap:city", "mkgmap:region", "mkgmap:country", "mkgmap:is_in", "mkgmap:skipSizeFilter", "mkgmap:synthesised", "mkgmap:highest-resolution-only", "mkgmap:flare-check", "mkgmap:numbers"));

    public RoadMerger(boolean reverseAllowed) {
        this.reverseAllowed = reverseAllowed;
    }

    private void workoutRestrictionRelations(List<RestrictionRelation> restrictionRels) {
        for (RestrictionRelation rel : restrictionRels) {
            Set<Long> restrictionWayIds = rel.getWayIds();
            for (Coord via : rel.getViaCoords()) {
                HashSet roadAtVia = new HashSet(this.sharedPoints.get(via));
                for (ConvertedWay r : roadAtVia) {
                    long wayId = r.getWay().getId();
                    if (!restrictionWayIds.contains(wayId)) continue;
                    this.restrictions.add(via, wayId);
                }
            }
        }
    }

    private boolean hasRestriction(Coord c, Way w) {
        return w.isViaWay() || this.restrictions.get(c).contains(w.getId());
    }

    private void mergeRoads(Coord mergePoint, ConvertedWay road1, ConvertedWay road2) {
        String wayPOI1;
        Way way1 = road1.getWay();
        Way way2 = road2.getWay();
        if (way1.getFirstPoint() == mergePoint) {
            assert (this.reverseAllowed) : "bad reverse at " + mergePoint;
            Collections.reverse(way1.getPoints());
        }
        assert (way1.getLastPoint() == mergePoint);
        List<Coord> points2 = way2.getPoints();
        this.sharedPoints.removeMapping(way2.getFirstPoint(), road2);
        this.sharedPoints.removeMapping(way2.getLastPoint(), road2);
        this.sharedPoints.removeMapping(mergePoint, road1);
        Coord endPoint = way2.getLastPoint();
        if (endPoint == mergePoint) {
            assert (this.reverseAllowed);
            Collections.reverse(points2);
            endPoint = way2.getLastPoint();
        }
        road1.getPoints().addAll(points2.subList(1, points2.size()));
        points2.clear();
        this.sharedPoints.add(endPoint, road1);
        String wayPOI2 = road2.getWay().getTag("mkgmap:way-poi-node-ids");
        if (wayPOI2 != null && !wayPOI2.equals(wayPOI1 = road1.getWay().getTag("mkgmap:way-poi-node-ids"))) {
            if (wayPOI1 == null) {
                wayPOI1 = "";
            }
            road1.getWay().addTag("mkgmap:way-poi-node-ids", wayPOI1 + wayPOI2);
        }
        mergePoint.decHighwayCount();
    }

    public List<ConvertedWay> merge(List<ConvertedWay> roads, List<RestrictionRelation> restrictions) {
        List roadsToMerge = roads.stream().filter(cw -> cw.isValid() && cw.isRoad()).collect(Collectors.toList());
        int noRoadsBeforeMerge = roadsToMerge.size();
        int numMerges = 0;
        ArrayList<Coord> mergePoints = new ArrayList<Coord>();
        for (Object road : roadsToMerge) {
            Coord end;
            Coord start = ((ConvertedWay)road).getWay().getFirstPoint();
            if (start == (end = ((ConvertedWay)road).getWay().getLastPoint())) continue;
            for (Coord p : Arrays.asList(start, end)) {
                if (p.getHighwayCount() < 2) continue;
                mergePoints.add(p);
                this.sharedPoints.add(p, (ConvertedWay)road);
            }
        }
        this.workoutRestrictionRelations(restrictions);
        Set mergeCompletedPoints = Collections.newSetFromMap(new IdentityHashMap());
        for (Coord mergePoint : mergePoints) {
            if (mergeCompletedPoints.contains(mergePoint)) continue;
            Object roadsAtPoint = this.sharedPoints.get(mergePoint);
            double bestAngle = Double.MAX_VALUE;
            ConvertedWay mergeRoad1 = null;
            ConvertedWay mergeRoad2 = null;
            Iterator iterator = roadsAtPoint.iterator();
            while (iterator.hasNext()) {
                ConvertedWay road1 = (ConvertedWay)iterator.next();
                if (!this.reverseAllowed && road1.getWay().getLastPoint() != mergePoint || this.hasRestriction(mergePoint, road1.getWay())) continue;
                Iterator iterator2 = roadsAtPoint.iterator();
                while (iterator2.hasNext()) {
                    ConvertedWay road2 = (ConvertedWay)iterator2.next();
                    if (road1 == road2 || !this.reverseAllowed && road2.getWay().getFirstPoint() != mergePoint || this.hasRestriction(road2.getWay().getFirstPoint(), road2.getWay()) || this.hasRestriction(road2.getWay().getLastPoint(), road2.getWay()) || !RoadMerger.isMergeable(mergePoint, road1, road2, this.reverseAllowed)) continue;
                    double angle = RoadMerger.getAngle(mergePoint, road1.getWay(), road2.getWay());
                    if (log.isDebugEnabled()) {
                        log.debug("Road", road1.getWay().getId(), "and road", road2.getWay().getId(), "are mergeable with angle", angle, "at", mergePoint);
                    }
                    if (!(angle < bestAngle)) continue;
                    mergeRoad1 = road1;
                    mergeRoad2 = road2;
                    bestAngle = angle;
                }
            }
            boolean merged = false;
            if (mergeRoad1 != null && mergeRoad2 != null) {
                if (bestAngle > 130.0) {
                    log.info("Merging ways", mergeRoad1.getWay().getId(), "and", mergeRoad2.getWay().getId(), "at", mergePoint, "with sharp angle", bestAngle);
                }
                if (log.isDebugEnabled()) {
                    log.debug("Merging", mergeRoad1.getWay().getId(), "and", mergeRoad2.getWay().getId(), "at", mergePoint, "with angle", bestAngle);
                }
                this.mergeRoads(mergePoint, mergeRoad1, mergeRoad2);
                ++numMerges;
                merged = true;
            }
            if (merged) continue;
            mergeCompletedPoints.add(mergePoint);
        }
        List<ConvertedWay> result = roadsToMerge.stream().filter(ConvertedWay::isValid).collect(Collectors.toList());
        int noRoadsAfterMerge = result.size();
        log.info("Roads before/after merge:", noRoadsBeforeMerge, "/", noRoadsAfterMerge);
        int percentage = (int)Math.round((double)(noRoadsBeforeMerge - noRoadsAfterMerge) * 100.0 / (double)noRoadsBeforeMerge);
        log.info("Road network reduced by", percentage, "%", numMerges, "merges");
        return result;
    }

    public static boolean isMergeable(Coord mergePoint, ConvertedWay road1, ConvertedWay road2, boolean reverseAllowed) {
        if (road1 == road2 || road1.hasDirection() != road2.hasDirection()) {
            return false;
        }
        if (road1.getRoadClass() != road2.getRoadClass() || road1.getRoadSpeed() != road2.getRoadSpeed()) {
            return false;
        }
        Way way1 = road1.getWay();
        Way way2 = road2.getWay();
        if (road1.getAccess() != road2.getAccess()) {
            if (log.isDebugEnabled()) {
                RoadMerger.reportFirstDifferentTag(way1, way2, road1.getAccess(), road2.getAccess(), AccessTagsAndBits.ACCESS_TAGS);
            }
            return false;
        }
        if (road1.getRouteFlags() != road2.getRouteFlags()) {
            if (log.isDebugEnabled()) {
                RoadMerger.reportFirstDifferentTag(way1, way2, road1.getRouteFlags(), road2.getRouteFlags(), AccessTagsAndBits.ROUTE_TAGS);
            }
            return false;
        }
        if (!RoadMerger.checkGeometry(mergePoint, road1, road2, reverseAllowed)) {
            return false;
        }
        if (!RoadMerger.isGTypeMergeable(road1.getGType(), road2.getGType())) {
            return false;
        }
        return RoadMerger.isWayTagsMergeable(way1, way2);
    }

    private static boolean checkGeometry(Coord mergePoint, ConvertedWay road1, ConvertedWay road2, boolean reverseAllowed) {
        boolean differentDir;
        Way way1 = road1.getWay();
        Way way2 = road2.getWay();
        Coord cStart = way1.getFirstPoint();
        Coord cEnd = way1.getLastPoint();
        if (cStart != mergePoint && cEnd != mergePoint) {
            return false;
        }
        Coord cOtherStart = way2.getFirstPoint();
        Coord cOtherEnd = way2.getLastPoint();
        if (cOtherStart != mergePoint && cOtherEnd != mergePoint) {
            return false;
        }
        if (!(reverseAllowed || mergePoint == cEnd && mergePoint == cOtherStart)) {
            return false;
        }
        if (cStart == cOtherEnd) {
            return false;
        }
        boolean bl = differentDir = cStart == mergePoint == (cOtherStart == mergePoint);
        if (!differentDir) {
            return true;
        }
        if (road1.isOneway()) {
            assert (road2.isOneway());
            log.warn("oneway with different direction", way1.getId(), way2.getId());
            return false;
        }
        return reverseAllowed && !road1.hasDirection() && !road2.hasDirection();
    }

    private static void reportFirstDifferentTag(Way way1, Way way2, byte flags1, byte flags2, Map<String, Byte> tagMaskMap) {
        for (Map.Entry<String, Byte> entry : tagMaskMap.entrySet()) {
            byte mask = entry.getValue();
            if ((flags1 & mask) == (flags2 & mask)) continue;
            String tagKey = entry.getKey();
            log.debug(entry.getKey(), "does not match", way1.getId(), "(" + way1.getTag(tagKey) + ")", way2.getId(), "(" + way2.getTag(tagKey) + ")");
            return;
        }
    }

    private static boolean isGTypeMergeable(GType type1, GType type2) {
        return type1.getType() == type2.getType() && type1.getMinResolution() == type2.getMinResolution() && type1.getMaxResolution() == type2.getMaxResolution() && type1.getMinLevel() == type2.getMinLevel() && type1.getMaxLevel() == type2.getMaxLevel();
    }

    private static boolean isWayTagsMergeable(Way way1, Way way2) {
        for (String tagname : mergeTagsEqualValue) {
            String tag2;
            String tag1 = way1.getTag(tagname);
            if (Objects.equals(tag1, tag2 = way2.getTag(tagname))) continue;
            if (log.isDebugEnabled()) {
                log.debug(tagname, "does not match", way1.getId(), "(" + tag1 + ")", way2.getId(), "(" + tag2 + ")");
            }
            return false;
        }
        return true;
    }

    private static double getAngle(Coord mergePoint, Way way1, Way way2) {
        Coord cOnWay1 = way1.getFirstPoint() == mergePoint ? way1.getPoints().get(1) : way1.getPoints().get(way1.getPoints().size() - 2);
        Coord cOnWay2 = way2.getFirstPoint() == mergePoint ? way2.getPoints().get(1) : way2.getPoints().get(way2.getPoints().size() - 2);
        return Math.abs(Utils.getAngle(cOnWay1, mergePoint, cOnWay2));
    }
}

