/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import uk.me.parabola.imgfmt.ExitException;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.osmstyle.eval.AbstractOp;
import uk.me.parabola.mkgmap.osmstyle.eval.AndOp;
import uk.me.parabola.mkgmap.osmstyle.eval.BinaryOp;
import uk.me.parabola.mkgmap.osmstyle.eval.EqualsOp;
import uk.me.parabola.mkgmap.osmstyle.eval.ExistsOp;
import uk.me.parabola.mkgmap.osmstyle.eval.GTEOp;
import uk.me.parabola.mkgmap.osmstyle.eval.GTOp;
import uk.me.parabola.mkgmap.osmstyle.eval.LTEOp;
import uk.me.parabola.mkgmap.osmstyle.eval.LTOp;
import uk.me.parabola.mkgmap.osmstyle.eval.LinkedOp;
import uk.me.parabola.mkgmap.osmstyle.eval.NodeType;
import uk.me.parabola.mkgmap.osmstyle.eval.NotEqualOp;
import uk.me.parabola.mkgmap.osmstyle.eval.NotExistsOp;
import uk.me.parabola.mkgmap.osmstyle.eval.NotRegexOp;
import uk.me.parabola.mkgmap.osmstyle.eval.Op;
import uk.me.parabola.mkgmap.osmstyle.eval.OrOp;
import uk.me.parabola.mkgmap.osmstyle.eval.RegexOp;
import uk.me.parabola.mkgmap.osmstyle.eval.ValueOp;
import uk.me.parabola.mkgmap.osmstyle.function.StyleFunction;
import uk.me.parabola.mkgmap.scan.SyntaxException;
import uk.me.parabola.mkgmap.scan.TokenScanner;

public class ExpressionArranger {
    private static final EnumSet<NodeType> OPERATORS = EnumSet.of(NodeType.AND, NodeType.OR, NodeType.NOT);
    private static final EnumSet<NodeType> BIN_OPERATORS = EnumSet.of(NodeType.AND, NodeType.OR);
    private static final EnumSet<NodeType> NEED_EXISTS = EnumSet.of(NodeType.GT, NodeType.GTE, NodeType.LT, NodeType.LTE, NodeType.REGEX);
    private static final EnumSet<NodeType> INVERTIBLE = EnumSet.allOf(NodeType.class);
    Logger log = Logger.getLogger(this.getClass());

    public Op arrange(Op expr) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("IN:", ExpressionArranger.fmtExpr(expr));
        }
        Op op = this.arrangeTop(expr);
        if (this.log.isDebugEnabled()) {
            this.log.debug("OUT:", ExpressionArranger.fmtExpr(expr));
        }
        return op;
    }

    private Op arrangeTop(Op expr) {
        if (!OPERATORS.contains((Object)expr.getType())) {
            return expr;
        }
        Op op = ExpressionArranger.removeAllNot(expr);
        if (BIN_OPERATORS.contains((Object)op.getType())) {
            ExpressionArranger.orderBest(op);
        }
        switch (op.getType()) {
            case AND: {
                ExpressionArranger.reAssociate(op, NodeType.AND);
                ExpressionArranger.arrangeAndChain(op);
                if (!op.getFirst().isType(NodeType.OR)) break;
                op = ExpressionArranger.distribute(op);
                this.arrangeTop(op);
                break;
            }
            case OR: {
                this.arrangeOr(op);
                break;
            }
        }
        return op;
    }

    private void arrangeOr(Op op) {
        Op last = op;
        for (Op current = op; current != null && current.isType(NodeType.OR); current = current.getSecond()) {
            Op newop = this.arrangeTop(current.getFirst());
            current.setFirst(newop);
            while (current.getFirst().isType(NodeType.OR)) {
                ExpressionArranger.reAssociate(current, NodeType.OR);
            }
            last = current;
        }
        Op newop = this.arrangeTop(last.getSecond());
        last.setSecond(newop);
    }

    private static Op distribute(Op op) {
        Op ab = op.getFirst();
        Op a = ab.getFirst();
        Op b = ab.getSecond();
        Op c = op.getSecond();
        assert (a != b) : "ab";
        assert (b != c) : "bc";
        ArrayList<Op> orterms = new ArrayList<Op>();
        while (b.isType(NodeType.OR)) {
            orterms.add(b.getFirst());
            b = b.getSecond();
        }
        OrOp topOR = new OrOp();
        topOR.setFirst((Op)new AndOp().set(a, c));
        OrOp current = topOR;
        for (Op orterm : orterms) {
            AndOp and = (AndOp)new AndOp().set(orterm, c.copy());
            OrOp newOr = (OrOp)new OrOp().set(and, null);
            current.setSecond(newOr);
            current = newOr;
        }
        current.setSecond((Op)new AndOp().set(b, c.copy()));
        return topOR;
    }

    private static void orderBest(Op op) {
        assert (OPERATORS.contains((Object)op.getType()));
        if (ExpressionArranger.leftNodeWeight(op.getFirst()) > ExpressionArranger.leftNodeWeight(op.getSecond())) {
            op.set(op.getSecond(), op.getFirst());
        }
    }

    private static int leftNodeWeight(Op op) {
        switch (op.getType()) {
            case AND: {
                return 10;
            }
            case OR: {
                return 20;
            }
        }
        return 0;
    }

    private static Op removeAllNot(Op expr) {
        if (expr == null) {
            return null;
        }
        Op op = expr;
        while (op.isType(NodeType.NOT) && INVERTIBLE.contains((Object)op.getFirst().getType())) {
            op = ExpressionArranger.removeNot(op);
        }
        if (OPERATORS.contains((Object)op.getType())) {
            op.set(ExpressionArranger.removeAllNot(op.getFirst()), ExpressionArranger.removeAllNot(op.getSecond()));
        }
        return op;
    }

    private static Op removeNot(Op op) {
        return ExpressionArranger.invert(op.getFirst());
    }

    private static Op invert(Op op) {
        switch (op.getType()) {
            case NOT: {
                Op f = op.getFirst();
                while (f != null && f.isType(NodeType.NOT) && f.getFirst().isType(NodeType.NOT)) {
                    f = f.getFirst().getFirst();
                }
                return f;
            }
            case EQUALS: {
                return new NotEqualOp().set(op.getFirst(), op.getSecond());
            }
            case GT: {
                return ExpressionArranger.neWith(new LTEOp().set(op.getFirst(), op.getSecond()));
            }
            case GTE: {
                return ExpressionArranger.neWith(new LTOp().set(op.getFirst(), op.getSecond()));
            }
            case LT: {
                return ExpressionArranger.neWith(new GTEOp().set(op.getFirst(), op.getSecond()));
            }
            case LTE: {
                return ExpressionArranger.neWith(new GTOp().set(op.getFirst(), op.getSecond()));
            }
            case NOT_EQUALS: {
                return new EqualsOp().set(op.getFirst(), op.getSecond());
            }
            case EXISTS: {
                return new NotExistsOp().setFirst(op.getFirst());
            }
            case NOT_EXISTS: {
                return new ExistsOp().setFirst(op.getFirst());
            }
            case OR: {
                return new AndOp().set(ExpressionArranger.invert(op.getFirst()), ExpressionArranger.invert(op.getSecond()));
            }
            case AND: {
                return new OrOp().set(ExpressionArranger.invert(op.getFirst()), ExpressionArranger.invert(op.getSecond()));
            }
            case REGEX: {
                return new NotRegexOp().set(op.getFirst(), op.getSecond());
            }
            case NOT_REGEX: {
                return new RegexOp().set(op.getFirst(), op.getSecond());
            }
        }
        throw new ExitException("Programming error, tried to invert invalid node " + op);
    }

    private static Op neWith(Op op) {
        return new OrOp().set((Op)new NotExistsOp().setFirst(op.getFirst()), op);
    }

    private static void reAssociate(Op op, NodeType kind) {
        assert (op.isType(kind));
        assert (kind == NodeType.OR || kind == NodeType.AND);
        while (op.getFirst().isType(kind)) {
            Op aAndB = op.getFirst();
            Op a = aAndB.getFirst();
            Op b = aAndB.getSecond();
            Op c = op.getSecond();
            assert (a != b);
            assert (a != c);
            assert (b != c);
            BinaryOp and = (BinaryOp)AbstractOp.createOp(kind).set(b, c);
            op.set(a, and);
        }
    }

    private static void arrangeAndChain(Op op) {
        Op last = op;
        ArrayList<Op> terms = new ArrayList<Op>();
        terms.add(op.getFirst());
        for (Op second = op.getSecond(); second != null && second.isType(NodeType.AND); second = second.getSecond()) {
            ExpressionArranger.reAssociate(second, NodeType.AND);
            terms.add(second.getFirst());
            last = second;
        }
        for (int i = 0; i < terms.size(); ++i) {
            Op o = (Op)terms.get(i);
            if (ExpressionArranger.selectivity(o) <= ExpressionArranger.selectivity(last.getSecond())) continue;
            Op tmp = last.getSecond();
            last.setSecond(o);
            terms.set(i, tmp);
        }
        if (terms.size() > 1) {
            terms.sort(Comparator.comparingInt(ExpressionArranger::selectivity));
        }
        Op current = op;
        for (Op o : terms) {
            current.setFirst(o);
            current = current.getSecond();
        }
    }

    private static int selectivity(Op op) {
        StyleFunction func;
        if (op.getFirst().isType(NodeType.FUNCTION) && !(func = (StyleFunction)op.getFirst()).isIndexable()) {
            return 1000 + func.getComplexity();
        }
        switch (op.getType()) {
            case EQUALS: {
                return 0;
            }
            case EXISTS: {
                return 100;
            }
            case NOT: 
            case NOT_EQUALS: 
            case NOT_EXISTS: 
            case NOT_REGEX: {
                return 1000;
            }
            case AND: {
                return 500;
            }
            case OR: {
                return 501;
            }
            case GT: 
            case GTE: 
            case LT: 
            case LTE: {
                return 200;
            }
            case REGEX: {
                return 210;
            }
        }
        return 1000;
    }

    public String getKeystring(TokenScanner scanner, Op op) {
        Op first = op.getFirst();
        Op second = op.getSecond();
        String keystring = null;
        String valuestring = null;
        if (op.isType(NodeType.EQUALS) && first.isType(NodeType.FUNCTION) && second.isType(NodeType.VALUE)) {
            keystring = first.getKeyValue();
            valuestring = second.getKeyValue();
        } else if (op.isType(NodeType.EXISTS)) {
            keystring = first.getKeyValue();
            valuestring = "*";
        } else if (op.isType(NodeType.AND)) {
            if (first.isType(NodeType.EQUALS) && first.getFirst().isType(NodeType.FUNCTION) && first.getSecond().isType(NodeType.VALUE)) {
                keystring = first.getFirst().getKeyValue();
                valuestring = first.getSecond().getKeyValue();
            } else if (first.isType(NodeType.EXISTS)) {
                if (ExpressionArranger.isIndexable(first)) {
                    keystring = first.getFirst().getKeyValue();
                    valuestring = "*";
                }
            } else if (first.isType(NodeType.NOT_EXISTS)) {
                // empty if block
            }
        }
        if (keystring == null || valuestring == null) {
            throw new SyntaxException(scanner, "Invalid rule, expression cannot be indexed: " + op);
        }
        return keystring + "=" + valuestring;
    }

    public Iterator<Op> prepareForSave(Op op) {
        ArrayList<Op> saveList = new ArrayList<Op>();
        switch (op.getType()) {
            default: {
                saveList.add(ExpressionArranger.prepareWithExists(op));
                break;
            }
            case OR: {
                Op last = op;
                LinkedOp prev = null;
                for (Op second = op; second != null && second.isType(NodeType.OR); second = second.getSecond()) {
                    Op term = second.getFirst();
                    LinkedOp lop = LinkedOp.create(ExpressionArranger.prepareWithExists(term), second == op);
                    if (prev != null) {
                        prev.setLink(lop);
                    }
                    prev = lop;
                    saveList.add(lop);
                    last = second;
                }
                LinkedOp lop = LinkedOp.create(ExpressionArranger.prepareWithExists(last.getSecond()), false);
                if (prev != null) {
                    prev.setLink(lop);
                }
                saveList.add(lop);
            }
        }
        return saveList.iterator();
    }

    private static Op prepareWithExists(Op op) {
        Op first = op;
        if (first.isType(NodeType.AND)) {
            first = first.getFirst();
        }
        if (NEED_EXISTS.contains((Object)first.getType()) || first.isType(NodeType.EQUALS) && first.getSecond().isType(NodeType.FUNCTION)) {
            return ExpressionArranger.combineWithExists((BinaryOp)op);
        }
        return op;
    }

    private static AndOp combineWithExists(BinaryOp op) {
        Op first = op;
        if (first.isType(NodeType.AND)) {
            first = first.getFirst();
        }
        return (AndOp)new AndOp().set((Op)new ExistsOp().setFirst(first.getFirst()), op);
    }

    public static boolean isSolved(Op op) {
        switch (op.getType()) {
            case NOT: {
                return false;
            }
            case AND: {
                return ExpressionArranger.isAndIndexable(ExpressionArranger.prepareWithExists(op.getFirst()));
            }
            case OR: {
                Op or = op;
                boolean valid = true;
                do {
                    if (ExpressionArranger.isAndIndexable(ExpressionArranger.prepareWithExists(or.getFirst()))) continue;
                    valid = false;
                } while ((or = or.getSecond()).isType(NodeType.OR));
                if (!ExpressionArranger.isAndIndexable(ExpressionArranger.prepareWithExists(or))) {
                    valid = false;
                }
                return valid;
            }
        }
        return ExpressionArranger.isIndexable(ExpressionArranger.prepareWithExists(op));
    }

    private static boolean isAndIndexable(Op op) {
        if (op.isType(NodeType.AND)) {
            return ExpressionArranger.isIndexable(op.getFirst());
        }
        return ExpressionArranger.isIndexable(op);
    }

    private static boolean isIndexable(Op op) {
        return (op.isType(NodeType.EQUALS) || op.isType(NodeType.EXISTS)) && ((ValueOp)op.getFirst()).isIndexable();
    }

    public static String fmtExpr(Op op) {
        return String.format("%s [%s] %s", new Object[]{op.getFirst(), op.getType(), op.getSecond()});
    }

    static {
        INVERTIBLE.removeAll(EnumSet.of(NodeType.VALUE, NodeType.FUNCTION));
    }
}

