/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.srt;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.imgfmt.app.BufferedImgFileWriter;
import uk.me.parabola.imgfmt.app.ImgFile;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.SectionWriter;
import uk.me.parabola.imgfmt.app.srt.CodePosition;
import uk.me.parabola.imgfmt.app.srt.SRTHeader;
import uk.me.parabola.imgfmt.app.srt.Sort;
import uk.me.parabola.imgfmt.fs.ImgChannel;

public class SRTFile
extends ImgFile {
    private SRTHeader header;
    private Sort sort;
    private boolean isMulti;
    private String description;
    private final List<Integer> srt8Starts = new ArrayList<Integer>();

    public SRTFile(ImgChannel chan) {
        BufferedImgFileWriter fileWriter = new BufferedImgFileWriter(chan, "SRT");
        fileWriter.setMaxSize(Long.MAX_VALUE);
        this.setWriter(fileWriter);
    }

    public void write() {
        ImgFileWriter writer = this.getWriter();
        this.writeDescription(writer);
        this.position(this.header.getHeaderLength());
        SectionWriter subWriter = this.header.makeSectionWriter(writer);
        int header3Len = this.sort.getHeader3Len();
        if (header3Len == 0) {
            header3Len = this.sort.isMulti() ? 92 : 52;
        }
        subWriter.position(header3Len);
        this.writeSrt4Chars(subWriter);
        this.writeSrt5Expansions(subWriter);
        if (this.sort.isMulti()) {
            for (int i = 0; i <= this.sort.getMaxPage(); ++i) {
                this.srt8Starts.add(-1);
            }
            this.writeSrt8(subWriter);
            this.writeSrt7(subWriter);
        }
        subWriter.close();
        writer.position(this.header.getHeaderLength());
        this.header.writeHeader2(writer);
        writer.position(this.header.getHeaderLength() + this.description.length() + 1 + 16);
        this.header.writeHeader3(writer);
        this.header.writeHeader(writer);
    }

    private void writeDescription(ImgFileWriter writer) {
        writer.position(this.header.getHeaderLength() + 16);
        writer.put(this.description.getBytes(Charset.forName("ascii")));
        writer.put1u(0);
        this.header.endDescription(writer.position());
    }

    private void writeSrt4Chars(ImgFileWriter writer) {
        for (int i = 1; i < 256; ++i) {
            writer.put1u(this.sort.getFlags(i));
            this.writeWeights(writer, i);
        }
        this.header.endCharTable(writer.position());
    }

    private void writeWeights(ImgFileWriter writer, int i) {
        int primary = this.sort.getPrimary(i);
        int secondary = this.sort.getSecondary(i);
        int tertiary = this.sort.getTertiary(i);
        if (this.isMulti) {
            assert (primary <= 65535) : primary;
            assert (secondary <= 255) : secondary;
            assert (tertiary <= 255) : tertiary;
            writer.put2u(primary);
            writer.put1u(secondary);
            writer.put1u(tertiary);
        } else {
            assert (primary <= 255) : primary;
            assert (secondary <= 15) : secondary;
            assert (tertiary <= 15) : tertiary;
            writer.put1u(primary);
            writer.put1u(tertiary << 4 | secondary & 0xF);
        }
    }

    private void writeSrt5Expansions(ImgFileWriter writer) {
        int size = this.sort.getExpansionSize();
        for (int j = 1; j <= size; ++j) {
            CodePosition b = this.sort.getExpansion(j);
            if (this.isMulti) {
                writer.put2u(b.getPrimary());
                writer.put1u(b.getSecondary());
                writer.put1u(b.getTertiary());
                continue;
            }
            writer.put1u(b.getPrimary());
            writer.put1u(b.getTertiary() << 4 | b.getSecondary() & 0xF);
        }
        this.header.endTab2(writer.position());
    }

    private void writeSrt7(SectionWriter writer) {
        assert (this.sort.isMulti());
        for (int i = 1; i <= this.sort.getMaxPage(); ++i) {
            writer.put4(this.srt8Starts.get(i));
        }
        this.header.endSrt7(writer.position());
    }

    private void writeSrt8(SectionWriter writer) {
        assert (this.sort.isMulti());
        int offset = 0;
        for (int p = 1; p <= this.sort.getMaxPage(); ++p) {
            if (!this.sort.hasPage(p)) continue;
            this.srt8Starts.set(p, offset);
            for (int j = 0; j < 256; ++j) {
                int ch = p * 256 + j;
                writer.put1u(this.sort.getFlags(ch));
                this.writeWeights(writer, ch);
                offset += 5;
            }
        }
        this.header.endSrt8(writer.position());
    }

    public void setSort(Sort sort) {
        this.sort = sort;
        this.header = new SRTHeader(sort.getHeaderLen());
        this.header.setSort(sort);
        this.description = sort.getDescription();
        this.isMulti = sort.isMulti();
    }
}

