/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.splitter.solver;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.awt.Point;
import java.awt.Rectangle;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import uk.me.parabola.splitter.Area;
import uk.me.parabola.splitter.RoundingUtils;
import uk.me.parabola.splitter.SplitFailedException;
import uk.me.parabola.splitter.Utils;
import uk.me.parabola.splitter.solver.DensityMap;
import uk.me.parabola.splitter.solver.EnhancedDensityMap;
import uk.me.parabola.splitter.solver.PolygonDesc;
import uk.me.parabola.splitter.solver.Solution;
import uk.me.parabola.splitter.solver.Tile;
import uk.me.parabola.splitter.solver.TileMetaInfo;

public class SplittableDensityArea {
    private static final int MAX_LAT_DEGREES = 85;
    private static final int MAX_LON_DEGREES = 90;
    public static final int MAX_SINGLE_POLYGON_VERTICES = 40;
    private static final int MAX_LOOPS = 100;
    static final int AXIS_HOR = 0;
    static final int AXIS_VERT = 1;
    public static final double NICE_MAX_ASPECT_RATIO = 4.0;
    private static final double VERY_NICE_FILL_RATIO = 0.94;
    private static final long LARGE_MAX_NODES = 10000000L;
    private static final double MAX_OUTSIDE_RATIO = 0.5;
    private static final int MIN_TILE_AREA_BAD_CACHE = 100;
    private static final int MAX_DEPTH_STATS = 10;
    private boolean enableExtraOpt = true;
    private final int startSearchLimit;
    private final DensityMap allDensities;
    private EnhancedDensityMap extraDensityInfo;
    private boolean beQuiet;
    private static final boolean DEBUG = false;
    private long maxNodes;
    private int stopNumber;
    private final int shift;
    private final boolean trimShape;
    private boolean trimTiles;
    private boolean allowEmptyPart;
    private int currMapId;
    private boolean hasEmptyPart;
    private int solverId;

    public SplittableDensityArea(DensityMap densities, int startSearchLimit, boolean trim) {
        this.shift = densities.getShift();
        this.startSearchLimit = startSearchLimit;
        this.trimShape = trim;
        this.allDensities = densities;
    }

    public DensityMap getAllDensities() {
        return this.allDensities;
    }

    public void setMapId(int mapId) {
        this.currMapId = mapId;
    }

    public void setMaxNodes(long maxNodes) {
        this.maxNodes = maxNodes;
    }

    public boolean hasData() {
        return this.allDensities != null && this.allDensities.getNodeCount() > 0L;
    }

    public Area getBounds() {
        return this.allDensities.getBounds();
    }

    private Solution split() {
        int countNoSol;
        Solution fullSolution = new Solution(this.maxNodes);
        if (this.allDensities == null || this.allDensities.getNodeCount() == 0L) {
            return fullSolution;
        }
        this.prepare(null);
        Tile startTile = new Tile(this.extraDensityInfo);
        ArrayList<Tile> startTiles = new ArrayList<Tile>();
        if (this.trimShape || this.allDensities.getBounds().getWidth() >= 0x1000000) {
            startTiles.addAll(this.checkForEmptyClusters(0, startTile, true));
        } else {
            startTiles.add(startTile);
        }
        while (true) {
            countNoSol = 0;
            for (Tile tile : startTiles) {
                Solution solution;
                this.hasEmptyPart = false;
                if (!this.beQuiet) {
                    System.out.println("Solving partition " + tile.toString());
                }
                if ((solution = this.solveRectangularArea(tile)) != null && !solution.isEmpty()) {
                    fullSolution.merge(solution);
                    continue;
                }
                ++countNoSol;
                if (this.beQuiet) continue;
                System.out.println("Warning: No solution found for partition " + tile.toString());
            }
            if (countNoSol == 0 || this.allowEmptyPart || !this.hasEmptyPart) break;
            this.allowEmptyPart = true;
            fullSolution = new Solution(this.maxNodes);
        }
        if (countNoSol > 0 && this.stopNumber == 0) {
            throw new SplitFailedException("Failed to find a correct split");
        }
        if (!this.beQuiet) {
            SplittableDensityArea.printFinalSplitMsg(fullSolution);
        }
        return fullSolution;
    }

    private List<Area> split(java.awt.geom.Area polygonArea) {
        if (polygonArea == null) {
            return this.getAreas(this.split(), null);
        }
        if (polygonArea.isSingular()) {
            java.awt.geom.Area rasteredArea = this.allDensities.rasterPolygon(polygonArea);
            List<List<Point>> shapes = Utils.areaToShapes(rasteredArea);
            ArrayList<Area> areas = new ArrayList<Area>();
            for (List<Point> shape : shapes) {
                java.awt.geom.Area rasteredPart = Utils.shapeToArea(shape);
                if (rasteredPart.isEmpty()) {
                    System.err.println("Bounding polygon doesn't intersect with the bounding box of the input file(s)");
                    return Collections.emptyList();
                }
                if (!rasteredPart.isSingular()) continue;
                this.prepare(polygonArea);
                Tile tile = new Tile(this.extraDensityInfo, rasteredPart.getBounds());
                Solution solution = this.findSolutionWithSinglePolygon(0, tile, rasteredPart, new HashSet<Rectangle>());
                if (solution == null && rasteredPart.isRectangular()) {
                    solution = this.split();
                }
                if (solution == null) continue;
                areas.addAll(this.getAreas(solution, polygonArea));
            }
            return areas;
        }
        if (polygonArea.intersects(Utils.area2Rectangle(this.allDensities.getBounds(), 0))) {
            return this.splitPolygon(polygonArea);
        }
        System.err.println("Bounding polygon doesn't intersect with the bounding box of the input file(s)");
        return Collections.emptyList();
    }

    public List<Area> split(List<PolygonDesc> namedPolygons) {
        int i;
        if (namedPolygons.isEmpty()) {
            return this.getAreas(this.split(), null);
        }
        ArrayList<Area> result = new ArrayList<Area>();
        class ShareInfo {
            java.awt.geom.Area area;
            final IntArrayList sharedBy = new IntArrayList();

            ShareInfo() {
            }
        }
        ArrayList<ShareInfo> sharedParts = new ArrayList<ShareInfo>();
        for (i = 0; i < namedPolygons.size(); ++i) {
            boolean wasDistinct = true;
            PolygonDesc namedPart = namedPolygons.get(i);
            java.awt.geom.Area distinctPart = new java.awt.geom.Area(namedPart.getArea());
            for (int j = 0; j < namedPolygons.size(); ++j) {
                if (j == i) continue;
                java.awt.geom.Area test = new java.awt.geom.Area(namedPart.getArea());
                test.intersect(namedPolygons.get(j).getArea());
                if (test.isEmpty()) continue;
                wasDistinct = false;
                distinctPart.subtract(namedPolygons.get(j).getArea());
                if (j <= i) continue;
                ShareInfo si = new ShareInfo();
                si.area = test;
                si.sharedBy.add(i);
                si.sharedBy.add(j);
                sharedParts.add(si);
            }
            if (distinctPart.isEmpty() || !distinctPart.intersects(Utils.area2Rectangle(this.allDensities.getBounds(), 0))) continue;
            if (!wasDistinct) {
                System.out.println("splitting distinct part of " + namedPart.getName());
            } else {
                System.out.println("splitting " + namedPart.getName());
            }
            result.addAll(this.split(distinctPart));
        }
        for (i = 0; i < sharedParts.size(); ++i) {
            ShareInfo si = (ShareInfo)sharedParts.get(i);
            int last = namedPolygons.size();
            for (int j = 0; j < last; ++j) {
                if (si.sharedBy.contains(j)) continue;
                java.awt.geom.Area test = new java.awt.geom.Area(si.area);
                test.intersect(namedPolygons.get(j).getArea());
                if (!test.isEmpty()) {
                    si.area.subtract(test);
                    if (j > si.sharedBy.getInt(si.sharedBy.size() - 1)) {
                        ShareInfo si2 = new ShareInfo();
                        si2.area = test;
                        si2.sharedBy.addAll(si.sharedBy);
                        si2.sharedBy.add(j);
                        sharedParts.add(si2);
                    }
                }
                if (si.area.isEmpty()) break;
            }
            if (si.area.isEmpty() || !si.area.intersects(Utils.area2Rectangle(this.allDensities.getBounds(), 0))) continue;
            String desc = "";
            IntListIterator intListIterator = si.sharedBy.iterator();
            while (intListIterator.hasNext()) {
                int pos = (Integer)intListIterator.next();
                desc = desc + namedPolygons.get(pos).getName() + " and ";
            }
            desc = desc.substring(0, desc.lastIndexOf(" and"));
            System.out.println("splitting area shared by exactly " + si.sharedBy.size() + " polygons: " + desc);
            result.addAll(this.split(si.area));
        }
        return result;
    }

    public List<Area> split(int wantedTiles) {
        this.stopNumber = wantedTiles;
        long currMaxNodes = (long)((double)this.allDensities.getNodeCount() / ((double)wantedTiles * 0.95));
        class Pair {
            long myMaxNodes;
            int numTiles;

            Pair(long maxNodes, int numTiles) {
                this.myMaxNodes = maxNodes;
                this.numTiles = numTiles;
            }
        }
        Pair bestBelow = null;
        Pair bestAbove = null;
        this.beQuiet = true;
        while (true) {
            long testMaxNodes;
            this.setMaxNodes(currMaxNodes);
            System.out.println("Trying a max-nodes value of " + currMaxNodes + " to split " + this.allDensities.getNodeCount() + " nodes into " + wantedTiles + " areas");
            Solution sol = this.split();
            if (sol.isEmpty() || sol.size() == wantedTiles) {
                this.beQuiet = false;
                SplittableDensityArea.printFinalSplitMsg(sol);
                return this.getAreas(sol, null);
            }
            Pair pair = new Pair(currMaxNodes, sol.size());
            if (sol.size() > wantedTiles) {
                if (bestAbove == null || bestAbove.numTiles > pair.numTiles || bestAbove.numTiles == pair.numTiles && pair.myMaxNodes < bestAbove.myMaxNodes) {
                    bestAbove = pair;
                }
            } else if (bestBelow == null || bestBelow.numTiles < pair.numTiles || bestBelow.numTiles == pair.numTiles && pair.myMaxNodes > bestBelow.myMaxNodes) {
                bestBelow = pair;
            }
            if ((testMaxNodes = bestBelow == null || bestAbove == null ? Math.min(Math.round((double)currMaxNodes * (double)sol.size() / (double)wantedTiles), this.allDensities.getNodeCount() - 1L) : (bestBelow.myMaxNodes + bestAbove.myMaxNodes) / 2L) == currMaxNodes) {
                System.err.println("Cannot find a good split with exactly " + wantedTiles + " areas");
                SplittableDensityArea.printFinalSplitMsg(sol);
                return this.getAreas(sol, null);
            }
            currMaxNodes = testMaxNodes;
        }
    }

    private void prepare(java.awt.geom.Area polygonArea) {
        this.extraDensityInfo = new EnhancedDensityMap(this.allDensities, polygonArea);
        if (!this.beQuiet) {
            System.out.println("Highest node count in a single grid element is " + Utils.format(this.extraDensityInfo.getMaxNodesInDensityMapGridElement()));
            if (polygonArea != null) {
                System.out.println("Highest node count in a single grid element within the bounding polygon is " + Utils.format(this.extraDensityInfo.getMaxNodesInDensityMapGridElementInPoly()));
            }
        }
        if (polygonArea != null) {
            this.trimTiles = true;
        }
    }

    private ArrayList<Tile> checkForEmptyClusters(int depth, Tile tile, boolean splitHoriz) {
        java.awt.geom.Area empty;
        long count;
        int i;
        java.awt.geom.Area area = new java.awt.geom.Area(tile);
        int firstEmpty = -1;
        int countEmpty = 0;
        long countLastPart = 0L;
        long countRemaining = tile.getCount();
        int maxEmpty = Utils.toMapUnit(30.0) / (1 << this.shift);
        int minEmpty = Utils.toMapUnit(10.0) / (1 << this.shift);
        if (splitHoriz) {
            for (i = 0; i < tile.width; ++i) {
                count = tile.getColSum(i);
                if (count == 0L) {
                    if (firstEmpty < 0) {
                        firstEmpty = i;
                    }
                    ++countEmpty;
                    continue;
                }
                if (countEmpty > maxEmpty || countEmpty > minEmpty && countLastPart > this.maxNodes / 3L && countRemaining > this.maxNodes / 3L) {
                    empty = new java.awt.geom.Area(new Rectangle(firstEmpty, tile.y, countEmpty, tile.height));
                    area.subtract(empty);
                    countLastPart = 0L;
                }
                countRemaining -= count;
                firstEmpty = -1;
                countEmpty = 0;
                countLastPart += count;
            }
        } else {
            for (i = 0; i < tile.height; ++i) {
                count = tile.getRowSum(i);
                if (count == 0L) {
                    if (firstEmpty < 0) {
                        firstEmpty = i;
                    }
                    ++countEmpty;
                    continue;
                }
                if (countEmpty > maxEmpty || countEmpty > minEmpty && countLastPart > this.maxNodes / 3L && countRemaining > this.maxNodes / 3L) {
                    empty = new java.awt.geom.Area(new Rectangle(tile.x, firstEmpty, tile.width, countEmpty));
                    area.subtract(empty);
                    countLastPart = 0L;
                }
                countRemaining -= count;
                firstEmpty = -1;
                countEmpty = 0;
                countLastPart += count;
            }
        }
        ArrayList<Tile> clusters = new ArrayList<Tile>();
        if (depth == 0 && area.isSingular()) {
            clusters.addAll(this.checkForEmptyClusters(depth + 1, tile.trim(), !splitHoriz));
        } else if (area.isSingular()) {
            clusters.add(tile.trim());
        } else {
            List<List<Point>> shapes = Utils.areaToShapes(area);
            for (List<Point> shape : shapes) {
                java.awt.geom.Area part = Utils.shapeToArea(shape);
                Tile t = new Tile(this.extraDensityInfo, part.getBounds());
                if (t.getCount() <= 0L) continue;
                clusters.addAll(this.checkForEmptyClusters(depth + 1, t.trim(), !splitHoriz));
            }
        }
        return clusters;
    }

    private List<Area> splitPolygon(java.awt.geom.Area polygonArea) {
        ArrayList<Area> result = new ArrayList<Area>();
        List<List<Point>> shapes = Utils.areaToShapes(polygonArea);
        for (int i = 0; i < shapes.size(); ++i) {
            List<Point> shape = shapes.get(i);
            if (!Utils.clockwise(shape)) continue;
            java.awt.geom.Area shapeArea = Utils.shapeToArea(shape);
            Rectangle rShape = shapeArea.getBounds();
            if (shape.size() > 40) {
                shapeArea = new java.awt.geom.Area(rShape);
                System.out.println("Warning: shape is too complex, using rectangle " + rShape + " instead");
            }
            Area shapeBounds = new Area(rShape.y, rShape.x, (int)rShape.getMaxY(), (int)rShape.getMaxX());
            int resolution = 24 - this.allDensities.getShift();
            shapeBounds = RoundingUtils.round(shapeBounds, resolution);
            SplittableDensityArea splittableArea = new SplittableDensityArea(this.allDensities.subset(shapeBounds), this.startSearchLimit, this.trimShape);
            splittableArea.setMaxNodes(this.maxNodes);
            if (!splittableArea.hasData()) {
                System.out.println("Warning: a part of the bounding polygon would be empty and is ignored:" + shapeBounds);
                continue;
            }
            List<Area> partResult = splittableArea.split(shapeArea);
            if (partResult == null) continue;
            result.addAll(partResult);
        }
        return result;
    }

    private Solution findSolutionWithSinglePolygon(int depth, Tile tile, java.awt.geom.Area rasteredPolygonArea, Set<Rectangle> knownBad) {
        if (!rasteredPolygonArea.isSingular()) {
            return null;
        }
        if (rasteredPolygonArea.isRectangular()) {
            Tile part = new Tile(this.extraDensityInfo, rasteredPolygonArea.getBounds());
            return this.solveRectangularArea(part);
        }
        List<List<Point>> shapes = Utils.areaToShapes(rasteredPolygonArea);
        List<Point> shape = shapes.get(0);
        if (shape.size() > 40) {
            Tile part = new Tile(this.extraDensityInfo, rasteredPolygonArea.getBounds());
            System.out.println("Warning: rastered shape is too complex, using rectangle " + part + " instead");
            return this.solveRectangularArea(part);
        }
        Rectangle pBounds = rasteredPolygonArea.getBounds();
        int lastPoint = shape.size() - 1;
        if (shape.get(0).equals(shape.get(lastPoint))) {
            --lastPoint;
        }
        for (int i = 0; i <= lastPoint; ++i) {
            Point point = shape.get(i);
            if (i > 0 && point.equals(shape.get(0))) continue;
            int cutX = point.x;
            int cutY = point.y;
            Solution part1Sol = null;
            Solution part2Sol = null;
            for (int axis = 0; axis < 2; ++axis) {
                Rectangle r2;
                Rectangle r1;
                if (axis == 0) {
                    r1 = new Rectangle(pBounds.x, pBounds.y, cutX - pBounds.x, pBounds.height);
                    r2 = new Rectangle(cutX, pBounds.y, (int)(pBounds.getMaxX() - (double)cutX), pBounds.height);
                } else {
                    r1 = new Rectangle(pBounds.x, pBounds.y, pBounds.width, cutY - pBounds.y);
                    r2 = new Rectangle(pBounds.x, cutY, pBounds.width, (int)(pBounds.getMaxY() - (double)cutY));
                }
                if (r1.isEmpty() || r2.isEmpty() || knownBad.contains(r1) || knownBad.contains(r2)) continue;
                if (r1.width * r1.height > r2.width * r2.height) {
                    Rectangle help = r1;
                    r1 = r2;
                    r2 = help;
                }
                java.awt.geom.Area area = new java.awt.geom.Area(r1);
                area.intersect(rasteredPolygonArea);
                part1Sol = this.findSolutionWithSinglePolygon(depth + 1, tile, area, knownBad);
                if (part1Sol != null && !part1Sol.isEmpty()) {
                    area = new java.awt.geom.Area(r2);
                    area.intersect(rasteredPolygonArea);
                    part2Sol = this.findSolutionWithSinglePolygon(depth + 1, tile, area, knownBad);
                    if (part2Sol != null && !part2Sol.isEmpty()) {
                        part1Sol.merge(part2Sol);
                        return part1Sol;
                    }
                    knownBad.add(r2);
                    continue;
                }
                knownBad.add(r1);
            }
        }
        return new Solution(this.maxNodes);
    }

    private Solution solveRectangularArea(Tile startTile) {
        if (startTile.getCount() <= 1L) {
            return new Solution(this.maxNodes);
        }
        int bestPossible = this.stopNumber > 0 ? this.stopNumber : startTile.getMinParts(this.maxNodes);
        System.out.println("Splitting tile " + startTile + ", goal is to get near " + bestPossible + " tiles");
        return this.solveRectangularAreaParallel(startTile, 0);
    }

    private Solution solveRectangularAreaParallel(Tile startTile, int depth) {
        if (depth == 0 && (this.stopNumber > 0 || startTile.getCount() < 256L * this.maxNodes)) {
            return this.solveRectangularAreaOne(startTile);
        }
        Solution res = new Solution(this.maxNodes);
        long partSize = 64L * this.maxNodes;
        if (depth > 0) {
            partSize = Math.max(1L, startTile.getCount() - 1L);
        }
        List<Tile> todo = startTile.divide(partSize);
        System.out.println("Initial simple split returned " + todo.size() + " tile(s)");
        ArrayList<Solver> solvers = new ArrayList<Solver>();
        ArrayList<Area> initialAreas = new ArrayList<Area>();
        for (Tile t : todo) {
            int areaSize;
            if (t.outsidePolygon()) continue;
            if (this.trimTiles) {
                t = t.trim();
            }
            boolean useSearchAll = (areaSize = t.width * t.height) < 32000 || t.getCount() < 16L * this.maxNodes;
            boolean anyOutside = t.countElemsOutside() > 0;
            Solver solver = new Solver(++this.solverId, useSearchAll, this.maxNodes, t, this.shift, 0, this.trimTiles, this.startSearchLimit, this.allowEmptyPart);
            solver.maxAspectRatio = this.getStartRatio(startTile);
            System.out.println("Using " + solver.toString() + " on " + Utils.format(areaSize) + " grid elements" + (this.trimTiles && anyOutside ? ", trim needed" : ", trim not needed"));
            Rectangle r = t.getRealBBox();
            Area area = new Area(r.y, r.x, (int)r.getMaxY(), (int)r.getMaxX());
            area.setMapId(this.solverId);
            initialAreas.add(area);
            solvers.add(solver);
        }
        solvers.parallelStream().forEach(Solver::solve);
        ArrayList<Solver> solvers2 = new ArrayList<Solver>();
        if (this.enableExtraOpt) {
            for (int i = 0; i < solvers.size(); ++i) {
                Solver solver = (Solver)solvers.get(i);
                Solution s = solver.bestSolution;
                int goal = solver.startTile.getMinParts(this.maxNodes);
                int areaSize = ((Solver)solver).startTile.width * ((Solver)solver).startTile.height;
                if (areaSize > 200000 || s.size() <= 1 || s.isNice() && s.size() < goal + 3) continue;
                System.out.println("trying to improve poor solution from " + solver);
                Solver sv2 = new Solver(++this.solverId, !solver.searchAll, this.maxNodes, solver.startTile, this.shift, this.stopNumber, solver.trimTiles, this.startSearchLimit, this.allowEmptyPart);
                System.out.println("Starting " + sv2.toString());
                sv2.maxAspectRatio = this.getStartRatio(startTile);
                solvers2.add(sv2);
            }
            solvers2.parallelStream().forEach(Solver::solve);
        }
        for (Solver sv : solvers) {
            Solution sol2;
            Solution sol = sv.bestSolution;
            Optional<Solver> opt = solvers2.stream().filter(s2 -> sv.startTile.equals(((Solver)s2).startTile)).findAny();
            if (opt.isPresent() && (sol2 = opt.get().bestSolution).isNice() && sol2.isSmallerOrBetter(sol)) {
                System.out.println(opt.get().name + ": replaced solution from " + sv.name);
                sol = sol2;
            }
            if (sol.isEmpty()) {
                sol = this.solveRectangularAreaParallel(sv.startTile, depth + 1);
            }
            res.merge(sol);
        }
        return res;
    }

    private Solution solveRectangularAreaOne(Tile startTile) {
        if (startTile.getCount() == 0L) {
            return new Solution(this.maxNodes);
        }
        ArrayList<Solver> solvers = new ArrayList<Solver>();
        int numAlgos = 2;
        for (int i = 0; i < numAlgos; ++i) {
            Solver solver;
            if ((solver = new Solver(++this.solverId, i == 1, this.maxNodes, startTile, this.shift, this.stopNumber, this.trimTiles, this.startSearchLimit, this.allowEmptyPart)).searchAll && startTile.getCount() > 300L * this.maxNodes || !solver.searchAll && this.stopNumber == 0 && startTile.getCount() < 10L * this.maxNodes) continue;
            solver.maxAspectRatio = this.getStartRatio(startTile);
            solvers.add(solver);
        }
        if (solvers.size() == 1) {
            ((Solver)solvers.get(0)).solve();
        } else {
            ExecutorService threadPool = Executors.newFixedThreadPool(solvers.size());
            ArrayList futures = new ArrayList();
            for (Solver solver : solvers) {
                futures.add(threadPool.submit(solver::solve));
            }
            threadPool.shutdown();
            Instant t1 = null;
            double n75 = 0.75 * (double)this.maxNodes;
            double n85 = 0.85 * (double)this.maxNodes;
            while (!threadPool.isTerminated()) {
                for (int i = 0; i < solvers.size(); ++i) {
                    Future future = (Future)futures.get(i);
                    if (!future.isDone()) continue;
                    try {
                        future.get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new SplitFailedException("parallel solver crashed", e.getCause());
                    }
                    Solution sol = ((Solver)solvers.get(i)).bestSolution;
                    if (!sol.isNice()) continue;
                    if (t1 == null) {
                        t1 = Instant.now();
                    }
                    long dt = Duration.between(t1, Instant.now()).getSeconds();
                    boolean stop = false;
                    if ((double)sol.getWorstMinNodes() >= n85 && dt > 10L) {
                        stop = true;
                    } else {
                        int num75 = 0;
                        for (Tile tile : sol.getTiles()) {
                            if (!((double)tile.getCount() < n75)) continue;
                            ++num75;
                        }
                        double below75 = 100.0 * (double)num75 / (double)sol.size();
                        if (below75 > 5.0 && dt > 30L) {
                            stop = true;
                        }
                    }
                    if (!stop) continue;
                    solvers.forEach(Solver::stop);
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            futures.forEach(f -> {
                try {
                    f.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    Thread.currentThread().interrupt();
                    throw new SplitFailedException("parallel solver crashed", e.getCause());
                }
            });
            solvers.sort((o1, o2) -> {
                int d = Boolean.compare(((Solver)o1).bestSolution.isNice(), ((Solver)o2).bestSolution.isNice());
                if (d != 0) {
                    return -d;
                }
                d = Integer.compare(((Solver)o1).bestSolution.size(), ((Solver)o2).bestSolution.size());
                if (d != 0) {
                    return d;
                }
                return Long.compare(((Solver)o2).bestSolution.getWorstMinNodes(), ((Solver)o1).bestSolution.getWorstMinNodes());
            });
        }
        Solver best = (Solver)solvers.get(0);
        if (best.bestSolution.isEmpty()) {
            int highestCount = this.extraDensityInfo.getMaxNodesInDensityMapGridElement();
            double ratio = (double)highestCount / (double)this.maxNodes;
            if (ratio > 4.0) {
                System.err.printf("max-nodes value %d is far below highest node count %d in single grid element, consider using a higher resolution.%n", this.maxNodes, highestCount);
            } else if (ratio > 1.0) {
                System.err.printf("max-nodes value %d is below highest node count %d in single grid element, consider using a higher resolution.%n", this.maxNodes, highestCount);
            } else if (ratio < 0.25) {
                System.err.printf("max-nodes value %d is far above highest node count %d in single grid element, consider using a lower resolution.%n", this.maxNodes, highestCount);
            }
        }
        this.hasEmptyPart = best.hasEmptyPart;
        this.printFinishMsg(best.bestSolution, best.searchLimit);
        return best.bestSolution;
    }

    private double getStartRatio(Tile startTile) {
        if (this.extraDensityInfo.getNodeCount() / this.maxNodes < 4L) {
            return 32.0;
        }
        double startMaxAspectRatio = startTile.getAspectRatio();
        if (startMaxAspectRatio < 1.0) {
            startMaxAspectRatio = 1.0 / startMaxAspectRatio;
        }
        if (startMaxAspectRatio < 4.0) {
            startMaxAspectRatio = 4.0;
        }
        return startMaxAspectRatio;
    }

    private void printFinishMsg(Solution solution, int searchLimit) {
        if (!this.beQuiet && !solution.isEmpty()) {
            if ((double)solution.getWorstMinNodes() > 0.94 * (double)this.maxNodes && solution.isNice()) {
                System.out.println("Solution is very nice. No need to search for a better solution: " + solution.toString());
            } else {
                System.out.println("Solution is " + (solution.isNice() ? "" : "not ") + "nice. Can't find a better solution with search-limit " + searchLimit + ": " + solution.toString());
            }
        }
    }

    private static void printFinalSplitMsg(Solution solution) {
        System.out.println("Final solution: " + solution.toString());
        if (solution.isNice()) {
            System.out.println("This seems to be nice.");
        }
    }

    private List<Area> getAreas(Solution sol, java.awt.geom.Area polygonArea) {
        ArrayList<Area> result = new ArrayList<Area>();
        int minLat = this.allDensities.getBounds().getMinLat();
        int minLon = this.allDensities.getBounds().getMinLong();
        if (polygonArea != null) {
            System.out.println("Trying to cut the areas so that they fit into the polygon ...");
        } else if (this.trimShape) {
            sol.trimOuterTiles();
        }
        boolean fits = true;
        for (Tile tile : sol.getTiles()) {
            if (tile.getCount() == 0L) continue;
            if (!tile.verify()) {
                throw new SplitFailedException("found invalid tile");
            }
            Rectangle r = new Rectangle(minLon + (tile.x << this.shift), minLat + (tile.y << this.shift), tile.width << this.shift, tile.height << this.shift);
            if (polygonArea != null) {
                java.awt.geom.Area cutArea = new java.awt.geom.Area(r);
                cutArea.intersect(polygonArea);
                if (!cutArea.isEmpty() && cutArea.isRectangular()) {
                    r = cutArea.getBounds();
                } else {
                    fits = false;
                }
            }
            Area area = new Area(r.y, r.x, (int)r.getMaxY(), (int)r.getMaxX());
            if (!this.beQuiet) {
                String note = tile.getCount() > this.maxNodes ? " but is already at the minimum size so can't be split further" : "";
                long percentage = 100L * tile.getCount() / this.maxNodes;
                System.out.println("Area " + this.currMapId++ + " covers " + area + " and contains " + tile.getCount() + " nodes (" + percentage + " %)" + note);
            }
            result.add(area);
        }
        if (!fits) {
            System.out.println("One or more areas do not exactly fit into the bounding polygon");
        }
        return result;
    }

    private static class Solver {
        private final long myMaxNodes;
        private boolean hasEmptyPart;
        private double maxAspectRatio;
        private int countBad;
        private Long minNodes;
        private int searchLimit;
        private LinkedHashMap<Tile, Integer> incomplete;
        private Map<Tile, Long> knownBad = new HashMap<Tile, Long>(50000);
        static final int MAX_SEARCH_LIMIT = 5000000;
        final String name;
        private boolean searchAll;
        private Solution bestSolution;
        private Solution smallestSolution;
        private boolean stopped;
        private long localOptMinNodes;
        private final Tile startTile;
        private int bestPossible;
        private long largestOptTileCount;
        private int largestOptSize;
        private long optLoops;
        private int[] lastGoodCounts;
        private final int maxTileHeight;
        private final int maxTileWidth;
        private final int stopNumber;
        private final boolean trimTiles;
        private final int startSearchLimit;
        private final boolean allowEmptyPart;

        public Solver(int id, boolean searchAll, long maxNodes, Tile startTile, int shift, int stopNumber, boolean trimTiles, int startSearchLimit, boolean allowEmptyPart) {
            this.searchAll = searchAll;
            this.myMaxNodes = maxNodes;
            this.startTile = startTile;
            this.stopNumber = stopNumber;
            this.trimTiles = trimTiles;
            this.startSearchLimit = startSearchLimit;
            this.allowEmptyPart = allowEmptyPart;
            this.incomplete = new LinkedHashMap();
            this.bestSolution = new Solution(this.myMaxNodes);
            this.name = "S" + id + " " + (searchAll ? "FULL" : "SOME");
            this.maxTileHeight = Utils.toMapUnit(85.0) / (1 << shift);
            this.maxTileWidth = Utils.toMapUnit(90.0) / (1 << shift);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Solution findSolution(int depth, Tile tile, Tile parent, TileMetaInfo smiParent) {
            Long x;
            Long x2;
            boolean isCacheCandidate;
            if (this.stopped) {
                return null;
            }
            boolean addAndReturn = false;
            if (tile.getCount() == 0L) {
                if (!this.allowEmptyPart) {
                    this.hasEmptyPart = true;
                    return null;
                }
                if (tile.width * tile.height > 4) return new Solution(this.myMaxNodes);
                return null;
            }
            if (tile.getCount() > this.myMaxNodes && tile.width == 1 && tile.height == 1) {
                addAndReturn = true;
            } else if (tile.getCount() < this.minNodes && depth == 0) {
                addAndReturn = true;
            } else {
                if (tile.getCount() < this.minNodes) {
                    return null;
                }
                if (tile.getCount() <= this.myMaxNodes) {
                    double ratio = tile.getAspectRatio();
                    if (ratio < 1.0) {
                        ratio = 1.0 / ratio;
                    }
                    if (!(ratio <= this.maxAspectRatio)) return null;
                    if (this.stopNumber > 0 || this.myMaxNodes >= 10000000L || this.checkSize(tile)) {
                        addAndReturn = true;
                    }
                } else if (tile.width < 2 && tile.height < 2) {
                    return null;
                }
            }
            if (addAndReturn) {
                if (depth > 0 && (double)smiParent.getNumOutside() > 0.5 * (double)tile.width * (double)tile.height && !tile.outsideRatioIsOK(0.5)) {
                    return null;
                }
                Solution solution = new Solution(this.myMaxNodes);
                solution.add(tile);
                return solution;
            }
            if (tile.getCount() < this.minNodes * 2L) {
                return null;
            }
            if (!this.trimTiles && (long)tile.getMinParts(this.myMaxNodes) * this.minNodes > tile.getCount()) {
                return null;
            }
            Integer alreadyDone = null;
            if (this.countBad == 0 && !this.incomplete.isEmpty() && (alreadyDone = (Integer)this.incomplete.remove(tile)) == null) {
                this.incomplete.clear();
            }
            boolean bl = isCacheCandidate = depth > 0 && tile.width * tile.height > 100;
            if (alreadyDone == null && isCacheCandidate && (x2 = this.knownBad.get(tile)) != null && x2 <= this.minNodes) {
                return null;
            }
            TileMetaInfo smi = new TileMetaInfo(tile, parent, smiParent);
            smi.setMinNodes(this.minNodes);
            TestGenerator generator = new TestGenerator(this.searchAll, tile, smi);
            int countDone = 0;
            Solution bestSol = null;
            while (generator.hasNext()) {
                int axis;
                boolean ok;
                int splitPos = generator.next();
                if (alreadyDone != null && ++countDone <= alreadyDone || !(ok = (axis = generator.getAxis()) == 0 ? tile.splitHoriz(splitPos, smi) : tile.splitVert(splitPos, smi))) continue;
                Tile[] parts = smi.getParts();
                if (parts[0].getCount() > parts[1].getCount()) {
                    Tile help = parts[0];
                    parts[0] = parts[1];
                    parts[1] = help;
                }
                Solution[] sols = new Solution[2];
                int countOK = 0;
                for (int i = 0; i < 2; ++i) {
                    if (this.trimTiles && smi.getNumOutside() > 0) {
                        parts[i] = parts[i].trim();
                    }
                    if (!this.incomplete.isEmpty() && !this.incomplete.containsKey(parts[i])) continue;
                    sols[i] = this.findSolution(depth + 1, parts[i], tile, smi);
                    if (sols[i] == null) {
                        ++this.countBad;
                        break;
                    }
                    ++countOK;
                }
                if (countOK == 2) {
                    Solution sol = sols[0];
                    sol.merge(sols[1]);
                    if (bestSol == null || bestSol.compareTo(sol) > 0) {
                        bestSol = sol;
                    }
                    if (depth <= 0 && tile.getCount() <= 2L * this.myMaxNodes) continue;
                    break;
                }
                if (this.countBad < this.searchLimit) continue;
                if (depth < 10) {
                    this.lastGoodCounts[depth] = -1;
                }
                this.incomplete.put(tile, countDone - 1);
                break;
            }
            if (depth < 10 && this.countBad < this.searchLimit) {
                this.lastGoodCounts[depth] = countDone;
            }
            smi.propagateToParent(smiParent, tile, parent);
            if (bestSol == null && this.countBad < this.searchLimit && isCacheCandidate && ((x = this.knownBad.get(tile)) == null || x > this.minNodes)) {
                this.knownBad.put(tile, this.minNodes);
            }
            if (bestSol == null || this.localOptMinNodes <= 0L || bestSol.size() <= 2 || bestSol.size() > 32) return bestSol;
            long backupMinNodes = this.minNodes;
            boolean backupSearchAll = this.searchAll;
            int backupCountBad = this.countBad;
            int min = tile.getMinParts(this.myMaxNodes);
            int oldSize = bestSol.size();
            while (bestSol.size() > min) {
                this.localOptMinNodes = Math.max(tile.getCount() / (long)bestSol.size(), bestSol.getWorstMinNodes() + 1L);
                this.minNodes = this.localOptMinNodes;
                this.searchAll = false;
                this.countBad = 0;
                Solution sol2 = this.findSolution(depth, tile, parent, smiParent);
                ++this.optLoops;
                this.minNodes = backupMinNodes;
                this.searchAll = backupSearchAll;
                if (sol2 == null || !sol2.isSmallerOrBetter(bestSol)) break;
                if (tile.getCount() > this.largestOptTileCount) {
                    this.largestOptTileCount = tile.getCount();
                }
                if (oldSize > this.largestOptSize) {
                    this.largestOptSize = oldSize;
                }
                bestSol = sol2;
            }
            this.countBad = backupCountBad;
            return bestSol;
        }

        private boolean checkSize(Tile tile) {
            return tile.height <= this.maxTileHeight && tile.width <= this.maxTileWidth;
        }

        public String toString() {
            return this.name + " for tile " + this.startTile;
        }

        public void solve() {
            this.bestPossible = this.stopNumber > 0 ? this.stopNumber : this.startTile.getMinParts(this.myMaxNodes);
            this.solve0();
            if (this.smallestSolution.isSmallerOrBetter(this.bestSolution)) {
                this.bestSolution = this.smallestSolution;
            }
            System.out.println(this.name + " goal was " + this.bestPossible + " tiles, solver " + (this.stopped ? "was stopped" : "finished") + " with : " + this.bestSolution.toString());
            this.knownBad.clear();
            this.incomplete.clear();
        }

        private void solve0() {
            this.knownBad.clear();
            this.lastGoodCounts = new int[10];
            this.bestSolution = new Solution(this.myMaxNodes);
            this.smallestSolution = new Solution(this.myMaxNodes);
            this.minNodes = Math.max(Math.min((long)(0.05 * (double)this.myMaxNodes), (long)this.startTile.getLargestInfo()), 1L);
            this.searchLimit = this.startSearchLimit;
            TileMetaInfo smiStart = new TileMetaInfo(this.startTile, null, null);
            long veryNiceMinNodes = (long)(0.94 * (double)this.myMaxNodes);
            boolean clearIncomplete = false;
            for (int numLoops = 1; numLoops < 100 && !this.stopped; ++numLoops) {
                if (clearIncomplete) {
                    this.incomplete.clear();
                }
                double saveMaxAspectRatio = this.maxAspectRatio;
                long saveMinNodes = this.minNodes;
                this.countBad = 0;
                String dbgPrefix = this.name + ": step " + numLoops;
                smiStart.setMinNodes(this.minNodes);
                int oldCacheSize = this.knownBad.size();
                this.largestOptTileCount = 0L;
                this.largestOptSize = 0;
                Solution solution = this.findSolution(0, this.startTile, this.startTile, smiStart);
                if (this.stopped) {
                    return;
                }
                if (solution != null) {
                    boolean foundBetter;
                    if (solution.isSmallerOrBetter(this.smallestSolution)) {
                        this.smallestSolution = solution;
                    }
                    if (solution.size() < this.stopNumber) {
                        this.minNodes = (this.bestSolution.getWorstMinNodes() + solution.getWorstMinNodes()) / 2L;
                        if (this.minNodes != saveMinNodes) continue;
                        solution = null;
                    }
                    boolean bl = foundBetter = this.bestSolution.compareTo(solution) > 0;
                    if (solution != null) {
                        if (foundBetter) {
                            Solution prevBest = this.bestSolution;
                            this.bestSolution = solution;
                            System.out.println(dbgPrefix + " goal: " + this.bestPossible + " tiles, now: " + this.bestSolution + ", cache size " + Utils.format(this.knownBad.size()));
                            double factor = 1.1;
                            if (!prevBest.isEmpty() && prevBest.isNice()) {
                                factor = Math.min(1.3, (double)this.bestSolution.getWorstMinNodes() / (double)prevBest.getWorstMinNodes());
                            }
                            this.minNodes = Math.max(this.myMaxNodes / 3L, (long)((double)this.bestSolution.getWorstMinNodes() * factor));
                            if (this.localOptMinNodes == 0L) {
                                this.minNodes = this.bestSolution.getWorstMinNodes() + 1L;
                                this.localOptMinNodes = this.minNodes;
                            }
                        } else {
                            this.minNodes = solution.getWorstMinNodes() + 1L;
                        }
                    }
                } else if (!this.bestSolution.isEmpty() && this.minNodes > this.bestSolution.getWorstMinNodes() + 1L) {
                    this.minNodes = (this.bestSolution.getWorstMinNodes() + this.minNodes) / 2L;
                    if ((double)this.minNodes.longValue() < (double)this.bestSolution.getWorstMinNodes() * 1.001) {
                        this.minNodes = this.bestSolution.getWorstMinNodes() + 1L;
                    }
                } else if (!this.searchAll && oldCacheSize < this.knownBad.size() && this.bestSolution.isEmpty()) {
                    clearIncomplete = false;
                    continue;
                }
                if (!this.bestSolution.isEmpty()) {
                    if ((double)this.stopNumber * 0.95 > (double)this.bestSolution.getTiles().size()) {
                        return;
                    }
                    if (this.bestSolution.size() == 1) {
                        return;
                    }
                    if (this.bestSolution.size() == this.bestPossible && numLoops > 6) {
                        return;
                    }
                }
                if (this.stopNumber == 0 && this.minNodes > veryNiceMinNodes) {
                    this.minNodes = veryNiceMinNodes;
                }
                clearIncomplete = true;
                this.maxAspectRatio = Math.min(32.0, Math.max(this.bestSolution.getWorstAspectRatio() / 2.0, 4.0));
                if (saveMaxAspectRatio != this.maxAspectRatio || saveMinNodes != this.minNodes) continue;
                boolean tryAgain = false;
                if (this.bestSolution.isEmpty() || (double)this.bestSolution.getWorstMinNodes() < 0.5 * (double)this.myMaxNodes) {
                    if (this.countBad > this.searchLimit && this.searchLimit < 5000000) {
                        this.searchLimit *= 2;
                        this.knownBad.clear();
                        clearIncomplete = false;
                        System.out.println(this.name + ": No good solution found, duplicated search-limit to " + this.searchLimit);
                        tryAgain = true;
                    } else if (this.bestSolution.isEmpty() && this.minNodes > 1L) {
                        this.minNodes = 1L;
                        this.searchLimit = this.searchAll ? this.startSearchLimit : Math.max(5000000, this.startSearchLimit);
                        System.out.println(this.name + ": No good solution found, trying to find one accepting anything");
                        tryAgain = true;
                    } else if (!this.bestSolution.isEmpty() && this.smallestSolution.size() < this.bestSolution.size() && this.minNodes != this.smallestSolution.getWorstMinNodes() + 1L) {
                        this.minNodes = this.smallestSolution.getWorstMinNodes() + 1L;
                        tryAgain = true;
                    }
                }
                if (tryAgain) continue;
                return;
            }
        }

        void stop() {
            this.stopped = true;
        }

        private class TestGenerator {
            final boolean searchAll;
            int axis;
            final Tile tile;
            final TileMetaInfo smi;
            int countAxis;
            int usedTestPos;
            private IntArrayList todoList;

            public TestGenerator(boolean searchAll, Tile tile, TileMetaInfo smi) {
                this.searchAll = searchAll;
                this.tile = tile;
                this.smi = smi;
                this.axis = tile.getAspectRatio() >= 1.0 ? 0 : 1;
                this.todoList = this.generateTestCases();
            }

            boolean hasNext() {
                if (this.usedTestPos >= this.todoList.size()) {
                    ++this.countAxis;
                    if (this.countAxis > 1) {
                        return false;
                    }
                    this.axis = this.axis == 0 ? 1 : 0;
                    this.todoList = this.generateTestCases();
                    this.usedTestPos = 0;
                }
                return this.usedTestPos < this.todoList.size();
            }

            int next() {
                return this.todoList.get(this.usedTestPos++);
            }

            public int getAxis() {
                return this.axis;
            }

            IntArrayList generateTestCases() {
                int start = this.axis == 0 ? this.tile.findValidStartX(this.smi) : this.tile.findValidStartY(this.smi);
                int end = this.axis == 0 ? this.tile.findValidEndX(this.smi) : this.tile.findValidEndY(this.smi);
                int mid = (start + end) / 2;
                int range = end - start;
                if (this.searchAll || range < 4) {
                    return Tile.genTests(start, end);
                }
                double ratio = this.tile.getAspectRatio();
                IntArrayList tests = new IntArrayList();
                if (range < 0 || ratio < 0.03125 || ratio > 32.0 || ratio < 0.0625 && this.axis == 0 || ratio > 16.0 && this.axis == 1) {
                    return tests;
                }
                if (range == 0) {
                    tests.add(start);
                    return tests;
                }
                if (range > 1024 && (this.axis == 0 && this.tile.width >= Solver.this.maxTileWidth || this.axis == 1 && this.tile.height >= Solver.this.maxTileHeight)) {
                    for (int i = 5; i > 1; --i) {
                        tests.add(start + range / i);
                    }
                } else if (this.tile.getCount() < Solver.this.myMaxNodes * 4L && range > 256) {
                    int step = range / 20;
                    for (int pos = start; pos <= end; pos += step) {
                        tests.add(pos);
                    }
                    if (tests.get(tests.size() - 1) != end) {
                        tests.add(end);
                    }
                } else if (this.tile.getCount() > Solver.this.myMaxNodes * 4L) {
                    int step = range / 7;
                    if (step < 1) {
                        step = 1;
                    }
                    for (int pos = start; pos <= end; pos += step) {
                        tests.add(pos);
                    }
                } else {
                    long minCount = this.smi.getNumOutside() > 0 ? this.tile.countInside() : this.tile.getCount();
                    int nMin = (int)(minCount / Solver.this.myMaxNodes);
                    if ((long)nMin * Solver.this.myMaxNodes < minCount) {
                        ++nMin;
                    }
                    if (nMin == 0) {
                        ++nMin;
                    }
                    long limit = nMin == 0 ? 1L : minCount / (long)nMin;
                    double dMin = (double)minCount / (double)Solver.this.myMaxNodes;
                    int around = dMin > 1.8 && dMin < 2.0 && ratio > 0.125 && ratio < 8.0 || dMin > 2.8 && dMin < 3.0 ? this.tile.findFirstHigher(this.axis, this.smi, limit) : (dMin > 3.8 ? this.tile.findFirstHigher(this.axis, this.smi, 2L * limit) : -1);
                    if (around >= 0) {
                        int numAround = 20;
                        int p1 = Math.max(start, around - 10);
                        int p2 = Math.min(end, around + 10);
                        int toAdd = p2 - p1;
                        if (toAdd > 16) {
                            tests = new IntArrayList(toAdd);
                        }
                        for (int i = p1; i <= p2; ++i) {
                            tests.add(i);
                        }
                        tests.sort((o1, o2) -> Integer.compare(Math.abs(o1 - around), Math.abs(o2 - around)));
                        return tests;
                    }
                    if (nMin == 4) {
                        tests.add(this.tile.findFirstHigher(this.axis, this.smi, 2L * limit));
                    }
                    tests.add(this.tile.findFirstHigher(this.axis, this.smi, limit));
                }
                if (tests.size() > 4) {
                    tests.sort((o1, o2) -> Integer.compare(Math.abs(o1 - mid), Math.abs(o2 - mid)));
                    if (tests.getInt(0) != mid) {
                        tests.add(0, mid);
                    }
                }
                return tests;
            }
        }
    }
}

