/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.splitter.kml;

import java.awt.geom.PathIterator;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Locale;
import uk.me.parabola.splitter.Area;
import uk.me.parabola.splitter.Utils;

public class KmlWriter {
    private static void writeKmlHeader(PrintWriter pw) {
        pw.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<kml xmlns=\"http://www.opengis.net/kml/2.2\">\n<Document>\n  <Style id=\"transWhitePoly\">\n    <LineStyle>\n      <width>1.5</width>\n    </LineStyle>\n    <PolyStyle>\n      <color>00ffffff</color>\n      <colorMode>normal</colorMode>\n    </PolyStyle>\n  </Style>\n\n", new Object[0]);
    }

    private static void writeLineHeader(PrintWriter pw, int id, String name) {
        pw.format(Locale.ROOT, "  <Placemark>\n    <name>%1$d</name>\n    <styleUrl>#transWhitePoly</styleUrl>\n      <description>\n        <![CDATA[%2$s]]>\n      </description>\n    <Polygon>\n      <outerBoundaryIs>\n        <LinearRing>\n          <coordinates>\n", id, name);
    }

    private static void writeLineFooter(PrintWriter pw) {
        pw.format(Locale.ROOT, "          </coordinates>\n        </LinearRing>\n      </outerBoundaryIs>\n    </Polygon>\n  </Placemark>\n", new Object[0]);
    }

    private static void writeKmlFooter(PrintWriter pw) {
        pw.format("</Document>\n</kml>\n", new Object[0]);
    }

    private static void writeCoordinates(PrintWriter pw, double x, double y) {
        pw.format(Locale.ROOT, "            %f,%f\n", x, y);
    }

    public static void writeKml(String filename, String name, java.awt.geom.Area area) {
        String filePath = filename;
        if (!filePath.endsWith(".kml")) {
            filePath = filePath + ".kml";
        }
        try (PrintWriter pw = new PrintWriter(filePath);){
            KmlWriter.writeKmlHeader(pw);
            int linePart = 0;
            double startx = 0.0;
            double starty = 0.0;
            double[] res = new double[6];
            PathIterator pit = area.getPathIterator(null);
            int id = 0;
            while (!pit.isDone()) {
                int type = pit.currentSegment(res);
                double x = Utils.toDegrees((int)res[0]);
                double y = Utils.toDegrees((int)res[1]);
                switch (type) {
                    case 0: {
                        KmlWriter.writeLineHeader(pw, id++, name + linePart++);
                        KmlWriter.writeCoordinates(pw, x, y);
                        startx = x;
                        starty = y;
                        break;
                    }
                    case 1: {
                        KmlWriter.writeCoordinates(pw, x, y);
                        break;
                    }
                    case 4: {
                        KmlWriter.writeCoordinates(pw, startx, starty);
                        KmlWriter.writeLineFooter(pw);
                        break;
                    }
                    default: {
                        System.err.println("Unsupported path iterator type " + type + ". This is an internal splitter error.");
                        throw new IOException();
                    }
                }
                pit.next();
            }
            KmlWriter.writeKmlFooter(pw);
        }
        catch (IOException e) {
            System.err.println("Could not write KML file " + filePath + ", processing continues");
        }
    }

    public static void writeKml(String filename, List<Area> areas) {
        System.out.println("Writing KML file to " + filename);
        try (PrintWriter pw = new PrintWriter(filename);){
            KmlWriter.writeKmlHeader(pw);
            for (Area area : areas) {
                double south = Utils.toDegrees(area.getMinLat());
                double west = Utils.toDegrees(area.getMinLong());
                double north = Utils.toDegrees(area.getMaxLat());
                double east = Utils.toDegrees(area.getMaxLong());
                String name = area.getName() == null ? String.valueOf(area.getMapId()) : area.getName();
                KmlWriter.writeLineHeader(pw, area.getMapId(), name);
                KmlWriter.writeCoordinates(pw, west, south);
                KmlWriter.writeCoordinates(pw, west, north);
                KmlWriter.writeCoordinates(pw, east, north);
                KmlWriter.writeCoordinates(pw, east, south);
                KmlWriter.writeCoordinates(pw, west, south);
                KmlWriter.writeLineFooter(pw);
            }
            KmlWriter.writeKmlFooter(pw);
        }
        catch (IOException e) {
            System.err.println("Could not write KML file " + filename + ", processing continues");
        }
    }
}

