/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.splitter;

public class Convert {
    private static final double[] PowersOfTen = new double[]{10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19};

    public static double parseDouble(String cs) throws NumberFormatException {
        boolean isNegative;
        int end = Math.min(cs.length(), 19);
        int i = 0;
        char c = cs.charAt(i);
        boolean bl = isNegative = c == '-';
        if ((isNegative || c == '+') && ++i < end) {
            c = cs.charAt(i);
        }
        long decimal = 0L;
        int decimalPoint = -1;
        while (true) {
            int digit;
            if ((digit = c - 48) >= 0 && digit < 10) {
                long tmp = decimal * 10L + (long)digit;
                if (tmp < decimal) {
                    throw new NumberFormatException("Overflow! Too many digits in " + cs);
                }
                decimal = tmp;
            } else if (c == '.' && decimalPoint < 0) {
                decimalPoint = i;
            } else {
                return Double.parseDouble(cs);
            }
            if (++i >= end) break;
            c = cs.charAt(i);
        }
        if (isNegative) {
            decimal = -decimal;
        }
        if (decimalPoint >= 0 && decimalPoint < i - 1) {
            return (double)decimal / PowersOfTen[i - decimalPoint - 2];
        }
        return decimal;
    }
}

