/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.splitter;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

public class BackgroundInputStream
extends InputStream {
    private static final int QUEUE_SIZE = 5;
    private static final int BUFFER_SIZE = 32768;
    private static final byte[] EOF_MARKER = new byte[0];
    private final BlockingQueue<byte[]> inQueue;
    private final BlockingQueue<byte[]> recycleQueue;
    private final int bufferSize;
    protected final InputStream sourceStream;
    protected volatile boolean closed;
    private byte[] currentBuffer;
    private int currentIndex;
    private Thread loaderThread;

    public BackgroundInputStream(InputStream source) {
        this(source, 5, 32768);
    }

    public BackgroundInputStream(InputStream source, int queueSize, int bufferSize) {
        this.inQueue = new ArrayBlockingQueue<byte[]>(queueSize);
        this.recycleQueue = new ArrayBlockingQueue<byte[]>(queueSize + 1);
        this.sourceStream = source;
        this.bufferSize = bufferSize;
    }

    @Override
    public int read() throws IOException {
        if (!this.ensureBuffer()) {
            return -1;
        }
        byte b = this.currentBuffer[this.currentIndex++];
        this.recycle();
        return b;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int count = 0;
        while (len > 0) {
            if (!this.ensureBuffer()) {
                return count == 0 ? -1 : count;
            }
            int remaining = this.currentBuffer.length - this.currentIndex;
            int bytesToCopy = Math.min(remaining, len);
            System.arraycopy(this.currentBuffer, this.currentIndex, b, off, bytesToCopy);
            count += bytesToCopy;
            this.currentIndex += bytesToCopy;
            off += bytesToCopy;
            len -= bytesToCopy;
            this.recycle();
        }
        return count;
    }

    private boolean ensureBuffer() throws IOException {
        if (this.loaderThread == null) {
            this.loaderThread = new Thread((Runnable)new Loader(), "BackgroundInputStream");
            this.loaderThread.start();
        }
        if (this.currentBuffer == null) {
            try {
                this.currentBuffer = this.inQueue.take();
            }
            catch (InterruptedException e) {
                throw new IOException("Failed to take a buffer from the queue", e);
            }
            this.currentIndex = 0;
        }
        return this.currentBuffer != EOF_MARKER;
    }

    private void recycle() {
        if (this.currentIndex == this.currentBuffer.length) {
            if (this.currentIndex == this.bufferSize) {
                this.recycleQueue.offer(this.currentBuffer);
            }
            this.currentBuffer = null;
        }
    }

    @Override
    public int available() throws IOException {
        return this.currentBuffer == null ? 0 : this.currentBuffer.length;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.inQueue.clear();
        this.recycleQueue.clear();
        this.currentBuffer = null;
    }

    private class Loader
    implements Runnable {
        private Loader() {
        }

        @Override
        public void run() {
            int bytesRead = 0;
            while (!BackgroundInputStream.this.closed) {
                int offset;
                byte[] buffer = (byte[])BackgroundInputStream.this.recycleQueue.poll();
                if (buffer == null) {
                    buffer = new byte[BackgroundInputStream.this.bufferSize];
                }
                try {
                    for (offset = 0; offset < BackgroundInputStream.this.bufferSize && (bytesRead = BackgroundInputStream.this.sourceStream.read(buffer, offset, BackgroundInputStream.this.bufferSize - offset)) != -1; offset += bytesRead) {
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to read from stream", e);
                }
                if (offset < BackgroundInputStream.this.bufferSize) {
                    buffer = Arrays.copyOf(buffer, offset);
                }
                try {
                    BackgroundInputStream.this.inQueue.put(buffer);
                    if (bytesRead == -1) {
                        BackgroundInputStream.this.inQueue.put(EOF_MARKER);
                        BackgroundInputStream.this.closed = true;
                    }
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Unable to put data onto queue", e);
                }
                if (!BackgroundInputStream.this.closed) continue;
                try {
                    BackgroundInputStream.this.sourceStream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to close source stream", e);
                }
            }
        }
    }
}

