/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle.housenumber;

import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import uk.me.parabola.imgfmt.MapFailedException;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.imgfmt.app.net.NumberStyle;
import uk.me.parabola.imgfmt.app.net.Numbers;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.general.CityInfo;
import uk.me.parabola.mkgmap.general.MapRoad;
import uk.me.parabola.mkgmap.general.ZipCodeInfo;
import uk.me.parabola.mkgmap.osmstyle.housenumber.HousenumberGenerator;
import uk.me.parabola.mkgmap.osmstyle.housenumber.HousenumberMatch;
import uk.me.parabola.mkgmap.osmstyle.housenumber.HousenumberRoad;

public class ExtNumbers {
    private static final Logger log = Logger.getLogger(ExtNumbers.class);
    private final HousenumberRoad housenumberRoad;
    private static final int MAX_LOCATE_ERROR = 40;
    private static final List<HousenumberMatch> NO_HOUSES = Collections.emptyList();
    public ExtNumbers prev;
    public ExtNumbers next;
    private RoadSide leftSide;
    private RoadSide rightSide;
    private Numbers numbers = null;
    private int startInRoad;
    private int endInRoad;
    private int nodeIndex;
    private boolean needsSplit;
    private HousenumberMatch worstHouse;
    private int badNum;
    private boolean hasGaps;
    public static final int SR_FIX_ERROR = 0;
    public static final int SR_OPT_LEN = 1;
    public static final int SR_SPLIT_ROAD_END = 2;
    public static final int OK_NO_CHANGES = 0;
    public static final int OK_AFTER_CHANGES = 1;
    public static final int NOT_OK_TRY_SPLIT = 2;
    public static final int NOT_OK_KEEP = 3;
    public static final int NOT_OK_STOP = 4;

    public ExtNumbers(HousenumberRoad housenumberRoad) {
        this.housenumberRoad = housenumberRoad;
        this.reset();
    }

    private void setNeedsSplit(boolean b) {
        this.needsSplit = true;
    }

    public boolean needsSplit() {
        return this.needsSplit;
    }

    private boolean notInOrder(boolean left) {
        RoadSide rs = left ? this.leftSide : this.rightSide;
        return rs != null ? rs.notInOrder : false;
    }

    private List<HousenumberMatch> getHouses(boolean left) {
        RoadSide rs = left ? this.leftSide : this.rightSide;
        return rs != null ? rs.houses : NO_HOUSES;
    }

    private MapRoad getRoad() {
        return this.housenumberRoad.getRoad();
    }

    private void reset() {
        this.numbers = null;
        this.needsSplit = false;
        this.hasGaps = false;
    }

    public void setNodeIndex(int nodeIndex) {
        this.nodeIndex = nodeIndex;
        if (this.numbers != null) {
            this.numbers.setIndex(nodeIndex);
        }
    }

    public Numbers getNumbers() {
        if (this.numbers == null) {
            this.numbers = new Numbers();
            this.numbers.setIndex(this.nodeIndex);
            this.fillNumbers(true);
            this.fillNumbers(false);
            if (!this.numbers.isEmpty()) {
                this.verify(this.getHouses(true));
                this.verify(this.getHouses(false));
            }
        }
        return this.numbers;
    }

    public int setNumbers(List<HousenumberMatch> housenumbers, int startSegment, int endSegment, boolean left) {
        int assignedNumbers = 0;
        this.startInRoad = startSegment;
        this.endInRoad = endSegment;
        if (!housenumbers.isEmpty()) {
            RoadSide rs = new RoadSide();
            if (left) {
                this.leftSide = rs;
            } else {
                this.rightSide = rs;
            }
            int maxN = -1;
            int numHouses = housenumbers.size();
            for (int i = 0; i < numHouses; ++i) {
                HousenumberMatch house = housenumbers.get(i);
                if (house.isIgnored()) continue;
                if (house.getSegment() >= endSegment) break;
                maxN = i;
            }
            if (maxN >= 0) {
                assignedNumbers = maxN + 1;
                rs.houses = new ArrayList<HousenumberMatch>(housenumbers.subList(0, assignedNumbers));
                assert (startSegment < endSegment) : this;
                this.checkIfStartIsNumberNode();
            }
        }
        return assignedNumbers;
    }

    private void checkIfStartIsNumberNode() {
        if (!this.getRoad().getPoints().get(this.startInRoad).isNumberNode()) {
            log.error("internal error: start is not a number node", this);
        }
    }

    private void fillNumbers(boolean left) {
        NumberStyle style = NumberStyle.NONE;
        List<HousenumberMatch> houses = this.getHouses(left);
        if (!houses.isEmpty()) {
            ZipCodeInfo zipCodeInfo;
            CityInfo ci;
            HousenumberMatch highest;
            HashSet<CityInfo> cityInfos = new HashSet<CityInfo>();
            HashSet<ZipCodeInfo> zipCodes = new HashSet<ZipCodeInfo>();
            boolean even = false;
            boolean odd = false;
            boolean inOrder = true;
            boolean inc = false;
            boolean dec = false;
            HousenumberMatch lowest = highest = houses.get(0);
            Int2IntOpenHashMap distinctNumbers = new Int2IntOpenHashMap();
            int numHouses = houses.size();
            HousenumberMatch pred = null;
            for (int i = 0; i < numHouses; ++i) {
                HousenumberMatch house = houses.get(i);
                if (house.getCityInfo() != null && !house.getCityInfo().isEmpty()) {
                    cityInfos.add(house.getCityInfo());
                }
                if (house.getZipCode() != null && house.getZipCode().getZipCode() != null) {
                    zipCodes.add(house.getZipCode());
                }
                int num = house.getHousenumber();
                if (!this.hasGaps) {
                    distinctNumbers.put(num, 1);
                }
                if (num > highest.getHousenumber()) {
                    highest = house;
                }
                if (num < lowest.getHousenumber()) {
                    lowest = house;
                }
                if (num % 2 == 0) {
                    even = true;
                } else {
                    odd = true;
                }
                if (pred != null) {
                    int diff = num - pred.getHousenumber();
                    if (diff > 0) {
                        inc = true;
                    } else if (diff < 0) {
                        dec = true;
                    }
                }
                pred = house;
            }
            style = even && odd ? NumberStyle.BOTH : (even ? NumberStyle.EVEN : NumberStyle.ODD);
            int highestNum = highest.getHousenumber();
            int lowestNum = lowest.getHousenumber();
            int start = houses.get(0).getHousenumber();
            int end = houses.get(numHouses - 1).getHousenumber();
            boolean increasing = false;
            if (dec & inc) {
                inOrder = false;
            }
            if (start == end && highestNum - lowestNum != 0) {
                if (this.prev != null) {
                    int lastEnd = this.prev.getNumbers().getEnd(left);
                    if (lastEnd <= lowestNum) {
                        increasing = true;
                    }
                } else if (this.next != null) {
                    int nextStart = this.next.getNumbers().getStart(left);
                    if (highestNum < nextStart) {
                        increasing = true;
                    }
                } else {
                    increasing = true;
                }
            } else if (start != highestNum && start != lowestNum || end != highestNum && end != lowestNum) {
                inOrder = false;
                if (start <= end) {
                    increasing = true;
                }
            } else if (start < end) {
                increasing = true;
            }
            if (increasing) {
                start = lowestNum;
                end = highestNum;
            } else {
                start = highestNum;
                end = lowestNum;
            }
            if (!this.hasGaps) {
                int step = style == NumberStyle.BOTH ? 1 : 2;
                for (int n = lowestNum + step; n < highestNum; n += step) {
                    if (distinctNumbers.containsKey(n)) continue;
                    this.hasGaps = true;
                    break;
                }
            }
            RoadSide rs = left ? this.leftSide : this.rightSide;
            this.numbers.setNumbers(left, style, start, end);
            rs.multipleCities = cityInfos.size() > 1;
            boolean bl = rs.multipleZipCodes = zipCodes.size() > 1;
            if (cityInfos.size() == 1 && !(ci = (CityInfo)cityInfos.iterator().next()).isEmpty() && !ci.equals(this.housenumberRoad.getRoadCityInfo())) {
                this.numbers.setCityInfo(left, ci);
            }
            if (zipCodes.size() == 1 && (zipCodeInfo = (ZipCodeInfo)zipCodes.iterator().next()).getZipCode() != null && !zipCodeInfo.equals(this.housenumberRoad.getRoadZipCode())) {
                if (this.housenumberRoad.getRoadZipCode() == null) {
                    this.housenumberRoad.setZipCodeInfo(zipCodeInfo);
                } else {
                    this.numbers.setZipCode(left, zipCodeInfo);
                }
            }
            rs.notInOrder = !inOrder;
        }
    }

    public List<Numbers> getNumberList() {
        ArrayList<Numbers> list = new ArrayList<Numbers>();
        if (!this.hasNumbersInChain()) {
            return list;
        }
        boolean headerWasReported = false;
        ExtNumbers curr = this;
        while (curr != null) {
            Numbers cn = curr.getNumbers();
            this.checkIfStartIsNumberNode();
            if (!cn.isEmpty()) {
                list.add(cn);
            }
            if (log.isInfoEnabled()) {
                if (!headerWasReported) {
                    MapRoad road = curr.getRoad();
                    if (road.getStreet() == null && road.getName() == null) {
                        log.info("final numbers for", road, curr.housenumberRoad.getName(), "in", road.getCity());
                    } else {
                        log.info("final numbers for", road, "in", road.getCity());
                    }
                    headerWasReported = true;
                }
                log.info(new Object[]{"Left: ", cn.getLeftNumberStyle(), cn.getIndex(), "Start:", cn.getLeftStart(), "End:", cn.getLeftEnd(), "numbers " + curr.getHouses(true)});
                log.info(new Object[]{"Right:", cn.getRightNumberStyle(), cn.getIndex(), "Start:", cn.getRightStart(), "End:", cn.getRightEnd(), "numbers " + curr.getHouses(false)});
            }
            curr = curr.next;
        }
        return list;
    }

    private boolean hasNumbersInChain() {
        ExtNumbers curr = this;
        while (curr != null) {
            if (curr.hasNumbers()) {
                return true;
            }
            curr = curr.next;
        }
        return false;
    }

    public ExtNumbers checkSingleChainSegments(String streetName, boolean removeGaps) {
        ExtNumbers test;
        ExtNumbers curr = this;
        ExtNumbers head = this;
        if (this.housenumberRoad.isRandom() || removeGaps) {
            curr = head;
            while (curr != null) {
                while (curr.hasGaps && (removeGaps || curr.notInOrder(true) || curr.notInOrder(false))) {
                    curr.worstHouse = null;
                    curr.badNum = -1;
                    test = curr.tryChange(0);
                    if (test != curr) {
                        if (curr.prev == null) {
                            head = test;
                        }
                        curr = test;
                        continue;
                    }
                    log.warn("can't split numbers interaval for road", curr.getNumbers(), curr);
                    break;
                }
                curr = curr.next;
            }
        }
        curr = head;
        while (curr != null) {
            while (!curr.isPlausible()) {
                if (log.isInfoEnabled()) {
                    log.info("detected unplausible interval in", streetName, curr.getNumbers(), "in road", this.getRoad());
                }
                if (log.isDebugEnabled()) {
                    if (curr.notInOrder(true)) {
                        log.debug("left numbers not in order:", this.getRoad(), curr.getHouses(true));
                    }
                    if (curr.notInOrder(false)) {
                        log.debug("right numbers not in order:", this.getRoad(), curr.getHouses(false));
                    }
                }
                curr.setNeedsSplit(true);
                curr.findGoodSplitPos();
                test = curr.tryChange(0);
                if (test != curr) {
                    this.housenumberRoad.setChanged(true);
                    if (curr.prev == null) {
                        head = test;
                    }
                    curr = test;
                    continue;
                }
                log.warn("can't fix unplausible numbers interaval for road", curr.getNumbers(), curr);
                break;
            }
            curr = curr.next;
        }
        return head;
    }

    private void verify(List<HousenumberMatch> houses) {
        for (HousenumberMatch house : houses) {
            if (house.isIgnored()) continue;
            if (house.getSegment() < this.startInRoad || house.getSegment() >= this.endInRoad) {
                log.error("internal error, house has wrong segment, road", this.getRoad(), "house", house, house.toBrowseURL());
            }
            if (!Double.isNaN(house.getDistance()) && !(house.getDistance() > 160.0) || house.getGroup() != null) continue;
            log.error("internal error, distance to road too large, road", this.getRoad(), "house", house, house.toBrowseURL());
        }
    }

    public ExtNumbers tryChange(int reason) {
        ExtNumbers en = this;
        if (reason == 0 && !this.notInOrder(true) && !this.notInOrder(false)) {
            if (this.badNum < 0 && this.worstHouse != null) {
                this.badNum = this.worstHouse.getHousenumber();
            }
            if (this.badNum > 0) {
                en = this.splitInterval();
            } else {
                log.info("have to split", this);
            }
        }
        if (en == this) {
            en = this.tryAddNumberNode(reason);
        }
        boolean changedInterval = false;
        if (en != this) {
            if (en.hasNumbers() && en.next != null && en.next.hasNumbers()) {
                changedInterval = true;
            } else {
                ExtNumbers test;
                ExtNumbers extNumbers = test = en.hasNumbers() ? en : en.next;
                if (!test.getNumbers().isSimilar(this.getNumbers())) {
                    changedInterval = true;
                }
            }
            if (changedInterval) {
                this.housenumberRoad.setChanged(true);
            } else if (reason == 0) {
                if (en.hasNumbers()) {
                    en.worstHouse = this.worstHouse;
                    return en.tryChange(reason);
                }
                en.next.worstHouse = this.worstHouse;
                en.next = en.next.tryAddNumberNode(reason);
            }
        }
        return en;
    }

    private ExtNumbers splitInterval() {
        if (log.isDebugEnabled()) {
            log.debug("trying to split", this, "so that", this.badNum, "is not contained");
        }
        if (this.getRoad().countNodes() + 1 > 1023) {
            log.warn("cannot increase number of number nodes", this.getRoad());
            return this;
        }
        boolean doSplit = false;
        Numbers origNumbers = this.getNumbers();
        if (origNumbers.countMatches(this.badNum) == 0) {
            if (log.isDebugEnabled()) {
                log.debug("badNum", this.badNum, "is not contained in", this);
            }
            return this;
        }
        Numbers testNumbers = new Numbers();
        testNumbers.setNumbers(true, origNumbers.getLeftNumberStyle(), origNumbers.getLeftStart(), origNumbers.getLeftEnd());
        boolean left = testNumbers.countMatches(this.badNum) > 0;
        ArrayList<HousenumberMatch> before = new ArrayList<HousenumberMatch>();
        ArrayList after = new ArrayList();
        List<HousenumberMatch> toSplit = this.getHouses(left);
        boolean inc = origNumbers.getEnd(left) > origNumbers.getStart(left);
        BitSet segmentsBefore = new BitSet();
        BitSet segmentsAfter = new BitSet();
        for (HousenumberMatch house : toSplit) {
            int s;
            ArrayList<Object> target = house.getHousenumber() < this.badNum ? (inc ? before : after) : (house.getHousenumber() > this.badNum ? (inc ? after : before) : ((s = origNumbers.getStart(left)) == this.badNum ? before : after));
            target.add(house);
            if (target == before) {
                segmentsBefore.set(house.getSegment());
                continue;
            }
            segmentsAfter.set(house.getSegment());
        }
        if (before.isEmpty() || after.isEmpty()) {
            return this;
        }
        if (log.isDebugEnabled()) {
            log.debug("todo: find best method to separate", before, "and", after);
        }
        HousenumberMatch house1 = (HousenumberMatch)before.get(before.size() - 1);
        HousenumberMatch house2 = (HousenumberMatch)after.get(0);
        ArrayList<HousenumberMatch> testOrder = new ArrayList<HousenumberMatch>();
        testOrder.add(house1);
        testOrder.add(house2);
        testOrder.sort(new HousenumberGenerator.HousenumberMatchByPosComparator());
        if (testOrder.get(0) != house1) {
            log.info("order indicates random case or missing road!", this);
            this.housenumberRoad.setRandom(true);
        }
        int splitSegment = -1;
        if (house1.getSegment() != house2.getSegment()) {
            if (log.isDebugEnabled()) {
                log.debug("simple case: change point to number node between", house1, house2);
            }
            splitSegment = house2.getSegment();
            doSplit = true;
        } else {
            double len2;
            double len1;
            int seg = house1.getSegment();
            Coord c1 = this.getRoad().getPoints().get(seg);
            Coord c2 = this.getRoad().getPoints().get(seg + 1);
            double segmentLength = c1.distance(c2);
            Coord toAdd = null;
            boolean addOK = true;
            double wantedFraction = (house1.getSegmentFrac() + house2.getSegmentFrac()) / 2.0;
            if (wantedFraction <= 0.0) {
                wantedFraction = 0.0;
                toAdd = new Coord(c1);
            } else if (wantedFraction >= 1.0) {
                wantedFraction = 1.0;
                toAdd = new Coord(c2);
            }
            double usedFraction = wantedFraction;
            if (toAdd == null) {
                Coord wanted = c1.makeBetweenPoint(c2, wantedFraction);
                log.debug("possible solution: split segment with length", ExtNumbers.formatLen(segmentLength), "near", ExtNumbers.formatLen(wantedFraction * segmentLength));
                toAdd = ExtNumbers.rasterLineNearPoint(c1, c2, wanted, true);
                if (toAdd != null) {
                    if (toAdd.equals(c1)) {
                        toAdd = new Coord(c1);
                        usedFraction = 0.0;
                    } else if (toAdd.equals(c2)) {
                        toAdd = new Coord(c2);
                        usedFraction = 0.0;
                    } else {
                        addOK = this.checkLineDistortion(c1, c2, toAdd);
                        if (addOK) {
                            usedFraction = HousenumberGenerator.getFrac(c1, c2, toAdd);
                        } else {
                            toAdd = null;
                        }
                    }
                }
            }
            if (toAdd == null && Math.min(len1 = wantedFraction * segmentLength, len2 = (1.0 - wantedFraction) * segmentLength) < 40.0) {
                if (len1 < len2) {
                    toAdd = new Coord(c1);
                    usedFraction = 0.0;
                } else {
                    toAdd = new Coord(c2);
                    usedFraction = 1.0;
                }
            }
            if (toAdd == null) {
                log.error("internal error, cannot split", this);
            }
            if (toAdd != null) {
                if (log.isDebugEnabled()) {
                    log.debug("solution: split segment with length", ExtNumbers.formatLen(segmentLength), "at", ExtNumbers.formatLen(usedFraction * segmentLength));
                    double distToLine = toAdd.getDisplayedCoord().distToLineSegment(c1.getDisplayedCoord(), c2.getDisplayedCoord());
                    log.info("adding number node at", toAdd, "to split, dist to line is", ExtNumbers.formatLen(distToLine));
                }
                doSplit = true;
                splitSegment = seg + 1;
                this.addAsNumberNode(splitSegment, toAdd);
                ++this.endInRoad;
                for (HousenumberMatch house : before) {
                    if (house.getSegment() < seg) continue;
                    HousenumberGenerator.findClosestRoadSegment(house, this.getRoad(), seg, splitSegment);
                }
                for (HousenumberMatch house : after) {
                    if (house.getSegment() < splitSegment) {
                        HousenumberGenerator.findClosestRoadSegment(house, this.getRoad(), splitSegment, splitSegment + 1);
                        continue;
                    }
                    house.setSegment(house.getSegment() + 1);
                }
                this.recalcHousePositions(this.getHouses(!left));
            }
        }
        if (doSplit) {
            ExtNumbers en1 = this.split(splitSegment);
            ExtNumbers en2 = en1.next;
            if (en1.getHouses(true).size() + en2.getHouses(true).size() != this.getHouses(true).size() || en1.getHouses(false).size() + en2.getHouses(false).size() != this.getHouses(false).size()) {
                log.error((Object)"internal error, lost houses");
            }
            log.info("number node added in street", this.getRoad(), this.getNumbers(), "==>", en1.getNumbers(), "+", en2.getNumbers());
            return en1;
        }
        return this;
    }

    private boolean checkLineDistortion(Coord c1, Coord c2, Coord toAdd) {
        double angle;
        double distToLine = toAdd.getDisplayedCoord().distToLineSegment(c1.getDisplayedCoord(), c2.getDisplayedCoord());
        return !(distToLine > 0.2) || !(Math.abs(angle = Utils.getDisplayedAngle(c1, toAdd, c2)) > 3.0);
    }

    private ExtNumbers tryAddNumberNode(int reason) {
        String action;
        int numNumNodes = this.getRoad().countNodes();
        if (numNumNodes + 1 > 1023) {
            log.warn("can't change intervals, road has already", numNumNodes, "number nodes");
            return this;
        }
        if (this.endInRoad - this.startInRoad > 1) {
            action = "change";
        } else {
            double midFraction;
            Coord c2;
            Coord c1 = this.getRoad().getPoints().get(this.startInRoad);
            if (c1.equals(c2 = this.getRoad().getPoints().get(this.startInRoad + 1))) {
                return this.dupNode(0.0, 0);
            }
            double segmentLength = c1.distance(c2);
            int countAfterEnd = 0;
            int countBeforeStart = 0;
            double minFraction0To1 = 2.0;
            double maxFraction0To1 = -1.0;
            for (int side = 0; side < 2; ++side) {
                boolean left = side == 0;
                List<HousenumberMatch> houses = this.getHouses(left);
                for (HousenumberMatch house : houses) {
                    if (house.getSegmentFrac() < 0.0) {
                        ++countBeforeStart;
                        continue;
                    }
                    if (house.getSegmentFrac() > 1.0) {
                        ++countAfterEnd;
                        continue;
                    }
                    if (minFraction0To1 > house.getSegmentFrac()) {
                        minFraction0To1 = house.getSegmentFrac();
                    }
                    if (!(maxFraction0To1 < house.getSegmentFrac())) continue;
                    maxFraction0To1 = house.getSegmentFrac();
                }
            }
            if (countBeforeStart > 0) {
                return this.dupNode(0.0, 2);
            }
            if (countAfterEnd > 0) {
                return this.dupNode(1.0, 2);
            }
            double wantedFraction = midFraction = (minFraction0To1 + maxFraction0To1) / 2.0;
            Coord toAdd = null;
            double len1 = segmentLength * minFraction0To1;
            double len2 = segmentLength * maxFraction0To1;
            double len3 = (1.0 - maxFraction0To1) * segmentLength;
            if (reason == 0 && this.worstHouse != null && ((wantedFraction = this.worstHouse.getSegmentFrac()) < minFraction0To1 || wantedFraction > maxFraction0To1)) {
                log.error("internal error, worst house not found", this, this.worstHouse);
            }
            boolean allowSplitBetween = true;
            boolean forceEmpty = false;
            ArrayList<Double> wantedFractions = new ArrayList<Double>();
            if (reason == 1) {
                if (log.isDebugEnabled()) {
                    if (maxFraction0To1 != minFraction0To1) {
                        log.debug("trying to find good split point, houses are between", ExtNumbers.formatLen(len1), "and", ExtNumbers.formatLen(len2), "in segment with", ExtNumbers.formatLen(segmentLength));
                    } else {
                        log.debug("trying to find good split point, houses are at", ExtNumbers.formatLen(len1), "in segment with", ExtNumbers.formatLen(segmentLength));
                    }
                }
                if (len2 - len1 < 10.0 && this.getHouses(true).size() <= 1 && this.getHouses(false).size() <= 1) {
                    wantedFraction = midFraction * 2.0 - (double)(midFraction > 0.5 ? 1 : 0);
                    allowSplitBetween = false;
                } else {
                    if (len1 > 20.0) {
                        wantedFractions.add(minFraction0To1 * 0.999);
                        forceEmpty = true;
                    }
                    if (len3 > 20.0) {
                        if (!wantedFractions.isEmpty() && len3 > len1) {
                            wantedFractions.add(0, maxFraction0To1 * 1.001);
                        } else {
                            wantedFractions.add(maxFraction0To1 * 1.001);
                        }
                        forceEmpty = true;
                    }
                }
            }
            if (wantedFractions.isEmpty()) {
                wantedFractions.add(wantedFraction);
            }
            double usedFraction = 0.0;
            double bestDist = Double.MAX_VALUE;
            for (int w = 0; w < wantedFractions.size(); ++w) {
                boolean tryAgain;
                double expectedError;
                wantedFraction = (Double)wantedFractions.get(w);
                double partLen = wantedFraction * segmentLength;
                double shorterLen = Math.min(partLen, segmentLength - partLen);
                if (shorterLen < 10.0) {
                    if (reason == 0 && minFraction0To1 == maxFraction0To1) {
                        return this.dupNode(midFraction, 0);
                    }
                    double splitFrac = len1 < len3 ? minFraction0To1 : maxFraction0To1;
                    return this.dupNode(splitFrac, 1);
                }
                double maxDistBefore = expectedError = c1.getDisplayedCoord().distance(new Coord(c1.getLatitude() + 1, c1.getLongitude()));
                double maxDistAfter = expectedError;
                if (wantedFraction < minFraction0To1) {
                    maxDistAfter = 0.0;
                }
                if (wantedFraction > maxFraction0To1) {
                    maxDistBefore = 0.0;
                }
                do {
                    Coord wanted = c1.makeBetweenPoint(c2, wantedFraction);
                    TreeMap<Double, List<Coord>> candidates = ExtNumbers.rasterLineNearPoint2(c1, c2, wanted, maxDistBefore, maxDistAfter);
                    boolean foundGood = false;
                    block4: for (Map.Entry entry : candidates.entrySet()) {
                        if (foundGood) break;
                        bestDist = (Double)entry.getKey();
                        for (Coord candidate : (List)entry.getValue()) {
                            double angle;
                            toAdd = candidate;
                            usedFraction = HousenumberGenerator.getFrac(c1, c2, toAdd);
                            if (usedFraction <= 0.0 || usedFraction >= 1.0) {
                                toAdd = null;
                                continue;
                            }
                            if (usedFraction > minFraction0To1 && wantedFraction < minFraction0To1 || usedFraction < maxFraction0To1 && wantedFraction > maxFraction0To1) {
                                toAdd = null;
                                continue;
                            }
                            if (!allowSplitBetween && usedFraction > minFraction0To1 && usedFraction < maxFraction0To1) {
                                toAdd = null;
                                continue;
                            }
                            if (bestDist > 0.2 && Math.abs(angle = Utils.getDisplayedAngle(c1, toAdd, c2)) > 3.0) {
                                toAdd = null;
                                continue;
                            }
                            foundGood = true;
                            continue block4;
                        }
                    }
                    if (foundGood) break;
                    toAdd = null;
                    tryAgain = false;
                    if (maxDistBefore > 0.0 && maxDistBefore < segmentLength * wantedFraction) {
                        maxDistBefore *= 2.0;
                        tryAgain = true;
                    }
                    if (!(maxDistAfter > 0.0) || !(maxDistAfter < segmentLength * (1.0 - wantedFraction))) continue;
                    maxDistAfter *= 2.0;
                    tryAgain = true;
                } while (tryAgain);
                if (toAdd != null) break;
            }
            boolean addOK = true;
            if (toAdd == null) {
                addOK = false;
            } else {
                toAdd.incHighwayCount();
                if (log.isDebugEnabled()) {
                    log.debug("spliting road segment", this.startInRoad, "at", ExtNumbers.formatLen(usedFraction * segmentLength));
                }
            }
            if (!addOK) {
                if (reason == 0 && minFraction0To1 == maxFraction0To1) {
                    return this.dupNode(midFraction, 0);
                }
                if (Math.min(len1, len3) < 40.0) {
                    double splitFrac = midFraction;
                    if (splitFrac <= 0.5) {
                        if (splitFrac * segmentLength > 40.0) {
                            splitFrac = Math.max(minFraction0To1, 40.0 / segmentLength);
                        }
                    } else if ((1.0 - splitFrac) * segmentLength > 40.0) {
                        splitFrac = Math.min(maxFraction0To1, (segmentLength - 40.0) / segmentLength);
                    }
                    return this.dupNode(splitFrac, 1);
                }
                if (reason == 0) {
                    log.warn("can't fix error in interval", this);
                } else if (log.isDebugEnabled()) {
                    log.debug("can't improve search result", this);
                }
                return this;
            }
            if (log.isInfoEnabled()) {
                log.info("adding number node at", toAdd, "to split, dist to line is", ExtNumbers.formatLen(bestDist));
            }
            action = "add";
            this.endInRoad = this.addAsNumberNode(this.startInRoad + 1, toAdd);
            int forcedSegment = -1;
            if (forceEmpty) {
                if (wantedFraction < minFraction0To1) {
                    forcedSegment = this.startInRoad + 1;
                } else if (wantedFraction > maxFraction0To1) {
                    forcedSegment = this.startInRoad;
                }
            }
            if (forcedSegment >= 0) {
                this.setSegment(forcedSegment, this.getHouses(true));
                this.setSegment(forcedSegment, this.getHouses(false));
            } else {
                this.recalcHousePositions(this.getHouses(true));
                this.recalcHousePositions(this.getHouses(false));
            }
        }
        int splitSegment = (this.startInRoad + this.endInRoad) / 2;
        if (this.worstHouse != null) {
            if (this.worstHouse.getSegment() == this.startInRoad) {
                splitSegment = this.startInRoad + 1;
            } else if (this.worstHouse.getSegment() == this.endInRoad - 1) {
                splitSegment = this.worstHouse.getSegment();
            }
        } else if (this.endInRoad - this.startInRoad > 2) {
            int firstSegWithHouses = this.endInRoad;
            int lastSegWithHouses = -1;
            for (int side = 0; side < 2; ++side) {
                boolean left = side == 0;
                List<HousenumberMatch> houses = this.getHouses(left);
                for (HousenumberMatch house : houses) {
                    int s = house.getSegment();
                    if (s < firstSegWithHouses) {
                        firstSegWithHouses = s;
                    }
                    if (s <= lastSegWithHouses) continue;
                    lastSegWithHouses = s;
                }
            }
            splitSegment = (firstSegWithHouses + lastSegWithHouses) / 2;
            if (splitSegment == this.startInRoad) {
                ++splitSegment;
            }
        }
        ExtNumbers en1 = this.split(splitSegment);
        ExtNumbers en2 = en1.next;
        if (reason == 1) {
            // empty if block
        }
        if ("add".equals(action)) {
            log.info("number node added in street", this.getRoad(), this.getNumbers(), "==>", en1.getNumbers(), "+", en2.getNumbers());
        } else {
            log.info("point changed to number node in street", this.getRoad(), this.getNumbers(), "==>", en1.getNumbers(), "+", en2.getNumbers());
        }
        return en1;
    }

    private ExtNumbers dupNode(double fraction, int reason) {
        log.info("duplicating number node in road", this.getRoad(), this.getNumbers(), this.getHouses(true), this.getHouses(false));
        boolean atStart = fraction <= 0.5;
        int index = atStart ? this.startInRoad : this.endInRoad;
        int splitSegment = atStart ? this.startInRoad + 1 : this.endInRoad;
        Coord closePoint = this.getRoad().getPoints().get(index);
        Coord toAdd = new Coord(closePoint);
        toAdd.setOnBoundary(closePoint.getOnBoundary());
        toAdd.setOnCountryBorder(closePoint.getOnCountryBorder());
        toAdd.incHighwayCount();
        this.endInRoad = this.addAsNumberNode(splitSegment, toAdd);
        List<ArrayList> leftTargets = Arrays.asList(new ArrayList(), new ArrayList());
        List<ArrayList> rightTargets = Arrays.asList(new ArrayList(), new ArrayList());
        if (reason == 2 || reason == 1) {
            for (int side = 0; side < 2; ++side) {
                boolean left = side == 0;
                List<ArrayList> targets = left ? leftTargets : rightTargets;
                for (HousenumberMatch house : this.getHouses(left)) {
                    int target = house.getSegmentFrac() < fraction ? 0 : (house.getSegmentFrac() > fraction ? 1 : (atStart ? 0 : 1));
                    targets.get(target).add(house);
                }
            }
        } else if (this.getHouses(true).size() > 1 || this.getHouses(false).size() > 1) {
            for (int side = 0; side < 2; ++side) {
                List<ArrayList> targets;
                boolean left;
                boolean bl = left = side == 0;
                if (this.getHouses(left).isEmpty()) continue;
                int start = this.getNumbers().getStart(left);
                int end = this.getNumbers().getEnd(left);
                List<ArrayList> list = targets = left ? leftTargets : rightTargets;
                if (start != end) {
                    int midNum = (start + end) / 2;
                    for (HousenumberMatch house : this.getHouses(left)) {
                        int target = house.getHousenumber() < midNum ? 0 : (house.getHousenumber() > midNum ? 1 : (atStart ? 0 : 1));
                        targets.get(target).add(house);
                    }
                    continue;
                }
                if (!this.multipleZipOrCity(left)) {
                    if (atStart) {
                        targets.get(1).addAll(this.getHouses(left));
                        continue;
                    }
                    targets.get(0).addAll(this.getHouses(left));
                    continue;
                }
                int mid = this.getHouses(left).size() / 2;
                targets.get(0).addAll(this.getHouses(left).subList(0, mid));
                targets.get(1).addAll(this.getHouses(left).subList(mid, this.getHouses(left).size()));
            }
        } else {
            log.error("internal error, don't know how to split", this);
        }
        assert (splitSegment != this.startInRoad && splitSegment != this.endInRoad);
        this.setSegment(this.startInRoad, leftTargets.get(0));
        this.setSegment(this.startInRoad, rightTargets.get(0));
        this.setSegment(splitSegment, leftTargets.get(1));
        this.setSegment(splitSegment, rightTargets.get(1));
        ExtNumbers en1 = this.divide();
        ExtNumbers en2 = en1.next;
        en1.setNumbers(leftTargets.get(0), this.startInRoad, splitSegment, true);
        en1.setNumbers(rightTargets.get(0), this.startInRoad, splitSegment, false);
        en2.setNumbers(leftTargets.get(1), splitSegment, this.endInRoad, true);
        en2.setNumbers(rightTargets.get(1), splitSegment, this.endInRoad, false);
        log.info("zero length interval added in street", this.getRoad(), this.getNumbers(), "==>", en1.getNumbers(), "+", en2.getNumbers());
        if (atStart && !en1.hasNumbers() || !atStart && !en2.hasNumbers()) {
            log.error("internal error, zero length interval has no numbers in road", this.getRoad());
        }
        return en1;
    }

    private void setSegment(int segment, List<HousenumberMatch> houses) {
        for (HousenumberMatch house : houses) {
            HousenumberGenerator.findClosestRoadSegment(house, this.getRoad(), segment, segment + 1);
            if (house.getRoad() != null && house.getSegment() == segment) continue;
            log.error("internal error, house too far from forced segment in road", this.getRoad(), house, house.toBrowseURL());
            house.setIgnored(true);
        }
    }

    private void recalcHousePositions(List<HousenumberMatch> houses) {
        for (HousenumberMatch house : houses) {
            HousenumberGenerator.findClosestRoadSegment(house, this.getRoad(), this.startInRoad, this.endInRoad);
        }
        if (houses.size() > 1) {
            houses.sort(new HousenumberGenerator.HousenumberMatchByPosComparator());
        }
    }

    private ExtNumbers divide() {
        ExtNumbers en1 = new ExtNumbers(this.housenumberRoad);
        ExtNumbers en2 = new ExtNumbers(this.housenumberRoad);
        en1.prev = this.prev;
        if (this.prev != null) {
            this.prev.next = en1;
        }
        en1.next = en2;
        en2.prev = en1;
        en2.next = this.next;
        if (this.next != null) {
            this.next.prev = en2;
        }
        en1.setNodeIndex(this.nodeIndex);
        en2.setNodeIndex(this.nodeIndex + 1);
        ExtNumbers work = en2.next;
        while (work != null) {
            work.setNodeIndex(work.nodeIndex + 1);
            work = work.next;
        }
        return en1;
    }

    private int addAsNumberNode(int pos, Coord toAdd) {
        if (this.getRoad().countNodes() + 1 > 1023) {
            throw new MapFailedException("too many number nodes in " + this.getRoad());
        }
        toAdd.setNumberNode(true);
        toAdd.setAddedNumberNode(true);
        this.getRoad().getPoints().add(pos, toAdd);
        ExtNumbers work = this.next;
        while (work != null) {
            work.increaseNodeIndexes(this.startInRoad);
            work = work.next;
        }
        return this.endInRoad + 1;
    }

    private void increaseNodeIndexes(int startPos) {
        if (this.startInRoad > startPos) {
            ++this.startInRoad;
            ++this.endInRoad;
        }
        for (int side = 0; side < 2; ++side) {
            boolean left = side == 0;
            for (HousenumberMatch house : this.getHouses(left)) {
                int s = house.getSegment();
                if (s > startPos) {
                    house.setSegment(s + 1);
                    continue;
                }
                assert (false) : "internal error " + this.getRoad() + " " + this.getHouses(true) + " " + this.getHouses(false);
            }
        }
    }

    private void findGoodSplitPos() {
        this.badNum = -1;
        this.worstHouse = null;
        boolean multipleZipOrCity = false;
        for (int side = 0; side < 2; ++side) {
            boolean left = side == 0;
            List<HousenumberMatch> houses = this.getHouses(left);
            if (houses.size() <= 1) continue;
            if (this.multipleZipOrCity(left)) {
                multipleZipOrCity = true;
            }
            if (houses.size() >= 50) continue;
            for (HousenumberMatch house : houses) {
                ExtNumbers modIvl;
                int hn = house.getHousenumber();
                if (ExtNumbers.countOccurence(houses, hn) > 1 || !(modIvl = this.simulateRemovalOfHouseNumber(hn, left)).isPlausible()) continue;
                this.badNum = hn;
                if (log.isDebugEnabled()) {
                    log.debug("splitpos details: single remove of", this.badNum, "results in plausible interval");
                }
                return;
            }
        }
        if (multipleZipOrCity) {
            return;
        }
        Numbers ivl = this.getNumbers();
        int[] firstBad = new int[]{-1, -1};
        int[] lastBad = new int[]{-1, -1};
        for (int side = 0; side < 2; ++side) {
            boolean left = side == 0;
            int step = 2;
            if (ivl.getNumberStyle(left) == NumberStyle.BOTH) {
                step = 1;
            }
            int s = ivl.getStart(left);
            int e = ivl.getEnd(left);
            int s2 = ivl.getStart(!left);
            int e2 = ivl.getEnd(!left);
            NumberStyle style2 = ivl.getNumberStyle(!left);
            for (int hn = Math.min(s, e); hn <= Math.max(s, e); hn += step) {
                if (style2 == NumberStyle.EVEN && hn % 2 == 1 || style2 == NumberStyle.ODD && hn % 2 == 0) {
                    if (firstBad[side] < 0) {
                        firstBad[side] = hn;
                    }
                    lastBad[side] = hn;
                    continue;
                }
                if (hn >= Math.min(s2, e2) && hn <= Math.max(s2, e2)) continue;
                if (firstBad[side] < 0) {
                    firstBad[side] = hn;
                }
                lastBad[side] = hn;
            }
        }
        if (firstBad[0] == lastBad[0]) {
            this.badNum = firstBad[0];
            if (this.badNum >= 0) {
                return;
            }
        }
        if (firstBad[1] == lastBad[1]) {
            this.badNum = firstBad[1];
            if (this.badNum >= 0) {
                return;
            }
        }
        this.badNum = Math.max(firstBad[0], lastBad[0]);
        if (this.badNum == -1) {
            this.badNum = Math.min(firstBad[1], lastBad[1]);
        }
        if (log.isDebugEnabled()) {
            log.debug("splitpos details", Arrays.toString(firstBad), Arrays.toString(lastBad), "gives badNum", this.badNum);
        }
    }

    private boolean multipleZipOrCity(boolean left) {
        RoadSide rs;
        RoadSide roadSide = rs = left ? this.leftSide : this.rightSide;
        return rs == null ? false : rs.multipleCities || rs.multipleZipCodes;
    }

    public ExtNumbers checkChainPlausibility(String streetName, List<HousenumberMatch> potentialNumbersThisRoad) {
        ExtNumbers head = this;
        for (int loop = 0; loop < 10; ++loop) {
            boolean anyChanges = false;
            ExtNumbers en1 = head;
            while (en1 != null && !anyChanges) {
                if (en1.hasNumbers()) {
                    ExtNumbers en2 = en1.next;
                    while (en2 != null && !anyChanges) {
                        if (en2.hasNumbers()) {
                            int res = ExtNumbers.checkIntervals(streetName, en1, en2);
                            switch (res) {
                                case 0: 
                                case 3: {
                                    break;
                                }
                                case 1: {
                                    anyChanges = true;
                                    break;
                                }
                                case 2: {
                                    ExtNumbers test;
                                    if (en1.needsSplit && (test = en1.tryChange(0)) != en1) {
                                        this.housenumberRoad.setChanged(true);
                                        anyChanges = true;
                                        if (test.prev == null) {
                                            head = test;
                                        }
                                    }
                                    if (!en2.needsSplit || (test = en2.tryChange(0)) == en2) break;
                                    anyChanges = true;
                                    this.housenumberRoad.setChanged(true);
                                    break;
                                }
                                case 4: {
                                    return head;
                                }
                            }
                        }
                        en2 = en2.next;
                    }
                }
                en1 = en1.next;
            }
            if (!anyChanges) break;
        }
        return head;
    }

    public static int checkIntervals(String streetName, ExtNumbers en1, ExtNumbers en2) {
        if (en1.getRoad() != en2.getRoad()) {
            Coord cs1 = en1.getRoad().getPoints().get(en1.startInRoad);
            Coord ce1 = en1.getRoad().getPoints().get(en1.endInRoad);
            Coord ce2 = en2.getRoad().getPoints().get(en2.endInRoad);
            if (ce2 == cs1 || ce2 == ce1) {
                ExtNumbers help = en1;
                en1 = en2;
                en2 = help;
            }
        }
        boolean allOK = true;
        Numbers ivl1 = en1.getNumbers();
        Numbers ivl2 = en2.getNumbers();
        for (int i = 0; i < 2; ++i) {
            boolean left1 = i == 0;
            NumberStyle style1 = ivl1.getNumberStyle(left1);
            if (style1 == NumberStyle.NONE) continue;
            int s1 = ivl1.getStart(left1);
            int e1 = ivl1.getEnd(left1);
            for (int j = 0; j < 2; ++j) {
                boolean left2 = j == 0;
                NumberStyle style2 = ivl2.getNumberStyle(left2);
                if (style2 == NumberStyle.NONE) continue;
                int s2 = ivl2.getStart(left2);
                int e2 = ivl2.getEnd(left2);
                boolean ok = true;
                if (style1 == style2 || style1 == NumberStyle.BOTH || style2 == NumberStyle.BOTH) {
                    ok = ExtNumbers.checkIntervalBoundaries(s1, e1, s2, e2, left1 == left2 && en1.getRoad() == en2.getRoad());
                }
                if (ok) continue;
                if (en1.getRoad() != en2.getRoad() && !en1.hasGaps && !en2.hasGaps) {
                    allOK = false;
                    continue;
                }
                if (s1 == e1 && en1.getHouses(left1).get(0).isFarDuplicate()) {
                    allOK = false;
                    continue;
                }
                if (s2 == e2 && en2.getHouses(left2).get(0).isFarDuplicate()) {
                    allOK = false;
                    continue;
                }
                List<HousenumberMatch> houses1 = en1.getHouses(left1);
                List<HousenumberMatch> houses2 = en2.getHouses(left2);
                if (log.isInfoEnabled()) {
                    log.info("detected unplausible combination of intervals in", streetName, s1 + ".." + e1, "and", s2 + ".." + e2, "houses:", left1 ? "left:" : "right", houses1, left2 ? "left:" : "right", houses2, en1.getRoad() == en2.getRoad() ? "in road " + en1.getRoad() : "road id(s):" + en1.getRoad().getRoadDef().getId() + ", " + en2.getRoad().getRoadDef().getId());
                }
                double smallestDelta = Double.POSITIVE_INFINITY;
                HousenumberMatch bestMoveOrig = null;
                HousenumberMatch bestMoveMod = null;
                ExtNumbers bestRemove = null;
                ArrayList<HousenumberMatch> possibleRemoves1 = new ArrayList<HousenumberMatch>();
                ArrayList<HousenumberMatch> possibleRemoves2 = new ArrayList<HousenumberMatch>();
                if (!en1.housenumberRoad.isRandom() && !en2.housenumberRoad.isRandom()) {
                    double deltaDist;
                    HousenumberMatch test;
                    boolean ok2;
                    NumberStyle modStyle;
                    Numbers modNumbers;
                    int n;
                    for (HousenumberMatch house : houses1) {
                        if (house.getGroup() != null || ExtNumbers.countOccurence(houses1, n = house.getHousenumber()) > 1 || n != s1 && n != e1) continue;
                        modNumbers = en1.simulateRemovalOfHouseNumber(n, left1).getNumbers();
                        int s1Mod = modNumbers.getStart(left1);
                        int e1Mod = modNumbers.getEnd(left1);
                        modStyle = modNumbers.getNumberStyle(left1);
                        ok2 = true;
                        if (modStyle == style2 || modStyle == NumberStyle.BOTH || style2 == NumberStyle.BOTH) {
                            ok2 = ExtNumbers.checkIntervalBoundaries(s1Mod, e1Mod, s2, e2, left1 == left2 && en1.getRoad() == en2.getRoad());
                        }
                        if (!ok2) continue;
                        if (houses1.size() > 1) {
                            possibleRemoves1.add(house);
                        }
                        if ((test = ExtNumbers.checkMoveTo(house, en2, left2)).getRoad() == null || !((deltaDist = test.getDistance() - house.getDistance()) < smallestDelta)) continue;
                        bestMoveMod = test;
                        bestMoveOrig = house;
                        smallestDelta = deltaDist;
                        bestRemove = en1;
                    }
                    for (HousenumberMatch house : houses2) {
                        if (house.getGroup() != null || ExtNumbers.countOccurence(houses2, n = house.getHousenumber()) > 1 || n != s2 && n != e2) continue;
                        modNumbers = en2.simulateRemovalOfHouseNumber(n, left2).getNumbers();
                        int s2Mod = modNumbers.getStart(left2);
                        int e2Mod = modNumbers.getEnd(left2);
                        modStyle = modNumbers.getNumberStyle(left2);
                        ok2 = true;
                        if (modStyle == style1 || modStyle == NumberStyle.BOTH || style1 == NumberStyle.BOTH) {
                            ok2 = ExtNumbers.checkIntervalBoundaries(s1, e1, s2Mod, e2Mod, left1 == left2 && en1.getRoad() == en2.getRoad());
                        }
                        if (!ok2) continue;
                        if (houses2.size() > 1) {
                            possibleRemoves2.add(house);
                        }
                        if ((test = ExtNumbers.checkMoveTo(house, en1, left1)).getRoad() == null || !((deltaDist = test.getDistance() - house.getDistance()) < smallestDelta)) continue;
                        bestMoveMod = test;
                        bestMoveOrig = house;
                        smallestDelta = deltaDist;
                        bestRemove = en2;
                    }
                    if (bestMoveMod != null) {
                        List<HousenumberMatch> toHouses;
                        List<HousenumberMatch> fromHouses;
                        ExtNumbers to;
                        ExtNumbers from;
                        if (bestMoveOrig.isDuplicate()) {
                            log.warn("duplicate number causes problems", streetName, bestMoveOrig.getSign(), bestMoveOrig.toBrowseURL());
                        }
                        if (bestRemove == en1) {
                            from = en1;
                            to = en2;
                            fromHouses = houses1;
                            toHouses = houses2;
                            bestMoveOrig.setLeft(left2);
                        } else {
                            from = en2;
                            to = en1;
                            fromHouses = houses2;
                            toHouses = houses1;
                            bestMoveOrig.setLeft(left1);
                        }
                        if (bestMoveOrig.getMoved() >= 3) {
                            bestMoveMod = null;
                            bestMoveOrig = null;
                            bestRemove.housenumberRoad.setRandom(true);
                        } else {
                            if (log.isInfoEnabled()) {
                                if (to.getRoad() == from.getRoad()) {
                                    log.info("moving", streetName, bestMoveOrig.getSign(), bestMoveOrig.getElement().toBrowseURL(), "from", fromHouses, "to", toHouses, "in road", to.getRoad());
                                } else {
                                    log.info("moving", streetName, bestMoveOrig.getSign(), bestMoveOrig.getElement().toBrowseURL(), "from", fromHouses, "in road", from.getRoad(), "to", toHouses, "in road", to.getRoad());
                                }
                            }
                            bestMoveOrig.incMoved();
                            bestMoveOrig.setRoad(to.getRoad());
                            bestMoveOrig.setHousenumberRoad(to.housenumberRoad);
                            bestMoveOrig.setSegment(bestMoveMod.getSegment());
                            bestMoveOrig.setDistance(bestMoveMod.getDistance());
                            bestMoveOrig.setSegmentFrac(bestMoveMod.getSegmentFrac());
                            from.housenumberRoad.getHouses().remove(bestMoveOrig);
                            fromHouses.remove(bestMoveOrig);
                            toHouses.add(bestMoveOrig);
                            toHouses.sort(new HousenumberGenerator.HousenumberMatchByPosComparator());
                            en1.reset();
                            en2.reset();
                            en1.setNumbers(houses1, en1.startInRoad, en1.endInRoad, left1);
                            en2.setNumbers(houses2, en2.startInRoad, en2.endInRoad, left2);
                            return 1;
                        }
                    }
                }
                ExtNumbers toSplit = null;
                int splitNum = -1;
                int delta1 = Math.abs(e1 - s1);
                int delta2 = Math.abs(e2 - s2);
                if (delta1 > 0 && delta2 > 0) {
                    if (en1.hasGaps != en2.hasGaps) {
                        if (en1.hasGaps) {
                            if (!possibleRemoves1.isEmpty()) {
                                splitNum = ((HousenumberMatch)possibleRemoves1.get(0)).getHousenumber();
                            }
                            toSplit = en1;
                        } else {
                            if (!possibleRemoves2.isEmpty()) {
                                splitNum = ((HousenumberMatch)possibleRemoves2.get(0)).getHousenumber();
                            }
                            toSplit = en2;
                        }
                    } else if (possibleRemoves1.size() == 1) {
                        splitNum = ((HousenumberMatch)possibleRemoves1.get(0)).getHousenumber();
                        toSplit = en1;
                    } else if (possibleRemoves2.size() == 1) {
                        splitNum = ((HousenumberMatch)possibleRemoves2.get(0)).getHousenumber();
                        toSplit = en2;
                    } else if (possibleRemoves1.size() > 0) {
                        splitNum = ((HousenumberMatch)possibleRemoves1.get(0)).getHousenumber();
                        toSplit = en1;
                    } else if (possibleRemoves2.size() > 0) {
                        splitNum = ((HousenumberMatch)possibleRemoves2.get(0)).getHousenumber();
                        toSplit = en2;
                    } else if (ivl1.isContained(s2, left1) && ivl1.isContained(e2, left1)) {
                        toSplit = en1;
                        splitNum = s2;
                    } else if (ivl2.isContained(s1, left2) && ivl2.isContained(e1, left2)) {
                        toSplit = en2;
                        splitNum = s1;
                    } else if (ivl1.isContained(s2, left1)) {
                        toSplit = en1;
                        splitNum = s2;
                    } else if (ivl1.isContained(e2, left1)) {
                        toSplit = en1;
                        splitNum = e2;
                    } else if (ivl2.isContained(s1, left2)) {
                        toSplit = en2;
                        splitNum = s1;
                    } else if (ivl2.isContained(e1, left2)) {
                        toSplit = en2;
                        splitNum = e1;
                    } else {
                        toSplit = style1 == NumberStyle.BOTH ? en1 : (style2 == NumberStyle.BOTH ? en2 : (delta1 >= delta2 ? en1 : en2));
                    }
                } else if (delta1 == 0 && delta2 > 0 && ExtNumbers.countOccurence(houses2, s1) == 0) {
                    toSplit = en2;
                    splitNum = s1;
                } else if (delta2 == 0 && delta1 > 0 && ExtNumbers.countOccurence(houses1, s2) == 0) {
                    toSplit = en1;
                    splitNum = s2;
                }
                if (toSplit != null) {
                    toSplit.worstHouse = null;
                    toSplit.badNum = splitNum;
                    toSplit.setNeedsSplit(true);
                    return 2;
                }
                allOK = false;
            }
        }
        if (allOK) {
            return 0;
        }
        return 3;
    }

    private static HousenumberMatch checkMoveTo(HousenumberMatch house, ExtNumbers other, boolean otherLeft) {
        Coord c2;
        Coord c1;
        HousenumberMatch test = new HousenumberMatch(house);
        Numbers otherIvl = other.getNumbers();
        int oStart = otherIvl.getStart(otherLeft);
        int oEnd = otherIvl.getEnd(otherLeft);
        if (house.getHousenumber() <= Math.min(oStart, oEnd) || house.getHousenumber() >= Math.max(oStart, oEnd)) {
            return test;
        }
        boolean even = house.getHousenumber() % 2 == 0;
        NumberStyle oStyle = otherIvl.getNumberStyle(otherLeft);
        if (oStyle == NumberStyle.EVEN && !even || oStyle == NumberStyle.ODD && even) {
            return test;
        }
        HousenumberGenerator.findClosestRoadSegment(test, other.getRoad(), other.startInRoad, other.endInRoad);
        if (test.getDistance() <= 150.0 && ((c1 = other.getRoad().getPoints().get(test.getSegment())).highPrecEquals(c2 = other.getRoad().getPoints().get(test.getSegment() + 1)) || otherLeft == HousenumberGenerator.isLeft(c1, c2, house.getLocation()))) {
            test.setLeft(otherLeft);
            return test;
        }
        test.setRoad(null);
        return test;
    }

    private static boolean checkIntervalBoundaries(int s1, int e1, int s2, int e2, boolean sameSide) {
        boolean ok = false;
        if (sameSide) {
            if (s1 == e1) {
                if (e1 == s2) {
                    ok = true;
                } else if (e1 < s2 && e1 < e2) {
                    ok = true;
                } else if (e1 > s2 && e1 > e2) {
                    ok = true;
                }
            } else if (s1 < e1) {
                if (e1 <= s2 && s2 <= e2) {
                    ok = true;
                } else if (s2 > e2 && e1 < e2) {
                    ok = true;
                } else if (s1 > s2 && s1 > e2) {
                    ok = true;
                }
            } else if (e1 >= s2 && s2 >= e2) {
                ok = true;
            } else if (e1 > s2 && e1 > e2) {
                ok = true;
            } else if (s1 < s2 && s1 < e2) {
                ok = true;
            }
        } else if (s1 == e1) {
            if (s2 == e2 && s1 != s2) {
                ok = true;
            } else if (s2 < e2 && (s1 < s2 || s1 > e2)) {
                ok = true;
            } else if (s2 > e2 && (s1 > s2 || s1 < e2)) {
                ok = true;
            }
        } else if (s1 < e1) {
            if (e1 < s2 && s2 <= e2) {
                ok = true;
            } else if (s2 > e2 && e1 < e2) {
                ok = true;
            } else if (s1 > s2 && s1 > e2) {
                ok = true;
            }
        } else if (e1 > s2 && s2 >= e2) {
            ok = true;
        } else if (e1 > s2 && e1 > e2) {
            ok = true;
        } else if (s1 < s2 && s1 < e2) {
            ok = true;
        }
        if (!ok) {
            // empty if block
        }
        return ok;
    }

    private ExtNumbers simulateRemovalOfHouseNumber(int hn, boolean left) {
        ExtNumbers help = new ExtNumbers(this.housenumberRoad);
        help.prev = this.prev;
        help.next = this.next;
        ArrayList<HousenumberMatch> modifiedHouses = new ArrayList<HousenumberMatch>(this.getHouses(left));
        Iterator iter = modifiedHouses.iterator();
        while (iter.hasNext()) {
            HousenumberMatch house = (HousenumberMatch)iter.next();
            if (house.getHousenumber() != hn) continue;
            iter.remove();
        }
        help.setNumbers(modifiedHouses, this.startInRoad, this.endInRoad, left);
        help.setNumbers(this.getHouses(!left), this.startInRoad, this.endInRoad, !left);
        return help;
    }

    public boolean hasNumbers() {
        return !this.getNumbers().isEmpty();
    }

    public ExtNumbers splitLargeGaps() {
        if (!this.hasNumbers()) {
            return this;
        }
        int numSegments = this.endInRoad - this.startInRoad;
        double[] segmentLenghts = new double[numSegments];
        double fullLength = 0.0;
        for (int i = this.startInRoad; i < this.endInRoad; ++i) {
            double len;
            Coord c1 = this.getRoad().getPoints().get(i);
            Coord c2 = this.getRoad().getPoints().get(i + 1);
            segmentLenghts[i - this.startInRoad] = len = c1.distance(c2);
            fullLength += len;
        }
        if (fullLength < 40.0) {
            if (log.isDebugEnabled()) {
                log.debug("segment", this.getNumbers(), "with length", ExtNumbers.formatLen(fullLength), "is considered OK");
            }
            return this;
        }
        TreeMap<Integer, Double> searchPositions = new TreeMap<Integer, Double>();
        boolean ok = this.calcSearchPositions(fullLength, searchPositions);
        if (!ok) {
            return this;
        }
        double worstDelta = 0.0;
        this.worstHouse = null;
        for (int side = 0; side < 2; ++side) {
            boolean left = side == 0;
            List<HousenumberMatch> houses = this.getHouses(left);
            for (HousenumberMatch house : houses) {
                Double searchDist;
                double distToStart = 0.0;
                for (int k = this.startInRoad; k < house.getSegment(); ++k) {
                    distToStart += segmentLenghts[k - this.startInRoad];
                }
                if (house.getSegmentFrac() > 0.0) {
                    try {
                        distToStart += Math.min(1.0, house.getSegmentFrac()) * segmentLenghts[house.getSegment() - this.startInRoad];
                    }
                    catch (Exception e) {
                        log.error((Object)e);
                    }
                }
                if ((searchDist = searchPositions.get(house.getHousenumber())) == null) {
                    log.warn("can't compute address search result of", house);
                    continue;
                }
                double delta = distToStart - searchDist;
                house.setSearchDist(delta);
                if (!(Math.abs(delta) > worstDelta)) continue;
                worstDelta = Math.abs(delta);
                this.worstHouse = house;
            }
        }
        if (worstDelta > 40.0) {
            if (log.isInfoEnabled()) {
                log.info("trying to optimize address search for house number in road", this.getRoad(), this.worstHouse, "error before opt is", ExtNumbers.formatLen(worstDelta));
            }
            return this.tryChange(1);
        }
        if (log.isDebugEnabled()) {
            log.debug("segment", this.getNumbers(), "with length", ExtNumbers.formatLen(fullLength), "is OK, worst address search for house number in road", this.getRoad(), this.worstHouse, "error is", ExtNumbers.formatLen(worstDelta));
        }
        return this;
    }

    private boolean calcSearchPositions(double fullLength, TreeMap<Integer, Double> searchPositions) {
        Numbers ivl = this.getNumbers();
        for (int side = 0; side < 2; ++side) {
            int step;
            boolean left = side == 0;
            NumberStyle style = ivl.getNumberStyle(left);
            if (style == NumberStyle.NONE) continue;
            int start = ivl.getStart(left);
            int end = ivl.getEnd(left);
            int n = step = style == NumberStyle.BOTH ? 1 : 2;
            if (step != 1 && start % 2 != end % 2) {
                log.error("internal error, bad interval in optimization", this);
                return false;
            }
            if (start == end) {
                searchPositions.put(start, fullLength / 2.0);
                continue;
            }
            int parts = Math.abs(end - start) / step;
            double partLen = fullLength / (double)parts;
            if (start > end) {
                step = -step;
            }
            int hn = start;
            double dist = 0.0;
            while (true) {
                searchPositions.put(hn, dist);
                if (hn == end) break;
                dist += partLen;
                hn += step;
            }
            if (parts > 1) assert (Math.abs(fullLength - dist) < 0.1);
        }
        return true;
    }

    public static Coord rasterLineNearPoint(Coord c1, Coord c2, Coord p, boolean includeEndPoints) {
        int x0 = c1.getLongitude();
        int y0 = c1.getLatitude();
        int x1 = c2.getLongitude();
        int y1 = c2.getLatitude();
        Coord c1Dspl = c1.getDisplayedCoord();
        Coord c2Dspl = c2.getDisplayedCoord();
        int x = x0;
        int y = y0;
        int dx = Math.abs(x1 - x);
        int sx = x < x1 ? 1 : -1;
        int dy = -Math.abs(y1 - y);
        int sy = y < y1 ? 1 : -1;
        int err = dx + dy;
        double minDistLine = Double.MAX_VALUE;
        double minDistTarget = Double.MAX_VALUE;
        int bestX = Integer.MAX_VALUE;
        int bestY = Integer.MAX_VALUE;
        while (includeEndPoints || x != x1 || y != y1) {
            if (Math.abs(y - p.getLatitude()) <= 1 || Math.abs(x - p.getLongitude()) <= 1) {
                double distLine;
                Coord t = new Coord(y, x);
                double distToTarget = t.distance(p);
                if ((includeEndPoints || x != x0 || y != y0) && distToTarget < 10.0 && ((distLine = t.distToLineSegment(c1Dspl, c2Dspl)) < minDistLine || distLine == minDistLine && distToTarget < minDistTarget || distLine < 0.2 && distToTarget < minDistTarget)) {
                    bestX = x;
                    bestY = y;
                    minDistLine = distLine;
                    minDistTarget = distToTarget;
                }
            }
            if (x == x1 && y == y1) break;
            int e2 = 2 * err;
            if (e2 > dy) {
                err += dy;
                x += sx;
            }
            if (e2 >= dx) continue;
            err += dx;
            y += sy;
        }
        if (minDistLine == Double.MAX_VALUE) {
            return null;
        }
        Coord best = new Coord(bestY, bestX);
        return best;
    }

    public static TreeMap<Double, List<Coord>> rasterLineNearPoint2(Coord c1, Coord c2, Coord p, double maxBefore, double maxAfter) {
        int x0 = c1.getLongitude();
        int y0 = c1.getLatitude();
        int x1 = c2.getLongitude();
        int y1 = c2.getLatitude();
        Coord c1Dspl = c1.getDisplayedCoord();
        Coord c2Dspl = c2.getDisplayedCoord();
        int x = x0;
        int y = y0;
        int dx = Math.abs(x1 - x);
        int sx = x < x1 ? 1 : -1;
        int dy = -Math.abs(y1 - y);
        int sy = y < y1 ? 1 : -1;
        int err = dx + dy;
        TreeMap<Double, List<Coord>> sortedByDistToLine = new TreeMap<Double, List<Coord>>();
        boolean beforeTarget = true;
        double lastDist = Double.NaN;
        while (true) {
            if (Math.abs(y - p.getLatitude()) <= 1 || Math.abs(x - p.getLongitude()) <= 1) {
                Coord t = new Coord(y, x);
                double distToTarget = t.distance(p);
                if (beforeTarget && !Double.isNaN(lastDist) && lastDist < distToTarget) {
                    beforeTarget = false;
                }
                if (beforeTarget && distToTarget < maxBefore || !beforeTarget && distToTarget < maxAfter) {
                    Double distLine = t.distToLineSegment(c1Dspl, c2Dspl);
                    sortedByDistToLine.computeIfAbsent(distLine, k -> new ArrayList()).add(t);
                }
                lastDist = distToTarget;
            }
            if (x == x1 && y == y1) break;
            int e2 = 2 * err;
            if (e2 > dy) {
                err += dy;
                x += sx;
            }
            if (e2 >= dx) continue;
            err += dx;
            y += sy;
        }
        return sortedByDistToLine;
    }

    private static int countOccurence(List<HousenumberMatch> houses, int num) {
        int count = 0;
        for (HousenumberMatch house : houses) {
            if (house.getHousenumber() != num) continue;
            ++count;
        }
        return count;
    }

    private static String formatLen(double length) {
        return HousenumberGenerator.formatLen(length);
    }

    public void detectRandom() {
        int countFilledIvls = 0;
        int countFilledSides = 0;
        int countNotInOrder = 0;
        ExtNumbers curr = this;
        while (curr != null) {
            if (curr.hasNumbers()) {
                ++countFilledIvls;
                if (curr.notInOrder(true)) {
                    ++countNotInOrder;
                }
                if (curr.notInOrder(false)) {
                    ++countNotInOrder;
                }
                if (curr.getHouses(true).size() > 1) {
                    ++countFilledSides;
                }
                if (curr.getHouses(false).size() > 1) {
                    ++countFilledSides;
                }
            }
            curr = curr.next;
        }
        if (countNotInOrder > 0 && (countNotInOrder > countFilledIvls || countNotInOrder > 2 || countFilledSides == countNotInOrder)) {
            this.housenumberRoad.setRandom(true);
        }
    }

    private boolean isPlausible() {
        if (!this.getNumbers().isPlausible()) {
            return false;
        }
        return !this.multipleZipOrCity(true) && !this.multipleZipOrCity(false);
    }

    private ExtNumbers split(int splitSegment) {
        this.getRoad().getPoints().get(splitSegment).setNumberNode(true);
        ExtNumbers first = this.divide();
        for (int side = 0; side < 2; ++side) {
            boolean left = side == 0;
            List<HousenumberMatch> houses = this.getHouses(left);
            if (houses.isEmpty()) continue;
            int used = first.setNumbers(houses, this.startInRoad, splitSegment, left);
            first.next.setNumbers(houses.subList(used, houses.size()), splitSegment, this.endInRoad, left);
        }
        return first;
    }

    public String toString() {
        return this.getRoad().toString() + this.getHouses(true).toString() + this.getHouses(false).toString();
    }

    class RoadSide {
        List<HousenumberMatch> houses = Collections.emptyList();
        boolean multipleZipCodes;
        boolean multipleCities;
        boolean notInOrder;

        RoadSide() {
        }
    }
}

