/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle.function;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import uk.me.parabola.mkgmap.osmstyle.function.CachedFunction;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.reader.osm.Relation;
import uk.me.parabola.mkgmap.reader.osm.Way;
import uk.me.parabola.mkgmap.scan.SyntaxException;

public class LengthFunction
extends CachedFunction {
    private final DecimalFormat nf = new DecimalFormat("0.0#####################", DecimalFormatSymbols.getInstance(Locale.US));

    public LengthFunction() {
        super(null);
    }

    @Override
    protected String calcImpl(Element el) {
        return this.nf.format(LengthFunction.calcLength(el, new HashSet<Element>()));
    }

    private static double calcLength(Element el, Set<Element> visited) {
        if (el == null || visited.contains(el)) {
            return 0.0;
        }
        visited.add(el);
        if (el instanceof Way) {
            return ((Way)el).calcLengthInMetres();
        }
        if (el instanceof Relation) {
            Relation rel = (Relation)el;
            double length = 0.0;
            for (Map.Entry<String, Element> relElem : rel.getElements()) {
                if (!(relElem.getValue() instanceof Way) && !(relElem.getValue() instanceof Relation)) continue;
                length += LengthFunction.calcLength(relElem.getValue(), visited);
            }
            return length;
        }
        throw new SyntaxException("length() cannot calculate elements of type " + el.getClass().getName());
    }

    @Override
    public String getName() {
        return "length";
    }

    @Override
    public boolean supportsWay() {
        return true;
    }

    @Override
    public boolean supportsRelation() {
        return true;
    }

    @Override
    public int getComplexity() {
        return 2;
    }
}

