/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm.o5m;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import uk.me.parabola.imgfmt.FormatException;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.reader.osm.GeneralRelation;
import uk.me.parabola.mkgmap.reader.osm.Node;
import uk.me.parabola.mkgmap.reader.osm.OsmHandler;
import uk.me.parabola.mkgmap.reader.osm.Relation;
import uk.me.parabola.mkgmap.reader.osm.Way;

public class O5mBinHandler
extends OsmHandler {
    private static final int NODE_DATASET = 16;
    private static final int WAY_DATASET = 17;
    private static final int REL_DATASET = 18;
    private static final int BBOX_DATASET = 219;
    private static final int TIMESTAMP_DATASET = 220;
    private static final int HEADER_DATASET = 224;
    private static final int EOD_FLAG = 254;
    private static final int RESET_FLAG = 255;
    private static final int EOF_FLAG = -1;
    private static final int STRING_TABLE_SIZE = 15000;
    private static final int MAX_STRING_PAIR_SIZE = 252;
    private static final String[] REL_REF_TYPES = new String[]{"node", "way", "relation", "?"};
    private static final double FACTOR = 1.0E-9;
    private BufferedInputStream fis;
    private InputStream is;
    private byte[] cnvBuffer;
    private byte[] ioBuf;
    private int ioBufPos;
    private String[][] stringTable;
    private String[] stringPair;
    private int currStringTablePos;
    private int bytesToRead;
    private long countBytes;
    private long lastNodeId;
    private long lastWayId;
    private long lastRelId;
    private long[] lastRef;
    private long lastTs;
    private long lastChangeSet;
    private int lastLon;
    private int lastLat;

    @Override
    public boolean isFileSupported(String name) {
        return name.endsWith(".o5m") || name.endsWith(".o5m.gz");
    }

    @Override
    public void parse(InputStream stream) {
        this.fis = new BufferedInputStream(stream);
        this.is = this.fis;
        this.cnvBuffer = new byte[4000];
        this.ioBuf = new byte[8192];
        this.ioBufPos = 0;
        this.stringPair = new String[2];
        this.lastRef = new long[3];
        this.reset();
        try {
            int start = this.is.read();
            ++this.countBytes;
            if (start != 255) {
                Logger.defaultLogger.error((Object)("wrong header byte " + start));
                throw new FormatException("wrong header byte " + start);
            }
            this.readFile();
        }
        catch (IOException e) {
            Logger.defaultLogger.error((Object)("exception after " + this.countBytes + " bytes"), e);
        }
    }

    private void readFile() throws IOException {
        boolean done = false;
        while (!done) {
            this.is = this.fis;
            long size = 0L;
            int fileType = this.is.read();
            ++this.countBytes;
            if (fileType >= 0 && fileType < 240) {
                this.bytesToRead = 0;
                size = this.readUnsignedNum64FromStream();
                this.countBytes += size - (long)this.bytesToRead;
                this.bytesToRead = (int)size;
                switch (fileType) {
                    case 16: 
                    case 17: 
                    case 18: 
                    case 219: 
                    case 220: 
                    case 224: {
                        if (this.bytesToRead > this.ioBuf.length) {
                            this.ioBuf = new byte[this.bytesToRead + 100];
                        }
                        int bytesRead = 0;
                        for (int neededBytes = this.bytesToRead; neededBytes > 0; neededBytes -= bytesRead) {
                            bytesRead += this.is.read(this.ioBuf, bytesRead, neededBytes);
                        }
                        this.ioBufPos = 0;
                        this.is = new ByteArrayInputStream(this.ioBuf, 0, this.bytesToRead);
                        break;
                    }
                }
            }
            if (fileType == -1) {
                done = true;
                continue;
            }
            if (fileType == 16) {
                this.readNode();
                continue;
            }
            if (fileType == 17) {
                this.readWay();
                continue;
            }
            if (fileType == 18) {
                this.readRel();
                continue;
            }
            if (fileType == 219) {
                this.readBBox();
                continue;
            }
            if (fileType == 220) {
                this.readFileTimestamp();
                continue;
            }
            if (fileType == 224) {
                this.readHeader();
                continue;
            }
            if (fileType == 254) {
                done = true;
                continue;
            }
            if (fileType == 255) {
                this.reset();
                continue;
            }
            if (fileType >= 240) continue;
            this.skip(size);
        }
    }

    private void readFileTimestamp() {
        this.readSignedNum64();
    }

    private void skip(long bytes) throws IOException {
        for (long toSkip = bytes; toSkip > 0L; toSkip -= this.is.skip(toSkip)) {
        }
    }

    private void readBBox() {
        double minlon = 1.0000000000000001E-7 * (double)this.readSignedNum32();
        double minlat = 1.0000000000000001E-7 * (double)this.readSignedNum32();
        double maxlon = 1.0000000000000001E-7 * (double)this.readSignedNum32();
        double maxlat = 1.0000000000000001E-7 * (double)this.readSignedNum32();
        assert (this.bytesToRead == 0);
        this.setBBox(minlat, minlon, maxlat, maxlon);
    }

    private void readNode() {
        int lat;
        int lon;
        this.lastNodeId += this.readSignedNum64();
        if (this.bytesToRead == 0) {
            return;
        }
        this.readVersionTsAuthor();
        if (this.bytesToRead == 0) {
            return;
        }
        this.lastLon = lon = this.readSignedNum32() + this.lastLon;
        this.lastLat = lat = this.readSignedNum32() + this.lastLat;
        double flon = 1.0E-9 * (double)(100L * (long)lon);
        double flat = 1.0E-9 * (double)(100L * (long)lat);
        assert (flat >= -90.0 && flat <= 90.0);
        assert (flon >= -180.0 && flon <= 180.0);
        Coord co = new Coord(flat, flon);
        this.saver.addPoint(this.lastNodeId, co);
        if (this.bytesToRead > 0) {
            Node node = new Node(this.lastNodeId, co);
            this.readTags(node);
            if (node.getTagCount() > 0) {
                this.saver.addNode(node);
                this.hooks.onAddNode(node);
            }
        }
    }

    private void readWay() {
        this.lastWayId += this.readSignedNum64();
        if (this.bytesToRead == 0) {
            return;
        }
        this.readVersionTsAuthor();
        if (this.bytesToRead == 0) {
            return;
        }
        Way way = this.startWay(this.lastWayId);
        long refSize = this.readUnsignedNum32();
        long stop = (long)this.bytesToRead - refSize;
        while ((long)this.bytesToRead > stop) {
            this.lastRef[0] = this.lastRef[0] + this.readSignedNum64();
            this.addCoordToWay(way, this.lastRef[0]);
        }
        this.readTags(way);
        this.endWay(way);
    }

    private void readRel() {
        this.lastRelId += this.readSignedNum64();
        if (this.bytesToRead == 0) {
            return;
        }
        this.readVersionTsAuthor();
        if (this.bytesToRead == 0) {
            return;
        }
        GeneralRelation rel = new GeneralRelation(this.lastRelId);
        long refSize = this.readUnsignedNum32();
        long stop = (long)this.bytesToRead - refSize;
        while ((long)this.bytesToRead > stop) {
            Element el = null;
            long deltaRef = this.readSignedNum64();
            int refType = this.readRelRef();
            String role = this.stringPair[1];
            int n = refType;
            this.lastRef[n] = this.lastRef[n] + deltaRef;
            long memId = this.lastRef[refType];
            if (refType == 0) {
                el = this.saver.getOrCreateNode(memId);
            } else if (refType == 1) {
                el = this.saver.getWay(memId);
            } else if (refType == 2) {
                el = this.saver.getRelation(memId);
                if (el == null) {
                    this.saver.deferRelation(memId, rel, role);
                }
            } else assert (false);
            if (el == null) continue;
            rel.addElement(role, el);
        }
        this.readTags(rel);
        this.saver.addRelation(rel);
    }

    private void readTags(Element elem) {
        while (this.bytesToRead > 0) {
            this.readStringPair();
            String key = this.stringPair[0];
            String val = this.stringPair[1];
            key = elem instanceof Relation && "type".equals(key) ? "type" : this.keepTag(key, val);
            if (key == null) continue;
            elem.addTagFromRawOSM(key, val);
        }
        assert (this.bytesToRead == 0);
    }

    private void storeStringPair() {
        this.stringTable[0][this.currStringTablePos] = this.stringPair[0];
        this.stringTable[1][this.currStringTablePos] = this.stringPair[1];
        ++this.currStringTablePos;
        if (this.currStringTablePos >= 15000) {
            this.currStringTablePos = 0;
        }
    }

    private void setStringRefPair(int ref) {
        int pos = this.currStringTablePos - ref;
        if (pos < 0) {
            pos += 15000;
        }
        this.stringPair[0] = this.stringTable[0][pos];
        this.stringPair[1] = this.stringTable[1][pos];
    }

    private void readVersionTsAuthor() {
        int version = this.readUnsignedNum32();
        if (version != 0) {
            long ts;
            this.lastTs = ts = this.readSignedNum64() + this.lastTs;
            if (ts != 0L) {
                long changeSet;
                this.lastChangeSet = changeSet = (long)this.readSignedNum32() + this.lastChangeSet;
                this.readAuthor();
            }
        }
    }

    private void readAuthor() {
        int stringRef = this.readUnsignedNum32();
        if (stringRef == 0) {
            long toReadStart = this.bytesToRead;
            long uidNum = this.readUnsignedNum64();
            if (uidNum == 0L) {
                this.stringPair[0] = "";
            } else {
                this.stringPair[0] = Long.toUnsignedString(uidNum);
                ++this.ioBufPos;
                --this.bytesToRead;
            }
            this.stringPair[1] = this.readString();
            long bytes = toReadStart - (long)this.bytesToRead;
            if (bytes <= 252L) {
                this.storeStringPair();
            }
        } else {
            this.setStringRefPair(stringRef);
        }
    }

    private int readRelRef() {
        int refType = -1;
        long toReadStart = this.bytesToRead;
        int stringRef = this.readUnsignedNum32();
        if (stringRef == 0) {
            refType = this.ioBuf[this.ioBufPos++] - 48;
            --this.bytesToRead;
            if (refType < 0 || refType > 2) {
                refType = 3;
            }
            this.stringPair[0] = REL_REF_TYPES[refType];
            this.stringPair[1] = this.readString();
            long bytes = toReadStart - (long)this.bytesToRead;
            if (bytes <= 252L) {
                this.storeStringPair();
            }
        } else {
            this.setStringRefPair(stringRef);
            char c = this.stringPair[0].charAt(0);
            switch (c) {
                case 'n': {
                    refType = 0;
                    break;
                }
                case 'w': {
                    refType = 1;
                    break;
                }
                case 'r': {
                    refType = 2;
                    break;
                }
                default: {
                    refType = 3;
                }
            }
        }
        return refType;
    }

    private void readStringPair() {
        int stringRef = this.readUnsignedNum32();
        if (stringRef == 0) {
            long toReadStart = this.bytesToRead;
            int cnt = 0;
            while (cnt < 2) {
                this.stringPair[cnt++] = this.readString();
            }
            long bytes = toReadStart - (long)this.bytesToRead;
            if (bytes <= 252L) {
                this.storeStringPair();
            }
        } else {
            this.setStringRefPair(stringRef);
        }
    }

    private String readString() {
        int length = 0;
        while (true) {
            byte b = this.ioBuf[this.ioBufPos++];
            --this.bytesToRead;
            if (b == 0) {
                return new String(this.cnvBuffer, 0, length, StandardCharsets.UTF_8);
            }
            this.cnvBuffer[length++] = b;
        }
    }

    private void reset() {
        this.lastNodeId = 0L;
        this.lastWayId = 0L;
        this.lastRelId = 0L;
        this.lastRef[0] = 0L;
        this.lastRef[1] = 0L;
        this.lastRef[2] = 0L;
        this.lastTs = 0L;
        this.lastChangeSet = 0L;
        this.lastLon = 0;
        this.lastLat = 0;
        this.stringTable = new String[2][15000];
        this.currStringTablePos = 0;
    }

    private void readHeader() throws IOException {
        if (this.ioBuf[0] != 111 || this.ioBuf[1] != 53 || this.ioBuf[2] != 99 && this.ioBuf[2] != 109 || this.ioBuf[3] != 50) {
            throw new IOException("unsupported header");
        }
    }

    private int readSignedNum32() {
        return (int)this.readSignedNum64();
    }

    private long readSignedNum64() {
        byte b = this.ioBuf[this.ioBufPos++];
        --this.bytesToRead;
        long result = b;
        if ((b & 0x80) == 0) {
            if ((b & 1) == 1) {
                return -1L - (result >> 1);
            }
            return result >> 1;
        }
        int sign = b & 1;
        result = (result & 0x7EL) >> 1;
        int shift = 6;
        while (((b = this.ioBuf[this.ioBufPos++]) & 0x80) != 0) {
            --this.bytesToRead;
            result += (long)(b & 0x7F) << shift;
            shift += 7;
        }
        --this.bytesToRead;
        result += (long)b << shift;
        if (sign == 1) {
            return -1L - result;
        }
        return result;
    }

    private long readUnsignedNum64FromStream() throws IOException {
        int b = this.is.read();
        --this.bytesToRead;
        long result = b;
        if ((b & 0x80) == 0) {
            return result;
        }
        result &= 0x7FL;
        int shift = 7;
        while (((b = this.is.read()) & 0x80) != 0) {
            --this.bytesToRead;
            result += (long)(b & 0x7F) << shift;
            shift += 7;
        }
        --this.bytesToRead;
        return result += (long)b << shift;
    }

    private long readUnsignedNum64() {
        byte b = this.ioBuf[this.ioBufPos++];
        --this.bytesToRead;
        long result = b;
        if ((b & 0x80) == 0) {
            return result;
        }
        result &= 0x7FL;
        int shift = 7;
        while (((b = this.ioBuf[this.ioBufPos++]) & 0x80) != 0) {
            --this.bytesToRead;
            result += (long)(b & 0x7F) << shift;
            shift += 7;
        }
        --this.bytesToRead;
        return result += (long)b << shift;
    }

    private int readUnsignedNum32() {
        return (int)this.readUnsignedNum64();
    }
}

