/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm.boundary;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.reader.osm.Tags;
import uk.me.parabola.mkgmap.reader.osm.boundary.Boundary;
import uk.me.parabola.mkgmap.reader.osm.boundary.BoundaryLocationInfo;
import uk.me.parabola.mkgmap.reader.osm.boundary.BoundaryLocationPreparer;
import uk.me.parabola.mkgmap.reader.osm.boundary.BoundarySaver;
import uk.me.parabola.mkgmap.reader.osm.boundary.BoundaryUtil;
import uk.me.parabola.util.EnhancedProperties;
import uk.me.parabola.util.Java2DConverter;
import uk.me.parabola.util.ShapeSplitter;

public class BoundaryQuadTree {
    private static final Logger log = Logger.getLogger(BoundaryQuadTree.class);
    private static final boolean DEBUG = false;
    private static final String DEBUG_TREEPATH = "?";
    private static final boolean DO_ALL_TESTS = false;
    private static final boolean DO_CLIP = true;
    private static final boolean DO_NOT_CLIP = false;
    private final Map<String, Tags> boundaryTags = new LinkedHashMap<String, Tags>();
    private final Map<String, BoundaryLocationInfo> preparedLocationInfo;
    private final BoundaryLocationPreparer preparer;
    private final Node root;
    private final Rectangle bbox;
    private final String bboxKey;
    public static final String[] mkgmapTagsArray = new String[]{"mkgmap:admin_level1", "mkgmap:admin_level2", "mkgmap:admin_level3", "mkgmap:admin_level4", "mkgmap:admin_level5", "mkgmap:admin_level6", "mkgmap:admin_level7", "mkgmap:admin_level8", "mkgmap:admin_level9", "mkgmap:admin_level10", "mkgmap:admin_level11", "mkgmap:postcode", "mkgmap:other"};
    public static final short POSTCODE_ONLY = 2048;
    public static final short NAME_ONLY = 4096;

    public BoundaryQuadTree(DataInputStream inpStream, Area fileBbox, Area searchBbox, EnhancedProperties props) throws IOException {
        this.preparedLocationInfo = new LinkedHashMap<String, BoundaryLocationInfo>();
        this.preparer = new BoundaryLocationPreparer(props);
        assert (fileBbox != null) : "parameter fileBbox must not be null";
        this.bbox = new Rectangle(fileBbox.getMinLong(), fileBbox.getMinLat(), fileBbox.getMaxLong() - fileBbox.getMinLong(), fileBbox.getMaxLat() - fileBbox.getMinLat());
        this.bboxKey = BoundaryUtil.getKey(this.bbox.y, this.bbox.x);
        this.root = new Node(this.bbox);
        this.readStreamQuadTreeFormat(inpStream, searchBbox);
    }

    public BoundaryQuadTree(Area givenBbox, List<Boundary> boundaries, EnhancedProperties props) {
        this.preparer = new BoundaryLocationPreparer(props);
        assert (givenBbox != null) : "parameter givenBbox must not be null";
        this.bbox = new Rectangle(givenBbox.getMinLong(), givenBbox.getMinLat(), givenBbox.getMaxLong() - givenBbox.getMinLong(), givenBbox.getMaxLat() - givenBbox.getMinLat());
        this.bboxKey = BoundaryUtil.getKey(this.bbox.y, this.bbox.x);
        this.root = new Node(this.bbox);
        this.preparedLocationInfo = this.preparer.getPreparedLocationInfo(boundaries);
        if (boundaries == null || boundaries.isEmpty()) {
            return;
        }
        HashMap<String, Boundary> bMap = new HashMap<String, Boundary>();
        for (Boundary b : boundaries) {
            bMap.put(b.getId(), b);
            this.boundaryTags.put(b.getId(), b.getTags());
        }
        this.sortBoundaryTagsMap();
        for (String id : this.boundaryTags.keySet()) {
            this.root.add(((Boundary)bMap.get(id)).getArea(), id, null, false);
        }
        bMap = null;
        this.root.split("_");
    }

    public Tags get(Coord co) {
        return this.get(co, true);
    }

    public Tags get(Coord co, boolean tryAlsoNearby) {
        Tags res = this.root.get(co);
        if (res == null && tryAlsoNearby) {
            int lonHp = co.getHighPrecLon();
            int latHp = co.getHighPrecLat();
            double x = (double)lonHp / 64.0;
            double y = (double)latHp / 64.0;
            int radius = 64;
            if (this.bbox.contains(x, y)) {
                res = this.root.get(Coord.makeHighPrecCoord(latHp + radius, lonHp));
                if (res == null) {
                    res = this.root.get(Coord.makeHighPrecCoord(latHp, lonHp + radius));
                }
                if (res == null) {
                    res = this.root.get(Coord.makeHighPrecCoord(latHp - radius, lonHp));
                }
                if (res == null) {
                    res = this.root.get(Coord.makeHighPrecCoord(latHp, lonHp - radius));
                }
            }
        }
        return res;
    }

    public Map<String, Tags> getTagsMap() {
        return new LinkedHashMap<String, Tags>(this.boundaryTags);
    }

    public Map<String, List<java.awt.geom.Area>> getAreas() {
        HashMap<String, List<java.awt.geom.Area>> areas = new HashMap<String, List<java.awt.geom.Area>>();
        this.root.getAreas(areas, "_", null);
        return areas;
    }

    public void merge(BoundaryQuadTree other) {
        if (!this.bbox.equals(other.bbox)) {
            log.error((Object)"Cannot merge tree with different bounding box");
            return;
        }
        for (Map.Entry<String, BoundaryLocationInfo> entry : other.preparedLocationInfo.entrySet()) {
            if (this.preparedLocationInfo.containsKey(entry.getKey())) continue;
            this.preparedLocationInfo.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : other.boundaryTags.entrySet()) {
            if (this.boundaryTags.containsKey(entry.getKey())) continue;
            this.boundaryTags.put(entry.getKey(), (Tags)entry.getValue());
        }
        this.sortBoundaryTagsMap();
        this.root.mergeNodes(other.root, "_");
    }

    public java.awt.geom.Area getCoveredArea(Integer admLevel) {
        return this.root.getCoveredArea(admLevel, "_");
    }

    public void save(OutputStream stream) throws IOException {
        for (Map.Entry<String, Tags> entry : this.boundaryTags.entrySet()) {
            BoundaryQuadTree.writeBoundaryTags(stream, entry.getValue(), entry.getKey());
        }
        this.root.save(stream, "_");
    }

    private void sortBoundaryTagsMap() {
        ArrayList<String> ids = new ArrayList<String>(this.boundaryTags.keySet());
        ids.sort(new AdminLevelCollator().reversed());
        LinkedHashMap<String, Tags> tmp = new LinkedHashMap<String, Tags>(this.boundaryTags);
        this.boundaryTags.clear();
        for (String id : ids) {
            this.boundaryTags.put(id, (Tags)((HashMap)tmp).get(id));
        }
    }

    private static void writeBoundaryTags(OutputStream stream, Tags tags, String id) throws IOException {
        DataOutputStream dOutStream = new DataOutputStream(stream);
        dOutStream.writeUTF("TAGS");
        dOutStream.writeUTF(id);
        int noOfTags = tags.size();
        dOutStream.writeInt(noOfTags);
        Iterator<Map.Entry<String, String>> tagIter = tags.entryIterator();
        while (tagIter.hasNext()) {
            Map.Entry<String, String> tag = tagIter.next();
            dOutStream.writeUTF(tag.getKey());
            dOutStream.writeUTF(tag.getValue());
            --noOfTags;
        }
        assert (noOfTags == 0) : "Remaining tags: " + noOfTags + " size: " + tags.size() + " " + tags.toString();
        dOutStream.flush();
    }

    private void readStreamQuadTreeFormat(DataInputStream inpStream, Area searchBBox) throws IOException {
        boolean isFirstArea = true;
        try {
            while (true) {
                String type;
                if ("TAGS".equals(type = inpStream.readUTF())) {
                    String id = inpStream.readUTF();
                    Tags tags = new Tags();
                    int noOfTags = inpStream.readInt();
                    for (int i = 0; i < noOfTags; ++i) {
                        String name = inpStream.readUTF();
                        String value = inpStream.readUTF();
                        tags.put(name, value.intern());
                    }
                    this.boundaryTags.put(id, tags);
                    continue;
                }
                if ("AREA".equals(type)) {
                    if (isFirstArea) {
                        isFirstArea = false;
                        this.prepareLocationInfo();
                    }
                    int minLat = inpStream.readInt();
                    int minLong = inpStream.readInt();
                    int maxLat = inpStream.readInt();
                    int maxLong = inpStream.readInt();
                    if (log.isDebugEnabled()) {
                        log.debug("Next boundary. Lat min:", minLat, "max:", maxLat, "Long min:", minLong, "max:", maxLong);
                    }
                    Area rBbox = new Area(minLat, minLong, maxLat, maxLong);
                    int bSize = inpStream.readInt();
                    log.debug("Size:", bSize);
                    if (searchBBox == null || searchBBox.intersects(rBbox)) {
                        java.awt.geom.Area area;
                        log.debug((Object)"Bbox intersects. Load the boundary");
                        String treePath = inpStream.readUTF();
                        String id = inpStream.readUTF();
                        String refs = inpStream.readUTF();
                        if (refs.isEmpty()) {
                            refs = null;
                        }
                        if ((area = BoundaryUtil.readAreaAsPath(inpStream)) != null && !area.isEmpty()) {
                            this.root.add(area, refs, id, treePath);
                            continue;
                        }
                        log.warn(refs, id, treePath, "invalid or empty or too small area");
                        continue;
                    }
                    log.debug("Bbox does not intersect. Skip", bSize);
                    inpStream.skipBytes(bSize);
                    continue;
                }
                log.error((Object)("unknown type field " + type));
            }
        }
        catch (EOFException eOFException) {
            return;
        }
    }

    private void prepareLocationInfo() {
        for (Map.Entry<String, Tags> entry : this.boundaryTags.entrySet()) {
            BoundaryLocationInfo info = this.preparer.parseTags(entry.getValue());
            this.preparedLocationInfo.put(entry.getKey(), info);
        }
    }

    public static boolean isWritable(java.awt.geom.Area area) {
        if (area.isEmpty()) {
            return false;
        }
        Path2D.Double path = new Path2D.Double(area);
        java.awt.geom.Area testArea = new java.awt.geom.Area(path);
        return !testArea.isEmpty();
    }

    public class AdminLevelCollator
    implements Comparator<String> {
        @Override
        public int compare(String o1, String o2) {
            boolean post2set;
            if (o1.equals(o2)) {
                return 0;
            }
            BoundaryLocationInfo i1 = (BoundaryLocationInfo)BoundaryQuadTree.this.preparedLocationInfo.get(o1);
            BoundaryLocationInfo i2 = (BoundaryLocationInfo)BoundaryQuadTree.this.preparedLocationInfo.get(o2);
            int adminLevel1 = i1.getAdmLevel();
            int adminLevel2 = i2.getAdmLevel();
            if (i1.getName() == null || BoundaryQuadTree.DEBUG_TREEPATH.equals(i1.getName())) {
                adminLevel1 = 100;
            }
            if (i2.getName() == null || BoundaryQuadTree.DEBUG_TREEPATH.equals(i2.getName())) {
                adminLevel2 = 100;
            }
            if (adminLevel1 > adminLevel2) {
                return 1;
            }
            if (adminLevel1 < adminLevel2) {
                return -1;
            }
            boolean post1set = i1.getZip() != null;
            boolean bl = post2set = i2.getZip() != null;
            if (post1set && !post2set) {
                return 1;
            }
            if (!post1set && post2set) {
                return -1;
            }
            return o1.compareTo(o2);
        }
    }

    private class NodeElem {
        private java.awt.geom.Area area;
        private Shape shape;
        private Tags locTags;
        private short tagMask;
        private final String boundaryId;
        private String locationDataSrc;
        private int srcPos;

        NodeElem(String boundaryId, java.awt.geom.Area area, String refs) {
            this.srcPos = -1;
            this.boundaryId = boundaryId;
            this.area = area;
            this.locationDataSrc = refs;
            this.calcLocTags();
        }

        NodeElem(String boundaryId, Shape shape, String refs) {
            this.srcPos = -1;
            this.boundaryId = boundaryId;
            this.shape = shape;
            this.locationDataSrc = refs;
            this.calcLocTags();
        }

        NodeElem(NodeElem other, java.awt.geom.Area area, int srcPos) {
            this.area = area;
            this.srcPos = srcPos;
            this.boundaryId = other.boundaryId;
            this.tagMask = other.tagMask;
            this.locationDataSrc = other.locationDataSrc;
            this.locTags = other.locTags.copy();
        }

        private boolean isValid() {
            if (this.tagMask == 0) {
                return false;
            }
            java.awt.geom.Area checkArea = this.getArea();
            return checkArea != null && !checkArea.isEmpty() && (checkArea.getBounds2D().getWidth() > 1.0E-7 || checkArea.getBounds2D().getHeight() > 1.0E-7);
        }

        private void addLocInfo(NodeElem toAdd) {
            this.addLocationDataString(toAdd);
            this.addMissingTags(toAdd.locTags);
            this.tagMask = (short)(this.tagMask | toAdd.tagMask);
        }

        private void calcLocTags() {
            this.locTags = new Tags();
            this.tagMask = 0;
            BoundaryLocationInfo bInfo = (BoundaryLocationInfo)BoundaryQuadTree.this.preparedLocationInfo.get(this.boundaryId);
            if (bInfo == null) {
                log.error((Object)("unknown boundaryId " + this.boundaryId));
                return;
            }
            if (bInfo.getZip() != null) {
                this.locTags.put("mkgmap:postcode", bInfo.getZip());
            }
            if (bInfo.getAdmLevel() != 100) {
                this.locTags.put(mkgmapTagsArray[bInfo.getAdmLevel() - 1], bInfo.getName());
            }
            if (this.locTags.size() == 0 && bInfo.getName() != null) {
                this.locTags.put("mkgmap:other", bInfo.getName());
            }
            if (this.locationDataSrc != null && !this.locationDataSrc.isEmpty()) {
                String[] relBounds;
                for (String relBound : relBounds = this.locationDataSrc.split(Pattern.quote(";"))) {
                    String[] relParts = relBound.split(Pattern.quote(":"));
                    if (relParts.length != 2) {
                        log.error((Object)("Wrong format. Value: " + this.locationDataSrc));
                        continue;
                    }
                    BoundaryLocationInfo addInfo = (BoundaryLocationInfo)BoundaryQuadTree.this.preparedLocationInfo.get(relParts[1]);
                    if (addInfo == null) {
                        log.warn("Referenced boundary not known:", relParts[1]);
                        continue;
                    }
                    int addAdmLevel = addInfo.getAdmLevel();
                    String addAdmName = null;
                    if (addAdmLevel != 100) {
                        addAdmName = addInfo.getName();
                    }
                    String addZip = addInfo.getZip();
                    if (addAdmName != null && this.locTags.get(mkgmapTagsArray[addAdmLevel - 1]) == null) {
                        this.locTags.put(mkgmapTagsArray[addAdmLevel - 1], addAdmName);
                    }
                    if (addZip == null || this.locTags.get("mkgmap:postcode") != null) continue;
                    this.locTags.put("mkgmap:postcode", addZip);
                }
            }
            this.tagMask = this.calcLocationTagsMask();
        }

        private void addLocationDataString(NodeElem toAdd) {
            BoundaryLocationInfo info = (BoundaryLocationInfo)BoundaryQuadTree.this.preparedLocationInfo.get(toAdd.boundaryId);
            assert (info.getAdmLevel() > 0) : "cannot use admLevel";
            String admLevel = info.getAdmLevel() + ":" + toAdd.boundaryId;
            this.locationDataSrc = this.locationDataSrc == null ? admLevel : this.locationDataSrc + ";" + admLevel;
            if (toAdd.locationDataSrc != null) {
                this.locationDataSrc = this.locationDataSrc + ";" + toAdd.locationDataSrc;
            }
        }

        private void save(OutputStream stream, String treePath) throws IOException {
            ByteArrayOutputStream oneItemStream = new ByteArrayOutputStream();
            try (DataOutputStream dos = new DataOutputStream(oneItemStream);){
                String id = this.boundaryId;
                dos.writeUTF(treePath.substring(1));
                dos.writeUTF(id);
                if (this.locationDataSrc == null) {
                    dos.writeUTF("");
                } else {
                    dos.writeUTF(this.locationDataSrc);
                }
                BoundarySaver.writeArea(dos, this.getArea());
            }
            Area outBBox = Java2DConverter.createBbox(this.getArea());
            DataOutputStream dOutStream = new DataOutputStream(stream);
            dOutStream.writeUTF("AREA");
            dOutStream.writeInt(outBBox.getMinLat());
            dOutStream.writeInt(outBBox.getMinLong());
            dOutStream.writeInt(outBBox.getMaxLat());
            dOutStream.writeInt(outBBox.getMaxLong());
            byte[] data = oneItemStream.toByteArray();
            assert (data.length > 0) : "bSize is not > 0 : " + data.length;
            dOutStream.writeInt(data.length);
            dOutStream.write(data);
            dOutStream.flush();
        }

        private java.awt.geom.Area getArea() {
            if (this.shape != null) {
                this.area = new java.awt.geom.Area(this.shape);
                this.shape = null;
            }
            return this.area;
        }

        private void setArea(java.awt.geom.Area area) {
            this.area = area;
            this.shape = null;
        }

        private short calcLocationTagsMask() {
            short res = 0;
            for (int i = 0; i < mkgmapTagsArray.length; ++i) {
                if (this.locTags.get(mkgmapTagsArray[i]) == null) continue;
                res = (short)(res | 1 << i);
            }
            return res;
        }

        private void saveGPX(String desc, String treePath) {
        }

        private String checkAddTags(NodeElem other, Area bounds) {
            String errMsg = null;
            int errAdmLevel = 0;
            for (int k = 0; k < mkgmapTagsArray.length; ++k) {
                int testMask = 1 << k;
                if ((testMask & other.tagMask) == 0 || (this.tagMask & testMask) == 0) continue;
                if (testMask == 2048) {
                    String zipKey = mkgmapTagsArray[k];
                    if (other.locTags.get(zipKey).equals(this.locTags.get(zipKey))) continue;
                    errMsg = "different " + zipKey;
                    break;
                }
                if (testMask == 4096) break;
                errAdmLevel = k + 1;
                errMsg = "same admin_level (" + errAdmLevel + ")";
                break;
            }
            if (errMsg != null) {
                String url = bounds.getCenter().toOSMURL() + "&";
                url = url + (other.boundaryId.startsWith("w") ? "way" : "relation");
                url = url + "=" + other.boundaryId.substring(1);
                errMsg = "incorrect data: " + url + " intersection of boundaries with " + errMsg + " " + other.boundaryId + " " + this.boundaryId + " ";
                if (errAdmLevel != 0 && this.locationDataSrc != null) {
                    errMsg = errMsg + this.locationDataSrc;
                }
            }
            return errMsg;
        }

        private void addMissingTags(Tags src) {
            Iterator<Map.Entry<String, String>> tagIter = src.entryIterator();
            while (tagIter.hasNext()) {
                Map.Entry<String, String> tag = tagIter.next();
                if (this.locTags.get(tag.getKey()) != null) continue;
                this.locTags.put(tag.getKey(), tag.getValue());
            }
        }
    }

    private class Node {
        private Node[] childs;
        private List<NodeElem> nodes;
        private final Rectangle bbox;
        private final Area bounds;
        private short depth;
        private boolean isLeaf;

        private Node(Rectangle bbox) {
            this.bounds = new Area(bbox.y, bbox.x, bbox.y + bbox.height, bbox.x + bbox.width);
            this.bbox = new Rectangle(bbox);
            this.isLeaf = true;
        }

        private Node(int minLat, int minLong, int maxLat, int maxLong) {
            this.bounds = new Area(minLat, minLong, maxLat, maxLong);
            this.bbox = new Rectangle(minLong, minLat, maxLong - minLong, maxLat - minLat);
            this.isLeaf = true;
        }

        private void save(OutputStream stream, String treePath) throws IOException {
            block3: {
                block2: {
                    if (!this.isLeaf) break block2;
                    if (this.nodes == null) break block3;
                    for (NodeElem nodeElem : this.nodes) {
                        if (!nodeElem.isValid()) continue;
                        nodeElem.save(stream, treePath);
                    }
                    break block3;
                }
                for (int i = 0; i < 4; ++i) {
                    this.childs[i].save(stream, treePath + i);
                }
            }
        }

        private Tags get(Coord co) {
            if (!this.bounds.contains(co)) {
                return null;
            }
            if (this.isLeaf) {
                if (this.nodes == null || this.nodes.isEmpty()) {
                    return null;
                }
                double lon = (double)co.getHighPrecLon() / 64.0;
                double lat = (double)co.getHighPrecLat() / 64.0;
                for (NodeElem nodeElem : this.nodes) {
                    if (nodeElem.tagMask <= 0 || !nodeElem.getArea().contains(lon, lat)) continue;
                    return nodeElem.locTags;
                }
            } else {
                for (int i = 0; i < 4; ++i) {
                    Tags res = this.childs[i].get(co);
                    if (res == null) continue;
                    return res;
                }
            }
            return null;
        }

        private void printNodes(String prefix, String treePath) {
            int n = 0;
            for (NodeElem nodeElem : this.nodes) {
                if (treePath.equals(BoundaryQuadTree.DEBUG_TREEPATH)) {
                    nodeElem.saveGPX(prefix, treePath);
                }
                StringBuilder sb = new StringBuilder();
                for (int i = mkgmapTagsArray.length - 1; i >= 0; --i) {
                    String tagVal = nodeElem.locTags.get(mkgmapTagsArray[i]);
                    if (tagVal == null) continue;
                    sb.append(i + 1).append('=').append(tagVal).append(';');
                }
                System.out.println(prefix + " " + treePath + " " + n + ":" + nodeElem.boundaryId + " " + nodeElem.tagMask + " " + sb.toString());
                ++n;
            }
        }

        private boolean testIfDistinct(String treePath) {
            boolean ok = true;
            for (int i = 0; i < this.nodes.size() - 1; ++i) {
                for (int j = i + 1; j < this.nodes.size(); ++j) {
                    Path2D.Double path;
                    java.awt.geom.Area a = new java.awt.geom.Area(this.nodes.get(i).getArea());
                    a.intersect(this.nodes.get(j).getArea());
                    if (a.isEmpty() || (a = new java.awt.geom.Area(path = new Path2D.Double(a))).isEmpty() || a.getBounds2D().getHeight() < 0.1 && a.getBounds2D().getWidth() < 0.1) continue;
                    ok = false;
                    log.error((Object)("boundaries still intersect in tree path " + treePath + " " + this.nodes.get(i).boundaryId + " " + this.nodes.get(j).boundaryId + " bbox: " + a.getBounds2D()));
                    NodeElem tmpNodeElem = new NodeElem(this.nodes.get(i).boundaryId + "_" + this.nodes.get(j).boundaryId, new java.awt.geom.Area(a.getBounds2D()), null);
                    tmpNodeElem.saveGPX("intersection_rect", treePath);
                }
            }
            return ok;
        }

        private void add(java.awt.geom.Area area, String refs, String boundaryId, String treePath) {
            Node node = this;
            String path = treePath;
            while (!path.isEmpty()) {
                int idx = Integer.parseInt(path.substring(0, 1));
                path = path.substring(1);
                if (node.childs == null) {
                    node.allocChilds();
                }
                node = node.childs[idx];
            }
            if (node.nodes == null) {
                node.nodes = new ArrayList<NodeElem>();
            }
            NodeElem nodeElem = new NodeElem(boundaryId, area, refs);
            assert (area.getBounds2D().getWidth() == 0.0 || area.getBounds2D().getHeight() == 0.0 || this.bbox.intersects(area.getBounds2D())) : "boundary bbox doesn't fit into quadtree " + this.bbox + " " + area.getBounds2D();
            node.nodes.add(nodeElem);
        }

        private void add(Shape shape, String boundaryId, String refs, boolean clipOption) {
            Path2D.Double path;
            assert (this.isLeaf);
            if (clipOption) {
                path = ShapeSplitter.clipShape(shape, this.bbox);
                if (path == null) {
                    return;
                }
            } else {
                path = new Path2D.Double(shape);
            }
            if (this.nodes == null) {
                this.nodes = new ArrayList<NodeElem>();
            }
            NodeElem nodeElem = new NodeElem(boundaryId, path, refs);
            this.nodes.add(nodeElem);
        }

        private void mergeNodes(Node other, String treePath) {
            if (!this.isLeaf && !other.isLeaf) {
                for (int i = 0; i < 4; ++i) {
                    this.childs[i].mergeNodes(other.childs[i], treePath + i);
                }
            } else {
                HashMap<String, List<java.awt.geom.Area>> areas = new HashMap<String, List<java.awt.geom.Area>>();
                this.getAreas(areas, treePath, null);
                other.getAreas(areas, treePath, null);
                this.isLeaf = true;
                this.nodes = null;
                this.childs = null;
                for (String id : BoundaryQuadTree.this.boundaryTags.keySet()) {
                    List<java.awt.geom.Area> aList = areas.get(id);
                    if (aList == null) continue;
                    Path2D.Double path = new Path2D.Double();
                    for (java.awt.geom.Area area : aList) {
                        path.append(area, false);
                    }
                    this.add((Shape)new java.awt.geom.Area(path), id, null, false);
                }
                this.split(treePath);
            }
        }

        private java.awt.geom.Area getCoveredArea(Integer admLevel, String treePath) {
            HashMap<String, List<java.awt.geom.Area>> areas = new HashMap<String, List<java.awt.geom.Area>>();
            this.getAreas(areas, treePath, admLevel);
            if (!areas.isEmpty()) {
                Path2D.Double path = new Path2D.Double(1, 0x100000);
                for (Map.Entry<String, List<java.awt.geom.Area>> entry : areas.entrySet()) {
                    for (java.awt.geom.Area area : entry.getValue()) {
                        path.append(area, false);
                    }
                }
                return new java.awt.geom.Area(path);
            }
            return new java.awt.geom.Area();
        }

        private void getAreas(Map<String, List<java.awt.geom.Area>> areas, String treePath, Integer admLevel) {
            if (!this.isLeaf) {
                for (int i = 0; i < 4; ++i) {
                    this.childs[i].getAreas(areas, treePath + i, admLevel);
                }
                return;
            }
            if (this.nodes == null || this.nodes.isEmpty()) {
                return;
            }
            Short testMask = null;
            if (admLevel != null) {
                testMask = (short)(1 << admLevel - 1);
            }
            for (NodeElem nodeElem : this.nodes) {
                String[] relBounds;
                String refInfo;
                String id = nodeElem.boundaryId;
                if (testMask != null && (nodeElem.tagMask & testMask) == 0) continue;
                java.awt.geom.Area a = new java.awt.geom.Area(nodeElem.getArea());
                areas.computeIfAbsent(id, k -> new ArrayList(4)).add(a);
                if (testMask != null || (refInfo = nodeElem.locationDataSrc) == null) continue;
                for (String relBound : relBounds = refInfo.split(Pattern.quote(";"))) {
                    String[] relParts = relBound.split(Pattern.quote(":"));
                    if (relParts.length != 2) {
                        log.error((Object)("Wrong format in locationDataSrc. Value: " + refInfo));
                        continue;
                    }
                    id = relParts[1];
                    a = new java.awt.geom.Area(nodeElem.getArea());
                    areas.computeIfAbsent(id, k -> new ArrayList(4)).add(a);
                }
            }
        }

        private void makeDistinct(String treePath) {
            if (!this.isLeaf || this.nodes == null || this.nodes.size() <= 1) {
                return;
            }
            long t1 = System.currentTimeMillis();
            this.mergeEqualIds();
            this.mergeLastRectangles();
            ArrayList<NodeElem> reworked = new ArrayList<NodeElem>();
            for (int i = 0; i < this.nodes.size(); ++i) {
                NodeElem toAdd = this.nodes.get(i);
                for (int j = 0; j < reworked.size() && toAdd.isValid(); ++j) {
                    Rectangle2D rCurr;
                    Rectangle2D rAdd;
                    NodeElem currElem = (NodeElem)reworked.get(j);
                    if (currElem.srcPos == i || currElem.getArea().isEmpty() || (rAdd = (rCurr = currElem.getArea().getBounds2D()).createIntersection(toAdd.getArea().getBounds2D())).isEmpty()) continue;
                    java.awt.geom.Area toAddxCurr = new java.awt.geom.Area(currElem.getArea());
                    toAddxCurr.intersect(toAdd.getArea());
                    if (!BoundaryQuadTree.isWritable(toAddxCurr)) continue;
                    java.awt.geom.Area toAddMinusCurr = new java.awt.geom.Area(toAdd.getArea());
                    toAddMinusCurr.subtract(currElem.getArea());
                    if (toAddMinusCurr.isEmpty() && toAdd.tagMask == 2048) {
                        toAdd.getArea().reset();
                        break;
                    }
                    String chkMsg = currElem.checkAddTags(toAdd, this.bounds);
                    if (chkMsg != null) {
                        log.warn((Object)chkMsg);
                    }
                    java.awt.geom.Area currMinusToAdd = new java.awt.geom.Area(currElem.getArea());
                    currMinusToAdd.subtract(toAdd.getArea());
                    toAdd.setArea(toAddMinusCurr);
                    if (!BoundaryQuadTree.isWritable(currMinusToAdd)) {
                        if (toAdd.tagMask == 2048) continue;
                        currElem.addLocInfo(toAdd);
                        continue;
                    }
                    NodeElem intersect = new NodeElem(currElem, toAddxCurr, i);
                    currElem.setArea(currMinusToAdd);
                    if (toAdd.tagMask == 2048) continue;
                    intersect.addLocInfo(toAdd);
                    reworked.add(intersect);
                }
                if (!toAdd.isValid()) continue;
                reworked.add(toAdd);
            }
            this.nodes = reworked;
            this.removeEmptyAreas();
            long dt = System.currentTimeMillis() - t1;
            if (dt > 1000L) {
                log.info(BoundaryQuadTree.this.bboxKey, ": makeDistinct required long time:", dt, "ms");
            }
        }

        private void mergeEqualIds() {
            int start;
            for (int i = start = this.nodes.size() - 1; i > 0; --i) {
                if (!this.nodes.get(i).boundaryId.equals(this.nodes.get(i - 1).boundaryId)) continue;
                this.nodes.get(i - 1).getArea().add(this.nodes.get(i).getArea());
                this.nodes.remove(i);
            }
        }

        private void mergeLastRectangles() {
            boolean done;
            do {
                done = true;
                if (this.nodes.size() <= 1) break;
                NodeElem lastNode = this.nodes.get(this.nodes.size() - 1);
                NodeElem prevNode = this.nodes.get(this.nodes.size() - 2);
                if (prevNode.tagMask == 2048 || !lastNode.getArea().isRectangular() || !prevNode.getArea().isRectangular() || !prevNode.getArea().equals(lastNode.getArea())) continue;
                prevNode.addLocInfo(lastNode);
                this.nodes.remove(this.nodes.size() - 1);
                done = false;
            } while (!done);
        }

        private void removeEmptyAreas() {
            for (int j = this.nodes.size() - 1; j >= 0; --j) {
                boolean removeThis = false;
                NodeElem chkRemove = this.nodes.get(j);
                if (!chkRemove.isValid()) {
                    removeThis = true;
                } else if (!this.bbox.intersects(chkRemove.getArea().getBounds2D())) {
                    removeThis = true;
                } else if (!BoundaryQuadTree.isWritable(chkRemove.getArea())) {
                    removeThis = true;
                }
                if (!removeThis) continue;
                this.nodes.remove(j);
            }
        }

        private void allocChilds() {
            this.childs = new Node[4];
            Coord center = this.bounds.getCenter();
            this.childs[0] = new Node(this.bounds.getMinLat(), this.bounds.getMinLong(), center.getLatitude(), center.getLongitude());
            this.childs[1] = new Node(center.getLatitude(), this.bounds.getMinLong(), this.bounds.getMaxLat(), center.getLongitude());
            this.childs[2] = new Node(this.bounds.getMinLat(), center.getLongitude(), center.getLatitude(), this.bounds.getMaxLong());
            this.childs[3] = new Node(center.getLatitude(), center.getLongitude(), this.bounds.getMaxLat(), this.bounds.getMaxLong());
            for (int i = 0; i < 4; ++i) {
                this.childs[i].depth = (short)(this.depth + 1);
            }
            this.isLeaf = false;
        }

        private void split(String treePath) {
            if (this.isLeaf) {
                if (this.nodes == null) {
                    return;
                }
                if (this.depth >= 5 || this.nodes.size() <= 7 || this.bounds.getHeight() < 10 || this.bounds.getWidth() < 10) {
                    this.makeDistinct(treePath);
                    return;
                }
                this.allocChilds();
                for (NodeElem nodeElem : this.nodes) {
                    Rectangle shapeBBox = nodeElem.shape.getBounds();
                    for (int i = 0; i < 4; ++i) {
                        if (!this.childs[i].bbox.intersects(shapeBBox)) continue;
                        this.childs[i].add(nodeElem.shape, nodeElem.boundaryId, nodeElem.locationDataSrc, true);
                    }
                }
                this.nodes = null;
            }
            for (int i = 0; i < 4; ++i) {
                this.childs[i].split(treePath + i);
            }
        }
    }
}

