/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle.eval;

import java.util.HashSet;
import java.util.Set;
import uk.me.parabola.imgfmt.ExitException;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.osmstyle.eval.AndOp;
import uk.me.parabola.mkgmap.osmstyle.eval.BinaryOp;
import uk.me.parabola.mkgmap.osmstyle.eval.CloseOp;
import uk.me.parabola.mkgmap.osmstyle.eval.EqualsOp;
import uk.me.parabola.mkgmap.osmstyle.eval.ExistsOp;
import uk.me.parabola.mkgmap.osmstyle.eval.GTEOp;
import uk.me.parabola.mkgmap.osmstyle.eval.GTOp;
import uk.me.parabola.mkgmap.osmstyle.eval.LTEOp;
import uk.me.parabola.mkgmap.osmstyle.eval.LTOp;
import uk.me.parabola.mkgmap.osmstyle.eval.NodeType;
import uk.me.parabola.mkgmap.osmstyle.eval.NotEqualOp;
import uk.me.parabola.mkgmap.osmstyle.eval.NotExistsOp;
import uk.me.parabola.mkgmap.osmstyle.eval.NotOp;
import uk.me.parabola.mkgmap.osmstyle.eval.NotRegexOp;
import uk.me.parabola.mkgmap.osmstyle.eval.NumericOp;
import uk.me.parabola.mkgmap.osmstyle.eval.Op;
import uk.me.parabola.mkgmap.osmstyle.eval.OpenOp;
import uk.me.parabola.mkgmap.osmstyle.eval.OrOp;
import uk.me.parabola.mkgmap.osmstyle.eval.RegexOp;
import uk.me.parabola.mkgmap.osmstyle.function.GetTagFunction;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.reader.osm.ElementSaver;
import uk.me.parabola.mkgmap.scan.SyntaxException;

public abstract class AbstractOp
implements Op {
    protected Op first;
    private NodeType type;
    protected boolean lastRes;
    protected int lastCachedId = -1;

    public static Op createOp(String value) {
        AbstractOp op;
        char c = value.charAt(0);
        switch (c) {
            case '=': {
                op = new EqualsOp();
                break;
            }
            case '&': {
                if (value.length() > 1) {
                    throw new SyntaxException(String.format("Use '&' instead of '%s'", value));
                }
                op = new AndOp();
                break;
            }
            case '|': {
                if (value.length() > 1) {
                    throw new SyntaxException(String.format("Use '|' instead of '%s'", value));
                }
                op = new OrOp();
                break;
            }
            case '~': {
                op = new RegexOp();
                break;
            }
            case '(': {
                op = new OpenOp();
                break;
            }
            case ')': {
                op = new CloseOp();
                break;
            }
            case '>': {
                if (">=".equals(value)) {
                    op = new GTEOp();
                    break;
                }
                op = new GTOp();
                break;
            }
            case '<': {
                if ("<=".equals(value)) {
                    op = new LTEOp();
                    break;
                }
                op = new LTOp();
                break;
            }
            case '!': {
                if ("!=".equals(value)) {
                    op = new NotEqualOp();
                    break;
                }
                op = new NotOp();
                break;
            }
            default: {
                throw new SyntaxException("Unrecognised operation " + c);
            }
        }
        return op;
    }

    public static Op createOp(NodeType kind) {
        switch (kind) {
            case EQUALS: {
                return new EqualsOp();
            }
            case GT: {
                return new GTOp();
            }
            case GTE: {
                return new GTEOp();
            }
            case LT: {
                return new LTOp();
            }
            case LTE: {
                return new LTEOp();
            }
            case NOT_EQUALS: {
                return new NotEqualOp();
            }
            case EXISTS: {
                return new ExistsOp();
            }
            case NOT_EXISTS: {
                return new NotExistsOp();
            }
            case AND: {
                return new AndOp();
            }
            case OR: {
                return new OrOp();
            }
            case NOT: {
                return new NotOp();
            }
            case REGEX: {
                return new RegexOp();
            }
            case NOT_REGEX: {
                return new NotRegexOp();
            }
        }
        throw new UnsupportedOperationException("Please implement if you want it");
    }

    @Override
    public boolean eval(int cacheId, Element el) {
        if (this.lastCachedId != cacheId) {
            if (this.lastCachedId > cacheId) {
                throw new ExitException("fatal error: cache id invalid");
            }
            this.lastRes = this.eval(el);
            this.lastCachedId = cacheId;
        }
        return this.lastRes;
    }

    @Override
    public boolean hasHigherPriority(Op other) {
        return this.priority() > other.priority();
    }

    @Override
    public Op getFirst() {
        return this.first;
    }

    @Override
    public <T extends Op> T setFirst(Op first) {
        this.first = first;
        this.lastCachedId = -1;
        return (T)this;
    }

    @Override
    public Op getSecond() {
        return null;
    }

    @Override
    public <T extends Op> T set(Op a, Op b) {
        this.setFirst(a);
        if (b != null) {
            this.setSecond(b);
        }
        return (T)this;
    }

    @Override
    public NodeType getType() {
        return this.type;
    }

    protected void setType(NodeType type) {
        this.type = type;
    }

    @Override
    public String value(Element el) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getKeyValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isType(NodeType value) {
        return this.type == value;
    }

    public void resetCache() {
        this.lastCachedId = -1;
    }

    @Override
    public Set<String> getEvaluatedTagKeys() {
        HashSet<String> set = new HashSet<String>();
        this.collectEvaluatedTags(set);
        return set;
    }

    private void collectEvaluatedTags(HashSet<String> set) {
        if (this instanceof GetTagFunction) {
            set.add(this.getKeyValue());
        } else if (this instanceof BinaryOp) {
            set.addAll(this.getFirst().getEvaluatedTagKeys());
            set.addAll(this.getSecond().getEvaluatedTagKeys());
        } else if (this instanceof NumericOp) {
            set.addAll(this.getFirst().getEvaluatedTagKeys());
        } else if (this.isType(NodeType.EXISTS) || this.isType(NodeType.NOT_EXISTS) || this.isType(NodeType.NOT)) {
            set.addAll(this.getFirst().getEvaluatedTagKeys());
        } else if (this.getFirst() != null) {
            Logger.defaultLogger.error((Object)"Unhandled type of Op");
        }
    }

    @Override
    public void augmentWith(ElementSaver elementSaver) {
        if (this.first != null) {
            this.first.augmentWith(elementSaver);
        }
    }
}

