/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uk.me.parabola.imgfmt.MapFailedException;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.filters.DouglasPeuckerFilter;
import uk.me.parabola.mkgmap.general.MapPoint;
import uk.me.parabola.mkgmap.osmstyle.ConvertedWay;
import uk.me.parabola.mkgmap.reader.osm.CoordPOI;
import uk.me.parabola.mkgmap.reader.osm.Node;
import uk.me.parabola.mkgmap.reader.osm.RestrictionRelation;
import uk.me.parabola.mkgmap.reader.osm.Way;
import uk.me.parabola.util.GpxCreator;

public class WrongAngleFixer {
    private static final Logger log = Logger.getLogger(WrongAngleFixer.class);
    private static final double MAX_BEARING_ERROR = 15.0;
    private static final double MAX_BEARING_ERROR_HALF = 7.5;
    private static final double MAX_DIFF_ANGLE_STRAIGHT_LINE = 3.0;
    private final Area bbox;
    private static final String DEBUG_PATH = null;
    private int pass;
    private boolean extraPass;
    private ArrayList<ConvertedWay> convertedWays;

    public WrongAngleFixer(Area bbox) {
        this.bbox = bbox;
        if (DEBUG_PATH != null && bbox != null && (long)bbox.getWidth() * (long)bbox.getHeight() < 100000L) {
            ArrayList<Coord> grid = new ArrayList<Coord>();
            for (int lat = bbox.getMinLat(); lat < bbox.getMaxLat(); ++lat) {
                for (int lon = bbox.getMinLong(); lon < bbox.getMaxLong(); ++lon) {
                    grid.add(new Coord(lat, lon));
                }
            }
            GpxCreator.createGpx(Utils.joinPath(DEBUG_PATH, "grid"), bbox.toCoords(), grid);
        }
    }

    public void optimizeWays(List<ConvertedWay> roads, List<ConvertedWay> lines, Map<Long, ConvertedWay> modifiedRoads, Set<Long> deletedRoads, List<RestrictionRelation> restrictions, Set<MapPoint> renderedPOI) {
        this.printBadAngles("bad_angles_start", roads);
        this.writeOSM("roads_orig", roads);
        this.writeOSM("lines_orig", lines);
        this.convertedWays = new ArrayList();
        this.convertedWays.addAll(roads);
        this.convertedWays.addAll(lines);
        this.convertedWays.removeIf(ConvertedWay::isOverlay);
        this.convertedWays.sort((o1, o2) -> Long.compare(o1.getWay().getId(), o2.getWay().getId()));
        WrongAngleFixer.replaceDuplicateBoundaryNodes(this.convertedWays);
        Map<Coord, Coord> replacements = this.removeWrongAngles(modifiedRoads, deletedRoads);
        this.writeOSM("roads_post_rem_wrong_angles", roads);
        this.removeObsoletePoints(modifiedRoads);
        this.writeOSM("roads_post_rem_obsolete_points", roads);
        this.printBadAngles("bad_angles_finish", roads);
        this.writeOSM("lines_post_rem_wrong_angles", lines);
        this.convertedWays = null;
        for (RestrictionRelation rr : restrictions) {
            for (Coord p : rr.getViaCoords()) {
                Coord replacement;
                if (p == (replacement = WrongAngleFixer.getReplacement(p, null, replacements))) continue;
                rr.replaceViaCoord(p, replacement);
            }
        }
        for (MapPoint mp : renderedPOI) {
            if (!(mp.getLocation() instanceof CoordPOI)) continue;
            Coord replacement = WrongAngleFixer.getReplacement(mp.getLocation(), null, replacements);
            if (mp.getLocation() == replacement) continue;
            mp.setLocation(replacement);
        }
    }

    private static void replaceDuplicateBoundaryNodes(List<ConvertedWay> convertedWays) {
        Long2ObjectOpenHashMap<Coord> coordMap = new Long2ObjectOpenHashMap<Coord>();
        for (ConvertedWay cw : convertedWays) {
            if (!cw.isValid()) continue;
            Way way = cw.getWay();
            List<Coord> points = way.getPoints();
            for (int i = 0; i < points.size(); ++i) {
                Coord co = points.get(i);
                if (!co.getOnBoundary()) continue;
                Coord repl = (Coord)coordMap.get(Utils.coord2Long(co));
                if (repl == null) {
                    coordMap.put(Utils.coord2Long(co), co);
                    continue;
                }
                if (!co.isAddedByClipper() && repl.isAddedByClipper()) {
                    log.debug("check replaced original boundary node at", co);
                }
                points.set(i, repl);
            }
        }
    }

    private static Coord getReplacement(Coord p, Way way, Map<Coord, Coord> replacements) {
        if (p.isReplaced()) {
            Coord replacement = null;
            Coord r = p;
            while ((r = replacements.get(r)) != null) {
                replacement = r;
            }
            if (replacement != null) {
                if (p instanceof CoordPOI) {
                    String wayPOI;
                    CoordPOI cp = (CoordPOI)p;
                    Node node = cp.getNode();
                    if (cp.isUsed() && way != null && way.getId() != 0L && (wayPOI = way.getTag("mkgmap:way-poi-node-ids")) != null && wayPOI.contains("[" + node.getId() + "]")) {
                        if (replacement instanceof CoordPOI) {
                            Node rNode = ((CoordPOI)replacement).getNode();
                            if (rNode.getId() != node.getId()) {
                                if (wayPOI.contains("[" + rNode.getId() + "]")) {
                                    log.warn("link-pois-to-ways: CoordPOI", node.getId(), "replaced by CoordPOI", rNode.getId(), "in way", way.toBrowseURL());
                                } else {
                                    log.warn("link-pois-to-ways: CoordPOI", node.getId(), "replaced by ignored CoordPOI", rNode.getId(), "in way", way.toBrowseURL());
                                }
                            }
                        } else {
                            log.warn("link-pois-to-ways: CoordPOI", node.getId(), "replaced by simple coord in way", way.toBrowseURL());
                        }
                    }
                }
                return replacement;
            }
            log.error((Object)("replacement not found for point " + p.toOSMURL()));
        }
        return p;
    }

    private Map<Coord, Coord> removeWrongAngles(Map<Long, ConvertedWay> modifiedRoads, Set<Long> deletedRoads) {
        List<Coord> points;
        Coord p;
        IdentityHashMap<Coord, Coord> replacements = new IdentityHashMap<Coord, Coord>();
        HashSet<Coord> changedPlaces = new HashSet<Coord>();
        int numNodesMerged = 0;
        HashSet<Way> waysWithBearingErrors = new HashSet<Way>();
        HashSet<Long> waysThatMapToOnePoint = new HashSet<Long>();
        this.prepWithDouglasPeucker(modifiedRoads);
        Way lastWay = null;
        boolean anotherPassRequired = true;
        int maxPass = 20;
        this.pass = 1;
        while (this.pass < 20 && (anotherPassRequired || this.extraPass)) {
            anotherPassRequired = false;
            log.info("Removing wrong angles - PASS", this.pass);
            this.writeOSM("pass_" + this.pass, this.convertedWays);
            lastWay = null;
            for (ConvertedWay cw : this.convertedWays) {
                Way way;
                if (!cw.isValid() || (way = cw.getWay()).equals(lastWay) || this.pass != 1 && !waysWithBearingErrors.contains(way)) continue;
                lastWay = way;
                Iterator<ConvertedWay> points2 = way.getPoints();
                Coord prev = null;
                if (points2.get(0) == points2.get(points2.size() - 1) && points2.size() >= 2) {
                    prev = (Coord)points2.get(points2.size() - 2);
                }
                boolean hasNonEqualPoints = false;
                for (int i = 0; i < points2.size(); ++i) {
                    Coord p2 = (Coord)points2.get(i);
                    if (this.pass == 1) {
                        p2.setRemove(false);
                    }
                    p2 = WrongAngleFixer.getReplacement(p2, way, replacements);
                    if (!(cw.isRoad() || i != 0 && i != points2.size() - 1)) {
                        p2.setEndOfWay(true);
                    }
                    if (prev != null) {
                        double err;
                        if (this.pass == 1 && !p2.equals(prev)) {
                            hasNonEqualPoints = true;
                        }
                        if ((err = WrongAngleFixer.calcBearingError(p2, prev)) >= 15.0) {
                            p2.setPartOfBadAngle(true);
                            prev.setPartOfBadAngle(true);
                        }
                    }
                    prev = p2;
                }
                if (this.pass != 1 || hasNonEqualPoints) continue;
                waysThatMapToOnePoint.add(way.getId());
                log.info("all points of way", way.toBrowseURL(), "are rounded to equal map units");
            }
            IdentityHashMap<Coord, CenterOfAngle> centerMap = new IdentityHashMap<Coord, CenterOfAngle>();
            ArrayList<CenterOfAngle> centers = new ArrayList<CenterOfAngle>();
            HashMap<Coord, Set<Way>> overlaps = new HashMap<Coord, Set<Way>>();
            lastWay = null;
            for (ConvertedWay cw : this.convertedWays) {
                if (!cw.isValid() || cw.getWay().equals(lastWay)) continue;
                Way way = cw.getWay();
                if (this.pass != 1 && !waysWithBearingErrors.contains(way)) continue;
                lastWay = way;
                boolean wayHasSpecialPoints = false;
                List<Coord> points3 = way.getPoints();
                Coord prev = null;
                if (points3.get(0) == points3.get(points3.size() - 1) && points3.size() >= 2) {
                    prev = (Coord)points3.get(points3.size() - 2);
                }
                for (int i = 0; i < points3.size(); ++i) {
                    p = (Coord)points3.get(i);
                    if (prev != null) {
                        if (p == prev) {
                            points3.remove(i);
                            --i;
                            if (!cw.isRoad()) continue;
                            modifiedRoads.put(way.getId(), cw);
                            continue;
                        }
                        if (p.isPartOfBadAngle() || prev.isPartOfBadAngle()) {
                            wayHasSpecialPoints = true;
                            Coord p1 = prev;
                            Coord p2 = p;
                            CenterOfAngle coa1 = this.getOrCreateCenter(p, cw, centerMap, centers, overlaps);
                            CenterOfAngle coa2 = this.getOrCreateCenter(prev, cw, centerMap, centers, overlaps);
                            coa1.addNeighbour(coa2);
                            coa2.addNeighbour(coa1);
                            if (points3.size() == 2) {
                                coa1.addBadMergeCandidate(coa2);
                            }
                            if (cw.isRoad() && p1.getHighwayCount() >= 2 && p2.getHighwayCount() >= 2 && cw.isRoundabout()) {
                                coa1.addBadMergeCandidate(coa2);
                            }
                        }
                    }
                    prev = p;
                }
                if (this.pass != 1 || !wayHasSpecialPoints) continue;
                waysWithBearingErrors.add(way);
            }
            this.markOverlaps(overlaps, centers);
            overlaps.clear();
            lastWay = null;
            block5: for (ConvertedWay cw : this.convertedWays) {
                Way way;
                if (!cw.isValid() || cw.getWay().equals(lastWay)) continue;
                lastWay = way = cw.getWay();
                if (waysWithBearingErrors.contains(way)) continue;
                List<Coord> points4 = way.getPoints();
                for (Coord p3 : points4) {
                    if (p3.getHighwayCount() < 2 || !centerMap.containsKey(p3)) continue;
                    waysWithBearingErrors.add(way);
                    continue block5;
                }
            }
            log.info((Object)("pass " + this.pass + ": analysing " + centers.size() + " points with bearing problems."));
            centerMap = null;
            ArrayList<CenterOfAngle> checkAgainList = null;
            boolean tryMerge = false;
            while (true) {
                checkAgainList = new ArrayList<CenterOfAngle>();
                for (CenterOfAngle coa : centers) {
                    coa.center.setPartOfBadAngle(false);
                    if (coa.getCurrentLocation(replacements) == null || coa.isOK(replacements)) continue;
                    boolean changed = coa.tryChange(replacements, tryMerge);
                    if (changed) {
                        if (DEBUG_PATH == null) continue;
                        changedPlaces.add(coa.center);
                        continue;
                    }
                    checkAgainList.add(coa);
                }
                if (tryMerge) break;
                tryMerge = true;
                centers = checkAgainList;
            }
            lastWay = null;
            boolean lastWayModified = false;
            ConvertedWay lastConvertedWay = null;
            for (ConvertedWay cw : this.convertedWays) {
                if (!cw.isValid() || !waysWithBearingErrors.contains(cw.getWay())) continue;
                Way way = cw.getWay();
                List<Coord> points5 = way.getPoints();
                if (way.equals(lastWay)) {
                    if (!lastWayModified) continue;
                    points5.clear();
                    points5.addAll(lastWay.getPoints());
                    if (cw.isReversed() == lastConvertedWay.isReversed()) continue;
                    Collections.reverse(points5);
                    continue;
                }
                lastWay = way;
                lastConvertedWay = cw;
                lastWayModified = false;
                for (int i = points5.size() - 1; i >= 0; --i) {
                    Coord p4 = points5.get(i);
                    if (p4.isToRemove()) {
                        if (this.pass >= 19) {
                            log.warn("removed point in last pass.", way.getBasicLogInformation(), p4);
                        }
                        points5.remove(i);
                        anotherPassRequired = true;
                        lastWayModified = true;
                        if (i <= 0 || i >= points5.size() || points5.get(i - 1) != points5.get(i)) continue;
                        points5.remove(i);
                        continue;
                    }
                    Coord replacement = WrongAngleFixer.getReplacement(p4, way, replacements);
                    if (p4 == replacement) continue;
                    if (p4.isViaNodeOfRestriction()) {
                        replacement.setViaNodeOfRestriction(true);
                        p4.setViaNodeOfRestriction(false);
                    }
                    p4 = replacement;
                    if (this.pass >= 19) {
                        log.warn("changed point in last pass.", way.getBasicLogInformation(), p4);
                    }
                    points5.set(i, p4);
                    if (p4.getHighwayCount() >= 2) {
                        ++numNodesMerged;
                    }
                    lastWayModified = true;
                    if (i + 1 < points5.size() && points5.get(i + 1) == p4) {
                        points5.remove(i);
                        anotherPassRequired = true;
                    }
                    if (i - 1 < 0 || points5.get(i - 1) != p4) continue;
                    points5.remove(i);
                    anotherPassRequired = true;
                }
                if (!lastWayModified || !cw.isRoad()) continue;
                modifiedRoads.put(way.getId(), cw);
            }
            if (this.extraPass) {
                anotherPassRequired = false;
                break;
            }
            if (!anotherPassRequired) {
                for (CenterOfAngle coa : centers) {
                    if (!coa.forceChange) continue;
                    anotherPassRequired = true;
                    this.extraPass = true;
                    break;
                }
            }
            ++this.pass;
        }
        int numWaysDeleted = 0;
        lastWay = null;
        boolean lastWayModified = false;
        ConvertedWay lastConvertedWay = null;
        for (ConvertedWay cw : this.convertedWays) {
            Way way = cw.getWay();
            points = way.getPoints();
            if (points.size() < 2) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("  Way " + way.getTag("name") + " (" + way.toBrowseURL() + ") has less than 2 points - deleting it"));
                }
                if (!cw.isRoad() && !waysThatMapToOnePoint.contains(way.getId())) {
                    log.warn("non-routable way", way.getId(), "was removed");
                }
                if (cw.isRoad()) {
                    deletedRoads.add(way.getId());
                }
                ++numWaysDeleted;
                continue;
            }
            if (way.equals(lastWay)) {
                if (!lastWayModified) continue;
                points.clear();
                points.addAll(lastWay.getPoints());
                if (cw.isReversed() == lastConvertedWay.isReversed()) continue;
                Collections.reverse(points);
                continue;
            }
            lastWay = way;
            lastConvertedWay = cw;
            lastWayModified = false;
            Coord prev = points.get(points.size() - 1);
            for (int i = points.size() - 2; i >= 0; --i) {
                Coord p5 = points.get(i);
                if (p5 == prev) {
                    points.remove(i);
                    lastWayModified = true;
                }
                prev = p5;
            }
        }
        for (ConvertedWay cw : this.convertedWays) {
            if (!cw.isValid() || cw.isRoad()) continue;
            Way way = cw.getWay();
            points = way.getPoints();
            int n = points.size();
            boolean hasReplacedPoints = false;
            for (int i = 0; i < n; ++i) {
                p = points.get(i);
                if (!p.isReplaced()) continue;
                hasReplacedPoints = true;
                points.set(i, WrongAngleFixer.getReplacement(p, null, replacements));
            }
            if (!hasReplacedPoints || DEBUG_PATH == null) continue;
            GpxCreator.createGpx(Utils.joinPath(DEBUG_PATH, way.getId() + "_mod_non_routable"), points);
        }
        if (DEBUG_PATH != null) {
            GpxCreator.createGpx(Utils.joinPath(DEBUG_PATH, "solved_badAngles"), this.bbox.toCoords(), new ArrayList<Coord>(changedPlaces));
        }
        if (anotherPassRequired) {
            log.warn((Object)("Removing wrong angles - didn't finish in " + this.pass + " passes, giving up!"));
        } else {
            log.info("Removing wrong angles - finished in", this.pass, "passes (", numNodesMerged, "nodes merged,", numWaysDeleted, "ways deleted)");
        }
        return replacements;
    }

    private CenterOfAngle getOrCreateCenter(Coord p, ConvertedWay cw, IdentityHashMap<Coord, CenterOfAngle> centerMap, List<CenterOfAngle> centers, Map<Coord, Set<Way>> overlaps) {
        CenterOfAngle coa = centerMap.get(p);
        if (coa == null) {
            coa = new CenterOfAngle(p, centerMap.size() + 1);
            centerMap.put(p, coa);
            centers.add(coa);
            if (cw.isRoad() && this.pass > 1) {
                overlaps.computeIfAbsent(p, k -> new HashSet()).add(cw.getWay());
            }
        }
        return coa;
    }

    private void markOverlaps(Map<Coord, Set<Way>> overlaps, List<CenterOfAngle> centers) {
        for (Map.Entry<Coord, Set<Way>> entry : overlaps.entrySet()) {
            if (entry.getValue().size() <= 1) continue;
            Coord p = entry.getKey();
            for (CenterOfAngle coa : centers) {
                if (!coa.center.equals(p)) continue;
                coa.forceChange = true;
            }
        }
    }

    private void removeObsoletePoints(Map<Long, ConvertedWay> modifiedRoads) {
        ConvertedWay lastConvertedWay = null;
        int numPointsRemoved = 0;
        boolean lastWasModified = false;
        ArrayList<Coord> removedInWay = new ArrayList<Coord>();
        ArrayList<Coord> obsoletePoints = new ArrayList<Coord>();
        ArrayList<Coord> modifiedPoints = new ArrayList<Coord>();
        WrongAngleFixer.markEndPoints(this.convertedWays, true);
        for (ConvertedWay cw : this.convertedWays) {
            List<Coord> points;
            if (!cw.isValid()) continue;
            Way way = cw.getWay();
            if (lastConvertedWay != null && way.equals(lastConvertedWay.getWay())) {
                if (!lastWasModified) continue;
                points = way.getPoints();
                points.clear();
                points.addAll(lastConvertedWay.getPoints());
                if (cw.isReversed() == lastConvertedWay.isReversed()) continue;
                Collections.reverse(points);
                continue;
            }
            lastConvertedWay = cw;
            lastWasModified = false;
            points = way.getPoints();
            modifiedPoints.clear();
            double maxErrorDistance = WrongAngleFixer.calcMaxErrorDistance(points.get(0));
            boolean draw = false;
            removedInWay.clear();
            modifiedPoints.add(points.get(0));
            int i = 1;
            while (i + 1 < points.size()) {
                block18: {
                    boolean keepThis;
                    Coord cm;
                    block22: {
                        double realAngle;
                        Coord c2;
                        Coord c1;
                        block20: {
                            block21: {
                                block19: {
                                    block17: {
                                        cm = points.get(i);
                                        if (WrongAngleFixer.allowedToRemove(cm)) break block17;
                                        modifiedPoints.add(cm);
                                        break block18;
                                    }
                                    c1 = (Coord)modifiedPoints.get(modifiedPoints.size() - 1);
                                    if (c1 != (c2 = points.get(i + 1))) break block19;
                                    modifiedPoints.add(cm);
                                    break block18;
                                }
                                keepThis = true;
                                realAngle = Utils.getAngle(c1, cm, c2);
                                if (!(Math.abs(realAngle) < 3.0)) break block20;
                                double distance = cm.distToLineSegment(c1, c2);
                                if (!(distance >= maxErrorDistance)) break block21;
                                modifiedPoints.add(cm);
                                break block18;
                            }
                            keepThis = false;
                            break block22;
                        }
                        double displayedAngle = Utils.getDisplayedAngle(c1, cm, c2);
                        if (displayedAngle < 0.0 && realAngle > 0.0 || displayedAngle > 0.0 && realAngle < 0.0) {
                            keepThis = false;
                        } else if (Math.abs(displayedAngle) < 1.0) {
                            if (c1.getHighwayCount() < 2 && c2.getHighwayCount() < 2) {
                                keepThis = false;
                            }
                        } else if (Math.abs(realAngle - displayedAngle) > 2.0 * Math.abs(realAngle) && Math.abs(realAngle) < 7.5) {
                            keepThis = false;
                        } else if (c1.equals(c2)) {
                            log.debug("pass", this.pass, "roads=" + cw.isRoad(), "extra remove to remove spike or overlap near", cm);
                            keepThis = false;
                        }
                    }
                    if (keepThis) {
                        modifiedPoints.add(cm);
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug("removing obsolete point on almost straight segment in", way.getBasicLogInformation(), "at", cm);
                        }
                        if (DEBUG_PATH != null) {
                            obsoletePoints.add(cm);
                            removedInWay.add(cm);
                        }
                        ++numPointsRemoved;
                        lastWasModified = true;
                    }
                }
                ++i;
            }
            if (!lastWasModified) continue;
            modifiedPoints.add(points.get(points.size() - 1));
            points.clear();
            points.addAll(modifiedPoints);
            if (cw.isRoad()) {
                modifiedRoads.put(way.getId(), cw);
            }
            if (DEBUG_PATH == null || !draw && !cw.isRoundabout()) continue;
            GpxCreator.createGpx(Utils.joinPath(DEBUG_PATH, way.getId() + "_dpmod"), points, removedInWay);
        }
        if (DEBUG_PATH != null) {
            GpxCreator.createGpx(Utils.joinPath(DEBUG_PATH, "_obsolete"), this.bbox.toCoords(), new ArrayList<Coord>(obsoletePoints));
        }
        log.info("Removed", numPointsRemoved, "obsolete points from lines");
    }

    private void printBadAngles(String name, List<ConvertedWay> roads) {
        if (DEBUG_PATH == null) {
            return;
        }
        ArrayList<ConvertedWay> badWays = new ArrayList<ConvertedWay>();
        Way lastWay = null;
        ArrayList<Coord> badAngles = new ArrayList<Coord>();
        for (int w = 0; w < roads.size(); ++w) {
            Coord plast;
            Coord p0;
            Way way;
            ConvertedWay cw = roads.get(w);
            if (!cw.isValid() || (way = cw.getWay()).equals(lastWay)) continue;
            boolean hasBadAngles = false;
            lastWay = way;
            List<Coord> points = way.getPoints();
            for (int i = points.size() - 2; i >= 1; --i) {
                Coord c2;
                Coord cm = points.get(i);
                Coord c1 = points.get(i - 1);
                if (c1 == (c2 = points.get(i + 1))) continue;
                double realAngle = Utils.getAngle(c1, cm, c2);
                double displayedAngle = Utils.getDisplayedAngle(c1, cm, c2);
                if (!(Math.abs(displayedAngle - realAngle) > 30.0)) continue;
                badAngles.add(cm);
                hasBadAngles = true;
            }
            if (points.size() > 2 && (p0 = points.get(0)) == (plast = points.get(points.size() - 1))) {
                Coord c2;
                Coord cm = points.get(0);
                Coord c1 = points.get(points.size() - 2);
                if (c1 == (c2 = points.get(1))) continue;
                double realAngle = Utils.getAngle(c1, cm, c2);
                double displayedAngle = Utils.getDisplayedAngle(c1, cm, c2);
                if (Math.abs(displayedAngle - realAngle) > 30.0) {
                    badAngles.add(cm);
                    hasBadAngles = true;
                }
            }
            if (!hasBadAngles) continue;
            badWays.add(cw);
        }
        GpxCreator.createGpx(Utils.joinPath(DEBUG_PATH, name), this.bbox.toCoords(), new ArrayList<Coord>(badAngles));
        this.writeOSM(name, badWays);
    }

    private static boolean allowedToRemove(Coord p) {
        if (p.getOnBoundary() || p.getOnCountryBorder() || p.isEndOfWay()) {
            return false;
        }
        if (p instanceof CoordPOI && ((CoordPOI)p).isUsed()) {
            return false;
        }
        return p.getHighwayCount() < 2 && !p.isViaNodeOfRestriction();
    }

    private void writeOSM(String name, List<ConvertedWay> convertedWays) {
        if (DEBUG_PATH != null) {
            // empty if block
        }
    }

    private static double calcBearingError(Coord p1, Coord p2) {
        double err;
        if (p1.equals(p2) || p1.highPrecEquals(p2)) {
            return Double.MAX_VALUE;
        }
        double realBearing = p1.bearingTo(p2);
        double displayedBearing = p1.getDisplayedCoord().bearingTo(p2.getDisplayedCoord());
        for (err = displayedBearing - realBearing; err > 180.0; err -= 360.0) {
        }
        while (err < -180.0) {
            err += 360.0;
        }
        return Math.abs(err);
    }

    private static double calcMaxErrorDistance(Coord p0) {
        Coord test = new Coord(p0.getLatitude(), p0.getLongitude() + 1);
        return p0.getDisplayedCoord().distance(test) / 2.0;
    }

    /*
     * Unable to fully structure code
     */
    public static List<Coord> fixAnglesInShape(List<Coord> points) {
        modifiedPoints = new ArrayList<Coord>(points.size());
        n = points.size();
        i = 0;
        while (i + 1 < points.size()) {
            c1 = modifiedPoints.isEmpty() == false ? (Coord)modifiedPoints.get(modifiedPoints.size() - 1) : (i > 0 ? points.get(i - 1) : points.get(n - 2));
            cm = points.get(i);
            if (!cm.highPrecEquals(c1)) ** GOTO lbl16
            if (modifiedPoints.size() <= 1) {
                if (modifiedPoints.isEmpty()) {
                    modifiedPoints.add(c1);
                }
            } else {
                modifiedPoints.remove(modifiedPoints.size() - 1);
                c1 = (Coord)modifiedPoints.get(modifiedPoints.size() - 1);
lbl16:
                // 2 sources

                if ((straightTest = Utils.isHighPrecStraight(c1, cm, c2 = points.get(i + 1))) != 2 && straightTest != 1) {
                    modifiedPoints.add(cm);
                }
            }
            ++i;
        }
        if (modifiedPoints.size() > 1 && modifiedPoints.get(0) != modifiedPoints.get(modifiedPoints.size() - 1)) {
            modifiedPoints.add((Coord)modifiedPoints.get(0));
        }
        while (modifiedPoints.size() > 3) {
            nPoints = modifiedPoints.size();
            switch (Utils.isHighPrecStraight((Coord)modifiedPoints.get(modifiedPoints.size() - 2), (Coord)modifiedPoints.get(0), (Coord)modifiedPoints.get(1))) {
                case 1: {
                    WrongAngleFixer.log.debug((Object)"removing closing spike");
                    modifiedPoints.remove(0);
                    modifiedPoints.set(modifiedPoints.size() - 1, (Coord)modifiedPoints.get(0));
                    if (!((Coord)modifiedPoints.get(modifiedPoints.size() - 2)).highPrecEquals((Coord)modifiedPoints.get(modifiedPoints.size() - 1))) break;
                    modifiedPoints.remove(modifiedPoints.size() - 2);
                    break;
                }
                case 2: {
                    WrongAngleFixer.log.debug((Object)"removing straight line across closing");
                    modifiedPoints.remove(modifiedPoints.size() - 1);
                    modifiedPoints.set(0, (Coord)modifiedPoints.get(modifiedPoints.size() - 1));
                }
            }
            if (nPoints != modifiedPoints.size()) continue;
            break;
        }
        return modifiedPoints;
    }

    public static List<Coord> removeSpikeInShape(List<Coord> points) {
        int numPoints = points.size();
        if (numPoints <= 1) {
            return points;
        }
        int requiredPoints = 4;
        ArrayList<Coord> newPoints = new ArrayList<Coord>(numPoints);
        while (true) {
            boolean removedSpike = false;
            numPoints = points.size();
            Coord lastP = points.get(0);
            newPoints.add(lastP);
            for (int i = 1; i < numPoints; ++i) {
                Coord newP = points.get(i);
                int last = newPoints.size() - 1;
                lastP = (Coord)newPoints.get(last);
                if (newPoints.size() > 1 && 1 == Utils.isHighPrecStraight((Coord)newPoints.get(last - 1), lastP, newP)) {
                    log.debug((Object)"removing spike");
                    newPoints.remove(last);
                    removedSpike = true;
                    if (((Coord)newPoints.get(last - 1)).highPrecEquals(newP)) {
                        newPoints.remove(last - 1);
                    }
                }
                newPoints.add(newP);
            }
            if (newPoints.get(0) != newPoints.get(newPoints.size() - 1)) {
                while (((Coord)newPoints.get(0)).highPrecEquals((Coord)newPoints.get(newPoints.size() - 1))) {
                    newPoints.remove(newPoints.size() - 1);
                }
                newPoints.add((Coord)newPoints.get(0));
            }
            if (!removedSpike || newPoints.size() < 4) break;
            points = newPoints;
            newPoints = new ArrayList(points.size());
        }
        if (newPoints.get(0) != newPoints.get(newPoints.size() - 1)) {
            throw new MapFailedException("shape is no longer closed");
        }
        while (newPoints.size() >= 4 && 1 == Utils.isHighPrecStraight((Coord)newPoints.get(newPoints.size() - 2), (Coord)newPoints.get(0), (Coord)newPoints.get(1))) {
            log.debug((Object)"removing closing spike");
            newPoints.remove(0);
            newPoints.set(newPoints.size() - 1, (Coord)newPoints.get(0));
            if (!((Coord)newPoints.get(newPoints.size() - 2)).highPrecEquals((Coord)newPoints.get(newPoints.size() - 1))) continue;
            newPoints.remove(newPoints.size() - 2);
        }
        if (newPoints.get(0) != newPoints.get(newPoints.size() - 1)) {
            throw new MapFailedException("shape is no longer closed");
        }
        return newPoints;
    }

    private void prepWithDouglasPeucker(Map<Long, ConvertedWay> modifiedRoads) {
        WrongAngleFixer.markEndPoints(this.convertedWays, true);
        double maxErrorDistance = 0.05;
        Way lastWay = null;
        for (ConvertedWay cw : this.convertedWays) {
            Way way;
            if (!cw.isValid() || cw.getWay().equals(lastWay)) continue;
            lastWay = way = cw.getWay();
            List<Coord> points = way.getPoints();
            ArrayList<Coord> coords = new ArrayList<Coord>(points);
            int endIndex = coords.size() - 1;
            for (int i = endIndex - 1; i > 0; --i) {
                Coord p = (Coord)coords.get(i);
                if (WrongAngleFixer.allowedToRemove(p)) continue;
                DouglasPeuckerFilter.douglasPeucker(coords, i, endIndex, maxErrorDistance);
                endIndex = i;
            }
            DouglasPeuckerFilter.douglasPeucker(coords, 0, endIndex, maxErrorDistance);
            if (coords.size() == points.size()) continue;
            if (cw.isRoad()) {
                modifiedRoads.put(way.getId(), cw);
            }
            points.clear();
            points.addAll(coords);
        }
        WrongAngleFixer.markEndPoints(this.convertedWays, false);
    }

    private static void markEndPoints(List<ConvertedWay> convertedWays, boolean b) {
        Way lastWay = null;
        for (ConvertedWay cw : convertedWays) {
            Way way;
            if (!cw.isValid() || cw.getWay().equals(lastWay)) continue;
            lastWay = way = cw.getWay();
            way.getFirstPoint().setEndOfWay(b);
            way.getLastPoint().setEndOfWay(b);
        }
    }

    private class CenterOfAngle {
        boolean forceChange;
        final Coord center;
        final List<CenterOfAngle> neighbours;
        final int id;
        boolean wasMerged;
        List<CenterOfAngle> badMergeCandidates;

        public CenterOfAngle(Coord center, int id) {
            this.center = center;
            assert (!center.isReplaced());
            this.id = id;
            this.neighbours = new ArrayList<CenterOfAngle>();
        }

        public String toString() {
            return "CenterOfAngle [id=" + this.id + " " + this.center.toString() + " " + this.center + ", wasMerged=" + this.wasMerged + ", num Neighbours=" + this.neighbours.size() + "]";
        }

        public Coord getCurrentLocation(Map<Coord, Coord> replacements) {
            Coord c = WrongAngleFixer.getReplacement(this.center, null, replacements);
            if (c.isToRemove()) {
                return null;
            }
            return c;
        }

        public void addBadMergeCandidate(CenterOfAngle other) {
            if (this.badMergeCandidates == null) {
                this.badMergeCandidates = new ArrayList<CenterOfAngle>();
            }
            this.badMergeCandidates.add(other);
        }

        public void addNeighbour(CenterOfAngle other) {
            if (this == other) {
                log.error((Object)"neighbour is equal");
            }
            boolean isNew = true;
            for (CenterOfAngle neighbour : this.neighbours) {
                if (neighbour != other) continue;
                isNew = false;
                break;
            }
            if (isNew) {
                this.neighbours.add(other);
            }
        }

        public boolean isOK(Map<Coord, Coord> replacements) {
            if (this.forceChange) {
                return false;
            }
            Coord c = this.getCurrentLocation(replacements);
            if (c == null) {
                return true;
            }
            for (CenterOfAngle neighbour : this.neighbours) {
                double err;
                Coord n = neighbour.getCurrentLocation(replacements);
                if (n == null || !((err = WrongAngleFixer.calcBearingError(c, n)) >= 15.0)) continue;
                return false;
            }
            return true;
        }

        private void replaceCoord(Coord toRepl, Coord replacement, Map<Coord, Coord> replacements) {
            CoordPOI cp;
            assert (toRepl != replacement);
            if (toRepl.getOnBoundary()) {
                if (!replacement.equals(toRepl)) {
                    log.error("boundary node is replaced by node with non-equal coordinates at", toRepl.toOSMURL());
                    assert (false) : "boundary node is replaced";
                }
                replacement.setOnBoundary(true);
            }
            if (toRepl.getOnCountryBorder()) {
                if (!replacement.equals(toRepl)) {
                    log.warn("country boundary node is replaced by node with non-equal coordinates at", toRepl.toOSMURL());
                }
                replacement.setOnCountryBorder(true);
            }
            toRepl.setReplaced(true);
            if (toRepl instanceof CoordPOI && (cp = (CoordPOI)toRepl).isUsed() && !(replacement = new CoordPOI(replacement, cp)).highPrecEquals(cp.getNode().getLocation())) {
                log.error("link-pois-to-ways: CoordPOI node is replaced with non-equal coordinates at", toRepl.toOSMURL());
            }
            if (toRepl.isViaNodeOfRestriction()) {
                replacement.setViaNodeOfRestriction(true);
            }
            replacements.put(toRepl, replacement);
            while (toRepl.getHighwayCount() > replacement.getHighwayCount()) {
                replacement.incHighwayCount();
            }
            if (toRepl.isEndOfWay()) {
                replacement.setEndOfWay(true);
            }
        }

        public boolean tryChange(Map<Coord, Coord> replacements, boolean tryAlsoMerge) {
            double maxDist;
            boolean bl;
            if (this.wasMerged) {
                return false;
            }
            Coord currentCenter = this.getCurrentLocation(replacements);
            if (currentCenter == null) {
                return false;
            }
            CenterOfAngle worstNeighbour = null;
            Coord worstNP = null;
            double initialMaxError = 0.0;
            double initialSumErr = 0.0;
            HashSet<Coord> dupCheck = new HashSet<Coord>();
            boolean hasDups = false;
            for (CenterOfAngle neighbour : this.neighbours) {
                double err;
                Coord n = neighbour.getCurrentLocation(replacements);
                if (n == null) {
                    return false;
                }
                if (!dupCheck.add(n)) {
                    hasDups = true;
                }
                if (currentCenter.highPrecEquals(n)) {
                    if (currentCenter == n) {
                        log.error((Object)(this.id + ": bad neighbour " + neighbour.id + " zero distance"));
                    }
                    if (!(this.badMergeCandidates != null && this.badMergeCandidates.contains(neighbour) || neighbour.badMergeCandidates != null && neighbour.badMergeCandidates.contains(this))) {
                        this.replaceCoord(currentCenter, n, replacements);
                        this.wasMerged = true;
                        neighbour.wasMerged = true;
                        return true;
                    }
                }
                if ((err = WrongAngleFixer.calcBearingError(currentCenter, n)) != Double.MAX_VALUE) {
                    initialSumErr += err;
                }
                if (!(err > initialMaxError)) continue;
                initialMaxError = err;
                worstNeighbour = neighbour;
                worstNP = n;
            }
            if (initialMaxError < 15.0) {
                return false;
            }
            double removeErr = this.calcRemoveError(replacements);
            if (removeErr == 0.0) {
                currentCenter.setRemove(true);
                return true;
            }
            if (hasDups) {
                if (WrongAngleFixer.this.extraPass && tryAlsoMerge && currentCenter.getHighwayCount() > 1) {
                    List<Coord> altPositions = currentCenter.getAlternativePositions();
                    for (Coord altCenter : altPositions) {
                        if (!dupCheck.contains(altCenter)) continue;
                        log.debug("pass", WrongAngleFixer.this.pass, "extra move to remove spike or overlap near", currentCenter);
                        this.replaceCoord(currentCenter, altCenter, replacements);
                        return true;
                    }
                }
                return false;
            }
            if (initialMaxError == Double.MAX_VALUE) {
                initialSumErr = initialMaxError;
            }
            double bestReplErr = initialMaxError;
            Coord bestCenterReplacement = null;
            List<Coord> altPositions = currentCenter.getAlternativePositions();
            for (Coord coord : altPositions) {
                double errMax;
                double err = WrongAngleFixer.calcBearingError(coord, worstNP);
                if (err >= bestReplErr || !((errMax = this.calcMaxError(replacements, currentCenter, coord)) < initialMaxError)) continue;
                bestReplErr = err;
                bestCenterReplacement = coord;
            }
            Coord bestNeighbourReplacement = null;
            if (worstNP.hasAlternativePos()) {
                for (Coord altCenter : altPositions) {
                    this.replaceCoord(currentCenter, altCenter, replacements);
                    for (Coord altN : worstNP.getAlternativePositions()) {
                        double errNeighbour;
                        double err = WrongAngleFixer.calcBearingError(altCenter, altN);
                        if (err >= bestReplErr || !((errNeighbour = worstNeighbour.calcMaxError(replacements, worstNP, altN)) < bestReplErr)) continue;
                        bestReplErr = err;
                        bestCenterReplacement = altCenter;
                        bestNeighbourReplacement = altN;
                    }
                    replacements.remove(currentCenter);
                    currentCenter.setReplaced(false);
                }
            }
            boolean bl2 = false;
            if (WrongAngleFixer.this.extraPass && bestReplErr >= 15.0 && bestCenterReplacement != null && bestReplErr * 2.0 < initialMaxError && initialMaxError < 180.0) {
                bl = true;
            }
            if (bestReplErr < 15.0 || bl) {
                if (removeErr < bestReplErr && initialMaxError - removeErr >= 7.5 && removeErr < 7.5) {
                    bestCenterReplacement = null;
                }
                if (bestCenterReplacement != null) {
                    double modifiedSumErr;
                    this.replaceCoord(currentCenter, bestCenterReplacement, replacements);
                    if (bestNeighbourReplacement != null) {
                        this.replaceCoord(worstNP, bestNeighbourReplacement, replacements);
                    }
                    if ((modifiedSumErr = this.calcSumOfErrors(replacements)) < initialSumErr) {
                        if (bl) {
                            log.debug("pass", WrongAngleFixer.this.pass, "special repl", this);
                        }
                        return true;
                    }
                    replacements.remove(currentCenter);
                    currentCenter.setReplaced(false);
                    replacements.remove(worstNP);
                    worstNP.setReplaced(false);
                }
            }
            if (removeErr < 15.0) {
                currentCenter.setRemove(true);
                return true;
            }
            if (!tryAlsoMerge) {
                return false;
            }
            double dist = currentCenter.distance(worstNP);
            if (dist < (maxDist = WrongAngleFixer.calcMaxErrorDistance(currentCenter) * 2.0) || this.neighbours.size() == 3 && worstNeighbour.neighbours.size() == 3) {
                return this.tryMerge(initialMaxError, worstNeighbour, replacements);
            }
            return false;
        }

        private boolean tryMerge(double initialMaxError, CenterOfAngle neighbour, Map<Coord, Coord> replacements) {
            if (this.badMergeCandidates != null && this.badMergeCandidates.contains(neighbour) || neighbour.badMergeCandidates != null && neighbour.badMergeCandidates.contains(this)) {
                return false;
            }
            Coord c = this.getCurrentLocation(replacements);
            Coord n = neighbour.getCurrentLocation(replacements);
            if (c.getOnBoundary() && (n.isViaNodeOfRestriction() || n.getOnBoundary() && !c.equals(n)) || c.isViaNodeOfRestriction() && (n.isViaNodeOfRestriction() || n.getOnBoundary()) || c instanceof CoordPOI && (n instanceof CoordPOI || n.getOnBoundary()) || n instanceof CoordPOI && (c instanceof CoordPOI || c.getOnBoundary())) {
                return false;
            }
            Coord mergePoint = c.getOnBoundary() || c instanceof CoordPOI ? c : (n.getOnBoundary() || n instanceof CoordPOI ? n : (c.equals(n) ? c : c.makeBetweenPoint(n, 0.5)));
            double err = 0.0;
            if (!c.equals(n)) {
                err = this.calcMergeErr(neighbour, mergePoint, replacements);
                if (err == Double.MAX_VALUE && initialMaxError == Double.MAX_VALUE) {
                    log.warn("still equal neighbour after merge", c.toOSMURL());
                } else {
                    if (err >= 15.0) {
                        return false;
                    }
                    if (initialMaxError - err < 7.5 && err > 7.5) {
                        return false;
                    }
                }
                if (!this.checkNearlyStraight(c.bearingTo(n), neighbour, replacements) || !neighbour.checkNearlyStraight(n.bearingTo(c), this, replacements)) {
                    return false;
                }
            }
            int hwc = c.getHighwayCount() + n.getHighwayCount() - 1;
            for (int i = mergePoint.getHighwayCount(); i < hwc; ++i) {
                mergePoint.incHighwayCount();
            }
            if (c != mergePoint) {
                this.replaceCoord(c, mergePoint, replacements);
            }
            if (n != mergePoint) {
                this.replaceCoord(n, mergePoint, replacements);
            }
            this.wasMerged = true;
            neighbour.wasMerged = true;
            return true;
        }

        private boolean checkNearlyStraight(double bearing, CenterOfAngle other, Map<Coord, Coord> replacements) {
            Coord c = this.getCurrentLocation(replacements);
            for (CenterOfAngle neighbour : this.neighbours) {
                double angle;
                Coord n;
                if (neighbour == other || (n = neighbour.getCurrentLocation(replacements)) == null) continue;
                double bearing2 = c.bearingTo(n);
                for (angle = bearing2 - (bearing - 180.0); angle > 180.0; angle -= 360.0) {
                }
                while (angle < -180.0) {
                    angle += 360.0;
                }
                if (!(Math.abs(angle) < 10.0)) continue;
                return true;
            }
            return false;
        }

        private double calcMergeErr(CenterOfAngle other, Coord mergePoint, Map<Coord, Coord> replacements) {
            double err;
            Coord n;
            double maxErr = 0.0;
            for (CenterOfAngle neighbour : this.neighbours) {
                if (neighbour == other || (n = neighbour.getCurrentLocation(replacements)) == null || !((err = WrongAngleFixer.calcBearingError(mergePoint, n)) > maxErr)) continue;
                maxErr = err;
            }
            for (CenterOfAngle othersNeighbour : other.neighbours) {
                if (othersNeighbour == this || (n = othersNeighbour.getCurrentLocation(replacements)) == null || !((err = WrongAngleFixer.calcBearingError(mergePoint, n)) > maxErr)) continue;
                maxErr = err;
            }
            return maxErr;
        }

        private double calcMaxError(Map<Coord, Coord> replacements, Coord toRepl, Coord replacement) {
            double maxErr = 0.0;
            Coord c = this.getCurrentLocation(replacements);
            for (CenterOfAngle neighbour : this.neighbours) {
                Coord n = neighbour.getCurrentLocation(replacements);
                if (n == null) continue;
                double err = c == toRepl ? WrongAngleFixer.calcBearingError(replacement, n) : (n == toRepl ? WrongAngleFixer.calcBearingError(c, replacement) : WrongAngleFixer.calcBearingError(c, n));
                if (err == Double.MAX_VALUE) {
                    return err;
                }
                if (!(err > maxErr)) continue;
                maxErr = err;
            }
            return maxErr;
        }

        private double calcSumOfErrors(Map<Coord, Coord> replacements) {
            double sumErr = 0.0;
            Coord c = this.getCurrentLocation(replacements);
            for (CenterOfAngle neighbour : this.neighbours) {
                Coord n = neighbour.getCurrentLocation(replacements);
                if (n == null) continue;
                double err = WrongAngleFixer.calcBearingError(c, n);
                if (err == Double.MAX_VALUE) {
                    return err;
                }
                sumErr += err;
            }
            return sumErr;
        }

        private double calcRemoveError(Map<Coord, Coord> replacements) {
            int i;
            if (!WrongAngleFixer.allowedToRemove(this.center)) {
                return Double.MAX_VALUE;
            }
            if (this.neighbours.size() > 2) {
                return Double.MAX_VALUE;
            }
            Coord c = this.getCurrentLocation(replacements);
            Coord[] outerPoints = new Coord[this.neighbours.size()];
            for (i = 0; i < this.neighbours.size(); ++i) {
                CenterOfAngle neighbour = this.neighbours.get(i);
                Coord n = neighbour.getCurrentLocation(replacements);
                if (n == null) {
                    return Double.MAX_VALUE;
                }
                if (c.equals(n)) {
                    if (!WrongAngleFixer.allowedToRemove(neighbour.center) || c.getDistToDisplayedPoint() >= n.getDistToDisplayedPoint()) {
                        return 0.0;
                    }
                    return Double.MAX_VALUE;
                }
                outerPoints[i] = n;
            }
            if (this.neighbours.size() < 2) {
                return Double.MAX_VALUE;
            }
            for (i = 0; i < this.neighbours.size(); ++i) {
                if (2 * c.getDistToDisplayedPoint() >= outerPoints[i].getDistToDisplayedPoint()) continue;
                return Double.MAX_VALUE;
            }
            double dsplAngle = Utils.getDisplayedAngle(outerPoints[0], c, outerPoints[1]);
            if (Math.abs(dsplAngle) < 3.0) {
                return Double.MAX_VALUE;
            }
            double realAngle = Utils.getAngle(outerPoints[0], c, outerPoints[1]);
            return Math.abs(realAngle) / 2.0;
        }

        private void createGPX(String gpxName, Map<Coord, Coord> replacements) {
            if (DEBUG_PATH == null || gpxName == null) {
                return;
            }
            if (gpxName.isEmpty()) {
                gpxName = Utils.joinPath(DEBUG_PATH, this.id + "_no_info");
            }
            Coord c = WrongAngleFixer.getReplacement(this.center, null, replacements);
            List<Coord> alternatives = c.getAlternativePositions();
            for (int i = 0; i < this.neighbours.size(); ++i) {
                CenterOfAngle n = this.neighbours.get(i);
                Coord nc = WrongAngleFixer.getReplacement(n.center, null, replacements);
                if (nc == null) continue;
                if (i == 0 && !alternatives.isEmpty()) {
                    GpxCreator.createGpx(gpxName + "_" + i, Arrays.asList(c, nc), alternatives);
                    continue;
                }
                GpxCreator.createGpx(gpxName + "_" + i, Arrays.asList(c, nc));
            }
            if (this.neighbours.isEmpty()) {
                GpxCreator.createGpx(gpxName + "_empty", Arrays.asList(c, c), alternatives);
            }
        }
    }
}

