/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle;

import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import it.unimi.dsi.fastutil.shorts.ShortListIterator;
import java.util.List;
import java.util.Properties;
import uk.me.parabola.mkgmap.CommandArgs;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.reader.osm.TagDict;
import uk.me.parabola.mkgmap.reader.osm.Tags;

public class NameFinder {
    private final ShortArrayList compiledNameTagList;
    private static final short TK_NAME = TagDict.getInstance().xlate("name");

    public NameFinder(Properties props) {
        this.compiledNameTagList = NameFinder.computeCompiledNameTags(props);
    }

    private static ShortArrayList computeCompiledNameTags(Properties props) {
        if (props == null) {
            return null;
        }
        List<String> nametags = CommandArgs.getNameTags(props);
        if (nametags.size() == 1 && "name".equals(nametags.get(0))) {
            return null;
        }
        return TagDict.compileTags(nametags.toArray(new String[0]));
    }

    public String getName(Element el) {
        if (this.compiledNameTagList == null) {
            return el.getTag(TK_NAME);
        }
        ShortListIterator shortListIterator = this.compiledNameTagList.iterator();
        while (shortListIterator.hasNext()) {
            short tagKey = (Short)shortListIterator.next();
            String val = el.getTag(tagKey);
            if (val == null) continue;
            return val;
        }
        return null;
    }

    public String getName(Tags tags) {
        if (this.compiledNameTagList == null) {
            return tags.get(TK_NAME);
        }
        ShortListIterator shortListIterator = this.compiledNameTagList.iterator();
        while (shortListIterator.hasNext()) {
            short tagKey = (Short)shortListIterator.next();
            String val = tags.get(tagKey);
            if (val == null) continue;
            return val;
        }
        return null;
    }

    public void setNameWithNameTagList(Element el) {
        if (this.compiledNameTagList == null) {
            return;
        }
        ShortListIterator shortListIterator = this.compiledNameTagList.iterator();
        while (shortListIterator.hasNext()) {
            short tagKey = (Short)shortListIterator.next();
            String val = el.getTag(tagKey);
            if (val == null) continue;
            if (tagKey == TK_NAME) break;
            el.addTag(TK_NAME, val);
            break;
        }
    }
}

