/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.combiners;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import uk.me.parabola.imgfmt.fs.FileSystem;
import uk.me.parabola.imgfmt.fs.ImgChannel;
import uk.me.parabola.imgfmt.sys.FileImgChannel;
import uk.me.parabola.imgfmt.sys.ImgFS;

class FileCopier {
    private final String filename;
    private FileSystem fs;
    private int refCount;

    public FileCopier(String filename) {
        this.filename = filename;
    }

    Closeable add(String name, ImgChannel fout) {
        ++this.refCount;
        return () -> this.sync(name, fout);
    }

    Closeable file(ImgChannel fout) {
        return () -> this.sync(fout);
    }

    public void sync(ImgChannel fout) throws IOException {
        try (FileImgChannel fin = new FileImgChannel(this.filename, "r");){
            FileCopier.copyFile(fin, fout);
        }
    }

    void sync(String name, ImgChannel fout) throws IOException {
        if (this.fs == null) {
            this.fs = ImgFS.openFs(this.filename);
        }
        this.copyFile(name, fout);
        --this.refCount;
        if (this.refCount <= 0) {
            this.fs.close();
        }
    }

    private void copyFile(String name, ImgChannel fout) throws IOException {
        try (ImgChannel fin = this.fs.open(name, "r");){
            FileCopier.copyFile(fin, fout);
        }
    }

    private static void copyFile(ImgChannel fin, ImgChannel fout) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(1024);
        while (fin.read(buf) > 0) {
            buf.flip();
            fout.write(buf);
            buf.compact();
        }
    }
}

