/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.lbl;

import java.nio.charset.StandardCharsets;
import uk.me.parabola.imgfmt.app.CommonHeader;
import uk.me.parabola.imgfmt.app.ImgFileReader;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.lbl.PlacesHeader;
import uk.me.parabola.imgfmt.app.srt.Sort;

public class LBLHeader
extends CommonHeader {
    public static final int HEADER_LEN = 196;
    private static final char UNK3_REC_LEN = '\u0000';
    private int labelStart;
    private int labelSize;
    private int offsetMultiplier;
    private Sort sort;
    private int sortDescriptionLength;
    private int encodingType = 6;
    private final PlacesHeader placeHeader = new PlacesHeader();

    public LBLHeader() {
        super(196, "GARMIN LBL");
    }

    public int getSortDescriptionLength() {
        return this.sortDescriptionLength;
    }

    @Override
    protected void readFileHeader(ImgFileReader reader) {
        this.labelStart = reader.get4();
        this.labelSize = reader.get4();
        this.offsetMultiplier = 1 << reader.get();
        this.encodingType = reader.get();
        this.placeHeader.readFileHeader(reader);
        int codepage = reader.get2u();
        int id1 = reader.get2u();
        int id2 = reader.get2u();
        int descOff = reader.get4();
        int descLen = reader.get4();
        reader.position(descOff);
        byte[] bytes = reader.get(descLen);
        String description = new String(bytes, StandardCharsets.US_ASCII);
        this.sort = new Sort();
        this.sort.setCodepage(codepage);
        this.sort.setId1(id1);
        this.sort.setId2(id2);
        this.sort.setDescription(description);
        reader.position(this.labelStart);
    }

    @Override
    protected void writeFileHeader(ImgFileWriter writer) {
        writer.put4(196 + this.sortDescriptionLength);
        writer.put4(this.getLabelSize());
        writer.put1u(this.offsetMultiplier);
        writer.put1u(this.encodingType);
        this.placeHeader.writeFileHeader(writer);
        writer.put2u(this.getCodePage());
        int id1 = this.sort.getId1();
        writer.put2u(id1);
        int id2 = this.sort.getId2();
        if (id1 != 0 && id2 != 0) {
            id2 |= 0x8000;
        }
        writer.put2u(id2);
        writer.put4(196);
        writer.put4(this.sortDescriptionLength);
        writer.put4(this.placeHeader.getLastPos());
        writer.put4(0);
        writer.put2u(0);
        writer.put2u(0);
    }

    protected int getEncodingType() {
        return this.encodingType;
    }

    public void setEncodingType(int type) {
        this.encodingType = type;
    }

    protected int getLabelSize() {
        return this.labelSize;
    }

    public void setLabelSize(int labelSize) {
        this.labelSize = labelSize;
        this.placeHeader.setLabelEnd(196 + this.sortDescriptionLength + labelSize);
    }

    protected int getCodePage() {
        return this.sort.getCodepage();
    }

    public void setSort(Sort sort) {
        this.sortDescriptionLength = sort.getDescription().length() + 1;
        this.sort = sort;
    }

    public int getSortOrderId() {
        return this.sort.getSortOrderId();
    }

    public int getLabelStart() {
        return this.labelStart;
    }

    public int getOffsetMultiplier() {
        return this.offsetMultiplier;
    }

    public PlacesHeader getPlaceHeader() {
        return this.placeHeader;
    }

    public void setOffsetMultiplier(int offsetMultiplier) {
        this.offsetMultiplier = offsetMultiplier;
    }
}

