/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app;

import java.io.IOException;
import java.nio.ByteBuffer;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.Section;

public class SectionWriter
implements ImgFileWriter {
    private final ImgFileWriter writer;
    private final Section section;
    private final int secStart;

    public SectionWriter(ImgFileWriter writer, Section section) {
        this.writer = writer;
        this.secStart = section.getPosition();
        this.section = section;
    }

    @Override
    public void sync() throws IOException {
        this.writer.sync();
    }

    @Override
    public void close() {
        if (this.section != null) {
            this.section.setSize(this.writer.position() - this.secStart);
        }
    }

    @Override
    public int position() {
        return this.writer.position() - this.secStart;
    }

    @Override
    public void position(long pos) {
        this.writer.position(pos + (long)this.secStart);
    }

    @Override
    public void put(byte b) {
        this.writer.put(b);
    }

    @Override
    public void put1s(int val) {
        this.writer.put1s(val);
    }

    @Override
    public void put2s(int val) {
        this.writer.put2s(val);
    }

    @Override
    public void put3s(int val) {
        this.writer.put3s(val);
    }

    @Override
    public void put1u(int val) {
        this.writer.put1u(val);
    }

    @Override
    public void put2u(int val) {
        this.writer.put2u(val);
    }

    @Override
    public void put3u(int val) {
        this.writer.put3u(val);
    }

    @Override
    public void putNu(int nBytes, int val) {
        this.writer.putNu(nBytes, val);
    }

    @Override
    public void put4(int val) {
        this.writer.put4(val);
    }

    @Override
    public void put(byte[] val) {
        this.writer.put(val);
    }

    @Override
    public void put(byte[] src, int start, int length) {
        this.writer.put(src, start, length);
    }

    @Override
    public void put(ByteBuffer src) {
        this.writer.put(src);
    }

    @Override
    public long getSize() {
        throw new UnsupportedOperationException("Cannot get size at this point");
    }
}

