# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import SDKClient
from msrest import Serializer, Deserializer

from ._configuration import AuthorizationManagementClientConfiguration
from .operations import PermissionsOperations
from .operations import RoleDefinitionsOperations
from .operations import ProviderOperationsMetadataOperations
from .operations import GlobalAdministratorOperations
from .operations import RoleAssignmentsOperations
from .operations import ClassicAdministratorsOperations
from . import models


class AuthorizationManagementClient(SDKClient):
    """Role based access control provides you a way to apply granular level policy administration down to individual resources or resource groups. These operations enable you to manage role definitions and role assignments. A role definition describes the set of actions that can be performed on resources. A role assignment grants access to Azure Active Directory users.

    :ivar config: Configuration for client.
    :vartype config: AuthorizationManagementClientConfiguration

    :ivar permissions: Permissions operations
    :vartype permissions: azure.mgmt.authorization.v2015_07_01.operations.PermissionsOperations
    :ivar role_definitions: RoleDefinitions operations
    :vartype role_definitions: azure.mgmt.authorization.v2015_07_01.operations.RoleDefinitionsOperations
    :ivar provider_operations_metadata: ProviderOperationsMetadata operations
    :vartype provider_operations_metadata: azure.mgmt.authorization.v2015_07_01.operations.ProviderOperationsMetadataOperations
    :ivar global_administrator: GlobalAdministrator operations
    :vartype global_administrator: azure.mgmt.authorization.v2015_07_01.operations.GlobalAdministratorOperations
    :ivar role_assignments: RoleAssignments operations
    :vartype role_assignments: azure.mgmt.authorization.v2015_07_01.operations.RoleAssignmentsOperations
    :ivar classic_administrators: ClassicAdministrators operations
    :vartype classic_administrators: azure.mgmt.authorization.v2015_07_01.operations.ClassicAdministratorsOperations

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: The ID of the target subscription.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        self.config = AuthorizationManagementClientConfiguration(credentials, subscription_id, base_url)
        super(AuthorizationManagementClient, self).__init__(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = '2015-07-01'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.permissions = PermissionsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.role_definitions = RoleDefinitionsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.provider_operations_metadata = ProviderOperationsMetadataOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.global_administrator = GlobalAdministratorOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.role_assignments = RoleAssignmentsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.classic_administrators = ClassicAdministratorsOperations(
            self._client, self.config, self._serialize, self._deserialize)
