/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.server;

import java.nio.ByteBuffer;
import org.sparkproject.guava.base.Preconditions;

public class BlockPushNonFatalFailure
extends RuntimeException {
    public static final String TOO_LATE_BLOCK_PUSH_MESSAGE_SUFFIX = " is received after merged shuffle is finalized";
    public static final String TOO_OLD_ATTEMPT_SUFFIX = " is from an older app attempt";
    public static final String STALE_BLOCK_PUSH_MESSAGE_SUFFIX = " is a stale block push from an indeterminate stage retry";
    public static final String BLOCK_APPEND_COLLISION_MSG_SUFFIX = " experienced merge collision on the server side";
    private ByteBuffer response;
    private ReturnCode returnCode;

    public BlockPushNonFatalFailure(ByteBuffer response, String msg) {
        super(msg);
        this.response = response;
    }

    public BlockPushNonFatalFailure(ReturnCode returnCode, String msg) {
        super(msg);
        this.returnCode = returnCode;
    }

    @Override
    public synchronized Throwable fillInStackTrace() {
        return this;
    }

    public ByteBuffer getResponse() {
        Preconditions.checkNotNull(this.response);
        return this.response;
    }

    public ReturnCode getReturnCode() {
        Preconditions.checkNotNull(this.returnCode);
        return this.returnCode;
    }

    public static ReturnCode getReturnCode(byte id) {
        return switch (id) {
            case 0 -> ReturnCode.SUCCESS;
            case 1 -> ReturnCode.TOO_LATE_BLOCK_PUSH;
            case 2 -> ReturnCode.BLOCK_APPEND_COLLISION_DETECTED;
            case 3 -> ReturnCode.STALE_BLOCK_PUSH;
            case 4 -> ReturnCode.TOO_OLD_ATTEMPT_PUSH;
            default -> throw new IllegalArgumentException("Unknown block push return code: " + id);
        };
    }

    public static boolean shouldNotRetryErrorCode(ReturnCode returnCode) {
        return returnCode == ReturnCode.TOO_LATE_BLOCK_PUSH || returnCode == ReturnCode.STALE_BLOCK_PUSH || returnCode == ReturnCode.TOO_OLD_ATTEMPT_PUSH;
    }

    public static String getErrorMsg(String blockId, ReturnCode errorCode) {
        Preconditions.checkArgument(errorCode != ReturnCode.SUCCESS);
        return "Block " + blockId + errorCode.errorMsgSuffix;
    }

    public static final class ReturnCode
    extends Enum<ReturnCode> {
        public static final /* enum */ ReturnCode SUCCESS = new ReturnCode(0, "");
        public static final /* enum */ ReturnCode TOO_LATE_BLOCK_PUSH = new ReturnCode(1, " is received after merged shuffle is finalized");
        public static final /* enum */ ReturnCode BLOCK_APPEND_COLLISION_DETECTED = new ReturnCode(2, " experienced merge collision on the server side");
        public static final /* enum */ ReturnCode STALE_BLOCK_PUSH = new ReturnCode(3, " is a stale block push from an indeterminate stage retry");
        public static final /* enum */ ReturnCode TOO_OLD_ATTEMPT_PUSH = new ReturnCode(4, " is from an older app attempt");
        private final byte id;
        private final String errorMsgSuffix;
        private static final /* synthetic */ ReturnCode[] $VALUES;

        public static ReturnCode[] values() {
            return (ReturnCode[])$VALUES.clone();
        }

        public static ReturnCode valueOf(String name) {
            return Enum.valueOf(ReturnCode.class, name);
        }

        private ReturnCode(int id, String errorMsgSuffix) {
            assert (id < 128) : "Cannot have more than 128 block push return code";
            this.id = (byte)id;
            this.errorMsgSuffix = errorMsgSuffix;
        }

        public byte id() {
            return this.id;
        }

        private static /* synthetic */ ReturnCode[] $values() {
            return new ReturnCode[]{SUCCESS, TOO_LATE_BLOCK_PUSH, BLOCK_APPEND_COLLISION_DETECTED, STALE_BLOCK_PUSH, TOO_OLD_ATTEMPT_PUSH};
        }

        static {
            $VALUES = ReturnCode.$values();
        }
    }
}

