/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.trergn;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import uk.me.parabola.imgfmt.app.BufferedImgFileWriter;
import uk.me.parabola.imgfmt.app.ImgFile;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.trergn.MapObject;
import uk.me.parabola.imgfmt.app.trergn.Point;
import uk.me.parabola.imgfmt.app.trergn.Polygon;
import uk.me.parabola.imgfmt.app.trergn.Polyline;
import uk.me.parabola.imgfmt.app.trergn.RGNHeader;
import uk.me.parabola.imgfmt.app.trergn.Subdivision;
import uk.me.parabola.imgfmt.fs.ImgChannel;
import uk.me.parabola.log.Logger;

public class RGNFile
extends ImgFile {
    private static final Logger log = Logger.getLogger(RGNFile.class);
    private static final int HEADER_LEN = 125;
    private final RGNHeader header = new RGNHeader();
    private Subdivision currentDivision;
    private int indPointPtrOff;
    private int polylinePtrOff;
    private int polygonPtrOff;
    private final ByteArrayOutputStream extTypePointsData = new ByteArrayOutputStream();
    private final ByteArrayOutputStream extTypeLinesData = new ByteArrayOutputStream();
    private final ByteArrayOutputStream extTypeAreasData = new ByteArrayOutputStream();

    public RGNFile(ImgChannel chan) {
        this.setHeader(this.header);
        this.setWriter(new BufferedImgFileWriter(chan, "RGN"));
        this.position(125L);
    }

    public void write() {
        if (!this.isWritable()) {
            throw new IllegalStateException("File not writable");
        }
        this.header.setDataSize(this.position() - 125);
        if (this.extTypeAreasData.size() > 0) {
            this.header.setExtTypeAreasInfo(this.position(), this.extTypeAreasData.size());
            this.getWriter().put(this.extTypeAreasData.toByteArray());
        }
        if (this.extTypeLinesData.size() > 0) {
            this.header.setExtTypeLinesInfo(this.position(), this.extTypeLinesData.size());
            this.getWriter().put(this.extTypeLinesData.toByteArray());
        }
        if (this.extTypePointsData.size() > 0) {
            this.header.setExtTypePointsInfo(this.position(), this.extTypePointsData.size());
            this.getWriter().put(this.extTypePointsData.toByteArray());
        }
        this.getHeader().writeHeader(this.getWriter());
    }

    public void startDivision(Subdivision sd) {
        sd.setStartRgnPointer(this.position() - 125);
        if (sd.needsIndPointPtr()) {
            this.indPointPtrOff = this.position();
            this.position((long)this.position() + 2L);
        }
        if (sd.needsPolylinePtr()) {
            this.polylinePtrOff = this.position();
            this.position((long)this.position() + 2L);
        }
        if (sd.needsPolygonPtr()) {
            this.polygonPtrOff = this.position();
            this.position((long)this.position() + 2L);
        }
        this.currentDivision = sd;
    }

    public void addMapObject(MapObject item) {
        block7: {
            if (item.hasExtendedType()) {
                try {
                    if (item instanceof Point) {
                        item.write(this.extTypePointsData);
                        break block7;
                    }
                    if (item instanceof Polygon) {
                        item.write(this.extTypeAreasData);
                        break block7;
                    }
                    if (item instanceof Polyline) {
                        item.write(this.extTypeLinesData);
                        break block7;
                    }
                    log.error((Object)("Can't add object of type " + item.getClass()));
                }
                catch (IOException ioe) {
                    log.error((Object)("Error writing extended type object: " + ioe.getMessage()));
                }
            } else {
                item.write(this.getWriter());
            }
        }
    }

    public void setIndPointPtr() {
        if (this.currentDivision.needsIndPointPtr()) {
            long currPos = this.position();
            this.position(this.indPointPtrOff);
            long off = currPos - (long)this.currentDivision.getStartRgnPointer() - 125L;
            if (off > 65535L) {
                throw new IllegalStateException("IndPoint offset too large: " + off);
            }
            this.getWriter().put2u((int)off);
            this.position(currPos);
        }
    }

    public void setPolylinePtr() {
        if (this.currentDivision.needsPolylinePtr()) {
            long currPos = this.position();
            this.position(this.polylinePtrOff);
            long off = currPos - (long)this.currentDivision.getStartRgnPointer() - 125L;
            if (off > 65535L) {
                throw new IllegalStateException("Polyline offset too large: " + off);
            }
            if (log.isDebugEnabled()) {
                log.debug("setting polyline offset to", off);
            }
            this.getWriter().put2u((int)off);
            this.position(currPos);
        }
    }

    public void setPolygonPtr() {
        if (this.currentDivision.needsPolygonPtr()) {
            long currPos = this.position();
            long off = currPos - (long)this.currentDivision.getStartRgnPointer() - 125L;
            log.debug("currpos=", currPos, ", off=", off);
            if (off > 65535L) {
                throw new IllegalStateException("Polygon offset too large: " + off);
            }
            if (log.isDebugEnabled()) {
                log.debug("setting polygon offset to", off, "@", this.polygonPtrOff);
            }
            this.position(this.polygonPtrOff);
            this.getWriter().put2u((int)off);
            this.position(currPos);
        }
    }

    @Override
    public ImgFileWriter getWriter() {
        return super.getWriter();
    }

    public int getExtTypePointsSize() {
        return this.extTypePointsData.size();
    }

    public int getExtTypeLinesSize() {
        return this.extTypeLinesData.size();
    }

    public int getExtTypeAreasSize() {
        return this.extTypeAreasData.size();
    }

    public boolean haveExtendedTypes() {
        return this.extTypeAreasData.size() != 0 || this.extTypeLinesData.size() != 0 || this.extTypePointsData.size() != 0;
    }
}

