/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.mdr;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.mdr.LargeListSorter;
import uk.me.parabola.imgfmt.app.mdr.Mdr10;
import uk.me.parabola.imgfmt.app.mdr.Mdr11Record;
import uk.me.parabola.imgfmt.app.mdr.Mdr12Record;
import uk.me.parabola.imgfmt.app.mdr.Mdr8Record;
import uk.me.parabola.imgfmt.app.mdr.MdrConfig;
import uk.me.parabola.imgfmt.app.mdr.MdrMapSection;
import uk.me.parabola.imgfmt.app.mdr.MdrSection;
import uk.me.parabola.imgfmt.app.srt.Sort;
import uk.me.parabola.imgfmt.app.srt.SortKey;
import uk.me.parabola.imgfmt.app.trergn.Point;

public class Mdr11
extends MdrMapSection {
    private ArrayList<Mdr11Record> pois = new ArrayList();
    private Mdr10 mdr10;

    public Mdr11(MdrConfig config) {
        this.setConfig(config);
    }

    public Mdr11Record addPoi(int mapIndex, Point point, String name, int strOff) {
        Mdr11Record poi = new Mdr11Record();
        poi.setMapIndex(mapIndex);
        poi.setPointIndex(point.getNumber());
        poi.setSubdiv(point.getSubdiv().getNumber());
        poi.setLblOffset(point.getLabel().getOffset());
        poi.setName(name);
        poi.setStrOffset(strOff);
        this.pois.add(poi);
        return poi;
    }

    @Override
    protected void preWriteImpl() {
        this.pois.trimToSize();
        Sort sort = this.getConfig().getSort();
        LargeListSorter<Mdr11Record> sorter = new LargeListSorter<Mdr11Record>(sort){

            @Override
            protected SortKey<Mdr11Record> makeKey(Mdr11Record r, Sort sort, Map<String, byte[]> cache) {
                return sort.createSortKey(r, r.getName(), r.getMapIndex(), cache);
            }
        };
        sorter.sort(this.pois);
        for (Mdr11Record poi : this.pois) {
            this.mdr10.addPoiType(poi);
        }
    }

    @Override
    public void writeSectData(ImgFileWriter writer) {
        int count = 1;
        boolean hasStrings = this.hasFlag(2);
        for (Mdr11Record poi : this.pois) {
            this.addIndexPointer(poi.getMapIndex(), count);
            poi.setRecordNumber(count++);
            this.putMapIndex(writer, poi.getMapIndex());
            writer.put1u(poi.getPointIndex());
            writer.put2u(poi.getSubdiv());
            writer.put3u(poi.getLblOffset());
            if (poi.isCity()) {
                this.putRegionIndex(writer, poi.getRegionIndex());
            } else {
                this.putCityIndex(writer, poi.getCityIndex());
            }
            if (!hasStrings) continue;
            this.putStringOffset(writer, poi.getStrOffset());
        }
    }

    @Override
    public int getItemSize() {
        MdrSection.PointerSizes sizes = this.getSizes();
        int size = sizes.getMapSize() + 6 + sizes.getCitySizeFlagged();
        if (this.hasFlag(2)) {
            size += sizes.getStrOffSize();
        }
        return size;
    }

    @Override
    protected int numberOfItems() {
        return this.pois.size();
    }

    public int getNumberOfPois() {
        return this.getNumberOfItems();
    }

    @Override
    public int getExtraValue() {
        int mdr11flags = 17;
        MdrSection.PointerSizes sizes = this.getSizes();
        int citySize = sizes.getCitySizeFlagged();
        if (citySize > 2) {
            mdr11flags |= citySize - 2 << 2;
        }
        if (this.isForDevice()) {
            if (!this.getConfig().getSort().isMulti()) {
                mdr11flags |= 0x80;
            }
        } else {
            mdr11flags |= 2;
        }
        return mdr11flags;
    }

    public List<Mdr8Record> getIndex() {
        ArrayList<Mdr8Record> list = new ArrayList<Mdr8Record>();
        Sort.SrtCollator collator = (Sort.SrtCollator)this.getConfig().getSort().getCollator();
        for (int number = 1; number <= this.pois.size(); number += 10240) {
            int rec;
            char[] prefix = this.getPrefixForRecord(number);
            for (rec = number; rec > 1; --rec) {
                char[] p = this.getPrefixForRecord(rec);
                int cmp = collator.compareOneStrengthWithLength(prefix, p, 0, 4);
                if (cmp == 0) continue;
                ++rec;
                break;
            }
            list.add(new Mdr12Record(prefix, rec));
        }
        return list;
    }

    private char[] getPrefixForRecord(int number) {
        Mdr11Record record = this.pois.get(number - 1);
        String name = record.getName();
        return this.getConfig().getSort().getPrefix(name, 4);
    }

    public void setMdr10(Mdr10 mdr10) {
        this.mdr10 = mdr10;
    }

    @Override
    public void releaseMemory() {
        this.pois = null;
        this.mdr10 = null;
    }

    public List<Mdr11Record> getPois() {
        return new ArrayList<Mdr11Record>(this.pois);
    }
}

