/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.labelenc;

import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import uk.me.parabola.imgfmt.app.labelenc.CharacterDecoder;
import uk.me.parabola.imgfmt.app.labelenc.DecodedText;

public class Format6Decoder
implements CharacterDecoder {
    private final ByteArrayOutputStream out = new ByteArrayOutputStream();
    private boolean needReset;
    private boolean symbol;
    private boolean lowerCaseOrSeparator;
    private int store;
    private int nbits;

    @Override
    public boolean addByte(int in) {
        int b = 0xFF & in;
        if (this.needReset) {
            this.needReset = false;
            this.out.reset();
        }
        this.store <<= 8;
        this.store |= b;
        this.nbits += 8;
        while (this.nbits >= 6) {
            this.convertChar(this.store >> this.nbits - 6 & 0x3F);
            if (this.needReset) {
                if (this.nbits > 8) {
                    this.nbits = 8;
                    break;
                }
                this.nbits = 0;
                break;
            }
            this.nbits -= 6;
        }
        return this.needReset;
    }

    @Override
    public DecodedText getText() {
        byte[] ba = this.out.toByteArray();
        DecodedText text = new DecodedText(ba, StandardCharsets.US_ASCII);
        assert (this.nbits == 0 || this.nbits == 8);
        if (this.nbits == 8) {
            text.setOffsetAdjustment(-1);
        }
        return text;
    }

    @Override
    public void reset() {
        this.needReset = false;
        this.out.reset();
        this.store = 0;
        this.nbits = 0;
    }

    private void convertChar(int b) {
        char c;
        if (b > 47) {
            this.needReset = true;
            return;
        }
        if (this.symbol) {
            this.symbol = false;
            c = "@!\"#$%&'()*+,-./xxxxxxxxxx:;<=>?xxxxxxxxxxx[\\]^_".charAt(b);
        } else if (this.lowerCaseOrSeparator) {
            this.lowerCaseOrSeparator = false;
            c = b == 43 || b == 44 ? (char)(b - 16) : (Character.isLetter(b) ? Character.toLowerCase(" ABCDEFGHIJKLMNOPQRSTUVWXYZxx   0123456789\u0001\u0002\u0003\u0004\u0005\u0006".charAt(b)) : " ABCDEFGHIJKLMNOPQRSTUVWXYZxx   0123456789\u0001\u0002\u0003\u0004\u0005\u0006".charAt(b));
        } else {
            switch (b) {
                case 27: {
                    this.lowerCaseOrSeparator = true;
                    return;
                }
                case 28: {
                    this.symbol = true;
                    return;
                }
                case 29: 
                case 30: 
                case 31: {
                    c = (char)b;
                    break;
                }
                default: {
                    c = " ABCDEFGHIJKLMNOPQRSTUVWXYZxx   0123456789\u0001\u0002\u0003\u0004\u0005\u0006".charAt(b);
                }
            }
        }
        this.out.write(c);
    }
}

