# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class AddOnFeatures(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Available cluster add-on features
    """

    REPAIR_MANAGER = "RepairManager"
    DNS_SERVICE = "DnsService"
    BACKUP_RESTORE_SERVICE = "BackupRestoreService"
    RESOURCE_MONITOR_SERVICE = "ResourceMonitorService"

class ArmServicePackageActivationMode(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The activation Mode of the service package
    """

    #: Indicates the application package activation mode will use shared process.
    SHARED_PROCESS = "SharedProcess"
    #: Indicates the application package activation mode will use exclusive process.
    EXCLUSIVE_PROCESS = "ExclusiveProcess"

class ArmUpgradeFailureAction(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The activation Mode of the service package
    """

    #: Indicates that a rollback of the upgrade will be performed by Service Fabric if the upgrade
    #: fails.
    ROLLBACK = "Rollback"
    #: Indicates that a manual repair will need to be performed by the administrator if the upgrade
    #: fails. Service Fabric will not proceed to the next upgrade domain automatically.
    MANUAL = "Manual"

class ClusterEnvironment(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Cluster operating system, the default will be Windows
    """

    WINDOWS = "Windows"
    LINUX = "Linux"

class ClusterOsType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Cluster operating system type.
    """

    WINDOWS = "Windows"
    UBUNTU = "Ubuntu"
    RED_HAT = "RedHat"
    UBUNTU18_04 = "Ubuntu18_04"

class ClusterState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The current state of the cluster.
    
    
    * WaitingForNodes - Indicates that the cluster resource is created and the resource provider is
    waiting for Service Fabric VM extension to boot up and report to it.
    * Deploying - Indicates that the Service Fabric runtime is being installed on the VMs. Cluster
    resource will be in this state until the cluster boots up and system services are up.
    * BaselineUpgrade - Indicates that the cluster is upgrading to establishes the cluster version.
    This upgrade is automatically initiated when the cluster boots up for the first time.
    * UpdatingUserConfiguration - Indicates that the cluster is being upgraded with the user
    provided configuration.
    * UpdatingUserCertificate - Indicates that the cluster is being upgraded with the user provided
    certificate.
    * UpdatingInfrastructure - Indicates that the cluster is being upgraded with the latest Service
    Fabric runtime version. This happens only when the **upgradeMode** is set to 'Automatic'.
    * EnforcingClusterVersion - Indicates that cluster is on a different version than expected and
    the cluster is being upgraded to the expected version.
    * UpgradeServiceUnreachable - Indicates that the system service in the cluster is no longer
    polling the Resource Provider. Clusters in this state cannot be managed by the Resource
    Provider.
    * AutoScale - Indicates that the ReliabilityLevel of the cluster is being adjusted.
    * Ready - Indicates that the cluster is in a stable state.
    """

    WAITING_FOR_NODES = "WaitingForNodes"
    DEPLOYING = "Deploying"
    BASELINE_UPGRADE = "BaselineUpgrade"
    UPDATING_USER_CONFIGURATION = "UpdatingUserConfiguration"
    UPDATING_USER_CERTIFICATE = "UpdatingUserCertificate"
    UPDATING_INFRASTRUCTURE = "UpdatingInfrastructure"
    ENFORCING_CLUSTER_VERSION = "EnforcingClusterVersion"
    UPGRADE_SERVICE_UNREACHABLE = "UpgradeServiceUnreachable"
    AUTO_SCALE = "AutoScale"
    READY = "Ready"

class DurabilityLevel(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The durability level of the node type. Learn about `DurabilityLevel
    <https://docs.microsoft.com/azure/service-fabric/service-fabric-cluster-capacity>`_.
    
    
    * Bronze - No privileges. This is the default.
    * Silver - The infrastructure jobs can be paused for a duration of 10 minutes per UD.
    * Gold - The infrastructure jobs can be paused for a duration of 2 hours per UD. Gold
    durability can be enabled only on full node VM skus like D15_V2, G5 etc.
    """

    BRONZE = "Bronze"
    SILVER = "Silver"
    GOLD = "Gold"

class Enum23(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    WINDOWS = "Windows"
    UBUNTU = "Ubuntu"
    RED_HAT = "RedHat"
    UBUNTU18_04 = "Ubuntu18_04"

class Enum8(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    WINDOWS = "Windows"
    LINUX = "Linux"

class ManagedClusterAddOnFeature(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Available cluster add-on features
    """

    DNS_SERVICE = "DnsService"
    BACKUP_RESTORE_SERVICE = "BackupRestoreService"
    RESOURCE_MONITOR_SERVICE = "ResourceMonitorService"

class ManagedIdentityType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of managed identity for the resource.
    """

    #: Indicates that system assigned identity is associated with the resource.
    SYSTEM_ASSIGNED = "SystemAssigned"
    #: Indicates that user assigned identity is associated with the resource.
    USER_ASSIGNED = "UserAssigned"
    #: Indicates that both system assigned and user assigned identity are associated with the
    #: resource.
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned, UserAssigned"
    #: Indicates that no identity is associated with the resource.
    NONE = "None"

class ManagedResourceProvisioningState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The provisioning state of the managed resource.
    """

    NONE = "None"
    CREATING = "Creating"
    CREATED = "Created"
    UPDATING = "Updating"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    DELETING = "Deleting"
    DELETED = "Deleted"
    OTHER = "Other"

class MoveCost(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Specifies the move cost for the service.
    """

    #: Zero move cost. This value is zero.
    ZERO = "Zero"
    #: Specifies the move cost of the service as Low. The value is 1.
    LOW = "Low"
    #: Specifies the move cost of the service as Medium. The value is 2.
    MEDIUM = "Medium"
    #: Specifies the move cost of the service as High. The value is 3.
    HIGH = "High"

class PartitionScheme(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Enumerates the ways that a service can be partitioned.
    """

    #: Indicates the partition kind is invalid. All Service Fabric enumerations have the invalid type.
    #: The value is zero.
    INVALID = "Invalid"
    #: Indicates that the partition is based on string names, and is a
    #: SingletonPartitionSchemeDescription object, The value is 1.
    SINGLETON = "Singleton"
    #: Indicates that the partition is based on Int64 key ranges, and is a
    #: UniformInt64RangePartitionSchemeDescription object. The value is 2.
    UNIFORM_INT64_RANGE = "UniformInt64Range"
    #: Indicates that the partition is based on string names, and is a NamedPartitionSchemeDescription
    #: object. The value is 3.
    NAMED = "Named"

class ProbeProtocol(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """the reference to the load balancer probe used by the load balancing rule.
    """

    TCP = "tcp"
    HTTP = "http"
    HTTPS = "https"

class Protocol(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The reference to the transport protocol used by the load balancing rule.
    """

    TCP = "tcp"
    UDP = "udp"

class ProvisioningState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The provisioning state of the cluster resource.
    """

    UPDATING = "Updating"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"

class ReliabilityLevel(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The reliability level sets the replica set size of system services. Learn about
    `ReliabilityLevel
    <https://docs.microsoft.com/azure/service-fabric/service-fabric-cluster-capacity>`_.
    
    
    * None - Run the System services with a target replica set count of 1. This should only be used
    for test clusters.
    * Bronze - Run the System services with a target replica set count of 3. This should only be
    used for test clusters.
    * Silver - Run the System services with a target replica set count of 5.
    * Gold - Run the System services with a target replica set count of 7.
    * Platinum - Run the System services with a target replica set count of 9.
    """

    NONE = "None"
    BRONZE = "Bronze"
    SILVER = "Silver"
    GOLD = "Gold"
    PLATINUM = "Platinum"

class RollingUpgradeMode(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The mode used to monitor health during a rolling upgrade. The values are UnmonitoredAuto,
    UnmonitoredManual, and Monitored.
    """

    #: Indicates the upgrade mode is invalid. All Service Fabric enumerations have the invalid type.
    #: The value is zero.
    INVALID = "Invalid"
    #: The upgrade will proceed automatically without performing any health monitoring. The value is
    #: 1.
    UNMONITORED_AUTO = "UnmonitoredAuto"
    #: The upgrade will stop after completing each upgrade domain, giving the opportunity to manually
    #: monitor health before proceeding. The value is 2.
    UNMONITORED_MANUAL = "UnmonitoredManual"
    #: The upgrade will stop after completing each upgrade domain and automatically monitor health
    #: before proceeding. The value is 3.
    MONITORED = "Monitored"

class ServiceCorrelationScheme(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The service correlation scheme.
    """

    #: An invalid correlation scheme. Cannot be used. The value is zero.
    INVALID = "Invalid"
    #: Indicates that this service has an affinity relationship with another service. Provided for
    #: backwards compatibility, consider preferring the Aligned or NonAlignedAffinity options. The
    #: value is 1.
    AFFINITY = "Affinity"
    #: Aligned affinity ensures that the primaries of the partitions of the affinitized services are
    #: collocated on the same nodes. This is the default and is the same as selecting the Affinity
    #: scheme. The value is 2.
    ALIGNED_AFFINITY = "AlignedAffinity"
    #: Non-Aligned affinity guarantees that all replicas of each service will be placed on the same
    #: nodes. Unlike Aligned Affinity, this does not guarantee that replicas of particular role will
    #: be collocated. The value is 3.
    NON_ALIGNED_AFFINITY = "NonAlignedAffinity"

class ServiceKind(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The kind of service (Stateless or Stateful).
    """

    #: Indicates the service kind is invalid. All Service Fabric enumerations have the invalid type.
    #: The value is zero.
    INVALID = "Invalid"
    #: Does not use Service Fabric to make its state highly available or reliable. The value is 1.
    STATELESS = "Stateless"
    #: Uses Service Fabric to make its state or part of its state highly available and reliable. The
    #: value is 2.
    STATEFUL = "Stateful"

class ServiceLoadMetricWeight(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Determines the metric weight relative to the other metrics that are configured for this
    service. During runtime, if two metrics end up in conflict, the Cluster Resource Manager
    prefers the metric with the higher weight.
    """

    #: Disables resource balancing for this metric. This value is zero.
    ZERO = "Zero"
    #: Specifies the metric weight of the service load as Low. The value is 1.
    LOW = "Low"
    #: Specifies the metric weight of the service load as Medium. The value is 2.
    MEDIUM = "Medium"
    #: Specifies the metric weight of the service load as High. The value is 3.
    HIGH = "High"

class ServicePlacementPolicyType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of placement policy for a service fabric service. Following are the possible values.
    """

    #: Indicates the type of the placement policy is invalid. All Service Fabric enumerations have the
    #: invalid type. The value is zero.
    INVALID = "Invalid"
    #: Indicates that the ServicePlacementPolicyDescription is of type
    #: ServicePlacementInvalidDomainPolicyDescription, which indicates that a particular fault or
    #: upgrade domain cannot be used for placement of this service. The value is 1.
    INVALID_DOMAIN = "InvalidDomain"
    #: Indicates that the ServicePlacementPolicyDescription is of type
    #: ServicePlacementRequireDomainDistributionPolicyDescription indicating that the replicas of the
    #: service must be placed in a specific domain. The value is 2.
    REQUIRED_DOMAIN = "RequiredDomain"
    #: Indicates that the ServicePlacementPolicyDescription is of type
    #: ServicePlacementPreferPrimaryDomainPolicyDescription, which indicates that if possible the
    #: Primary replica for the partitions of the service should be located in a particular domain as
    #: an optimization. The value is 3.
    PREFERRED_PRIMARY_DOMAIN = "PreferredPrimaryDomain"
    #: Indicates that the ServicePlacementPolicyDescription is of type
    #: ServicePlacementRequireDomainDistributionPolicyDescription, indicating that the system will
    #: disallow placement of any two replicas from the same partition in the same domain at any time.
    #: The value is 4.
    REQUIRED_DOMAIN_DISTRIBUTION = "RequiredDomainDistribution"
    #: Indicates that the ServicePlacementPolicyDescription is of type
    #: ServicePlacementNonPartiallyPlaceServicePolicyDescription, which indicates that if possible all
    #: replicas of a particular partition of the service should be placed atomically. The value is 5.
    NON_PARTIALLY_PLACE_SERVICE = "NonPartiallyPlaceService"

class SkuName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Sku Name. Basic will have a minimum of 3 seed nodes and Standard a minimum of 5. Basic only
    allows 1 node type.
    """

    BASIC = "Basic"
    STANDARD = "Standard"

class StoreName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The local certificate store location.
    """

    ADDRESS_BOOK = "AddressBook"
    AUTH_ROOT = "AuthRoot"
    CERTIFICATE_AUTHORITY = "CertificateAuthority"
    DISALLOWED = "Disallowed"
    MY = "My"
    ROOT = "Root"
    TRUSTED_PEOPLE = "TrustedPeople"
    TRUSTED_PUBLISHER = "TrustedPublisher"

class UpgradeMode(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The upgrade mode of the cluster when new Service Fabric runtime version is available.
    
    
    * Automatic - The cluster will be automatically upgraded to the latest Service Fabric runtime
    version as soon as it is available.
    * Manual - The cluster will not be automatically upgraded to the latest Service Fabric runtime
    version. The cluster is upgraded by setting the **clusterCodeVersion** property in the cluster
    resource.
    """

    AUTOMATIC = "Automatic"
    MANUAL = "Manual"
