/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.splitter.writer;

import crosby.binary.BinarySerializer;
import crosby.binary.Osmformat;
import crosby.binary.StringTable;
import crosby.binary.file.BlockOutputStream;
import crosby.binary.file.FileBlock;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import uk.me.parabola.splitter.Area;
import uk.me.parabola.splitter.Element;
import uk.me.parabola.splitter.Node;
import uk.me.parabola.splitter.Relation;
import uk.me.parabola.splitter.Utils;
import uk.me.parabola.splitter.Version;
import uk.me.parabola.splitter.Way;
import uk.me.parabola.splitter.writer.AbstractOSMWriter;

public class BinaryMapWriter
extends AbstractOSMWriter {
    protected PBFSerializer serializer;
    private BlockOutputStream output;
    protected boolean useDense = true;
    protected boolean headerWritten = false;

    public BinaryMapWriter(Area bounds, File outputDir, int mapId, int extra) {
        super(bounds, outputDir, mapId, extra);
    }

    @Override
    public void initForWrite() {
        String filename = String.format(Locale.ROOT, "%08d.osm.pbf", this.mapId);
        try {
            this.output = new BlockOutputStream(new FileOutputStream(new File(this.outputDir, filename)));
            this.serializer = new PBFSerializer(this.output);
            this.writeHeader();
        }
        catch (IOException e) {
            System.out.println("Could not open or write file header. Reason: " + e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private void writeHeader() {
        Osmformat.HeaderBlock.Builder headerblock = Osmformat.HeaderBlock.newBuilder();
        Osmformat.HeaderBBox.Builder pbfBbox = Osmformat.HeaderBBox.newBuilder();
        pbfBbox.setLeft(this.serializer.mapRawDegrees(Utils.toDegrees(this.bounds.getMinLong())));
        pbfBbox.setBottom(this.serializer.mapRawDegrees(Utils.toDegrees(this.bounds.getMinLat())));
        pbfBbox.setRight(this.serializer.mapRawDegrees(Utils.toDegrees(this.bounds.getMaxLong())));
        pbfBbox.setTop(this.serializer.mapRawDegrees(Utils.toDegrees(this.bounds.getMaxLat())));
        headerblock.setBbox(pbfBbox);
        this.finishHeader(headerblock);
    }

    public void finishHeader(Osmformat.HeaderBlock.Builder headerblock) {
        headerblock.setWritingprogram("splitter-r" + Version.VERSION);
        headerblock.addRequiredFeatures("OsmSchema-V0.6");
        if (this.useDense) {
            headerblock.addRequiredFeatures("DenseNodes");
        }
        Osmformat.HeaderBlock message = headerblock.build();
        try {
            this.output.write(FileBlock.newInstance("OSMHeader", message.toByteString(), null));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write OSM header.", e);
        }
        this.headerWritten = true;
    }

    @Override
    public void finishWrite() {
        try {
            this.serializer.switchTypes();
            this.serializer.processBatch();
            this.serializer.close();
            this.serializer = null;
        }
        catch (IOException e) {
            System.out.println("Could not write end of file: " + e);
        }
    }

    @Override
    public void write(Node node) {
        this.serializer.processor.process(node);
    }

    @Override
    public void write(Way way) {
        this.serializer.processor.process(way);
    }

    @Override
    public void write(Relation relation) {
        this.serializer.processor.process(relation);
    }

    private class PBFSerializer
    extends BinarySerializer {
        protected WayGroup ways;
        protected NodeGroup nodes;
        protected RelationGroup relations;
        protected Processor processor;

        public PBFSerializer(BlockOutputStream output) {
            super(output);
            this.processor = new Processor();
            this.configBatchLimit(1000);
        }

        protected void switchTypes() {
            if (this.nodes != null) {
                this.groups.add(this.nodes);
                this.nodes = null;
            } else if (this.ways != null) {
                this.groups.add(this.ways);
                this.ways = null;
            } else if (this.relations != null) {
                this.groups.add(this.relations);
                this.relations = null;
            }
        }

        public void writeEmptyHeaderIfNeeded() {
            if (BinaryMapWriter.this.headerWritten) {
                return;
            }
            Osmformat.HeaderBlock.Builder headerblock = Osmformat.HeaderBlock.newBuilder();
            BinaryMapWriter.this.finishHeader(headerblock);
        }

        public class Processor {
            public void checkLimit() {
                PBFSerializer.this.total_entities++;
                if (++PBFSerializer.this.batch_size < PBFSerializer.this.batch_limit) {
                    return;
                }
                PBFSerializer.this.switchTypes();
                PBFSerializer.this.processBatch();
            }

            public void process(Node node) {
                if (PBFSerializer.this.nodes == null) {
                    PBFSerializer.this.writeEmptyHeaderIfNeeded();
                    PBFSerializer.this.switchTypes();
                    PBFSerializer.this.nodes = new NodeGroup();
                }
                PBFSerializer.this.nodes.add(node);
                this.checkLimit();
            }

            public void process(Way way) {
                if (PBFSerializer.this.ways == null) {
                    PBFSerializer.this.writeEmptyHeaderIfNeeded();
                    PBFSerializer.this.switchTypes();
                    PBFSerializer.this.ways = new WayGroup();
                }
                PBFSerializer.this.ways.add(way);
                this.checkLimit();
            }

            public void process(Relation relation) {
                if (PBFSerializer.this.relations == null) {
                    PBFSerializer.this.writeEmptyHeaderIfNeeded();
                    PBFSerializer.this.switchTypes();
                    PBFSerializer.this.relations = new RelationGroup();
                }
                PBFSerializer.this.relations.add(relation);
                this.checkLimit();
            }
        }

        private class RelationGroup
        extends Prim<Relation>
        implements BinarySerializer.PrimGroupWriterInterface {
            private RelationGroup() {
            }

            @Override
            public void addStringsToStringtable() {
                StringTable stable = BinaryMapWriter.this.serializer.getStringTable();
                super.addStringsToStringtable();
                for (Relation i : this.contents) {
                    for (Relation.Member j : i.getMembers()) {
                        stable.incr(j.getRole());
                    }
                }
            }

            @Override
            public Osmformat.PrimitiveGroup serialize() {
                if (this.contents.isEmpty()) {
                    return null;
                }
                StringTable stable = BinaryMapWriter.this.serializer.getStringTable();
                Osmformat.PrimitiveGroup.Builder builder = Osmformat.PrimitiveGroup.newBuilder();
                for (Relation i : this.contents) {
                    Osmformat.Relation.Builder bi = Osmformat.Relation.newBuilder();
                    bi.setId(i.getId());
                    Relation.Member[] arr = new Relation.Member[i.getMembers().size()];
                    i.getMembers().toArray(arr);
                    long lastid = 0L;
                    for (Relation.Member j : i.getMembers()) {
                        long id = j.getRef();
                        bi.addMemids(id - lastid);
                        lastid = id;
                        if ("node".equals(j.getType())) {
                            bi.addTypes(Osmformat.Relation.MemberType.NODE);
                        } else if ("way".equals(j.getType())) {
                            bi.addTypes(Osmformat.Relation.MemberType.WAY);
                        } else if ("relation".equals(j.getType())) {
                            bi.addTypes(Osmformat.Relation.MemberType.RELATION);
                        } else assert (false);
                        bi.addRolesSid(stable.getIndex(j.getRole()));
                    }
                    Iterator<Element.Tag> tags = i.tagsIterator();
                    while (tags.hasNext()) {
                        Element.Tag t = tags.next();
                        bi.addKeys(stable.getIndex(t.getKey()));
                        bi.addVals(stable.getIndex(t.getValue()));
                    }
                    if (!PBFSerializer.this.omit_metadata) {
                        bi.setInfo(this.serializeMetadata(i));
                    }
                    builder.addRelations(bi);
                }
                return builder.build();
            }
        }

        private class WayGroup
        extends Prim<Way>
        implements BinarySerializer.PrimGroupWriterInterface {
            private WayGroup() {
            }

            @Override
            public Osmformat.PrimitiveGroup serialize() {
                if (this.contents.isEmpty()) {
                    return null;
                }
                StringTable stable = BinaryMapWriter.this.serializer.getStringTable();
                Osmformat.PrimitiveGroup.Builder builder = Osmformat.PrimitiveGroup.newBuilder();
                for (Way i : this.contents) {
                    Osmformat.Way.Builder bi = Osmformat.Way.newBuilder();
                    bi.setId(i.getId());
                    long lastid = 0L;
                    LongListIterator longListIterator = i.getRefs().iterator();
                    while (longListIterator.hasNext()) {
                        long j;
                        long id = j = ((Long)longListIterator.next()).longValue();
                        bi.addRefs(id - lastid);
                        lastid = id;
                    }
                    Iterator<Element.Tag> tags = i.tagsIterator();
                    while (tags.hasNext()) {
                        Element.Tag t = tags.next();
                        bi.addKeys(stable.getIndex(t.getKey()));
                        bi.addVals(stable.getIndex(t.getValue()));
                    }
                    if (!PBFSerializer.this.omit_metadata) {
                        bi.setInfo(this.serializeMetadata(i));
                    }
                    builder.addWays(bi);
                }
                return builder.build();
            }
        }

        private class NodeGroup
        extends Prim<Node>
        implements BinarySerializer.PrimGroupWriterInterface {
            private NodeGroup() {
            }

            @Override
            public Osmformat.PrimitiveGroup serialize() {
                if (BinaryMapWriter.this.useDense) {
                    return this.serializeDense();
                }
                return this.serializeNonDense();
            }

            public Osmformat.PrimitiveGroup serializeDense() {
                if (this.contents.isEmpty()) {
                    return null;
                }
                Osmformat.PrimitiveGroup.Builder builder = Osmformat.PrimitiveGroup.newBuilder();
                StringTable stable = BinaryMapWriter.this.serializer.getStringTable();
                long lastlat = 0L;
                long lastlon = 0L;
                long lastid = 0L;
                Osmformat.DenseNodes.Builder bi = Osmformat.DenseNodes.newBuilder();
                boolean doesBlockHaveTags = false;
                for (Node i : this.contents) {
                    doesBlockHaveTags = doesBlockHaveTags || i.tagsIterator().hasNext();
                }
                if (!PBFSerializer.this.omit_metadata) {
                    Osmformat.DenseInfo.Builder bdi = Osmformat.DenseInfo.newBuilder();
                    this.serializeMetadataDense(bdi, this.contents);
                    bi.setDenseinfo(bdi);
                }
                for (Node i : this.contents) {
                    long id = i.getId();
                    int lat = PBFSerializer.this.mapDegrees(i.getLat());
                    int lon = PBFSerializer.this.mapDegrees(i.getLon());
                    bi.addId(id - lastid);
                    lastid = id;
                    bi.addLon((long)lon - lastlon);
                    lastlon = lon;
                    bi.addLat((long)lat - lastlat);
                    lastlat = lat;
                    if (!doesBlockHaveTags) continue;
                    Iterator<Element.Tag> tags = i.tagsIterator();
                    while (tags.hasNext()) {
                        Element.Tag t = tags.next();
                        bi.addKeysVals(stable.getIndex(t.getKey()));
                        bi.addKeysVals(stable.getIndex(t.getValue()));
                    }
                    bi.addKeysVals(0);
                }
                builder.setDense(bi);
                return builder.build();
            }

            public Osmformat.PrimitiveGroup serializeNonDense() {
                if (this.contents.isEmpty()) {
                    return null;
                }
                StringTable stable = BinaryMapWriter.this.serializer.getStringTable();
                Osmformat.PrimitiveGroup.Builder builder = Osmformat.PrimitiveGroup.newBuilder();
                for (Node i : this.contents) {
                    long id = i.getId();
                    int lat = PBFSerializer.this.mapDegrees(i.getLat());
                    int lon = PBFSerializer.this.mapDegrees(i.getLon());
                    Osmformat.Node.Builder bi = Osmformat.Node.newBuilder();
                    bi.setId(id);
                    bi.setLon(lon);
                    bi.setLat(lat);
                    Iterator<Element.Tag> tags = i.tagsIterator();
                    while (tags.hasNext()) {
                        Element.Tag t = tags.next();
                        bi.addKeys(stable.getIndex(t.getKey()));
                        bi.addVals(stable.getIndex(t.getValue()));
                    }
                    if (!PBFSerializer.this.omit_metadata) {
                        bi.setInfo(this.serializeMetadata(i));
                    }
                    builder.addNodes(bi);
                }
                return builder.build();
            }
        }

        private abstract class Prim<T extends Element> {
            ArrayList<T> contents = new ArrayList();

            private Prim() {
            }

            public void add(T item) {
                this.contents.add(item);
            }

            public void addStringsToStringtable() {
                StringTable stable = PBFSerializer.this.getStringTable();
                for (Element i : this.contents) {
                    Iterator<Element.Tag> tags = i.tagsIterator();
                    while (tags.hasNext()) {
                        Element.Tag tag = tags.next();
                        stable.incr(tag.getKey());
                        stable.incr(tag.getValue());
                    }
                    if (PBFSerializer.this.omit_metadata) continue;
                }
            }

            public void serializeMetadataDense(Osmformat.DenseInfo.Builder b, List<? extends Element> entities) {
                if (PBFSerializer.this.omit_metadata) {
                    return;
                }
                for (Element element : entities) {
                    int version = BinaryMapWriter.this.getWriteVersion(element);
                    if (BinaryMapWriter.this.versionMethod != 3 || version == 0) {
                        version = 1;
                    }
                    b.addVersion(version);
                    b.addTimestamp(0L);
                    b.addChangeset(0L);
                    b.addUid(0);
                    b.addUserSid(0);
                }
            }

            public Osmformat.Info.Builder serializeMetadata(Element e) {
                int version;
                Osmformat.Info.Builder b = Osmformat.Info.newBuilder();
                if (BinaryMapWriter.this.versionMethod != 1 && (version = BinaryMapWriter.this.getWriteVersion(e)) != 0) {
                    b.setVersion(version);
                    b.setTimestamp(0L);
                    b.setChangeset(0L);
                    b.setUid(0);
                    b.setUserSid(0);
                }
                return b;
            }
        }
    }
}

