/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.splitter.solver;

import java.util.Arrays;
import uk.me.parabola.splitter.solver.Tile;

class TileMetaInfo {
    private long minNodes;
    private final long[] rowSums;
    private final long[] colSums;
    private final Tile[] parts = new Tile[2];
    private int validStartX = -1;
    private int validStartY = -1;
    private int firstNonZeroX = -1;
    private int firstNonZeroY = -1;
    private int lastNonZeroX = -1;
    private int lastNonZeroY = -1;
    private long vertMidSum = -1L;
    private long horMidSum = -1L;
    private int vertMidPos = -1;
    private int horMidPos = -1;
    private int validEndX = -1;
    private int validEndY = -1;
    private int numOutside = -1;

    public TileMetaInfo(Tile tile, Tile parent, TileMetaInfo smiParent) {
        int srcPos;
        this.rowSums = new long[tile.height];
        this.colSums = new long[tile.width];
        if (parent != null && parent.width == tile.width) {
            srcPos = tile.y - parent.y;
            System.arraycopy(smiParent.rowSums, srcPos, this.rowSums, 0, this.rowSums.length);
            if (srcPos == 0) {
                this.firstNonZeroY = smiParent.firstNonZeroY;
            }
        } else {
            Arrays.fill(this.rowSums, -1L);
        }
        if (parent != null && parent.height == tile.height) {
            srcPos = tile.x - parent.x;
            System.arraycopy(smiParent.colSums, srcPos, this.colSums, 0, this.colSums.length);
            if (srcPos == 0) {
                this.firstNonZeroX = smiParent.firstNonZeroX;
            }
        } else {
            Arrays.fill(this.colSums, -1L);
        }
        if (smiParent != null) {
            this.minNodes = smiParent.minNodes;
            if (smiParent.getNumOutside() == 0) {
                this.numOutside = 0;
            }
        }
        if (this.numOutside < 0) {
            this.numOutside = tile.countElemsOutside();
        }
    }

    public void setMinNodes(long minNodes) {
        if (this.minNodes == minNodes) {
            return;
        }
        this.minNodes = minNodes;
        this.validStartX = -1;
        this.validStartY = -1;
        this.validEndX = -1;
        this.validEndY = -1;
    }

    public int getValidStartX() {
        return this.validStartX;
    }

    public void setValidStartX(int validStartX) {
        this.validStartX = validStartX;
    }

    public int getValidStartY() {
        return this.validStartY;
    }

    public void setValidStartY(int validStartY) {
        this.validStartY = validStartY;
    }

    public int getFirstNonZeroX() {
        return this.firstNonZeroX;
    }

    public void setFirstNonZeroX(int firstNonZeroX) {
        this.firstNonZeroX = firstNonZeroX;
    }

    public int getFirstNonZeroY() {
        return this.firstNonZeroY;
    }

    public void setFirstNonZeroY(int firstNonZeroY) {
        this.firstNonZeroY = firstNonZeroY;
    }

    public int getLastNonZeroX() {
        return this.lastNonZeroX;
    }

    public void setLastNonZeroX(int lastNonZeroX) {
        this.lastNonZeroX = lastNonZeroX;
    }

    public int getLastNonZeroY() {
        return this.lastNonZeroY;
    }

    public void setLastNonZeroY(int lastNonZeroY) {
        this.lastNonZeroY = lastNonZeroY;
    }

    public long getVertMidSum() {
        return this.vertMidSum;
    }

    public void setVertMidSum(long vertMidSum) {
        this.vertMidSum = vertMidSum;
    }

    public long getHorMidSum() {
        return this.horMidSum;
    }

    public void setHorMidSum(long horMidSum) {
        this.horMidSum = horMidSum;
    }

    public int getVertMidPos() {
        return this.vertMidPos;
    }

    public void setVertMidPos(int vertMidPos) {
        this.vertMidPos = vertMidPos;
    }

    public int getHorMidPos() {
        return this.horMidPos;
    }

    public void setHorMidPos(int horMidPos) {
        this.horMidPos = horMidPos;
    }

    public long getMinNodes() {
        return this.minNodes;
    }

    public long[] getRowSums() {
        return this.rowSums;
    }

    public long[] getColSums() {
        return this.colSums;
    }

    public Tile[] getParts() {
        return this.parts;
    }

    public int getValidEndX() {
        return this.validEndX;
    }

    public void setValidEndX(int pos) {
        this.validEndX = pos;
    }

    public int getValidEndY() {
        return this.validEndY;
    }

    public void setValidEndY(int pos) {
        this.validEndY = pos;
    }

    public int getNumOutside() {
        return this.numOutside;
    }

    public void setNumOutside(int numOutside) {
        this.numOutside = numOutside;
    }

    void propagateToParent(TileMetaInfo smiParent, Tile tile, Tile parent) {
        int destPos;
        if (parent.width == tile.width) {
            destPos = tile.y - parent.y;
            System.arraycopy(this.rowSums, 0, smiParent.rowSums, destPos, this.rowSums.length);
            if (destPos == 0) {
                if (smiParent.firstNonZeroY < 0 && this.firstNonZeroY >= 0) {
                    smiParent.firstNonZeroY = this.firstNonZeroY;
                }
                if (smiParent.validStartY < 0 && this.validStartY >= 0) {
                    smiParent.validStartY = this.validStartY;
                }
            } else {
                if (smiParent.lastNonZeroY < 0 && this.lastNonZeroY >= 0) {
                    smiParent.lastNonZeroY = destPos + this.lastNonZeroY;
                    assert (smiParent.lastNonZeroY <= parent.height);
                }
                if (smiParent.validEndY < 0 && this.validEndY >= 0) {
                    smiParent.validEndY = destPos + this.validEndY;
                    assert (smiParent.validEndY <= parent.height);
                }
            }
        }
        if (parent.height == tile.height) {
            destPos = tile.x - parent.x;
            System.arraycopy(this.colSums, 0, smiParent.colSums, destPos, this.colSums.length);
            if (destPos == 0) {
                if (smiParent.firstNonZeroX < 0 && this.firstNonZeroX >= 0) {
                    smiParent.firstNonZeroX = this.firstNonZeroX;
                }
                if (smiParent.validStartX < 0 && this.validStartX >= 0) {
                    smiParent.validStartX = this.validStartX;
                }
            } else {
                if (smiParent.lastNonZeroX < 0 && this.lastNonZeroX >= 0) {
                    smiParent.lastNonZeroX = destPos + this.lastNonZeroX;
                    assert (parent.getColSum(smiParent.lastNonZeroX) > 0L);
                }
                if (smiParent.validEndX < 0 && this.validEndX >= 0) {
                    smiParent.validEndX = destPos + this.validEndX;
                    assert (smiParent.validEndX <= parent.width);
                }
            }
        }
    }

    boolean verify(Tile tile) {
        int i;
        int i2;
        if (this.firstNonZeroX >= 0) {
            assert (tile.getColSum(this.firstNonZeroX) > 0L);
            for (i2 = 0; i2 < this.firstNonZeroX; ++i2) {
                assert (tile.getColSum(i2) == 0L);
            }
        }
        if (this.lastNonZeroX >= 0) {
            assert (tile.getColSum(this.lastNonZeroX) > 0L);
            for (i2 = this.lastNonZeroX + 1; i2 < tile.width; ++i2) {
                assert (tile.getColSum(i2) == 0L);
            }
        }
        if (this.validEndX >= 0) {
            long sum = 0L;
            for (i = this.validEndX; i < tile.width; ++i) {
                sum += tile.getColSum(i);
            }
            assert (sum >= this.minNodes);
            assert (sum - tile.getColSum(this.validEndX) < this.minNodes);
        }
        if (this.validStartX >= 0) {
            long sum = 0L;
            for (i = 0; i < this.validStartX; ++i) {
                sum += tile.getColSum(i);
            }
            assert (sum < this.minNodes);
            assert (sum + tile.getColSum(this.validStartX) >= this.minNodes);
        }
        if (this.firstNonZeroY >= 0) {
            assert (tile.getRowSum(this.firstNonZeroY) > 0L);
            for (int i3 = 0; i3 < this.firstNonZeroY; ++i3) {
                assert (tile.getRowSum(i3) == 0L);
            }
        }
        if (this.lastNonZeroY >= 0) {
            assert (tile.getRowSum(this.lastNonZeroY) > 0L);
            for (int i4 = this.lastNonZeroY + 1; i4 < tile.height; ++i4) {
                assert (tile.getRowSum(i4) == 0L);
            }
        }
        if (this.validStartY >= 0) {
            long sum = 0L;
            for (i = 0; i < this.validStartY; ++i) {
                sum += tile.getRowSum(i);
            }
            assert (sum < this.minNodes);
            assert (sum + tile.getRowSum(this.validStartY) >= this.minNodes);
        }
        if (this.validEndY >= 0) {
            long sum = 0L;
            for (i = this.validEndY; i < tile.height; ++i) {
                sum += tile.getRowSum(i);
            }
            assert (sum >= this.minNodes);
            assert (sum - tile.getRowSum(this.validEndY) < this.minNodes);
        }
        return false;
    }
}

