/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.splitter.parser;

import crosby.binary.BinaryParser;
import crosby.binary.Osmformat;
import crosby.binary.file.FileBlockPosition;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import java.util.List;
import uk.me.parabola.splitter.Area;
import uk.me.parabola.splitter.MapProcessor;
import uk.me.parabola.splitter.Node;
import uk.me.parabola.splitter.Relation;
import uk.me.parabola.splitter.UnknownFeatureException;
import uk.me.parabola.splitter.Utils;
import uk.me.parabola.splitter.Way;
import uk.me.parabola.splitter.parser.ElementCounter;

public class BinaryMapParser
extends BinaryParser {
    private static final short TYPE_DENSE = 1;
    private static final short TYPE_NODES = 2;
    private static final short TYPE_WAYS = 4;
    private static final short TYPE_RELS = 8;
    private final ShortArrayList blockTypes = new ShortArrayList();
    private final ShortArrayList knownBlockTypes;
    private final ElementCounter elemCounter = new ElementCounter();
    private short blockType = (short)-1;
    private int blockCount = -1;
    private boolean skipTags;
    private boolean skipNodes;
    private boolean skipWays;
    private boolean skipRels;
    private short wantedTypeMask = 0;
    private int msgLevel;
    MapProcessor processor;

    public BinaryMapParser(MapProcessor processor, ShortArrayList knownBlockTypes, int msgLevel) {
        this.processor = processor;
        this.knownBlockTypes = knownBlockTypes;
        this.skipTags = processor.skipTags();
        this.skipNodes = processor.skipNodes();
        this.skipWays = processor.skipWays();
        this.skipRels = processor.skipRels();
        this.msgLevel = msgLevel;
        if (!this.skipNodes) {
            this.wantedTypeMask = (short)(this.wantedTypeMask | 1);
            this.wantedTypeMask = (short)(this.wantedTypeMask | 2);
        }
        if (!this.skipWays) {
            this.wantedTypeMask = (short)(this.wantedTypeMask | 4);
        }
        if (!this.skipRels) {
            this.wantedTypeMask = (short)(this.wantedTypeMask | 8);
        }
    }

    public ShortArrayList getBlockList() {
        return this.blockTypes;
    }

    @Override
    public boolean skipBlock(FileBlockPosition block) {
        ++this.blockCount;
        if (this.knownBlockTypes != null) {
            this.blockType = this.knownBlockTypes.getShort(this.blockCount);
            if (this.blockType != 0 && (this.blockType & this.wantedTypeMask) == 0) {
                return true;
            }
        } else if (this.blockType != -1) {
            this.blockTypes.add(this.blockType);
        }
        this.blockType = 0;
        if (block.getType().equals("OSMData")) {
            return false;
        }
        if (block.getType().equals("OSMHeader")) {
            return false;
        }
        System.out.println("Skipped block of type: " + block.getType());
        return true;
    }

    @Override
    public void complete() {
        this.blockTypes.add(this.blockType);
    }

    @Override
    protected void parseDense(Osmformat.DenseNodes nodes) {
        this.blockType = (short)(this.blockType | 1);
        if (this.skipNodes) {
            return;
        }
        long lastId = 0L;
        long lastLat = 0L;
        long lastLon = 0L;
        int j = 0;
        int maxi = nodes.getIdCount();
        for (int i = 0; i < maxi; ++i) {
            long id;
            long lon;
            long lat;
            lastLat = lat = nodes.getLat(i) + lastLat;
            lastLon = lon = nodes.getLon(i) + lastLon;
            lastId = id = nodes.getId(i) + lastId;
            double latf = this.parseLat(lat);
            double lonf = this.parseLon(lon);
            Node tmp = new Node();
            tmp.set(id, latf, lonf);
            if (nodes.hasDenseinfo()) {
                tmp.setVersion(nodes.getDenseinfo().getVersion(i));
            }
            if (!this.skipTags && nodes.getKeysValsCount() > 0) {
                while (nodes.getKeysVals(j) != 0) {
                    int keyid = nodes.getKeysVals(j++);
                    int valid = nodes.getKeysVals(j++);
                    tmp.addTag(this.getStringById(keyid), this.getStringById(valid));
                }
                ++j;
            }
            this.processor.processNode(tmp);
            this.elemCounter.countNode(tmp.getId());
        }
    }

    @Override
    protected void parseNodes(List<Osmformat.Node> nodes) {
        if (nodes.isEmpty()) {
            return;
        }
        this.blockType = (short)(this.blockType | 2);
        if (this.skipNodes) {
            return;
        }
        for (Osmformat.Node i : nodes) {
            Node tmp = new Node();
            for (int j = 0; j < i.getKeysCount(); ++j) {
                tmp.addTag(this.getStringById(i.getKeys(j)), this.getStringById(i.getVals(j)));
            }
            long id = i.getId();
            double latf = this.parseLat(i.getLat());
            double lonf = this.parseLon(i.getLon());
            tmp.set(id, latf, lonf);
            if (i.hasInfo()) {
                tmp.setVersion(i.getInfo().getVersion());
            }
            this.processor.processNode(tmp);
            this.elemCounter.countNode(tmp.getId());
        }
    }

    @Override
    protected void parseWays(List<Osmformat.Way> ways) {
        long numways = ways.size();
        if (numways == 0L) {
            return;
        }
        this.blockType = (short)(this.blockType | 4);
        if (this.skipWays) {
            return;
        }
        for (Osmformat.Way i : ways) {
            Way tmp = new Way();
            if (!this.skipTags) {
                for (int j = 0; j < i.getKeysCount(); ++j) {
                    tmp.addTag(this.getStringById(i.getKeys(j)), this.getStringById(i.getVals(j)));
                }
            }
            long lastId = 0L;
            for (long j : i.getRefsList()) {
                tmp.addRef(j + lastId);
                lastId = j + lastId;
            }
            long id = i.getId();
            tmp.setId(id);
            if (i.hasInfo()) {
                tmp.setVersion(i.getInfo().getVersion());
            }
            this.processor.processWay(tmp);
            this.elemCounter.countWay(i.getId());
        }
    }

    @Override
    protected void parseRelations(List<Osmformat.Relation> rels) {
        if (rels.isEmpty()) {
            return;
        }
        this.blockType = (short)(this.blockType | 8);
        if (this.skipRels) {
            return;
        }
        for (Osmformat.Relation i : rels) {
            Relation tmp = new Relation();
            if (!this.skipTags) {
                for (int j = 0; j < i.getKeysCount(); ++j) {
                    tmp.addTag(this.getStringById(i.getKeys(j)), this.getStringById(i.getVals(j)));
                }
            }
            long id = i.getId();
            tmp.setId(id);
            tmp.setVersion(i.getInfo().getVersion());
            long lastMemId = 0L;
            for (int j = 0; j < i.getMemidsCount(); ++j) {
                long mid;
                lastMemId = mid = lastMemId + i.getMemids(j);
                String role = this.getStringById(i.getRolesSid(j));
                String etype = null;
                if (i.getTypes(j) == Osmformat.Relation.MemberType.NODE) {
                    etype = "node";
                } else if (i.getTypes(j) == Osmformat.Relation.MemberType.WAY) {
                    etype = "way";
                } else if (i.getTypes(j) == Osmformat.Relation.MemberType.RELATION) {
                    etype = "relation";
                } else assert (false);
                tmp.addMember(etype, mid, role);
            }
            this.processor.processRelation(tmp);
            this.elemCounter.countRelation(tmp.getId());
        }
    }

    @Override
    public void parse(Osmformat.HeaderBlock block) {
        for (String s : block.getRequiredFeaturesList()) {
            if (s.equals("OsmSchema-V0.6") || s.equals("DenseNodes")) continue;
            throw new UnknownFeatureException(s);
        }
        if (block.hasBbox()) {
            Area area;
            double multiplier = 1.0E-9;
            double rightf = (double)block.getBbox().getRight() * 1.0E-9;
            double leftf = (double)block.getBbox().getLeft() * 1.0E-9;
            double topf = (double)block.getBbox().getTop() * 1.0E-9;
            double bottomf = (double)block.getBbox().getBottom() * 1.0E-9;
            if (this.msgLevel > 0) {
                System.out.println("Bounding box " + leftf + " " + bottomf + " " + rightf + " " + topf);
            }
            if (!(area = new Area(Utils.toMapUnit(bottomf), Utils.toMapUnit(leftf), Utils.toMapUnit(topf), Utils.toMapUnit(rightf))).verify()) {
                throw new IllegalArgumentException("invalid bbox area in pbf file: " + area);
            }
            this.processor.boundTag(area);
        }
    }
}

