/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.splitter;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import uk.me.parabola.splitter.Node;
import uk.me.parabola.splitter.Utils;

public class Area {
    public static final Area EMPTY = new Area();
    private int mapId;
    private String name;
    private final int minLat;
    private final int minLong;
    private final int maxLat;
    private final int maxLong;
    private Rectangle javaRect;
    private boolean isJoinable = true;
    private boolean isPseudoArea;

    public boolean isJoinable() {
        return this.isJoinable;
    }

    public void setJoinable(boolean isJoinable) {
        this.isJoinable = isJoinable;
    }

    public Area(int minLat, int minLong, int maxLat, int maxLong) {
        this.minLat = minLat;
        this.maxLat = maxLat == minLat ? minLat + 1 : maxLat;
        this.minLong = minLong;
        this.maxLong = minLong == maxLong ? maxLong + 1 : maxLong;
    }

    public static Area calcArea(Area area, Rectangle bbox) {
        Rectangle dest = new Rectangle();
        Rectangle2D.intersect(area.getRect(), bbox, dest);
        if (dest.getHeight() > 0.0 && dest.getWidth() > 0.0) {
            return new Area(dest.y, dest.x, dest.y + dest.height, dest.x + dest.width);
        }
        return null;
    }

    private Area() {
        this.minLat = 0;
        this.maxLat = 0;
        this.minLong = 0;
        this.maxLong = 0;
    }

    public boolean verify() {
        return this.minLat <= this.maxLat && this.minLong <= this.maxLong && this.minLong >= Utils.MIN_LON_MAP_UNITS && this.maxLong <= Utils.MAX_LON_MAP_UNITS && this.minLat >= Utils.MIN_LAT_MAP_UNITS && this.maxLat <= Utils.MAX_LAT_MAP_UNITS;
    }

    public Rectangle getRect() {
        if (this.javaRect == null) {
            this.javaRect = new Rectangle(this.minLong, this.minLat, this.maxLong - this.minLong, this.maxLat - this.minLat);
        }
        return this.javaRect;
    }

    public java.awt.geom.Area getJavaArea() {
        return new java.awt.geom.Area(this.getRect());
    }

    public void setMapId(int mapId) {
        this.mapId = mapId;
    }

    public int getMapId() {
        return this.mapId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getMinLat() {
        return this.minLat;
    }

    public int getMinLong() {
        return this.minLong;
    }

    public int getMaxLat() {
        return this.maxLat;
    }

    public int getMaxLong() {
        return this.maxLong;
    }

    public int getWidth() {
        return this.maxLong - this.minLong;
    }

    public int getHeight() {
        return this.maxLat - this.minLat;
    }

    public String toString() {
        return "(" + Utils.toDegrees(this.minLat) + ',' + Utils.toDegrees(this.minLong) + ") to (" + Utils.toDegrees(this.maxLat) + ',' + Utils.toDegrees(this.maxLong) + ')';
    }

    public String toHexString() {
        return "(0x" + Integer.toHexString(this.minLat) + ",0x" + Integer.toHexString(this.minLong) + ") to (0x" + Integer.toHexString(this.maxLat) + ",0x" + Integer.toHexString(this.maxLong) + ')';
    }

    public boolean contains(int lat, int lon) {
        return lat >= this.minLat && lat <= this.maxLat && lon >= this.minLong && lon <= this.maxLong;
    }

    public boolean contains(Node node) {
        return this.contains(node.getMapLat(), node.getMapLon());
    }

    public final boolean contains(Area other) {
        return other.getMinLat() >= this.minLat && other.getMaxLat() <= this.maxLat && other.getMinLong() >= this.minLong && other.getMaxLong() <= this.maxLong;
    }

    public final boolean intersects(Area bbox) {
        return this.minLat <= bbox.getMaxLat() && this.maxLat >= bbox.getMinLat() && this.minLong <= bbox.getMaxLong() && this.maxLong >= bbox.getMinLong();
    }

    public final boolean overlaps(Area bbox) {
        return this.minLat < bbox.getMaxLat() && this.maxLat > bbox.getMinLat() && this.minLong < bbox.getMaxLong() && this.maxLong > bbox.getMinLong();
    }

    public Area add(Area area) {
        return new Area(Math.min(this.minLat, area.minLat), Math.min(this.minLong, area.minLong), Math.max(this.maxLat, area.maxLat), Math.max(this.maxLong, area.maxLong));
    }

    public boolean isPseudoArea() {
        return this.isPseudoArea;
    }

    public void setPseudoArea(boolean isPseudoArea) {
        this.isPseudoArea = isPseudoArea;
    }
}

