/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.main;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import uk.me.parabola.imgfmt.FileExistsException;
import uk.me.parabola.imgfmt.FileNotWritableException;
import uk.me.parabola.imgfmt.FileSystemParam;
import uk.me.parabola.imgfmt.FormatException;
import uk.me.parabola.imgfmt.MapFailedException;
import uk.me.parabola.imgfmt.app.map.Map;
import uk.me.parabola.imgfmt.app.srt.Sort;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.CommandArgs;
import uk.me.parabola.mkgmap.build.MapBuilder;
import uk.me.parabola.mkgmap.combiners.OverviewBuilder;
import uk.me.parabola.mkgmap.general.LoadableMapDataSource;
import uk.me.parabola.mkgmap.main.MapProcessor;
import uk.me.parabola.mkgmap.reader.MapReader;

public class MapMaker
implements MapProcessor {
    private static final Logger log = Logger.getLogger(MapMaker.class);
    private Sort sort;
    private final boolean createOverviewFiles;

    public MapMaker(boolean createOverviewFiles) {
        this.createOverviewFiles = createOverviewFiles;
    }

    @Override
    public String makeMap(CommandArgs args, String filename) {
        if (new File(filename).isDirectory()) {
            Logger.defaultLogger.error((Object)("Need a single file, not a directory: " + filename));
            return filename;
        }
        try {
            LoadableMapDataSource src = MapMaker.loadFromFile(args, filename);
            this.sort = args.getSort();
            if (this.createOverviewFiles) {
                if (src.overviewMapLevels() != null) {
                    this.makeMap(args, src, "ovm_");
                } else {
                    String fname = OverviewBuilder.getOverviewImgName(args.getMapname());
                    File f = new File(args.getOutputDir(), fname);
                    MapMaker.tryRemove(f);
                }
            }
            return this.makeMap(args, src, "");
        }
        catch (FormatException e) {
            Logger.defaultLogger.error((Object)("Bad file format: " + filename), e);
            return filename;
        }
        catch (FileNotFoundException e) {
            Logger.defaultLogger.error((Object)("Could not open file: " + filename));
            return filename;
        }
    }

    private static void tryRemove(File f) {
        if (f.exists() && f.isFile()) {
            try {
                Files.delete(f.toPath());
                log.warn((Object)("removed " + f));
            }
            catch (IOException e) {
                log.warn((Object)("removing " + f + "failed with " + e.getMessage()));
            }
        }
    }

    private String makeMap(CommandArgs args, LoadableMapDataSource src, String mapNamePrefix) {
        if (src.getBounds().isEmpty()) {
            return null;
        }
        FileSystemParam params = new FileSystemParam();
        params.setBlockSize(args.getBlockSize());
        params.setMapDescription(args.getDescription());
        log.info("Started making", args.getMapname(), "(" + args.getDescription() + ")");
        try {
            Map map = Map.createMap(mapNamePrefix + args.getMapname(), args.getOutputDir(), params, args.getMapname(), this.sort, false);
            MapMaker.setOptions(map, args);
            MapBuilder builder = new MapBuilder("ovm_".equals(mapNamePrefix), false);
            builder.config(args.getProperties());
            builder.makeMap(map, src);
            String outName = map.getFilename();
            log.info("finished making map", outName, "closing");
            map.close();
            return outName;
        }
        catch (FileExistsException e) {
            Logger.defaultLogger.error((Object)e.getMessage());
            throw new MapFailedException("File exists already", e);
        }
        catch (FileNotWritableException e) {
            Logger.defaultLogger.error((Object)e.getMessage());
            throw new MapFailedException("Could not create or write to file", e);
        }
        catch (MapFailedException e) {
            Logger.defaultLogger.error((Object)e.getMessage());
            throw e;
        }
    }

    private static void setOptions(Map map, CommandArgs args) {
        map.config(args.getProperties());
        String s = args.getCharset();
        if (s != null) {
            map.setLabelCharset(s, args.isForceUpper());
        }
        Sort sort = args.getSort();
        map.setSort(sort);
    }

    private static LoadableMapDataSource loadFromFile(CommandArgs args, String name) throws FileNotFoundException {
        LoadableMapDataSource src = MapReader.createMapReader(name);
        src.config(args.getProperties());
        log.info("Started loading", name);
        src.load(name, !args.getProperties().getProperty("transparent", false));
        log.info("Finished loading", name);
        return src;
    }
}

