/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.net;

import java.util.ArrayList;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.net.RouteNode;

public class TableB {
    private final ArrayList<RouteNode> nodes = new ArrayList();
    private static final int ITEM_SIZE = 3;
    private int offset;

    public int size() {
        return this.nodes.size();
    }

    public int getNumberOfItems() {
        assert (this.nodes.size() < 256) : "Table B too large.";
        return this.nodes.size();
    }

    public void addNode(RouteNode node) {
        int i = this.nodes.indexOf(node);
        if (i < 0) {
            this.nodes.add(node);
        }
    }

    public int getIndex(RouteNode node) {
        int i = this.nodes.indexOf(node);
        assert (i >= 0) : "Trying to read Table B index for non-registered node.";
        assert (i < 256) : "Table B index too large.";
        return i;
    }

    public void write(ImgFileWriter writer) {
        this.offset = writer.position();
        int size = this.nodes.size() * 3;
        for (int i = 0; i < size; ++i) {
            writer.put1u(0);
        }
    }

    public void writePost(ImgFileWriter writer) {
        writer.position(this.offset);
        for (RouteNode node : this.nodes) {
            writer.put3u(node.getOffsetNod1());
        }
    }
}

