/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.net;

import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.imgfmt.app.CoordNode;

public class GeneralRouteRestriction {
    private final byte exceptionMask;
    private final RestrType type;
    private final String sourceDesc;
    private long fromWayId;
    private long toWayId;
    private CoordNode fromNode;
    private CoordNode toNode;
    private List<Long> viaWayIds = new ArrayList<Long>();
    private List<CoordNode> viaNodes = new ArrayList<CoordNode>();
    private char dirIndicator;

    public GeneralRouteRestriction(String type, byte exceptionMask, String sourceDesc) {
        if ("not".equals(type)) {
            this.type = RestrType.TYPE_NOT;
        } else if ("only".equals(type)) {
            this.type = RestrType.TYPE_ONLY;
        } else if ("no_through".equals(type)) {
            this.type = RestrType.TYPE_NO_TROUGH;
        } else {
            throw new IllegalArgumentException("invalid type " + type);
        }
        this.exceptionMask = exceptionMask;
        this.sourceDesc = sourceDesc;
        this.setDirIndicator('?');
    }

    public long getFromWayId() {
        return this.fromWayId;
    }

    public void setFromWayId(long fromWayId) {
        this.fromWayId = fromWayId;
    }

    public long getToWayId() {
        return this.toWayId;
    }

    public void setToWayId(long toWayId) {
        this.toWayId = toWayId;
    }

    public byte getExceptionMask() {
        return this.exceptionMask;
    }

    public RestrType getType() {
        return this.type;
    }

    public CoordNode getFromNode() {
        return this.fromNode;
    }

    public void setFromNode(CoordNode fromNode) {
        this.fromNode = fromNode;
    }

    public CoordNode getToNode() {
        return this.toNode;
    }

    public void setToNode(CoordNode toNode) {
        this.toNode = toNode;
    }

    public List<Long> getViaWayIds() {
        return this.viaWayIds;
    }

    public void setViaWayIds(List<Long> viaWayIds) {
        this.viaWayIds = new ArrayList<Long>(viaWayIds);
    }

    public List<CoordNode> getViaNodes() {
        return this.viaNodes;
    }

    public void setViaNodes(List<CoordNode> viaNodes) {
        this.viaNodes = new ArrayList<CoordNode>(viaNodes);
    }

    public String getSourceDesc() {
        return this.sourceDesc;
    }

    public char getDirIndicator() {
        return this.dirIndicator;
    }

    public void setDirIndicator(char dirIndicator) {
        this.dirIndicator = dirIndicator;
    }

    public static enum RestrType {
        TYPE_ONLY,
        TYPE_NOT,
        TYPE_NO_TROUGH;

    }
}

