/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.mdr;

import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.mdr.Mdr5Record;
import uk.me.parabola.imgfmt.app.mdr.Mdr7Record;
import uk.me.parabola.imgfmt.app.mdr.Mdr8Record;
import uk.me.parabola.imgfmt.app.mdr.MdrConfig;
import uk.me.parabola.imgfmt.app.mdr.MdrSection;
import uk.me.parabola.imgfmt.app.mdr.NamedRecord;
import uk.me.parabola.imgfmt.app.srt.Sort;

public class PrefixIndex
extends MdrSection {
    private final int prefixLength;
    private int maxIndex;
    private final List<Mdr8Record> index = new ArrayList<Mdr8Record>();

    public PrefixIndex(MdrConfig config, int prefixLength) {
        this.setConfig(config);
        this.prefixLength = prefixLength;
    }

    public void createFromList(List<? extends NamedRecord> list, boolean grouped) {
        this.maxIndex = list.size();
        Sort sort = this.getConfig().getSort();
        Sort.SrtCollator collator = (Sort.SrtCollator)sort.getCollator();
        collator.setStrength(0);
        String lastCountryName = null;
        char[] lastPrefix = "".toCharArray();
        int inRecord = 0;
        int outRecord = 0;
        int lastMdr22SortPos = -1;
        for (NamedRecord namedRecord : list) {
            String countryName;
            Mdr5Record city;
            char[] prefix;
            int cmp;
            String name;
            ++inRecord;
            if (namedRecord instanceof Mdr7Record) {
                name = ((Mdr7Record)namedRecord).getPartialName();
                if (grouped) {
                    int mdr22SortPos = ((Mdr7Record)namedRecord).getCity().getMdr22SortPos();
                    if (mdr22SortPos != lastMdr22SortPos) {
                        lastPrefix = "".toCharArray();
                    }
                    lastMdr22SortPos = mdr22SortPos;
                }
            } else {
                name = namedRecord.getName();
            }
            if ((cmp = collator.compareOneStrengthWithLength(prefix = sort.getPrefix(name, this.prefixLength), lastPrefix, 0, this.prefixLength)) <= 0) continue;
            ++outRecord;
            this.index.add(new Mdr8Record(prefix, inRecord));
            lastPrefix = prefix;
            if (!grouped || (city = ((Mdr7Record)namedRecord).getCity()) == null || (countryName = city.getCountryName()).equals(lastCountryName)) continue;
            city.getMdrCountry().getMdr29().setMdr17(outRecord);
            lastCountryName = countryName;
        }
    }

    public void createFromList(List<? extends NamedRecord> list) {
        this.createFromList(list, false);
    }

    @Override
    public void writeSectData(ImgFileWriter writer) {
        int size = Utils.numberToPointerSize(this.maxIndex);
        for (Mdr8Record s : this.index) {
            for (int i = 0; i < this.prefixLength; ++i) {
                writer.put1u(s.getPrefix()[i]);
            }
            writer.putNu(size, s.getRecordNumber());
        }
    }

    @Override
    public int getItemSize() {
        return this.prefixLength + Utils.numberToPointerSize(this.maxIndex);
    }

    @Override
    protected int numberOfItems() {
        return this.index.size();
    }

    public int getPrefixLength() {
        return this.prefixLength;
    }
}

