/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm.boundary;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.Version;
import uk.me.parabola.mkgmap.reader.osm.Tags;
import uk.me.parabola.mkgmap.reader.osm.boundary.Boundary;
import uk.me.parabola.mkgmap.reader.osm.boundary.BoundaryQuadTree;
import uk.me.parabola.mkgmap.reader.osm.boundary.BoundaryUtil;
import uk.me.parabola.util.Java2DConverter;

public class BoundarySaver {
    private static final Logger log = Logger.getLogger(BoundarySaver.class);
    public static final String LEGACY_DATA_FORMAT = "";
    public static final String RAW_DATA_FORMAT = "RAW";
    public static final String QUADTREE_DATA_FORMAT = "QUADTREE";
    public static final int CURRENT_RECORD_ID = 1;
    public static final double RESET_DELTA = Double.POSITIVE_INFINITY;
    private final File boundaryDir;
    private final String dataFormat;
    private Area bbox;
    private final HashSet<String> writtenFileNames;
    private int minLat = Integer.MAX_VALUE;
    private int minLong = Integer.MAX_VALUE;
    private int maxLat = Integer.MIN_VALUE;
    private int maxLong = Integer.MIN_VALUE;
    private int lastAccessNo = 0;
    private final List<StreamInfo> openStreams = new ArrayList<StreamInfo>();
    private final Map<String, StreamInfo> streams;
    private boolean createEmptyFiles = false;

    public BoundarySaver(File boundaryDir, String mode) {
        this.boundaryDir = boundaryDir;
        if (boundaryDir.exists() && !boundaryDir.isDirectory()) {
            log.error((Object)"output target exists and is not a directory");
            System.exit(-1);
        }
        this.dataFormat = mode;
        this.streams = new HashMap<String, StreamInfo>();
        this.writtenFileNames = new HashSet();
    }

    public void saveQuadTree(BoundaryQuadTree bqt, String boundsFileName) {
        String[] parts = boundsFileName.split("[_" + Pattern.quote(".") + "]");
        String key = boundsFileName;
        if (parts.length >= 3) {
            key = parts[1] + "_" + parts[2];
        }
        try {
            StreamInfo streamInfo = this.getStream(key);
            if (streamInfo != null && streamInfo.isOpen()) {
                bqt.save(streamInfo.stream);
                this.writtenFileNames.add(boundsFileName);
            }
        }
        catch (Exception exp) {
            log.error((Object)("Cannot write boundary: " + exp), exp);
        }
        this.tidyStreams();
    }

    public void addBoundary(Boundary boundary) {
        Map<String, Shape> splitBounds = BoundaryUtil.rasterArea(boundary.getArea());
        for (Map.Entry<String, Shape> split : splitBounds.entrySet()) {
            this.saveToFile(split.getKey(), split.getValue(), boundary.getTags(), boundary.getId());
        }
    }

    public HashSet<String> end() {
        if (this.isCreateEmptyFiles() && this.getBbox() != null) {
            for (int latSplit = BoundaryUtil.getSplitBegin(this.getBbox().getMinLat()); latSplit <= BoundaryUtil.getSplitBegin(this.getBbox().getMaxLat()); latSplit += 50000) {
                for (int lonSplit = BoundaryUtil.getSplitBegin(this.getBbox().getMinLong()); lonSplit <= BoundaryUtil.getSplitBegin(this.getBbox().getMaxLong()); lonSplit += 50000) {
                    String key = BoundaryUtil.getKey(latSplit, lonSplit);
                    StreamInfo stream = this.getStream(key, false);
                    if (stream == null) {
                        stream = this.getStream(key);
                    }
                    if (stream.isOpen()) {
                        stream.close();
                    }
                    this.streams.remove(key);
                }
            }
        }
        for (StreamInfo streamInfo : this.streams.values()) {
            streamInfo.close();
        }
        this.streams.clear();
        this.openStreams.clear();
        return this.writtenFileNames;
    }

    private void tidyStreams() {
        if (this.openStreams.size() < 100) {
            return;
        }
        this.openStreams.sort((o1, o2) -> o1.lastAccessNo - o2.lastAccessNo);
        log.debug(this.openStreams.size(), "open streams.");
        List<StreamInfo> closingStreams = this.openStreams.subList(0, this.openStreams.size() - 80);
        for (StreamInfo streamInfo : closingStreams) {
            log.debug("Closing", streamInfo.file);
            streamInfo.close();
        }
        closingStreams.clear();
        log.debug("Remaining", this.openStreams.size(), "open streams.");
    }

    private void openStream(StreamInfo streamInfo, boolean newFile) {
        block10: {
            if (!streamInfo.file.getParentFile().exists() && streamInfo.file.getParentFile() != null) {
                streamInfo.file.getParentFile().mkdirs();
            }
            FileOutputStream fileStream = null;
            try {
                fileStream = new FileOutputStream(streamInfo.file, !newFile);
                streamInfo.stream = new BufferedOutputStream(fileStream);
                this.openStreams.add(streamInfo);
                if (newFile) {
                    this.writeDefaultInfos(streamInfo.stream);
                    String[] keyParts = streamInfo.boundsKey.split(Pattern.quote("_"));
                    int lat = Integer.parseInt(keyParts[0]);
                    int lon = Integer.parseInt(keyParts[1]);
                    if (lat < this.minLat) {
                        this.minLat = lat;
                        log.debug("New min Lat:", this.minLat);
                    }
                    if (lat > this.maxLat) {
                        this.maxLat = lat;
                        log.debug("New max Lat:", this.maxLat);
                    }
                    if (lon < this.minLong) {
                        this.minLong = lon;
                        log.debug("New min Lon:", this.minLong);
                    }
                    if (lon > this.maxLong) {
                        this.maxLong = lon;
                        log.debug("New max Long:", this.maxLong);
                    }
                }
            }
            catch (IOException exp) {
                log.error((Object)("Cannot save boundary: " + exp));
                if (fileStream == null) break block10;
                try {
                    fileStream.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private StreamInfo getStream(String filekey) {
        return this.getStream(filekey, true);
    }

    private StreamInfo getStream(String filekey, boolean autoopen) {
        StreamInfo stream = this.streams.get(filekey);
        if (autoopen) {
            if (stream == null) {
                log.debug("Create stream for", filekey);
                stream = new StreamInfo();
                stream.boundsKey = filekey;
                stream.file = new File(this.boundaryDir, "bounds_" + filekey + ".bnd");
                this.streams.put(filekey, stream);
                this.openStream(stream, true);
            } else if (!stream.isOpen()) {
                this.openStream(stream, false);
            }
        }
        if (stream != null) {
            stream.lastAccessNo = ++this.lastAccessNo;
        }
        return stream;
    }

    private void writeDefaultInfos(OutputStream stream) throws IOException {
        DataOutputStream dos = new DataOutputStream(stream);
        dos.writeUTF("BND");
        dos.writeLong(System.currentTimeMillis());
        ByteArrayOutputStream headerStream = new ByteArrayOutputStream();
        try (DataOutputStream headerDataStream = new DataOutputStream(headerStream);){
            headerDataStream.writeUTF(this.dataFormat);
            headerDataStream.writeInt(1);
            headerDataStream.writeUTF(Version.VERSION);
        }
        byte[] header2 = headerStream.toByteArray();
        dos.writeInt(header2.length);
        dos.write(header2);
        dos.flush();
    }

    private void saveToFile(String filekey, Shape shape, Tags tags, String id) {
        try {
            StreamInfo streamInfo = this.getStream(filekey);
            if (streamInfo != null && streamInfo.isOpen()) {
                this.writeRawFormat(streamInfo.stream, shape, tags, id);
            }
        }
        catch (Exception exp) {
            log.error((Object)("Cannot write boundary: " + exp), exp);
        }
        this.tidyStreams();
    }

    private void writeRawFormat(OutputStream stream, Shape shape, Tags tags, String id) {
        ByteArrayOutputStream oneItemStream = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(oneItemStream);
        if (this.dataFormat == QUADTREE_DATA_FORMAT) {
            log.error((Object)"wrong format for write, must use BoundaryQuadTree.save() ");
            System.exit(1);
        }
        try {
            dos.writeUTF(id);
            int noOfTags = tags.size();
            dos.writeInt(noOfTags);
            Iterator<Map.Entry<String, String>> tagIter = tags.entryIterator();
            while (tagIter.hasNext()) {
                Map.Entry<String, String> tag = tagIter.next();
                dos.writeUTF(tag.getKey());
                dos.writeUTF(tag.getValue());
                --noOfTags;
            }
            assert (noOfTags == 0) : "Remaining tags: " + noOfTags + " size: " + tags.size() + " " + tags.toString();
            BoundarySaver.writeArea(dos, shape);
            dos.close();
            Area outBBox = Java2DConverter.createBbox(shape);
            DataOutputStream dOutStream = new DataOutputStream(stream);
            dOutStream.writeInt(outBBox.getMinLat());
            dOutStream.writeInt(outBBox.getMinLong());
            dOutStream.writeInt(outBBox.getMaxLat());
            dOutStream.writeInt(outBBox.getMaxLong());
            byte[] data = oneItemStream.toByteArray();
            assert (data.length > 0) : "bSize is not > 0 : " + data.length;
            dOutStream.writeInt(data.length);
            dOutStream.write(data);
            dOutStream.flush();
        }
        catch (IOException exp) {
            log.error((Object)exp.toString());
        }
    }

    public static void writeArea(DataOutputStream dos, Shape area) throws IOException {
        double[] res = new double[6];
        double[] lastRes = new double[2];
        IntArrayList pairs = new IntArrayList();
        PathIterator pit = area.getPathIterator(null);
        int prevType = -1;
        int len = 0;
        while (!pit.isDone()) {
            int type = pit.currentSegment(res);
            if (type != 1 && prevType == 1) {
                pairs.add(len);
                len = 0;
            }
            if (type == 1) {
                ++len;
            }
            prevType = type;
            pit.next();
        }
        pit = area.getPathIterator(null);
        prevType = -1;
        int pairsPos = 0;
        dos.writeInt(pit.getWindingRule());
        while (!pit.isDone()) {
            int type = pit.currentSegment(res);
            if (type != prevType) {
                dos.writeInt(type);
            }
            switch (type) {
                case 1: {
                    if (prevType != type) {
                        len = pairs.getInt(pairsPos++);
                        dos.writeInt(len);
                    }
                }
                case 0: {
                    --len;
                    for (int i = 0; i < 2; ++i) {
                        double delta = res[i] - lastRes[i];
                        if (delta + lastRes[i] != res[i]) {
                            BoundarySaver.writeVarDouble(dos, Double.POSITIVE_INFINITY);
                            delta = res[i];
                        }
                        lastRes[i] = res[i];
                        BoundarySaver.writeVarDouble(dos, delta);
                    }
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    log.error((Object)("Unsupported path iterator type " + type + ". This is an mkgmap error."));
                }
            }
            prevType = type;
            pit.next();
        }
        if (len != 0) {
            log.error((Object)("len not zero " + len));
        }
        dos.writeInt(-1);
    }

    public Area getBbox() {
        if (this.bbox == null) {
            this.bbox = new Area(this.minLat, this.minLong, this.maxLat, this.maxLong);
            log.error((Object)("Calculate bbox to " + this.bbox));
        }
        return this.bbox;
    }

    public void setBbox(Area bbox) {
        if (bbox.isEmpty()) {
            log.warn((Object)"Do not use bounding box because it's empty");
            this.bbox = null;
        } else {
            this.bbox = bbox;
            log.info((Object)("Set bbox: " + bbox.getMinLat() + " " + bbox.getMinLong() + " " + bbox.getMaxLat() + " " + bbox.getMaxLong()));
        }
    }

    public boolean isCreateEmptyFiles() {
        return this.createEmptyFiles;
    }

    public void setCreateEmptyFiles(boolean createEmptyFiles) {
        this.createEmptyFiles = createEmptyFiles;
    }

    private static void writeVarDouble(OutputStream dos, double val) throws IOException {
        long v64 = Double.doubleToRawLongBits(val);
        if (v64 == 0L) {
            dos.write(0);
            return;
        }
        byte[] buffer = new byte[12];
        int numBytes = 0;
        while (v64 != 0L) {
            v64 = v64 << 7 | v64 >>> -7;
            buffer[numBytes++] = (byte)(v64 & 0x7FL | 0x80L);
            v64 &= 0xFFFFFFFFFFFFFF80L;
        }
        int n = numBytes - 1;
        buffer[n] = (byte)(buffer[n] & 0x7F);
        dos.write(buffer, 0, numBytes);
    }

    private static final class StreamInfo {
        File file;
        String boundsKey;
        OutputStream stream;
        int lastAccessNo = 0;

        public boolean isOpen() {
            return this.stream != null;
        }

        public void close() {
            if (this.stream != null) {
                try {
                    this.stream.close();
                }
                catch (IOException exp) {
                    log.error((Object)exp);
                }
            }
            this.stream = null;
        }
    }
}

