/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm;

import java.awt.Polygon;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.filters.ShapeMergeFilter;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.reader.osm.MultiPolygonRelation;

public class Way
extends Element {
    private static final Logger log = Logger.getLogger(Way.class);
    private final List<Coord> points;
    private long fullArea = Long.MAX_VALUE;
    private MultiPolygonRelation mpRel;
    private boolean closedInOSM;
    private boolean complete = true;
    private boolean isViaWay;

    public Way(long id) {
        this.points = new ArrayList<Coord>(5);
        this.setId(id);
    }

    public Way(long id, List<Coord> points) {
        this.points = new ArrayList<Coord>(points);
        this.setId(id);
    }

    @Override
    public Way copy() {
        Way dup = new Way(this.getId(), this.points);
        dup.copyIds(this);
        dup.copyTags(this);
        dup.closedInOSM = this.closedInOSM;
        dup.complete = this.complete;
        dup.isViaWay = this.isViaWay;
        dup.fullArea = this.getFullArea();
        dup.mpRel = this.mpRel;
        return dup;
    }

    public List<Coord> getPoints() {
        return this.points;
    }

    public Coord getFirstPoint() {
        return this.points.isEmpty() ? null : this.points.get(0);
    }

    public Coord getLastPoint() {
        return this.points.isEmpty() ? null : this.points.get(this.points.size() - 1);
    }

    public void addPoint(Coord co) {
        this.points.add(co);
    }

    public void addPointIfNotEqualToLastPoint(Coord co) {
        if (this.points.isEmpty() || !co.highPrecEquals(this.getLastPoint())) {
            this.points.add(co);
        }
    }

    public void reverse() {
        Collections.reverse(this.points);
    }

    public boolean isClosed() {
        if (!this.isComplete()) {
            return this.closedInOSM;
        }
        return !this.points.isEmpty() && this.hasIdenticalEndPoints();
    }

    public boolean isClosedInOSM() {
        return this.closedInOSM;
    }

    public boolean hasIdenticalEndPoints() {
        return !this.points.isEmpty() && this.points.get(0) == this.points.get(this.points.size() - 1);
    }

    public boolean hasEqualEndPoints() {
        return !this.points.isEmpty() && this.points.get(0).equals(this.points.get(this.points.size() - 1));
    }

    public void setClosedInOSM(boolean closed) {
        this.closedInOSM = closed;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        if (this.getName() != null) {
            sb.append(' ').append(this.getName());
        }
        if (this.points.isEmpty()) {
            sb.append(" empty");
        } else {
            Coord coord = this.getFirstPoint();
            if (this.hasEqualEndPoints()) {
                sb.append(" starting and ending at ").append(coord);
            } else {
                sb.append(" starting at ").append(coord).append(" and ending at ").append(this.getLastPoint());
            }
        }
        sb.append(' ').append(this.toTagString());
        return sb.toString();
    }

    public int hashCode() {
        return (int)this.getId();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.getId() == ((Way)o).getId();
    }

    public Coord getCofG() {
        int numPoints = this.points.size();
        if (numPoints < 1) {
            return null;
        }
        double lat = 0.0;
        double lon = 0.0;
        if (this.hasIdenticalEndPoints()) {
            --numPoints;
        }
        for (int i = 0; i < numPoints; ++i) {
            Coord p = this.points.get(i);
            lat += (double)p.getHighPrecLat() / (double)numPoints;
            lon += (double)p.getHighPrecLon() / (double)numPoints;
        }
        return Coord.makeHighPrecCoord((int)Math.round(lat), (int)Math.round(lon));
    }

    @Override
    public String kind() {
        return "way";
    }

    public static boolean clockwise(List<Coord> points) {
        if (points.size() < 3 || !points.get(0).equals(points.get(points.size() - 1))) {
            return false;
        }
        if (!points.get(0).highPrecEquals(points.get(points.size() - 1))) {
            log.error((Object)"Way.clockwise was called for way that is not closed in high precision");
        }
        long area = 0L;
        Coord p1 = points.get(0);
        for (int i = 1; i < points.size(); ++i) {
            Coord p2 = points.get(i);
            area += (long)p1.getHighPrecLon() * (long)p2.getHighPrecLat() - (long)p2.getHighPrecLon() * (long)p1.getHighPrecLat();
            p1 = p2;
        }
        return area <= 0L;
    }

    public boolean containsPointsOf(Way other) {
        Polygon thisPoly = new Polygon();
        for (Coord p : this.points) {
            thisPoly.addPoint(p.getHighPrecLon(), p.getHighPrecLat());
        }
        for (Coord p : other.points) {
            if (thisPoly.contains(p.getHighPrecLon(), p.getHighPrecLat())) continue;
            return false;
        }
        return true;
    }

    public boolean isViaWay() {
        return this.isViaWay;
    }

    public void setViaWay(boolean isViaWay) {
        this.isViaWay = isViaWay;
    }

    public void setFullArea(long fullArea) {
        this.fullArea = fullArea;
    }

    public long getFullArea() {
        if (this.fullArea == Long.MAX_VALUE && this.points.size() >= 4 && this.getFirstPoint().highPrecEquals(this.getLastPoint())) {
            this.fullArea = ShapeMergeFilter.calcAreaSizeTestVal(this.points);
        }
        return this.fullArea;
    }

    public double calcLengthInMetres() {
        double length = 0.0;
        if (this.points.size() > 1) {
            Coord p0 = this.points.get(0);
            for (int i = 1; i < this.points.size(); ++i) {
                Coord p1 = this.points.get(i);
                length += p0.distance(p1);
                p0 = p1;
            }
        }
        return length;
    }

    public MultiPolygonRelation getMpRel() {
        return this.mpRel;
    }

    public void setMpRel(MultiPolygonRelation mpRel) {
        this.mpRel = mpRel;
    }
}

