/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.reader.osm.CoordPOI;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.reader.osm.ElementSaver;
import uk.me.parabola.mkgmap.reader.osm.Node;
import uk.me.parabola.mkgmap.reader.osm.OsmReadingHooks;
import uk.me.parabola.mkgmap.reader.osm.Style;
import uk.me.parabola.mkgmap.reader.osm.Way;
import uk.me.parabola.util.ElementQuadTree;
import uk.me.parabola.util.EnhancedProperties;

public class HighwayHooks
implements OsmReadingHooks {
    private static final Logger log = Logger.getLogger(HighwayHooks.class);
    private final List<Element> motorways = new ArrayList<Element>();
    private final List<Element> exits = new ArrayList<Element>();
    private boolean makeOppositeCycleways;
    private ElementSaver saver;
    private boolean linkPOIsToWays;
    private Node currentNodeInWay;
    private static final int XTRA = 150;

    @Override
    public boolean init(ElementSaver saver, EnhancedProperties props, Style style) {
        this.saver = saver;
        if (props.getProperty("make-all-cycleways", false)) {
            log.error((Object)"option make-all-cycleways is deprecated, please use make-opposite-cycleways");
            this.makeOppositeCycleways = true;
        } else {
            this.makeOppositeCycleways = props.getProperty("make-opposite-cycleways", false);
        }
        this.linkPOIsToWays = props.getProperty("link-pois-to-ways", false);
        this.currentNodeInWay = null;
        return true;
    }

    @Override
    public Set<String> getUsedTags() {
        HashSet<String> usedTags = new HashSet<String>(Arrays.asList("highway", "access", "barrier", "oneway", "junction", "name", "exit:road_ref", "ref", "motorroad"));
        if (this.makeOppositeCycleways) {
            usedTags.add("cycleway");
            usedTags.add("bicycle");
            usedTags.add("oneway:bicycle");
            usedTags.add("bicycle:oneway");
            usedTags.add("cycleway:left");
            usedTags.add("cycleway:right");
        }
        return usedTags;
    }

    @Override
    public void onAddNode(Node node) {
        String highway = node.getTag("highway");
        if (highway != null && ("motorway_junction".equals(highway) || "services".equals(highway) || "rest_area".equals(highway))) {
            this.exits.add(node);
            node.addTag("mkgmap:osmid", String.valueOf(node.getId()));
        }
    }

    @Override
    public void onNodeAddedToWay(Way way, long id) {
        if (!this.linkPOIsToWays) {
            return;
        }
        this.currentNodeInWay = this.saver.getNode(id);
        if (this.currentNodeInWay == null) {
            return;
        }
        Coord co = this.currentNodeInWay.getLocation();
        if (!(co instanceof CoordPOI)) {
            String[] coordPOITags;
            for (String cpt : coordPOITags = new String[]{"barrier", "highway"}) {
                if (this.currentNodeInWay.getTag(cpt) == null) continue;
                CoordPOI cp = new CoordPOI(co);
                this.saver.addPoint(id, cp);
                Node newNode = new Node(id, cp);
                newNode.copyTags(this.currentNodeInWay);
                this.saver.addNode(newNode);
                cp.setNode(newNode);
                co = cp;
                if (this.exits.remove(this.currentNodeInWay)) {
                    this.exits.add(newNode);
                }
                this.currentNodeInWay = newNode;
                break;
            }
        }
        if (co instanceof CoordPOI) {
            way.addTag("mkgmap:way-has-pois", "true");
            if (log.isInfoEnabled()) {
                log.info("link-pois-to-ways: Linking POI", this.currentNodeInWay.toBrowseURL(), "to way at", co.toOSMURL());
            }
        }
    }

    @Override
    public void onAddWay(Way way) {
        String highway = way.getTag("highway");
        if (highway != null) {
            if ("roundabout".equals(way.getTag("junction")) && way.getTag("oneway") == null) {
                way.addTag("oneway", "yes");
            }
            if (this.makeOppositeCycleways && !"cycleway".equals(highway)) {
                String onewayTag = way.getTag("oneway");
                if (way.tagIsLikeYes("oneway") || "-1".equals(onewayTag)) {
                    String cycleway = way.getTag("cycleway");
                    if ("no".equals(way.getTag("oneway:bicycle")) || "no".equals(way.getTag("bicycle:oneway")) || "opposite".equals(cycleway) || "opposite_lane".equals(cycleway) || "opposite_track".equals(cycleway) || "opposite_lane".equals(way.getTag("cycleway:left")) || "opposite_lane".equals(way.getTag("cycleway:right")) || "opposite_track".equals(way.getTag("cycleway:left")) || "opposite_track".equals(way.getTag("cycleway:right"))) {
                        way.addTag("mkgmap:make-cycle-way", "yes");
                    }
                }
            }
        }
        if ("motorway".equals(highway) || "trunk".equals(highway) || "primary".equals(highway) || way.tagIsLikeYes("motorroad")) {
            this.motorways.add(way);
        } else if (this.linkPOIsToWays && ("services".equals(highway) || "rest_area".equals(highway))) {
            this.exits.add(way);
            way.addTag("mkgmap:osmid", String.valueOf(way.getId()));
        }
    }

    @Override
    public void end() {
        this.finishExits();
        this.exits.clear();
        this.motorways.clear();
    }

    private void finishExits() {
        if (this.exits.isEmpty() || this.motorways.isEmpty()) {
            return;
        }
        ElementQuadTree majorRoads = new ElementQuadTree(this.saver.getBoundingBox(), this.motorways);
        for (Element e : this.exits) {
            boolean isServices;
            String refTag;
            if (e.getTag(refTag = "exit:road_ref") != null) continue;
            String exitName = e.getTag("name");
            if (exitName == null) {
                exitName = e.getTag("ref");
            }
            String ref = null;
            Way motorway = null;
            Area bBox = e instanceof Node ? Area.getBBox(Collections.singletonList(((Node)e).getLocation())) : Area.getBBox(((Way)e).getPoints());
            String highway = e.getTag("highway");
            boolean bl = isServices = "services".equals(highway) || "rest_area".equals(highway);
            if (isServices) {
                bBox = new Area(bBox.getMinLat() - 150, bBox.getMinLong() - 150, bBox.getMaxLat() + 150, bBox.getMaxLong() + 150);
            }
            ArrayList<Way> possibleRoads = new ArrayList<Way>();
            for (Element w : majorRoads.get(bBox)) {
                motorway = (Way)w;
                ref = motorway.getTag("ref");
                if (ref == null) continue;
                if (isServices) {
                    possibleRoads.add(motorway);
                    continue;
                }
                if (!(e instanceof Node)) {
                    log.warn("Motorway exit", exitName, "expected to be a Node", e);
                    continue;
                }
                if (!motorway.getPoints().contains(((Node)e).getLocation())) continue;
                possibleRoads.add(motorway);
            }
            if (possibleRoads.size() > 1) {
                if (isServices) {
                    Coord serviceCoord = e instanceof Node ? ((Node)e).getLocation() : ((Way)e).getFirstPoint();
                    long closestRoad = Long.MAX_VALUE;
                    for (Way road : possibleRoads) {
                        long closestCoord = Long.MAX_VALUE;
                        for (Coord pointOnRoad : road.getPoints()) {
                            long dist = pointOnRoad.distanceInHighPrecSquared(serviceCoord);
                            if (dist >= closestCoord) continue;
                            closestCoord = dist;
                        }
                        if (closestCoord >= closestRoad) continue;
                        closestRoad = closestCoord;
                        motorway = road;
                        ref = motorway.getTag("ref");
                    }
                } else {
                    int bestRoad = Integer.MAX_VALUE;
                    for (Way road : possibleRoads) {
                        String roadType = road.getTag("highway");
                        int thisRoad = 4;
                        if ("motorway".equals(roadType)) {
                            thisRoad = 0;
                        } else if (road.tagIsLikeYes("motorroad")) {
                            thisRoad = 1;
                        } else if ("trunk".equals(roadType)) {
                            thisRoad = 2;
                        } else if ("primary".equals(roadType)) {
                            thisRoad = 3;
                        }
                        if (thisRoad >= bestRoad) continue;
                        bestRoad = thisRoad;
                        motorway = road;
                        ref = motorway.getTag("ref");
                    }
                }
            }
            if (ref != null) {
                log.info("Adding", refTag + "=" + ref, "to exit", exitName);
                e.addTag(refTag, ref);
                continue;
            }
            if (motorway == null) continue;
            log.warn("Motorway exit", exitName, "is positioned on a motorway that doesn't have a 'ref' tag", e);
        }
    }
}

