/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.mkgmap.general.LoadableMapDataSource;
import uk.me.parabola.mkgmap.reader.osm.OsmMapDataSource;
import uk.me.parabola.mkgmap.reader.polish.PolishMapDataSource;
import uk.me.parabola.mkgmap.reader.test.ElementTestDataSource;

public class MapReader {
    private static final List<LoadableMapDataSource> loaders = new ArrayList<LoadableMapDataSource>();

    public static LoadableMapDataSource createMapReader(String name) {
        for (LoadableMapDataSource loader : loaders) {
            if (!loader.isFileSupported(name)) continue;
            try {
                return (LoadableMapDataSource)loader.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            }
        }
        throw new UnsupportedOperationException("Don't know how to read " + name);
    }

    static {
        loaders.add(new PolishMapDataSource());
        loaders.add(new ElementTestDataSource());
        loaders.add(new OsmMapDataSource());
    }
}

