/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle.function;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import uk.me.parabola.imgfmt.ExitException;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.osmstyle.function.CachedFunction;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.reader.osm.ElementSaver;
import uk.me.parabola.mkgmap.reader.osm.FeatureKind;
import uk.me.parabola.mkgmap.reader.osm.Node;
import uk.me.parabola.mkgmap.reader.osm.Way;
import uk.me.parabola.mkgmap.scan.SyntaxException;
import uk.me.parabola.util.ElementQuadTree;
import uk.me.parabola.util.IsInUtil;

public class IsInFunction
extends CachedFunction {
    private static final Logger log = Logger.getLogger(IsInFunction.class);
    private MethodArg method;
    private boolean hasIn;
    private boolean hasOn;
    private boolean hasOut;
    private ElementQuadTree qt = null;

    public IsInFunction() {
        super(null);
        this.reqdNumParams = 3;
        log.debug("isInFunction", System.identityHashCode(this));
    }

    private void resetHasFlags() {
        this.hasIn = false;
        this.hasOn = false;
        this.hasOut = false;
    }

    @Override
    public String calcImpl(Element el) {
        log.debug(new Object[]{"calcImpl", System.identityHashCode(this), this.kind, this.params, el});
        assert (this.qt != null) : "invoked the non-augmented instance";
        if (this.qt.isEmpty()) {
            return String.valueOf(false);
        }
        this.resetHasFlags();
        try {
            switch (this.kind) {
                case POINT: {
                    this.doPointTest((Node)el);
                    break;
                }
                case POLYLINE: {
                    this.doLineTest((Way)el);
                    break;
                }
                case POLYGON: {
                    this.doPolygonTest((Way)el);
                    break;
                }
                default: {
                    throw new ExitException("Bad FeatureKind: " + (Object)((Object)this.kind));
                }
            }
        }
        catch (CanStopProcessing canStopProcessing) {
            // empty catch block
        }
        log.debug("done", System.identityHashCode(this), this.hasIn, this.hasOn, this.hasOut);
        if (!this.hasIn && !this.hasOn) {
            this.hasOut = true;
        }
        return String.valueOf(this.method.mapFlags(this.hasIn, this.hasOn, this.hasOut));
    }

    @Override
    public void setParams(List<String> params, FeatureKind kind) {
        super.setParams(params, kind);
        log.debug(new Object[]{"setParams", System.identityHashCode(this), kind, params});
        String methodStr = params.get(2);
        boolean knownMethod = false;
        ArrayList<String> methodsForKind = new ArrayList<String>();
        for (MethodArg tstMethod : MethodArg.values()) {
            if (methodStr.equalsIgnoreCase(tstMethod.toString())) {
                if (tstMethod.getKind() == kind) {
                    this.method = tstMethod;
                    return;
                }
                knownMethod = true;
                continue;
            }
            if (tstMethod.getKind() != kind) continue;
            methodsForKind.add(tstMethod.toString());
        }
        throw new SyntaxException(String.format("Third parameter '%s' of function %s is not " + (knownMethod ? "supported for this style section" : "understood") + ", valid are: %s", methodStr, this.getName(), methodsForKind));
    }

    private void setIn() {
        log.debug("setIn", this.hasIn, this.hasOn, this.hasOut);
        this.hasIn = true;
        if (this.method.canStopIn() || this.hasOut) {
            throw new CanStopProcessing();
        }
    }

    private void setOn() {
        log.debug("setOn", this.hasIn, this.hasOn, this.hasOut);
        this.hasOn = true;
        if (this.method.canStopOn() || this.hasIn && this.hasOut) {
            throw new CanStopProcessing();
        }
    }

    private void setOut() {
        log.debug("setOut", this.hasIn, this.hasOn, this.hasOut);
        this.hasOut = true;
        if (this.method.canStopOut() || this.hasIn) {
            throw new CanStopProcessing();
        }
    }

    private void setHasFromFlags(int flags) {
        log.debug("setFlags", flags);
        if ((flags & 2) != 0) {
            this.setOn();
        }
        if ((flags & 1) != 0) {
            this.setIn();
        }
        if ((flags & 4) != 0) {
            this.setOut();
        }
    }

    private static boolean notInHole(Coord c, List<List<Coord>> holes) {
        if (holes == null) {
            return true;
        }
        for (List<Coord> hole : holes) {
            int flags = IsInUtil.isPointInShape(c, hole);
            log.debug("notInHole", flags);
            if (flags == 4) continue;
            return false;
        }
        return true;
    }

    private void checkPointInShape(Coord c, List<Coord> shape, List<List<Coord>> holes) {
        int flags = IsInUtil.isPointInShape(c, shape);
        log.debug("checkPoint", flags);
        switch (this.method) {
            case POINT_IN: {
                if (flags != 1) break;
                if (IsInFunction.notInHole(c, holes)) {
                    this.setIn();
                    break;
                }
                throw new CanStopProcessing();
            }
            case POINT_IN_OR_ON: {
                if (flags == 4) break;
                this.setIn();
                break;
            }
            case POINT_ON: {
                if (flags != 2) break;
                this.setOn();
                break;
            }
            default: {
                throw new ExitException("Bad point method: " + (Object)((Object)this.method));
            }
        }
    }

    private void doPointTest(Node el) {
        block4: {
            Set polygons;
            Coord c;
            block3: {
                c = el.getLocation();
                Area elementBbox = Area.getBBox(Collections.singletonList(c));
                polygons = this.qt.get(elementBbox).stream().map(e -> (Way)e).collect(Collectors.toCollection(LinkedHashSet::new));
                if (!this.method.needMerge() || polygons.size() <= 1) break block3;
                ArrayList<List<Coord>> outers = new ArrayList<List<Coord>>();
                ArrayList<List<Coord>> holes = new ArrayList<List<Coord>>();
                IsInUtil.mergePolygons(polygons, outers, holes);
                log.debug("pointMerge", polygons.size(), outers.size(), holes.size());
                for (List list : outers) {
                    this.checkPointInShape(c, list, holes);
                }
                if (this.method != MethodArg.POINT_ON || holes.isEmpty()) break block4;
                for (List list : holes) {
                    this.checkPointInShape(c, list, null);
                }
                break block4;
            }
            log.debug("point1by1", polygons.size());
            for (Way polygon : polygons) {
                this.checkPointInShape(c, polygon.getPoints(), null);
            }
        }
    }

    private void doLineTest(Way el) {
        this.doCommonTest(el);
    }

    private void doPolygonTest(Way el) {
        this.doCommonTest(el);
    }

    private boolean checkHoles(List<Coord> polyLine, List<List<Coord>> holes, Area elementBbox) {
        boolean foundSomething = false;
        for (List<Coord> hole : holes) {
            int flags = IsInUtil.isLineInShape(polyLine, hole, elementBbox);
            log.debug("checkhole", flags);
            if ((flags & 1) != 0) {
                this.setOut();
                if ((flags & 2) != 0) {
                    this.setOn();
                }
                if ((flags & 4) != 0) {
                    this.setIn();
                }
                return true;
            }
            if ((flags & 2) == 0) continue;
            this.setOn();
            if ((flags & 4) != 0) {
                this.setIn();
            }
            foundSomething = true;
        }
        return foundSomething;
    }

    private void checkHoleInThis(List<Coord> polyLine, List<List<Coord>> holes, Area elementBbox) {
        for (List<Coord> hole : holes) {
            int flags = IsInUtil.isLineInShape(hole, polyLine, elementBbox);
            log.debug("holeInThis", flags);
            if ((flags & 1) == 0 && flags != 2) continue;
            this.setOut();
            return;
        }
    }

    private void doCommonTest(Element el) {
        List<Coord> polyLine = ((Way)el).getPoints();
        Area elementBbox = Area.getBBox(polyLine);
        Set polygons = this.qt.get(elementBbox).stream().map(e -> (Way)e).collect(Collectors.toCollection(LinkedHashSet::new));
        if (log.isDebugEnabled()) {
            log.debug("line", polyLine);
            log.debug(polygons.size(), "polygons");
            for (Way polygon : polygons) {
                log.debug("polygon", polygon.getPoints());
            }
        }
        if (this.method.needMerge() && polygons.size() > 1) {
            ArrayList<List<Coord>> outers = new ArrayList<List<Coord>>();
            ArrayList<List<Coord>> holes = new ArrayList<List<Coord>>();
            IsInUtil.mergePolygons(polygons, outers, holes);
            if (log.isDebugEnabled()) {
                log.debug(outers.size(), "outers", holes.size(), "holes");
                for (List list : outers) {
                    log.debug("outer", list);
                }
                for (List list : holes) {
                    log.debug("hole", list);
                }
            }
            for (List list : outers) {
                int flags = IsInUtil.isLineInShape(polyLine, list, elementBbox);
                log.debug("checkShape", flags);
                if ((flags & 1) != 0) {
                    if ((flags & 2) != 0) {
                        this.setOn();
                    }
                    if ((flags & 4) != 0) {
                        this.setOut();
                    }
                    if (!this.checkHoles(polyLine, holes, elementBbox)) {
                        this.setIn();
                    }
                    if (this.hasOut || this.kind != FeatureKind.POLYGON) break;
                    this.checkHoleInThis(polyLine, holes, elementBbox);
                    break;
                }
                if ((flags & 2) == 0) continue;
                this.setOn();
                if ((flags & 4) != 0) {
                    this.setOut();
                    continue;
                }
                if (this.kind != FeatureKind.POLYGON) break;
                this.checkHoleInThis(polyLine, holes, elementBbox);
                break;
            }
        } else {
            for (Way polygon : polygons) {
                this.setHasFromFlags(IsInUtil.isLineInShape(polyLine, polygon.getPoints(), elementBbox));
            }
        }
    }

    @Override
    public String getName() {
        return "is_in";
    }

    @Override
    public boolean supportsNode() {
        return true;
    }

    @Override
    public boolean supportsWay() {
        return true;
    }

    @Override
    public Set<String> getUsedTags() {
        return Collections.singleton(this.params.get(0));
    }

    @Override
    public String toString() {
        return this.getName() + "(" + (Object)((Object)this.kind) + ", " + String.join((CharSequence)", ", this.params) + ")";
    }

    @Override
    protected String getCacheTag() {
        return "mkgmap:cache_is_in_" + (Object)((Object)this.kind) + "_" + String.join((CharSequence)"_", this.params);
    }

    @Override
    public void augmentWith(ElementSaver elementSaver) {
        log.debug(new Object[]{"augmentWith", System.identityHashCode(this), this.kind, this.params});
        if (this.qt != null) {
            return;
        }
        this.qt = IsInFunction.buildTree(elementSaver, (String)this.params.get(0), (String)this.params.get(1));
    }

    public static ElementQuadTree buildTree(ElementSaver elementSaver, String tagKey, String tagVal) {
        ArrayList<Element> matchingPolygons = new ArrayList<Element>();
        boolean matchAllValues = "*".equals(tagVal);
        for (Way w : elementSaver.getWays().values()) {
            String val;
            if (!w.hasIdenticalEndPoints() || "polyline".equals(w.getTag("mkgmap:stylefilter")) || (val = w.getTag(tagKey)) == null || !matchAllValues && !val.equals(tagVal)) continue;
            matchingPolygons.add(w);
        }
        return new ElementQuadTree(elementSaver.getBoundingBox(), matchingPolygons);
    }

    public void unitTestAugment(ElementQuadTree qt) {
        this.qt = qt;
    }

    @Override
    public int getComplexity() {
        return 5;
    }

    private class CanStopProcessing
    extends RuntimeException {
        private CanStopProcessing() {
        }
    }

    private static enum MethodArg {
        POINT_IN("in", FeatureKind.POINT, true, false, false, true){

            @Override
            public boolean mapFlags(boolean hasIn, boolean hasOn, boolean hasOut) {
                return hasIn;
            }
        }
        ,
        POINT_IN_OR_ON("in_or_on", FeatureKind.POINT, true, true, false, false){

            @Override
            public boolean mapFlags(boolean hasIn, boolean hasOn, boolean hasOut) {
                return hasIn || hasOn;
            }
        }
        ,
        POINT_ON("on", FeatureKind.POINT, false, true, false, true){

            @Override
            public boolean mapFlags(boolean hasIn, boolean hasOn, boolean hasOut) {
                return hasOn;
            }
        }
        ,
        LINE_SOME_IN_NONE_OUT("all", FeatureKind.POLYLINE, false, false, true, true){

            @Override
            public boolean mapFlags(boolean hasIn, boolean hasOn, boolean hasOut) {
                return hasIn && !hasOut;
            }
        }
        ,
        LINE_ALL_IN_OR_ON("all_in_or_on", FeatureKind.POLYLINE, false, false, true, true){

            @Override
            public boolean mapFlags(boolean hasIn, boolean hasOn, boolean hasOut) {
                return !hasOut;
            }
        }
        ,
        LINE_ALL_ON("on", FeatureKind.POLYLINE, true, false, true, true){

            @Override
            public boolean mapFlags(boolean hasIn, boolean hasOn, boolean hasOut) {
                return !hasIn && !hasOut;
            }
        }
        ,
        LINE_ANY_IN("any", FeatureKind.POLYLINE, true, false, false, true){

            @Override
            public boolean mapFlags(boolean hasIn, boolean hasOn, boolean hasOut) {
                return hasIn;
            }
        }
        ,
        LINE_NONE_IN_SOME_OUT("none", FeatureKind.POLYLINE, true, false, false, true){

            @Override
            public boolean mapFlags(boolean hasIn, boolean hasOn, boolean hasOut) {
                return !hasIn && hasOut;
            }
        }
        ,
        POLYGON_ALL("all", FeatureKind.POLYGON, false, false, true, true){

            @Override
            public boolean mapFlags(boolean hasIn, boolean hasOn, boolean hasOut) {
                return !hasOut;
            }
        }
        ,
        POLYGON_ANY("any", FeatureKind.POLYGON, true, false, false, false){

            @Override
            public boolean mapFlags(boolean hasIn, boolean hasOn, boolean hasOut) {
                return hasIn || !hasOut;
            }
        };

        private final String methodName;
        private final FeatureKind kind;
        private final boolean stopIn;
        private final boolean stopOn;
        private final boolean stopOut;
        private final boolean needMerge;

        public abstract boolean mapFlags(boolean var1, boolean var2, boolean var3);

        private MethodArg(String methodName, FeatureKind kind, boolean stopIn, boolean stopOn, boolean stopOut, boolean needMerge) {
            this.methodName = methodName;
            this.kind = kind;
            this.stopIn = stopIn;
            this.stopOn = stopOn;
            this.stopOut = stopOut;
            this.needMerge = needMerge;
        }

        public String toString() {
            return this.methodName;
        }

        public FeatureKind getKind() {
            return this.kind;
        }

        public boolean canStopIn() {
            return this.stopIn;
        }

        public boolean canStopOn() {
            return this.stopOn;
        }

        public boolean canStopOut() {
            return this.stopOut;
        }

        public boolean needMerge() {
            return this.needMerge;
        }
    }
}

