/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.filters;

import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.mkgmap.filters.FilterConfig;
import uk.me.parabola.mkgmap.filters.MapFilter;
import uk.me.parabola.mkgmap.filters.MapFilterChain;
import uk.me.parabola.mkgmap.general.MapElement;
import uk.me.parabola.mkgmap.general.MapLine;

public class SmoothingFilter
implements MapFilter {
    private static final int MIN_SPACING = 5;
    private int shift;

    @Override
    public void init(FilterConfig config) {
        this.shift = config.getShift();
    }

    @Override
    public void doFilter(MapElement element, MapFilterChain next) {
        MapLine line = (MapLine)element;
        if (this.shift == 0) {
            next.doFilter(element);
            return;
        }
        List<Coord> points = line.getPoints();
        int n = points.size();
        if (n <= 5) {
            next.doFilter(element);
            return;
        }
        ArrayList<Coord> coords = new ArrayList<Coord>(n);
        int stepsize = 5 << this.shift;
        Coord last = points.get(0);
        coords.add(last);
        Average av = new Average(last, stepsize);
        for (int i = 1; i < n; ++i) {
            Coord co = points.get(i);
            av.add(co);
            if (!av.isMoreThanStep()) continue;
            Coord nco = av.getAverageCoord();
            coords.add(nco);
            if (av.pointCounter() > 1) {
                --i;
            }
            last = nco;
            av.reset(last);
        }
        Coord end = points.get(n - 1);
        if (!last.equals(end)) {
            coords.add(end);
        }
        MapLine newline = line.copy();
        newline.setPoints(coords);
        next.doFilter(newline);
    }

    private static class Average {
        private int count;
        private int startLat;
        private int startLon;
        private int avlat;
        private int avlon;
        private int step;
        private final int stepsize;

        Average(Coord start, int stepsize) {
            this.startLat = start.getLatitude();
            this.startLon = start.getLongitude();
            this.stepsize = stepsize;
        }

        public void add(int lat, int lon) {
            ++this.count;
            this.avlat += lat;
            this.avlon += lon;
            this.step += Math.abs(this.startLat - lat);
            this.step += Math.abs(this.startLon - lon);
        }

        public void reset(Coord start) {
            this.startLat = start.getLatitude();
            this.startLon = start.getLongitude();
            this.step = 0;
            this.count = 0;
            this.avlat = 0;
            this.avlon = 0;
        }

        public Coord getAverageCoord() {
            assert (this.count > 0);
            return new Coord(this.avlat / this.count, this.avlon / this.count);
        }

        public void add(Coord co) {
            this.add(co.getLatitude(), co.getLongitude());
        }

        public boolean isMoreThanStep() {
            return this.step > this.stepsize;
        }

        public int pointCounter() {
            return this.count;
        }
    }
}

