/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.build;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.imgfmt.app.net.RoadNetwork;
import uk.me.parabola.imgfmt.app.trergn.Overview;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.filters.FilterConfig;
import uk.me.parabola.mkgmap.filters.LineSizeSplitterFilter;
import uk.me.parabola.mkgmap.filters.MapFilterChain;
import uk.me.parabola.mkgmap.filters.PredictFilterPoints;
import uk.me.parabola.mkgmap.filters.ShapeMergeFilter;
import uk.me.parabola.mkgmap.general.MapDataSource;
import uk.me.parabola.mkgmap.general.MapElement;
import uk.me.parabola.mkgmap.general.MapLine;
import uk.me.parabola.mkgmap.general.MapPoint;
import uk.me.parabola.mkgmap.general.MapRoad;
import uk.me.parabola.mkgmap.general.MapShape;
import uk.me.parabola.mkgmap.reader.osm.GType;
import uk.me.parabola.util.ShapeSplitter;

public class MapArea
implements MapDataSource {
    private static final Logger log = Logger.getLogger(MapArea.class);
    private static final int MAX_RESOLUTION = 24;
    private static final int LARGE_OBJECT_DIM = 8192;
    public static final int POINT_KIND = 0;
    public static final int LINE_KIND = 1;
    public static final int SHAPE_KIND = 2;
    public static final int XT_POINT_KIND = 3;
    public static final int XT_LINE_KIND = 4;
    public static final int XT_SHAPE_KIND = 5;
    public static final int NUM_KINDS = 6;
    private Area bounds;
    private int minLat = Integer.MAX_VALUE;
    private int minLon = Integer.MAX_VALUE;
    private int maxLat = Integer.MIN_VALUE;
    private int maxLon = Integer.MIN_VALUE;
    private final List<MapPoint> points = new ArrayList<MapPoint>();
    private final List<MapLine> lines = new ArrayList<MapLine>();
    private final List<MapShape> shapes = new ArrayList<MapShape>();
    private final int[] sizes = new int[6];
    private int nActivePoints;
    private int nActiveIndPoints;
    private int nActiveLines;
    private int nActiveShapes;
    private int areaResolution;
    private final boolean splitPolygonsIntoArea;
    private int splittableCount;
    private Long2ObjectOpenHashMap<Coord> areasHashMap;

    public MapArea(MapDataSource src, int resolution, boolean splitPolygonsIntoArea) {
        this.areaResolution = 0;
        this.bounds = src.getBounds();
        this.splitPolygonsIntoArea = splitPolygonsIntoArea;
        for (MapPoint p : src.getPoints()) {
            if (p.getMaxResolution() < resolution) continue;
            if (this.bounds.contains(p.getLocation())) {
                this.addPoint(p);
                continue;
            }
            log.error((Object)("Point with type 0x" + Integer.toHexString(p.getType()) + " at " + p.getLocation().toOSMURL() + " is outside of the map area centred on " + this.bounds.getCenter().toOSMURL() + " width = " + this.bounds.getWidth() + " height = " + this.bounds.getHeight() + " resolution = " + this.areaResolution));
        }
        this.addLines(src, resolution);
        this.addPolygons(src, resolution);
        this.areaResolution = resolution;
    }

    private void addPolygons(MapDataSource src, int resolution) {
        for (MapShape s : src.getShapes()) {
            if (s.getMaxResolution() < resolution) continue;
            this.addShape(s);
        }
    }

    private void addLines(MapDataSource src, int resolution) {
        MapFilterChain chain = element -> this.addLine((MapLine)element);
        LineSizeSplitterFilter filter = new LineSizeSplitterFilter();
        FilterConfig config = new FilterConfig();
        config.setResolution(resolution);
        config.setBounds(this.bounds);
        filter.init(config);
        for (MapLine l : src.getLines()) {
            if (l.getMaxResolution() < resolution) continue;
            filter.doFilter(l, chain);
        }
    }

    private MapArea(Area area, int resolution, boolean splitPolygonsIntoArea) {
        this.bounds = area;
        this.areaResolution = resolution;
        this.splitPolygonsIntoArea = splitPolygonsIntoArea;
    }

    public MapArea[] split(int nx, int ny, Area bounds, boolean tooSmallToDivide) {
        MapArea largeObjectArea;
        int areaIndex;
        int resolutionShift = 24 - this.areaResolution;
        Area[] areas = bounds.split(nx, ny, resolutionShift);
        if (areas == null) {
            if (log.isDebugEnabled()) {
                for (MapLine mapLine : this.lines) {
                    if (mapLine.getMinResolution() > this.areaResolution) continue;
                    log.debug("line. locn=", mapLine.getPoints().get(0).toOSMURL(), " type=", GType.formatType(mapLine.getType()), " name=", mapLine.getName(), "min=", mapLine.getMinResolution(), "max=", mapLine.getMaxResolution());
                }
                for (MapShape mapShape : this.shapes) {
                    if (mapShape.getMinResolution() > this.areaResolution) continue;
                    log.debug("shape. locn=", mapShape.getPoints().get(0).toOSMURL(), " type=", GType.formatType(mapShape.getType()), " name=", mapShape.getName(), "min=", mapShape.getMinResolution(), "max=", mapShape.getMaxResolution(), " full=", mapShape.getFullArea(), " calc=", ShapeMergeFilter.calcAreaSizeTestVal(mapShape.getPoints()));
                }
            }
            return null;
        }
        MapArea[] mapAreas = new MapArea[nx * ny];
        log.info("Splitting area " + bounds + " into " + nx + "x" + ny + " pieces at resolution " + this.areaResolution, tooSmallToDivide);
        ArrayList<MapArea> arrayList = new ArrayList<MapArea>();
        for (int i = 0; i < mapAreas.length; ++i) {
            mapAreas[i] = new MapArea(areas[i], this.areaResolution, this.splitPolygonsIntoArea);
            if (!log.isDebugEnabled()) continue;
            log.debug("area before", mapAreas[i].getBounds());
        }
        int xbaseHp = areas[0].getMinLong() << 6;
        int ybaseHp = areas[0].getMinLat() << 6;
        int dxHp = areas[0].getWidth() << 6;
        int dyHp = areas[0].getHeight() << 6;
        int maxSize = Math.min(0xFFFFFF, Math.max(Short.MAX_VALUE << 24 - this.areaResolution, 32768));
        int maxWidth = Math.max(Math.min(areas[0].getWidth(), maxSize / 2), 16384);
        int maxHeight = Math.max(Math.min(areas[0].getHeight(), maxSize / 2), 16384);
        if (tooSmallToDivide) {
            this.distShapesIntoNewAreas(arrayList, mapAreas[0]);
        } else {
            for (MapShape e : this.shapes) {
                Area shapeBounds = e.getBounds();
                if (this.splitPolygonsIntoArea || shapeBounds.getMaxDimension() > maxSize) {
                    this.splitIntoAreas(mapAreas, e);
                    continue;
                }
                areaIndex = MapArea.pickArea(mapAreas, e, xbaseHp, ybaseHp, nx, ny, dxHp, dyHp);
                if (areas[areaIndex].contains(shapeBounds)) {
                    mapAreas[areaIndex].addShape(e);
                    continue;
                }
                if (shapeBounds.getHeight() <= maxHeight && shapeBounds.getWidth() <= maxWidth) {
                    mapAreas[areaIndex].addShape(e);
                    continue;
                }
                largeObjectArea = new MapArea(shapeBounds, this.areaResolution, true);
                largeObjectArea.addShape(e);
                arrayList.add(largeObjectArea);
            }
        }
        if (tooSmallToDivide) {
            this.distPointsIntoNewAreas(arrayList, mapAreas[0]);
        } else {
            for (MapPoint p : this.points) {
                int areaIndex2 = MapArea.pickArea(mapAreas, p, xbaseHp, ybaseHp, nx, ny, dxHp, dyHp);
                mapAreas[areaIndex2].addPoint(p);
            }
        }
        if (tooSmallToDivide) {
            this.distLinesIntoNewAreas(arrayList, mapAreas[0]);
        } else {
            for (MapLine l : this.lines) {
                if (!(l instanceof MapRoad) && l.getRect().height <= 0 && l.getRect().width <= 0) continue;
                Area lineBounds = l.getBounds();
                areaIndex = MapArea.pickArea(mapAreas, l, xbaseHp, ybaseHp, nx, ny, dxHp, dyHp);
                if (!(lineBounds.getHeight() <= maxHeight && lineBounds.getWidth() <= maxWidth || areas[areaIndex].contains(lineBounds))) {
                    largeObjectArea = new MapArea(lineBounds, this.areaResolution, false);
                    largeObjectArea.addLine(l);
                    arrayList.add(largeObjectArea);
                    continue;
                }
                mapAreas[areaIndex].addLine(l);
            }
        }
        if (!arrayList.isEmpty()) {
            int pos = mapAreas.length;
            mapAreas = Arrays.copyOf(mapAreas, mapAreas.length + arrayList.size());
            for (MapArea ma : arrayList) {
                if (ma.getBounds() == null) {
                    ma.setBounds(ma.getFullBounds());
                }
                mapAreas[pos++] = ma;
            }
        }
        return mapAreas;
    }

    private void distPointsIntoNewAreas(List<MapArea> addedAreas, MapArea primaryArea) {
        MapArea extraArea = primaryArea;
        for (MapPoint p : this.points) {
            if (p.getMinResolution() > this.areaResolution) {
                primaryArea.addPoint(p);
                continue;
            }
            if (!extraArea.canAddSize(p, 0)) {
                extraArea = new MapArea((Area)null, this.areaResolution, false);
                addedAreas.add(extraArea);
            }
            extraArea.addPoint(p);
        }
    }

    private void distLinesIntoNewAreas(List<MapArea> addedAreas, MapArea primaryArea) {
        MapArea extraArea = primaryArea;
        for (MapLine l : this.lines) {
            if (l.getMinResolution() > this.areaResolution) {
                primaryArea.addLine(l);
                continue;
            }
            if (!extraArea.canAddSize(l, 1)) {
                extraArea = new MapArea((Area)null, this.areaResolution, false);
                addedAreas.add(extraArea);
            }
            extraArea.addLine(l);
        }
    }

    private void distShapesIntoNewAreas(List<MapArea> addedAreas, MapArea primaryArea) {
        MapArea extraArea = primaryArea;
        for (MapShape e : this.shapes) {
            if (e.getMinResolution() > this.areaResolution) {
                primaryArea.addShape(e);
                continue;
            }
            if (!extraArea.canAddSize(e, 2)) {
                extraArea = new MapArea((Area)null, this.areaResolution, true);
                addedAreas.add(extraArea);
            }
            extraArea.addShape(e);
        }
    }

    public Area getFullBounds() {
        return new Area(this.minLat, this.minLon, this.maxLat, this.maxLon);
    }

    public int[] getEstimatedSizes() {
        return this.sizes;
    }

    @Override
    public Area getBounds() {
        return this.bounds;
    }

    public void setBounds(Area actualBounds) {
        this.bounds = actualBounds;
    }

    @Override
    public List<MapPoint> getPoints() {
        return this.points;
    }

    @Override
    public List<MapLine> getLines() {
        return this.lines;
    }

    @Override
    public List<MapShape> getShapes() {
        return this.shapes;
    }

    @Override
    public RoadNetwork getRoadNetwork() {
        return null;
    }

    @Override
    public List<Overview> getOverviews() {
        return null;
    }

    public boolean hasPoints() {
        return this.nActivePoints > 0;
    }

    public boolean hasIndPoints() {
        return this.nActiveIndPoints > 0;
    }

    public boolean hasLines() {
        return this.nActiveLines > 0;
    }

    public int getNumLines() {
        return this.nActiveLines;
    }

    public int getNumShapes() {
        return this.nActiveShapes;
    }

    public int getNumPoints() {
        return this.nActivePoints + this.nActiveIndPoints;
    }

    public boolean hasShapes() {
        return this.nActiveShapes > 0;
    }

    public boolean canSplit() {
        return this.splittableCount > 1;
    }

    private void addSize(MapElement el, int kind) {
        int res = el.getMinResolution();
        if (res > this.areaResolution || res > 24) {
            return;
        }
        ++this.splittableCount;
        switch (kind) {
            case 0: 
            case 3: {
                int n = kind;
                this.sizes[n] = this.sizes[n] + 9;
                if (el.hasExtendedType()) break;
                if (((MapPoint)el).isCity()) {
                    ++this.nActiveIndPoints;
                    break;
                }
                ++this.nActivePoints;
                break;
            }
            case 1: 
            case 4: {
                int numPoints = PredictFilterPoints.predictedMaxNumPoints(((MapLine)el).getPoints(), this.areaResolution, ((MapLine)el).isRoad() && this.areaResolution == 24);
                if (numPoints <= 1 && !((MapLine)el).isRoad()) {
                    return;
                }
                int numElements = 1 + (numPoints - 1) / 250;
                int n = kind;
                this.sizes[n] = this.sizes[n] + (numElements * 11 + numPoints * 4);
                if (el.hasExtendedType()) break;
                this.nActiveLines += numElements;
                break;
            }
            case 2: 
            case 5: {
                ++this.splittableCount;
                int numPoints = PredictFilterPoints.predictedMaxNumPoints(((MapShape)el).getPoints(), this.areaResolution, false);
                if (numPoints <= 3) {
                    return;
                }
                int numElements = 1 + (numPoints - 1) / 250;
                int n = kind;
                this.sizes[n] = this.sizes[n] + (numElements * 11 + numPoints * 4);
                if (el.hasExtendedType()) break;
                this.nActiveShapes += numElements;
                break;
            }
            default: {
                log.error((Object)"should not be here");
                assert (false);
                break;
            }
        }
    }

    private boolean canAddSize(MapElement el, int kind) {
        int sumSize = 0;
        for (int s : this.sizes) {
            sumSize += s;
        }
        switch (kind) {
            case 0: {
                if (this.getNumPoints() >= 255) {
                    return false;
                }
                if (sumSize + 9 <= 16383) break;
                return false;
            }
            case 1: {
                int numPoints = PredictFilterPoints.predictedMaxNumPoints(((MapLine)el).getPoints(), this.areaResolution, ((MapLine)el).isRoad() && this.areaResolution == 24);
                if (numPoints <= 1 && !((MapLine)el).isRoad()) break;
                int numElements = 1 + (numPoints - 1) / 250;
                if (this.getNumLines() + numElements > 255) {
                    return false;
                }
                if (sumSize + numElements * 11 + numPoints * 4 <= 16383) break;
                return false;
            }
            case 2: {
                int numElements;
                int numPoints = PredictFilterPoints.predictedMaxNumPoints(((MapShape)el).getPoints(), this.areaResolution, false);
                if (numPoints <= 3 || sumSize + (numElements = 1 + (numPoints - 1) / 250) * 11 + numPoints * 4 <= 16383) break;
                return false;
            }
        }
        return true;
    }

    private void addPoint(MapPoint p) {
        this.points.add(p);
        this.addToBounds(p.getLocation());
        this.addSize(p, p.hasExtendedType() ? 3 : 0);
    }

    private void addLine(MapLine l) {
        this.lines.add(l);
        this.addToBounds(l.getBounds());
        this.addSize(l, l.hasExtendedType() ? 4 : 1);
    }

    private void addShape(MapShape s) {
        this.shapes.add(s);
        this.addToBounds(s.getBounds());
        this.addSize(s, s.hasExtendedType() ? 5 : 2);
    }

    private void addToBounds(Area a) {
        int l = a.getMinLat();
        if (l < this.minLat) {
            this.minLat = l;
        }
        if ((l = a.getMaxLat()) > this.maxLat) {
            this.maxLat = l;
        }
        if ((l = a.getMinLong()) < this.minLon) {
            this.minLon = l;
        }
        if ((l = a.getMaxLong()) > this.maxLon) {
            this.maxLon = l;
        }
    }

    private void addToBounds(Coord co) {
        int lonHp;
        int lonLeft;
        int lonRight;
        int latUpper;
        int latHp = co.getHighPrecLat();
        int latLower = latHp >> 6;
        int n = latUpper = latLower << 6 < latHp ? latLower + 1 : latLower;
        if (latLower < this.minLat) {
            this.minLat = latLower;
        }
        if (latUpper > this.maxLat) {
            this.maxLat = latUpper;
        }
        int n2 = lonRight = (lonLeft = (lonHp = co.getHighPrecLon()) >> 6) << 6 < lonHp ? lonLeft + 1 : lonLeft;
        if (lonLeft < this.minLon) {
            this.minLon = lonLeft;
        }
        if (lonRight > this.maxLon) {
            this.maxLon = lonRight;
        }
    }

    private static int pickArea(MapArea[] areas, MapElement e, int xbaseHp, int ybaseHp, int nx, int ny, int dxHp, int dyHp) {
        int x = e.getLocation().getHighPrecLon();
        int y = e.getLocation().getHighPrecLat();
        int xcell = (x - xbaseHp) / dxHp;
        int ycell = (y - ybaseHp) / dyHp;
        if (xcell < 0) {
            log.info("xcell was", xcell, "x", x, "xbase", xbaseHp);
            xcell = 0;
        }
        if (ycell < 0) {
            log.info("ycell was", ycell, "y", y, "ybase", ybaseHp);
            ycell = 0;
        }
        if (xcell >= nx) {
            xcell = nx - 1;
        }
        if (ycell >= ny) {
            ycell = ny - 1;
        }
        if (log.isDebugEnabled()) {
            log.debug("adding", e.getLocation(), "to", xcell, "/", ycell, areas[xcell * ny + ycell].getBounds());
        }
        return xcell * ny + ycell;
    }

    private void splitIntoAreas(MapArea[] areas, MapShape e) {
        if (areas.length == 1) {
            areas[0].addShape(e);
            return;
        }
        Area shapeBounds = e.getBounds();
        int xtra = 2;
        if (Math.min(shapeBounds.getWidth(), shapeBounds.getHeight()) > 8) {
            xtra = -2;
        }
        shapeBounds = new Area(shapeBounds.getMinLat() - xtra, shapeBounds.getMinLong() - xtra, shapeBounds.getMaxLat() + xtra, shapeBounds.getMaxLong() + xtra);
        for (int areaIndex = 0; areaIndex < areas.length; ++areaIndex) {
            if (!areas[areaIndex].getBounds().contains(shapeBounds)) continue;
            areas[areaIndex].addShape(e);
            return;
        }
        if (this.areasHashMap == null) {
            this.areasHashMap = new Long2ObjectOpenHashMap();
        }
        int stepLat = 0;
        if (areas[0].getBounds().getMaxLat() == areas[1].getBounds().getMinLat()) {
            stepLat = 1;
        } else if (areas[0].getBounds().getMaxLong() == areas[1].getBounds().getMinLong()) {
            stepLat = areas.length;
        } else {
            log.error((Object)"SplitIntoAreas expects shared edge between the subDivs");
        }
        if (stepLat != 0) {
            int dimLat = stepLat == 1 ? areas.length : 1;
            for (int areaIndex = 2; areaIndex < areas.length; ++areaIndex) {
                if (stepLat == 1) {
                    if (areas[areaIndex - 1].getBounds().getMaxLat() == areas[areaIndex].getBounds().getMinLat()) continue;
                    dimLat = areaIndex;
                    break;
                }
                if (areas[areaIndex - 1].getBounds().getMaxLong() == areas[areaIndex].getBounds().getMinLong()) continue;
                stepLat = areaIndex;
                dimLat = areas.length / areaIndex;
                break;
            }
            MapArea.splitIntoRows(e, areas, stepLat, dimLat, this.areasHashMap);
            return;
        }
        for (int areaIndex = 0; areaIndex < areas.length; ++areaIndex) {
            List<List<Coord>> subShapePoints = ShapeSplitter.clipToBounds(e.getPoints(), areas[areaIndex].getBounds(), this.areasHashMap);
            for (List<Coord> subShape : subShapePoints) {
                MapShape s = e.copy();
                s.setPoints(subShape);
                s.setClipped(true);
                areas[areaIndex].addShape(s);
            }
        }
    }

    private static void splitIntoRows(MapShape e, MapArea[] areas, int stepLat, int dimLat, Long2ObjectOpenHashMap<Coord> areasHashMap) {
        int dimLong = areas.length / dimLat;
        int stepLong = stepLat == 1 ? dimLat : 1;
        List<List<Coord>> pendList = Collections.singletonList(e.getPoints());
        for (int inx = 1; inx < dimLat; ++inx) {
            int areaIndex = inx * stepLat;
            int dividingLine = areas[areaIndex].getBounds().getMinLat();
            ArrayList<List<Coord>> lessList = new ArrayList<List<Coord>>();
            ArrayList<List<Coord>> moreList = new ArrayList<List<Coord>>();
            for (List<Coord> subShape : pendList) {
                ShapeSplitter.splitShape(subShape, dividingLine << 6, false, lessList, moreList, areasHashMap);
            }
            if (!lessList.isEmpty()) {
                MapArea.splitIntoCols(lessList, areas, areaIndex - stepLat, stepLong, dimLong, areasHashMap, e);
            }
            if (moreList.isEmpty()) {
                return;
            }
            pendList = moreList;
        }
        MapArea.splitIntoCols(pendList, areas, (dimLat - 1) * stepLat, stepLong, dimLong, areasHashMap, e);
    }

    private static void splitIntoCols(List<List<Coord>> rowList, MapArea[] areas, int startInx, int stepLong, int dimLong, Long2ObjectOpenHashMap<Coord> areasHashMap, MapShape template) {
        List<List<Coord>> pendList = rowList;
        for (int inx = 1; inx < dimLong; ++inx) {
            int areaIndex = startInx + inx * stepLong;
            int dividingLine = areas[areaIndex].getBounds().getMinLong();
            ArrayList<List<Coord>> lessList = new ArrayList<List<Coord>>();
            ArrayList<List<Coord>> moreList = new ArrayList<List<Coord>>();
            for (List<Coord> subShape : pendList) {
                ShapeSplitter.splitShape(subShape, dividingLine << 6, true, lessList, moreList, areasHashMap);
            }
            if (!lessList.isEmpty()) {
                MapArea.saveParts(lessList, areas[areaIndex - stepLong], template);
            }
            if (moreList.isEmpty()) {
                return;
            }
            pendList = moreList;
        }
        MapArea.saveParts(pendList, areas[startInx + (dimLong - 1) * stepLong], template);
    }

    private static void saveParts(List<List<Coord>> cellList, MapArea area, MapShape template) {
        for (List<Coord> subShape : cellList) {
            MapShape s = template.copy();
            s.setPoints(subShape);
            s.setClipped(true);
            area.addShape(s);
        }
    }

    public boolean hasData() {
        return !this.points.isEmpty() || !this.lines.isEmpty() || !this.shapes.isEmpty();
    }

    public String toString() {
        return "MapArea [res=" + this.areaResolution + ", width=" + this.bounds.getWidth() + ", height=" + this.bounds.getHeight() + ", sizes=" + Arrays.toString(this.sizes) + "]";
    }
}

