/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.HashSet;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.Option;
import uk.me.parabola.mkgmap.OptionProcessor;
import uk.me.parabola.mkgmap.scan.TokType;
import uk.me.parabola.mkgmap.scan.Token;
import uk.me.parabola.mkgmap.scan.TokenScanner;

public class Options {
    private static final Logger log = Logger.getLogger(Options.class);
    private final OptionProcessor proc;
    private final Collection<String> readFiles = new HashSet<String>();

    public Options(OptionProcessor proc) {
        this.proc = proc;
    }

    public void readOptionFile(String filename) throws IOException {
        log.info("reading option file", filename);
        File file = new File(filename);
        try {
            String path = file.getCanonicalPath();
            if (this.readFiles.contains(path)) {
                return;
            }
            this.readFiles.add(path);
        }
        catch (IOException e) {
            log.warn((Object)"the config file could not be read");
            return;
        }
        try (InputStreamReader r = new InputStreamReader(new FileInputStream(filename));){
            this.readOptionFile(r, filename);
        }
    }

    public void readOptionFile(Reader r, String filename) {
        BufferedReader br = r instanceof BufferedReader ? (BufferedReader)r : new BufferedReader(r);
        TokenScanner ts = new TokenScanner(filename, br);
        ts.setExtraWordChars("-");
        if (r instanceof InputStreamReader) {
            ts.setCharset(((InputStreamReader)r).getEncoding());
        }
        File file = new File(filename);
        String parent = file.getParent();
        while (!ts.isEndOfFile()) {
            Token tok = ts.nextToken();
            if (tok.isValue("#")) {
                ts.skipLine();
                continue;
            }
            String key = tok.getValue();
            ts.skipSpace();
            tok = ts.peekToken();
            if (tok.getType() == TokType.SYMBOL) {
                String val;
                String punc = ts.nextValue();
                if (":".equals(punc) || "=".equals(punc)) {
                    val = ts.readLine();
                } else if ("{".equals(punc)) {
                    ts.skipSpace();
                    val = ts.readUntil(TokType.SYMBOL, "}");
                    ts.nextToken();
                } else {
                    ts.skipLine();
                    continue;
                }
                if ("input-file".equals(key) && !new File(val).isAbsolute()) {
                    val = new File(parent, val).getPath();
                }
                this.proc.processOption(new Option(key, val));
                continue;
            }
            if (key != null) {
                this.proc.processOption(new Option(key, ""));
                continue;
            }
            ts.skipLine();
        }
    }
}

