/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.sys;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import uk.me.parabola.imgfmt.FileSystemParam;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.labelenc.CharacterEncoder;
import uk.me.parabola.imgfmt.app.labelenc.CodeFunctions;
import uk.me.parabola.imgfmt.app.labelenc.EncodedText;
import uk.me.parabola.imgfmt.fs.ImgChannel;
import uk.me.parabola.log.Logger;

class ImgHeader {
    private static final Logger log = Logger.getLogger(ImgHeader.class);
    private static final int OFF_XOR = 0;
    private static final int OFF_VERSION = 8;
    private static final int OFF_UPDATE_MONTH = 10;
    private static final int OFF_UPDATE_YEAR = 11;
    private static final int OFF_SUPP = 14;
    private static final int OFF_CHECKSUM = 15;
    private static final int OFF_SIGNATURE = 16;
    private static final int OFF_UNK_1 = 23;
    private static final int OFF_SECTORS = 24;
    private static final int OFF_HEADS = 26;
    private static final int OFF_CYLINDERS = 28;
    private static final int OFF_CREATION_DATE = 57;
    private static final int OFF_DIRECTORY_START_BLOCK = 64;
    private static final int OFF_MAP_FILE_INTENTIFIER = 65;
    private static final int OFF_MAP_DESCRIPTION = 73;
    private static final int OFF_HEADS2 = 93;
    private static final int OFF_SECTORS2 = 95;
    private static final int OFF_BLOCK_SIZE_EXPONENT1 = 97;
    private static final int OFF_BLOCK_SIZE_EXPONENT2 = 98;
    private static final int OFF_BLOCK_SIZE = 99;
    private static final int OFF_MAP_NAME_CONT = 101;
    private static final int OFF_START_HEAD = 447;
    private static final int OFF_START_SECTOR = 448;
    private static final int OFF_START_CYLINDER = 449;
    private static final int OFF_SYSTEM_TYPE = 450;
    private static final int OFF_END_HEAD = 451;
    private static final int OFF_END_SECTOR = 452;
    private static final int OFF_END_CYLINDER = 453;
    private static final int OFF_REL_SECTORS = 454;
    private static final int OFF_NUMBER_OF_SECTORS = 458;
    private static final int OFF_PARTITION_SIG = 510;
    private static final int LEN_MAP_NAME_CONT = 30;
    private static final int LEN_MAP_DESCRIPTION = 20;
    private FileSystemParam fsParams;
    private final ByteBuffer header = ByteBuffer.allocate(512);
    private ImgChannel file;
    private Date creationTime;
    private int sectorsPerTrack;
    private int headsPerCylinder;
    private static final byte[] FILE_ID = new byte[]{71, 65, 82, 77, 73, 78, 0};
    private static final byte[] SIGNATURE = new byte[]{68, 83, 75, 73, 77, 71, 0};
    private int numBlocks;

    ImgHeader(ImgChannel chan) {
        this.file = chan;
        this.header.order(ByteOrder.LITTLE_ENDIAN);
    }

    void createHeader(FileSystemParam params) {
        this.fsParams = params;
        this.header.put(0, (byte)0);
        int exp = 9;
        int bs = params.getBlockSize();
        for (int i = 0; i < 32; ++i) {
            if ((bs >>>= 1) != 0) continue;
            exp = i;
            break;
        }
        if (exp < 9) {
            throw new IllegalArgumentException("block size too small");
        }
        this.header.put(97, (byte)9);
        this.header.put(98, (byte)(exp - 9));
        this.header.position(16);
        this.header.put(SIGNATURE);
        this.header.position(65);
        this.header.put(FILE_ID);
        this.header.put(23, (byte)2);
        this.header.put(64, (byte)this.fsParams.getDirectoryStartEntry());
        this.header.position(57);
        Utils.setCreationTime(this.header, this.creationTime);
        this.setDirectoryStartEntry(params.getDirectoryStartEntry());
        Date date = new Date();
        this.setCreationTime(date);
        this.setUpdateTime(date);
        this.setDescription(params.getMapDescription());
        if (this.fsParams.isGmapsupp()) {
            this.header.put(14, (byte)(this.fsParams.isHideGmapsuppOnPC() ? 1 : 0));
            int prodVersion = this.fsParams.getProductVersion();
            if (prodVersion >= 0) {
                int major = prodVersion / 100;
                int minor = prodVersion % 100;
                short version = (short)(major | minor << 8);
                this.header.putShort(8, version);
            }
        }
        this.header.put(15, (byte)0);
    }

    private void writeSizeValues(int blockSize) {
        int endSector = (int)((((long)this.numBlocks + 1L) * (long)blockSize + 511L) / 512L);
        this.sectorsPerTrack = 32;
        this.headsPerCylinder = 128;
        int cyls = 1024;
        block0: for (int h : Arrays.asList(16, 32, 64, 128, 256)) {
            for (int s : Arrays.asList(4, 8, 16, 32)) {
                for (int c : Arrays.asList(32, 64, 128, 256, 512, 1023)) {
                    log.info("shc=", s + "," + h + "," + c, "end=", endSector);
                    if (s * h * c <= endSector) continue;
                    this.headsPerCylinder = h;
                    this.sectorsPerTrack = s;
                    cyls = c;
                    break block0;
                }
            }
        }
        this.header.putShort(24, (short)this.sectorsPerTrack);
        this.header.putShort(95, (short)this.sectorsPerTrack);
        this.header.putShort(26, (short)this.headsPerCylinder);
        this.header.putShort(93, (short)this.headsPerCylinder);
        this.header.putShort(28, (short)cyls);
        int blocks = (int)((long)endSector * 512L / (long)blockSize);
        char shortBlocks = (char)(blocks > 65535 ? 65535 : (char)blocks);
        this.header.putChar(99, shortBlocks);
        this.header.put(510, (byte)85);
        this.header.put(511, (byte)-86);
        this.header.put(447, (byte)0);
        this.header.put(448, (byte)1);
        this.header.put(449, (byte)0);
        this.header.put(450, (byte)0);
        CHS chs = new CHS(endSector - 1);
        this.header.put(451, (byte)chs.h);
        this.header.put(452, (byte)(chs.s | chs.c >> 2 & 0xC0));
        this.header.put(453, (byte)(chs.c & 0xFF));
        this.header.putInt(454, 0);
        this.header.putInt(458, endSector);
        log.info("number of blocks", endSector - 1);
    }

    void setHeader(ByteBuffer buf) {
        buf.flip();
        this.header.put(buf);
        byte exp1 = this.header.get(97);
        byte exp2 = this.header.get(98);
        log.debug("header exponent", exp1, exp2);
        this.fsParams = new FileSystemParam();
        this.fsParams.setBlockSize(1 << exp1 + exp2);
        this.fsParams.setDirectoryStartEntry(this.header.get(64));
        StringBuffer sb = new StringBuffer();
        sb.append(Utils.bytesToString(buf, 73, 20));
        sb.append(Utils.bytesToString(buf, 101, 30));
        this.fsParams.setMapDescription(sb.toString().trim());
        byte h = this.header.get(451);
        byte sc1 = this.header.get(452);
        byte sc2 = this.header.get(453);
        CHS chs = new CHS();
        chs.setFromPartition(h, sc1, sc2);
        int lba = chs.toLba();
        log.info("partition sectors", lba);
    }

    void setFile(ImgChannel file) {
        this.file = file;
    }

    FileSystemParam getParams() {
        return this.fsParams;
    }

    public void sync() throws IOException {
        this.setUpdateTime(new Date());
        this.writeSizeValues(this.fsParams.getBlockSize());
        this.header.rewind();
        this.file.position(0L);
        this.file.write(this.header);
        this.file.position((long)this.fsParams.getDirectoryStartEntry() * 512L);
    }

    protected void setUpdateTime(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        this.header.put(11, ImgHeader.toYearCode(cal.get(1)));
        this.header.put(10, (byte)(cal.get(2) + 1));
    }

    protected void setDescription(String desc) {
        CodeFunctions funcs = CodeFunctions.createEncoderForLBL(0, 0);
        CharacterEncoder encoder = funcs.getEncoder();
        EncodedText enc = encoder.encodeText(desc);
        byte[] ctext = enc.getCtext();
        int len = enc.getLength() - 1;
        if (len > 50) {
            throw new IllegalArgumentException("Description is too long (max 50)");
        }
        byte[] part1 = new byte[20];
        Arrays.fill(part1, (byte)32);
        byte[] part2 = new byte[30];
        Arrays.fill(part2, (byte)32);
        if (ctext != null) {
            if (len > 20) {
                System.arraycopy(ctext, 0, part1, 0, 20);
                System.arraycopy(ctext, 20, part2, 0, len - 20);
            } else {
                System.arraycopy(ctext, 0, part1, 0, len);
            }
        }
        this.header.position(73);
        this.header.put(part1);
        this.header.position(101);
        this.header.put(part2);
        this.header.put((byte)0);
    }

    private static byte toYearCode(int y) {
        return (byte)(y - 1900);
    }

    protected void setDirectoryStartEntry(int directoryStartEntry) {
        this.header.put(64, (byte)directoryStartEntry);
        this.fsParams.setDirectoryStartEntry(directoryStartEntry);
    }

    protected void setCreationTime(Date date) {
        this.creationTime = date;
    }

    public void setNumBlocks(int numBlocks) {
        this.numBlocks = numBlocks;
    }

    public void hideGmapsuppOnPC(boolean b) {
        this.header.put(14, (byte)(this.fsParams.isGmapsupp() && b ? 1 : 0));
    }

    private class CHS {
        private int h;
        private int s;
        private int c;

        private CHS() {
        }

        public CHS(int lba) {
            this.toChs(lba);
        }

        private void toChs(int lba) {
            this.h = lba / ImgHeader.this.sectorsPerTrack % ImgHeader.this.headsPerCylinder;
            this.s = lba % ImgHeader.this.sectorsPerTrack + 1;
            this.c = lba / (ImgHeader.this.sectorsPerTrack * ImgHeader.this.headsPerCylinder);
        }

        public void setFromPartition(byte h, byte sc1, byte sc2) {
            this.h = h;
            this.s = (sc1 & 0x3F) + (sc2 >> 2 & 0xC0);
            this.c = sc2 & 0xFF;
        }

        public int toLba() {
            return (this.c * ImgHeader.this.headsPerCylinder + this.h) * ImgHeader.this.sectorsPerTrack + (this.s - 1);
        }
    }
}

