/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.trergn;

import uk.me.parabola.imgfmt.app.ImgFileWriter;

public abstract class Overview
implements Comparable<Overview> {
    public static final int POINT_KIND = 1;
    public static final int LINE_KIND = 2;
    public static final int SHAPE_KIND = 3;
    private final int kind;
    private final int extType;
    private final int type;
    private final int subType;
    private final int minResolution;
    private final int size;
    private int maxLevel;

    protected Overview(int kind, int fullType, int minres) {
        this.kind = kind;
        this.extType = fullType >> 16;
        this.type = fullType >> 8 & 0xFF;
        this.subType = fullType & 0xFF;
        this.minResolution = minres;
        this.size = kind == 1 ? 3 : 2;
    }

    public void write(ImgFileWriter file) {
        if (this.extType == 0) {
            file.put1u(this.type);
            file.put1u(this.maxLevel);
            if (this.size > 2) {
                file.put1u(this.subType);
            }
        } else {
            file.put1u(this.type);
            file.put1u(this.maxLevel);
            file.put1u(this.subType);
            file.put1u(0);
        }
    }

    public int hashCode() {
        return (this.kind << 7) + (this.type << 3) + this.subType;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Overview)) {
            return false;
        }
        Overview ov = (Overview)obj;
        return ov.kind == this.kind && ov.extType == this.extType && ov.type == this.type && ov.subType == this.subType;
    }

    public int getKind() {
        return this.kind;
    }

    @Override
    public int compareTo(Overview ov) {
        if (this.kind != ov.kind) {
            return this.kind > ov.kind ? 1 : -1;
        }
        if (this.extType != ov.extType) {
            return this.extType > ov.extType ? 1 : -1;
        }
        int res = this.type == ov.type ? (this.subType == ov.subType ? 0 : (this.subType > ov.subType ? 1 : -1)) : (this.type == ov.type ? 0 : (this.type > ov.type ? 1 : -1));
        return res;
    }

    public void setMaxLevel(int maxLevel) {
        this.maxLevel = maxLevel;
    }

    public int getMinResolution() {
        return this.minResolution;
    }

    public boolean hasExtType() {
        return this.extType != 0;
    }
}

