/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.srt;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uk.me.parabola.imgfmt.app.BufferedImgFileReader;
import uk.me.parabola.imgfmt.app.ImgFile;
import uk.me.parabola.imgfmt.app.ImgFileReader;
import uk.me.parabola.imgfmt.app.Section;
import uk.me.parabola.imgfmt.app.labelenc.CharacterDecoder;
import uk.me.parabola.imgfmt.app.labelenc.CodeFunctions;
import uk.me.parabola.imgfmt.app.srt.CodePosition;
import uk.me.parabola.imgfmt.app.srt.SRTFile;
import uk.me.parabola.imgfmt.app.srt.SRTHeader;
import uk.me.parabola.imgfmt.app.srt.Sort;
import uk.me.parabola.imgfmt.fs.DirectoryEntry;
import uk.me.parabola.imgfmt.fs.FileSystem;
import uk.me.parabola.imgfmt.fs.ImgChannel;
import uk.me.parabola.imgfmt.sys.FileImgChannel;
import uk.me.parabola.imgfmt.sys.ImgFS;

public class SrtFileReader
extends ImgFile {
    private Sort sort;
    private final CharacterDecoder decoder;
    private SRTHeader header = new SRTHeader();
    private Section description = new Section();
    private Section tableHeader = new Section();
    private Section characterTable = new Section();
    private Section srt5 = new Section();
    private Section srt6 = new Section();
    private Section srt7 = new Section();
    private Section srt8 = new Section();
    private int countExp;
    private final Map<Integer, Integer> offsetToBlock = new HashMap<Integer, Integer>();

    public SrtFileReader(ImgChannel chan) {
        CodeFunctions funcs = CodeFunctions.createEncoderForLBL("latin1");
        this.decoder = funcs.getDecoder();
        this.sort = new Sort();
        this.setHeader(this.header);
        this.setReader(new BufferedImgFileReader(chan));
        this.header.readHeader(this.getReader());
        this.sort.setHeaderLen(this.header.getHeaderLength());
        this.readSrt1();
        this.readDesc();
        this.readTableHeader();
    }

    private void readTableHeader() {
        ImgFileReader reader = this.getReader();
        reader.position(this.tableHeader.getPosition());
        int len = reader.get2u();
        this.sort.setHeader3Len(len);
        this.sort.setId1(reader.get2u());
        this.sort.setId2(reader.get2u());
        this.sort.setCodepage(reader.get2u());
        if (this.sort.getCodepage() == 65001) {
            this.sort.setMulti(true);
        }
        reader.get4();
        this.characterTable.readSectionInfo(reader, true);
        reader.position(reader.position() + 6L);
        this.srt5.readSectionInfo(reader, true);
        reader.position(reader.position() + 6L);
        if (len > 44) {
            this.srt6.readSectionInfo(reader, false);
        }
        if (len > 52) {
            reader.get4();
            int maxCodeBlock = reader.get4();
            this.sort.setMaxPage(maxCodeBlock);
            this.srt7.readSectionInfo(reader, true);
            reader.position(reader.position() + 6L);
        }
        if (len > 68) {
            this.srt8.readSectionInfo(reader, true);
        }
        this.readCharacterTable();
        if (this.srt7.getSize() > 0) {
            this.readSrt7();
            this.readSrt8();
        }
        this.readExpansions();
    }

    private void readSrt7() {
        ImgFileReader reader = this.getReader();
        reader.position(this.tableHeader.getPosition() + this.srt7.getPosition());
        int block = 1;
        for (int i = 0; i < this.srt7.getNumItems(); ++i) {
            int val = reader.get4();
            if (val >= 0) {
                this.offsetToBlock.put(val / this.srt8.getItemSize(), block);
            }
            ++block;
        }
    }

    private void readSrt8() {
        ImgFileReader reader = this.getReader();
        reader.position(this.tableHeader.getPosition() + this.srt8.getPosition());
        int reclen = this.srt8.getItemSize();
        int block = 1;
        for (int i = 0; i < this.srt8.getNumItems(); ++i) {
            Integer nblock = this.offsetToBlock.get(i);
            if (nblock != null) {
                block = nblock;
            }
            int flags = reader.get1u();
            CodePosition cp = this.readCharPosition(reclen - 1);
            int ch = block * 256 + i % 256;
            if ((flags & 0xF0) != 0) {
                this.sort.add(ch, this.countExp + 1, 0, 0, flags);
                this.countExp += (flags >> 4 & 0xF) + 1;
                continue;
            }
            this.sort.add(ch, cp.getPrimary(), cp.getSecondary(), cp.getTertiary(), flags);
        }
    }

    private void readCharacterTable() {
        ImgFileReader reader = this.getReader();
        reader.position(this.characterTable.getPosition());
        int rs = this.characterTable.getItemSize();
        long start = this.tableHeader.getPosition() + this.characterTable.getPosition();
        reader.position(start);
        for (int ch = 1; ch <= this.characterTable.getNumItems(); ++ch) {
            int flags = reader.get1u();
            CodePosition cp = this.readCharPosition(rs - 1);
            if ((flags & 0xF0) != 0) {
                this.sort.add(ch, this.countExp + 1, 0, 0, flags);
                this.countExp += (flags >> 4 & 0xF) + 1;
                continue;
            }
            this.sort.add(ch, cp.getPrimary(), cp.getSecondary(), cp.getTertiary(), flags);
        }
    }

    private CodePosition readCharPosition(int posLength) {
        ImgFileReader reader = this.getReader();
        CodePosition cp = new CodePosition();
        if (posLength == 2) {
            int rec = reader.get2u();
            cp.setPrimary(rec & 0xFF);
            cp.setSecondary(rec >> 8 & 0xF);
            cp.setTertiary(rec >> 12 & 0xF);
        } else if (posLength == 3) {
            int rec = reader.get3u();
            cp.setPrimary(rec & 0xFF);
            cp.setSecondary(rec >> 8 & 0xF);
            cp.setTertiary(rec >> 12 & 0xF);
        } else if (posLength == 4) {
            int rec = reader.get4();
            cp.setPrimary(rec & 0xFFFF);
            cp.setSecondary(rec >> 16 & 0xFF);
            cp.setTertiary(rec >> 24 & 0xFF);
        } else {
            throw new RuntimeException("unexpected value posLength " + posLength);
        }
        return cp;
    }

    private void readExpansions() {
        ImgFileReader reader = this.getReader();
        int reclen = this.srt5.getItemSize();
        reader.position(this.tableHeader.getPosition() + this.srt5.getPosition());
        ArrayList<CodePosition> expansionList = new ArrayList<CodePosition>(this.srt5.getNumItems());
        if (this.countExp != this.srt5.getNumItems()) {
            throw new RuntimeException("unexpected number of expansions " + this.srt5.getNumItems() + " expected: " + this.countExp);
        }
        for (int i = 0; i < this.srt5.getNumItems(); ++i) {
            CodePosition cp = this.readCharPosition(reclen);
            expansionList.add(cp);
        }
        this.sort.setExpansions(expansionList);
    }

    private void readSrt1() {
        ImgFileReader reader = this.getReader();
        reader.position(this.header.getHeaderLength());
        this.description.readSectionInfo(reader, false);
        this.tableHeader.readSectionInfo(reader, false);
    }

    private void readDesc() {
        this.getReader().position(this.description.getPosition());
        byte[] zString = this.getReader().getZString();
        this.sort.setDescription(this.decodeToString(zString));
    }

    private String decodeToString(byte[] zString) {
        this.decoder.reset();
        for (byte b : zString) {
            this.decoder.addByte(b);
        }
        return this.decoder.getText().getText();
    }

    public Sort getSort() {
        return this.sort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        String infile = "we2.srt";
        if (args.length > 0) {
            infile = args[0];
        }
        String outfile = "out.srt";
        if (args.length > 1) {
            outfile = args[1];
        }
        try {
            Files.delete(Paths.get(outfile, ""));
        }
        catch (Exception exception) {
            // empty catch block
        }
        ImgChannel inChannel = null;
        try (FileSystem fs = null;){
            if (infile.endsWith("srt")) {
                inChannel = new FileImgChannel(infile, "r");
            } else {
                fs = ImgFS.openFs(infile);
                List<DirectoryEntry> entries = fs.list();
                String mapname = null;
                for (DirectoryEntry ent : entries) {
                    if (!"SRT".equals(ent.getExt())) continue;
                    mapname = ent.getName();
                    break;
                }
                inChannel = fs.open(mapname + ".SRT", "r");
                FileImgChannel chan = new FileImgChannel(outfile, "rw");
                SrtFileReader tr = new SrtFileReader(inChannel);
                tr.close();
                Sort sort1 = tr.getSort();
                SRTFile sf = new SRTFile(chan);
                sf.setSort(sort1);
                sf.write();
                sf.close();
                chan.close();
            }
        }
    }
}

