/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.net;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.BufferedImgFileWriter;
import uk.me.parabola.imgfmt.app.ImgFile;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.Label;
import uk.me.parabola.imgfmt.app.lbl.City;
import uk.me.parabola.imgfmt.app.lbl.Zip;
import uk.me.parabola.imgfmt.app.net.NETHeader;
import uk.me.parabola.imgfmt.app.net.RoadDef;
import uk.me.parabola.imgfmt.app.srt.DoubleSortKey;
import uk.me.parabola.imgfmt.app.srt.IntegerSortKey;
import uk.me.parabola.imgfmt.app.srt.MultiSortKey;
import uk.me.parabola.imgfmt.app.srt.Sort;
import uk.me.parabola.imgfmt.app.srt.SortKey;
import uk.me.parabola.imgfmt.fs.ImgChannel;

public class NETFile
extends ImgFile {
    private final NETHeader netHeader = new NETHeader();
    private List<RoadDef> roads;
    private Sort sort;

    public NETFile(ImgChannel chan) {
        this.setHeader(this.netHeader);
        this.setWriter(new BufferedImgFileWriter(chan, "NET"));
        this.position(55L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int numCities, int numZips) {
        ImgFileWriter writer = this.netHeader.makeRoadWriter(this.getWriter());
        try {
            for (RoadDef rd : this.roads) {
                rd.writeNet1(writer, numCities, numZips);
            }
        }
        finally {
            Utils.closeFile(writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePost(ImgFileWriter rgn) {
        for (RoadDef rd : this.roads) {
            rd.writeRgnOffsets(rgn);
        }
        ImgFileWriter writer = this.netHeader.makeSortedRoadWriter(this.getWriter());
        try {
            List<LabeledRoadDef> labeledRoadDefs = this.deDupRoads();
            this.sortByName(labeledRoadDefs);
            for (LabeledRoadDef labeledRoadDef : labeledRoadDefs) {
                labeledRoadDef.roadDef.putSortedRoadEntry(writer, labeledRoadDef.label);
            }
        }
        finally {
            Utils.closeFile(writer);
        }
        this.getHeader().writeHeader(this.getWriter());
    }

    private List<LabeledRoadDef> deDupRoads() {
        List<SortKey<LabeledRoadDef>> sortKeys = this.createSortKeysByNameAndCity();
        sortKeys.sort(null);
        ArrayList<LabeledRoadDef> out = new ArrayList<LabeledRoadDef>(sortKeys.size());
        ArrayList<LabeledRoadDef> dupes = new ArrayList<LabeledRoadDef>();
        SortKey<LabeledRoadDef> lastKey = null;
        for (SortKey<LabeledRoadDef> key : sortKeys) {
            if (lastKey == null || key.compareTo((LabeledRoadDef)((Object)lastKey)) != 0) {
                NETFile.analyseRoadsOfCity(dupes, out);
                dupes.clear();
                lastKey = key;
            }
            dupes.add(key.getObject());
        }
        NETFile.analyseRoadsOfCity(dupes, out);
        return out;
    }

    private List<SortKey<LabeledRoadDef>> createSortKeysByNameAndCity() {
        ArrayList<SortKey<LabeledRoadDef>> sortKeys = new ArrayList<SortKey<LabeledRoadDef>>(this.roads.size());
        for (RoadDef rd : this.roads) {
            Label[] labels = rd.getLabels();
            for (int i = 0; i < labels.length && labels[i] != null; ++i) {
                SortKey<Object> cityKey;
                City city;
                Label label = labels[i];
                if (label.getLength() == 0) continue;
                LabeledRoadDef lrd = new LabeledRoadDef(label, rd);
                IntegerSortKey<LabeledRoadDef> nameKey = new IntegerSortKey<LabeledRoadDef>(lrd, label.getOffset(), 0);
                City city2 = city = rd.getCities().isEmpty() ? null : rd.getCities().get(0);
                if (city != null) {
                    int region = city.getRegionNumber();
                    int country = city.getCountryNumber();
                    cityKey = this.sort.createSortKey(null, city.getLabel(), (region & 0xFFFF) << 16 | country & 0xFFFF);
                } else {
                    cityKey = this.sort.createSortKey(null, Label.NULL_OUT_LABEL, 0);
                }
                Zip zip = rd.getZips().isEmpty() ? null : rd.getZips().get(0);
                Label zipLabel = zip == null ? Label.NULL_OUT_LABEL : zip.getLabel();
                SortKey<Object> zipKey = this.sort.createSortKey(null, zipLabel);
                sortKeys.add(new MultiSortKey<Object>(nameKey, cityKey, zipKey));
            }
        }
        return sortKeys;
    }

    private void sortByName(List<LabeledRoadDef> roads) {
        ArrayList<DoubleSortKey<Object>> sortKeys = new ArrayList<DoubleSortKey<Object>>(roads.size());
        HashMap<Label, byte[]> cachePartial = new HashMap<Label, byte[]>();
        HashMap<Label, byte[]> cacheFull = new HashMap<Label, byte[]>();
        for (LabeledRoadDef labeledRoadDef : roads) {
            SortKey<LabeledRoadDef> sk1 = this.sort.createSortKeyPartial(labeledRoadDef, labeledRoadDef.label, 0, cachePartial);
            SortKey<Object> sk2 = this.sort.createSortKey(null, labeledRoadDef.label, 0, cacheFull);
            sortKeys.add(new DoubleSortKey<Object>(sk1, sk2));
        }
        sortKeys.sort(null);
        roads.clear();
        for (SortKey sortKey : sortKeys) {
            roads.add((LabeledRoadDef)sortKey.getObject());
        }
    }

    private static void analyseRoadsOfCity(List<LabeledRoadDef> in, List<LabeledRoadDef> out) {
        if (in.size() > 200) {
            NETFile.analyseRoadsOfCityLarge(in, out);
        } else {
            NETFile.analyseRoadsOfCitySmall(in, out);
        }
    }

    private static void analyseRoadsOfCitySmall(List<LabeledRoadDef> in, List<LabeledRoadDef> out) {
        if (in.size() < 2) {
            out.addAll(in);
        } else {
            in.sort((o1, o2) -> Boolean.compare(NETFile.needed(o2), NETFile.needed(o1)));
            int posOther = -1;
            for (int i = 0; i < in.size(); ++i) {
                if (!NETFile.needed(in.get(i))) {
                    posOther = i;
                    break;
                }
                out.add(in.get(i));
            }
            if (posOther >= 0) {
                NETFile.findRoadNetworks(in, posOther, out);
            }
        }
    }

    private static void analyseRoadsOfCityLarge(List<LabeledRoadDef> in, List<LabeledRoadDef> out) {
        in.sort(Comparator.comparingInt(lr -> ((LabeledRoadDef)lr).roadDef.getStartSubdivNumber()));
        int lastDiv = 0;
        ArrayList<LabeledRoadDef> dupes = new ArrayList<LabeledRoadDef>();
        for (LabeledRoadDef lrd : in) {
            int sd = lrd.roadDef.getStartSubdivNumber();
            if (sd != lastDiv) {
                NETFile.analyseRoadsOfCitySmall(dupes, out);
                dupes.clear();
                lastDiv = sd;
            }
            dupes.add(lrd);
        }
        NETFile.analyseRoadsOfCitySmall(dupes, out);
    }

    private static boolean needed(LabeledRoadDef lr) {
        return lr.roadDef.hasHouseNumbers() || lr.roadDef.getCities().size() > 1;
    }

    private static void findRoadNetworks(List<LabeledRoadDef> in, int posOther, List<LabeledRoadDef> out) {
        boolean done;
        int inSize = in.size();
        int[] groups = new int[inSize];
        for (int i = 0; i < groups.length; ++i) {
            groups[i] = i;
        }
        BitSet unconnected = new BitSet(inSize * inSize);
        do {
            done = true;
            for (int current = 0; current < groups.length; ++current) {
                RoadDef first = in.get(current).roadDef;
                for (int i = current + 1; i < groups.length; ++i) {
                    if (groups[current] == groups[i] || unconnected.get(current * inSize + i)) continue;
                    if (first.connectedTo(in.get(i).roadDef)) {
                        groups[current] = groups[i] = Math.min(groups[current], groups[i]);
                        done = false;
                        continue;
                    }
                    unconnected.set(current * inSize + i);
                }
            }
        } while (!done);
        int last = posOther - 1;
        for (int i = posOther; i < groups.length; ++i) {
            if (groups[i] <= last) continue;
            LabeledRoadDef lrd = in.get(i);
            out.add(lrd);
            last = groups[i];
        }
    }

    public void setNetwork(List<RoadDef> roads) {
        this.roads = roads;
    }

    public void setSort(Sort sort) {
        this.sort = sort;
    }

    class LabeledRoadDef {
        private final Label label;
        private final RoadDef roadDef;

        LabeledRoadDef(Label label, RoadDef roadDef) {
            this.label = label;
            this.roadDef = roadDef;
        }
    }
}

