/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import uk.me.parabola.imgfmt.Utils;

public class Coord
implements Comparable<Coord> {
    private static final short ON_BOUNDARY_MASK = 1;
    private static final short PRESERVED_MASK = 2;
    private static final short REPLACED_MASK = 4;
    private static final short ADDED_BY_CLIPPER_MASK = 8;
    private static final short SKIP_DEAD_END_CHECK_NODE_MASK = 16;
    private static final short REMOVE_MASK = 32;
    private static final short VIA_NODE_MASK = 64;
    private static final short PART_OF_BAD_ANGLE = 128;
    private static final short PART_OF_SHAPE2 = 256;
    private static final short END_OF_WAY = 512;
    private static final short HOUSENUMBER_NODE = 1024;
    private static final short ADDED_HOUSENUMBER_NODE = 2048;
    private static final short ON_COUNTRY_BORDER = 4096;
    private static final int HIGH_PREC_BITS = 30;
    public static final int DELTA_SHIFT = 6;
    private static final int MAX_DELTA = 16;
    private static final long FACTOR_HP = 0x40000000L;
    private static final int HIGH_PREC_UNUSED_BITS = 2;
    public static final double R = 6378137.0;
    public static final double U = 4.007501668557849E7;
    public static final double MEAN_EARTH_RADIUS = 6371000.0;
    private final int latitude;
    private final int longitude;
    private byte highwayCount;
    private short flags;
    private final byte latDelta;
    private final byte lonDelta;
    private short approxDistanceToDisplayedCoord = (short)-1;
    static final double HIGH_PREC_RAD_FACTOR = 5.8516723170686385E-9;

    public Coord(int latitude, int longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.lonDelta = 0;
        this.latDelta = 0;
    }

    public Coord(double latitude, double longitude) {
        this.latitude = Utils.toMapUnit(latitude);
        this.longitude = Utils.toMapUnit(longitude);
        int latHighPrec = Coord.toHighPrec(latitude);
        int lonHighPrec = Coord.toHighPrec(longitude);
        this.latDelta = (byte)((this.latitude << 6) - latHighPrec);
        this.lonDelta = (byte)((this.longitude << 6) - lonHighPrec);
        assert ((this.latitude << 6) - this.latDelta == latHighPrec);
        assert ((this.longitude << 6) - this.lonDelta == lonHighPrec);
    }

    private Coord(int lat, int lon, byte latDelta, byte lonDelta) {
        this.latitude = lat;
        this.longitude = lon;
        this.latDelta = latDelta;
        this.lonDelta = lonDelta;
    }

    public static Coord makeHighPrecCoord(int latHighPrec, int lonHighPrec) {
        int lat24 = latHighPrec + 32 >> 6;
        int lon24 = lonHighPrec + 32 >> 6;
        byte dLat = (byte)((lat24 << 6) - latHighPrec);
        byte dLon = (byte)((lon24 << 6) - lonHighPrec);
        return new Coord(lat24, lon24, dLat, dLon);
    }

    public static Coord makeHighPrecCoord(int latHp, int lonHp, Long2ObjectOpenHashMap<Coord> coordPool) {
        if (coordPool == null) {
            return Coord.makeHighPrecCoord(latHp, lonHp);
        }
        long key = ((long)latHp & 0xFFFFFFFFL) << 32 | (long)lonHp & 0xFFFFFFFFL;
        Coord p = coordPool.get(key);
        if (p == null) {
            p = Coord.makeHighPrecCoord(latHp, lonHp);
            coordPool.put(key, p);
        }
        return p;
    }

    public Coord(Coord other) {
        this.latitude = other.latitude;
        this.longitude = other.longitude;
        this.latDelta = other.latDelta;
        this.lonDelta = other.lonDelta;
        this.approxDistanceToDisplayedCoord = other.approxDistanceToDisplayedCoord;
    }

    public int getLatitude() {
        return this.latitude;
    }

    public int getLongitude() {
        return this.longitude;
    }

    public int getId() {
        return 0;
    }

    public int getHighwayCount() {
        return this.highwayCount;
    }

    public void incHighwayCount() {
        if (this.highwayCount < 127) {
            this.highwayCount = (byte)(this.highwayCount + 1);
        }
    }

    public void decHighwayCount() {
        if (this.highwayCount > 0) {
            this.highwayCount = (byte)(this.highwayCount - 1);
        }
    }

    public void resetHighwayCount() {
        this.highwayCount = 0;
    }

    public boolean getOnBoundary() {
        return (this.flags & 1) != 0;
    }

    public void setOnBoundary(boolean onBoundary) {
        this.flags = onBoundary ? (short)(this.flags | 1) : (short)(this.flags & 0xFFFFFFFE);
    }

    public boolean preserved() {
        return (this.flags & 2) != 0;
    }

    public void preserved(boolean preserved) {
        this.flags = preserved ? (short)(this.flags | 2) : (short)(this.flags & 0xFFFFFFFD);
    }

    public boolean isReplaced() {
        return (this.flags & 4) != 0;
    }

    public void setReplaced(boolean replaced) {
        this.flags = replaced ? (short)(this.flags | 4) : (short)(this.flags & 0xFFFFFFFB);
    }

    public boolean isAddedByClipper() {
        return (this.flags & 8) != 0;
    }

    public void setAddedByClipper(boolean b) {
        this.flags = b ? (short)(this.flags | 8) : (short)(this.flags & 0xFFFFFFF7);
    }

    public boolean isSkipDeadEndCheck() {
        return (this.flags & 0x10) != 0;
    }

    public void setSkipDeadEndCheck(boolean b) {
        this.flags = b ? (short)(this.flags | 0x10) : (short)(this.flags & 0xFFFFFFEF);
    }

    public boolean isToRemove() {
        return (this.flags & 0x20) != 0;
    }

    public void setRemove(boolean b) {
        this.flags = b ? (short)(this.flags | 0x20) : (short)(this.flags & 0xFFFFFFDF);
    }

    public boolean isViaNodeOfRestriction() {
        return (this.flags & 0x40) != 0;
    }

    public void setViaNodeOfRestriction(boolean b) {
        this.flags = b ? (short)(this.flags | 0x40) : (short)(this.flags & 0xFFFFFFBF);
    }

    public boolean isPartOfBadAngle() {
        return (this.flags & 0x80) != 0;
    }

    public void setPartOfBadAngle(boolean b) {
        this.flags = b ? (short)(this.flags | 0x80) : (short)(this.flags & 0xFFFFFF7F);
    }

    public boolean isPartOfShape2() {
        return (this.flags & 0x100) != 0;
    }

    public void setPartOfShape2(boolean b) {
        this.flags = b ? (short)(this.flags | 0x100) : (short)(this.flags & 0xFFFFFEFF);
    }

    public boolean isEndOfWay() {
        return (this.flags & 0x200) != 0;
    }

    public void setEndOfWay(boolean b) {
        this.flags = b ? (short)(this.flags | 0x200) : (short)(this.flags & 0xFFFFFDFF);
    }

    public boolean isNumberNode() {
        return (this.flags & 0x400) != 0;
    }

    public void setNumberNode(boolean b) {
        this.flags = b ? (short)(this.flags | 0x400) : (short)(this.flags & 0xFFFFFBFF);
    }

    public boolean isAddedNumberNode() {
        return (this.flags & 0x800) != 0;
    }

    public void setAddedNumberNode(boolean b) {
        this.flags = b ? (short)(this.flags | 0x800) : (short)(this.flags & 0xFFFFF7FF);
    }

    public boolean getOnCountryBorder() {
        return (this.flags & 0x1000) != 0;
    }

    public void setOnCountryBorder(boolean onCountryBorder) {
        this.flags = onCountryBorder ? (short)(this.flags | 0x1000) : (short)(this.flags & 0xFFFFEFFF);
    }

    public int hashCode() {
        return 503 * this.latitude + this.longitude;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Coord)) {
            return false;
        }
        Coord other = (Coord)obj;
        return this.latitude == other.latitude && this.longitude == other.longitude;
    }

    public boolean highPrecEquals(Coord other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        return this.getHighPrecLat() == other.getHighPrecLat() && this.getHighPrecLon() == other.getHighPrecLon();
    }

    public double distance(Coord other) {
        double d1 = 111319.49079327358 * Math.sqrt(this.distanceInDegreesSquared(other));
        if (d1 < 10000.0) {
            return d1;
        }
        return this.distanceOnRhumbLine(other);
    }

    public double distanceInDegreesSquared(Coord other) {
        double longDiff;
        if (this == other || this.highPrecEquals(other)) {
            return 0.0;
        }
        double lat1 = this.getLatDegrees();
        double lat2 = other.getLatDegrees();
        double long1 = this.getLonDegrees();
        double long2 = other.getLonDegrees();
        double latDiff = lat1 < lat2 ? lat2 - lat1 : lat1 - lat2;
        if (latDiff > 90.0) {
            latDiff -= 180.0;
        }
        if ((longDiff = long1 < long2 ? long2 - long1 : long1 - long2) > 180.0) {
            longDiff -= 360.0;
        }
        return latDiff * latDiff + (longDiff *= Math.cos(Math.PI / 180 * Math.abs((lat1 + lat2) / 2.0))) * longDiff;
    }

    public double distanceHaversine(Coord point) {
        double lat1 = Coord.hpToRadians(this.getHighPrecLat());
        double lat2 = Coord.hpToRadians(point.getHighPrecLat());
        double lon1 = Coord.hpToRadians(this.getHighPrecLon());
        double lon2 = Coord.hpToRadians(point.getHighPrecLon());
        double sinMidLat = Math.sin((lat1 - lat2) / 2.0);
        double sinMidLon = Math.sin((lon1 - lon2) / 2.0);
        double dRad = 2.0 * Math.asin(Math.sqrt(sinMidLat * sinMidLat + Math.cos(lat1) * Math.cos(lat2) * sinMidLon * sinMidLon));
        return dRad * 6378137.0;
    }

    public double distanceOnRhumbLine(Coord point) {
        double deltaPhi;
        double lat1 = Coord.hpToRadians(this.getHighPrecLat());
        double lat2 = Coord.hpToRadians(point.getHighPrecLat());
        double lon1 = Coord.hpToRadians(this.getHighPrecLon());
        double lon2 = Coord.hpToRadians(point.getHighPrecLon());
        double dLat = lat2 - lat1;
        double dLon = Math.abs(lon2 - lon1);
        if (Math.abs(dLon) > Math.PI) {
            dLon = dLon > 0.0 ? -(Math.PI * 2 - dLon) : Math.PI * 2 + dLon;
        }
        double q = Math.abs(deltaPhi = Math.log(Math.tan(lat2 / 2.0 + 0.7853981633974483) / Math.tan(lat1 / 2.0 + 0.7853981633974483))) > 1.0E-11 ? dLat / deltaPhi : Math.cos(lat1);
        double distRad = Math.sqrt(dLat * dLat + q * q * dLon * dLon);
        return distRad * 6378137.0;
    }

    public long distanceInHighPrecSquared(Coord other) {
        int dLatHp = other.getHighPrecLat() - this.getHighPrecLat();
        int dLonHp = other.getHighPrecLon() - this.getHighPrecLon();
        dLonHp = dLonHp << 2 >> 2;
        return (long)dLatHp * (long)dLatHp + (long)dLonHp * (long)dLonHp;
    }

    public Coord makeBetweenPoint(Coord other, double fraction) {
        int dlatHp = other.getHighPrecLat() - this.getHighPrecLat();
        int dlonHp = other.getHighPrecLon() - this.getHighPrecLon();
        if (dlonHp == 0 || Math.abs(dlatHp) < 1000000 && Math.abs(dlonHp) < 1000000) {
            int latHighPrec = (int)Math.round((double)this.getHighPrecLat() + (double)dlatHp * fraction);
            int lonHighPrec = (int)Math.round((double)this.getHighPrecLon() + (double)dlonHp * fraction);
            return Coord.makeHighPrecCoord(latHighPrec, lonHighPrec);
        }
        double brng = this.bearingToOnRhumbLine(other, true);
        double dist = this.distance(other) * fraction;
        return this.destOnRhumbLine(dist, brng);
    }

    public double bearingTo(Coord point) {
        return this.bearingToOnRhumbLine(point, false);
    }

    public double bearingToOnGreatCircle(Coord point, boolean needHighPrec) {
        double lat1 = Coord.hpToRadians(this.getHighPrecLat());
        double lat2 = Coord.hpToRadians(point.getHighPrecLat());
        double lon1 = Coord.hpToRadians(this.getHighPrecLon());
        double lon2 = Coord.hpToRadians(point.getHighPrecLon());
        double dlon = lon2 - lon1;
        double y = Math.sin(dlon) * Math.cos(lat2);
        double x = Math.cos(lat1) * Math.sin(lat2) - Math.sin(lat1) * Math.cos(lat2) * Math.cos(dlon);
        double brngRad = needHighPrec ? Math.atan2(y, x) : Utils.atan2_approximation(y, x);
        return brngRad * 180.0 / Math.PI;
    }

    public double bearingToOnRhumbLine(Coord point, boolean needHighPrec) {
        double lat1 = Coord.hpToRadians(this.getHighPrecLat());
        double lat2 = Coord.hpToRadians(point.getHighPrecLat());
        double lon1 = Coord.hpToRadians(this.getHighPrecLon());
        double lon2 = Coord.hpToRadians(point.getHighPrecLon());
        double dLon = lon2 - lon1;
        if (Math.abs(dLon) > Math.PI) {
            dLon = dLon > 0.0 ? -(Math.PI * 2 - dLon) : Math.PI * 2 + dLon;
        }
        double deltaPhi = Math.log(Math.tan(lat2 / 2.0 + 0.7853981633974483) / Math.tan(lat1 / 2.0 + 0.7853981633974483));
        double brngRad = needHighPrec ? Math.atan2(dLon, deltaPhi) : Utils.atan2_approximation(dLon, deltaPhi);
        return brngRad * 180.0 / Math.PI;
    }

    @Override
    public int compareTo(Coord other) {
        if (this.longitude == other.getLongitude()) {
            if (this.latitude == other.getLatitude()) {
                return 0;
            }
            return this.latitude > other.getLatitude() ? 1 : -1;
        }
        return this.longitude > other.getLongitude() ? 1 : -1;
    }

    public String toString() {
        return String.format(Locale.ENGLISH, "%.6f,%.6f", this.getLatDegrees(), this.getLonDegrees());
    }

    public String toGarminString() {
        return this.latitude + "/" + this.longitude;
    }

    protected String toOSMURL(int zoom) {
        return "http://www.openstreetmap.org/?mlat=" + String.format(Locale.ENGLISH, "%.6f", this.getLatDegrees()) + "&mlon=" + String.format(Locale.ENGLISH, "%.6f", this.getLonDegrees()) + "&zoom=" + zoom;
    }

    public String toOSMURL() {
        return this.toOSMURL(17);
    }

    private static int toHighPrec(double degrees) {
        double DELTA = 360.0;
        double RESCALE = 2982616.177777778;
        int UNDO360 = 0x40000000;
        return (int)((degrees + 360.0) * 2982616.177777778) - 0x40000000;
    }

    public static double hpToRadians(int valHighPrec) {
        return 5.8516723170686385E-9 * (double)valHighPrec;
    }

    public int getHighPrecLat() {
        return (this.latitude << 6) - this.latDelta;
    }

    public int getHighPrecLon() {
        return (this.longitude << 6) - this.lonDelta;
    }

    public double getLatDegrees() {
        return 3.3527612686157227E-7 * (double)this.getHighPrecLat();
    }

    public double getLonDegrees() {
        return 3.3527612686157227E-7 * (double)this.getHighPrecLon();
    }

    public Coord getDisplayedCoord() {
        return new Coord(this.latitude, this.longitude);
    }

    public boolean hasAlternativePos() {
        if (this.getOnBoundary() || this.getOnCountryBorder()) {
            return false;
        }
        return Math.abs(this.latDelta) > 16 || Math.abs(this.lonDelta) > 16;
    }

    public List<Coord> getAlternativePositions() {
        ArrayList<Coord> list = new ArrayList<Coord>();
        if (this.getOnBoundary() || this.getOnCountryBorder()) {
            return list;
        }
        int modLatDelta = 0;
        int modLonDelta = 0;
        int modLat = this.latitude;
        int modLon = this.longitude;
        if (this.latDelta > 16) {
            --modLat;
        } else if (this.latDelta < -16) {
            ++modLat;
        }
        if (this.lonDelta > 16) {
            --modLon;
        } else if (this.lonDelta < -16) {
            ++modLon;
        }
        int latHighPrec = this.getHighPrecLat();
        int lonHighPrec = this.getHighPrecLon();
        modLatDelta = (modLat << 6) - latHighPrec;
        modLonDelta = (modLon << 6) - lonHighPrec;
        assert (modLatDelta >= -128 && modLatDelta <= 127);
        assert (modLonDelta >= -128 && modLonDelta <= 127);
        if (modLat != this.latitude) {
            if (modLon != this.longitude) {
                list.add(new Coord(modLat, modLon, (byte)modLatDelta, (byte)modLonDelta));
            }
            list.add(new Coord(modLat, this.longitude, (byte)modLatDelta, this.lonDelta));
        }
        if (modLon != this.longitude) {
            list.add(new Coord(this.latitude, modLon, this.latDelta, (byte)modLonDelta));
        }
        return list;
    }

    public short getDistToDisplayedPoint() {
        if (this.approxDistanceToDisplayedCoord < 0) {
            this.approxDistanceToDisplayedCoord = (short)Math.round(this.getDisplayedCoord().distance(this) * 100.0);
        }
        return this.approxDistanceToDisplayedCoord;
    }

    public Coord destOnRhumbLine(double dist, double brng) {
        double lon2;
        double distRad = dist / 6378137.0;
        double lat1 = Coord.hpToRadians(this.getHighPrecLat());
        double lon1 = Coord.hpToRadians(this.getHighPrecLon());
        double brngRad = Math.toRadians(brng);
        double deltaLat = distRad * Math.cos(brngRad);
        double lat2 = lat1 + deltaLat;
        if (Math.abs(lat2) > 1.5707963267948966) {
            double d = lat2 = lat2 > 0.0 ? Math.PI - lat2 : -Math.PI - lat2;
        }
        if (this.getLongitude() == 0x800000 && brng == 0.0) {
            lon2 = lon1;
        } else {
            double deltaPhi = Math.log(Math.tan(lat2 / 2.0 + 0.7853981633974483) / Math.tan(lat1 / 2.0 + 0.7853981633974483));
            double q = Math.abs(deltaPhi) > 1.0E-11 ? deltaLat / deltaPhi : Math.cos(lat1);
            double deltaLon = distRad * Math.sin(brngRad) / q;
            lon2 = lon1 + deltaLon;
            lon2 = (lon2 + Math.PI * 3) % (Math.PI * 2) - Math.PI;
        }
        return new Coord(Math.toDegrees(lat2), Math.toDegrees(lon2));
    }

    public double distToLineSegment(Coord a, Coord b) {
        double dist;
        double ab = a.distance(b);
        double ap = a.distance(this);
        if (ab == 0.0) {
            return ap;
        }
        double bp = b.distance(this);
        if (ap == 0.0 || bp == 0.0) {
            return 0.0;
        }
        double abpa = (ab + ap + bp) / 2.0;
        double dx = abpa - ab;
        if (dx < 0.0) {
            double b_ab = a.bearingToOnRhumbLine(b, true);
            Coord x = a.destOnRhumbLine(ap, b_ab);
            dist = x.distance(this);
        } else {
            dist = 2.0 * Math.sqrt(abpa * (abpa - ab) * (abpa - ap) * (abpa - bp)) / ab;
        }
        return dist;
    }

    public double shortestDistToLineSegment(Coord a, Coord b) {
        double frac;
        int aLon = a.getHighPrecLon();
        int bLon = b.getHighPrecLon();
        int aLat = a.getHighPrecLat();
        int bLat = b.getHighPrecLat();
        double deltaLon = bLon - aLon;
        double deltaLat = bLat - aLat;
        if (deltaLon == 0.0 && deltaLat == 0.0) {
            frac = 0.0;
        } else {
            int pLon = this.getHighPrecLon();
            int pLat = this.getHighPrecLat();
            double scale = Math.cos(Coord.hpToRadians((aLat + bLat + pLat) / 3));
            deltaLon = scale * deltaLon;
            if (deltaLon == 0.0 && deltaLat == 0.0) {
                frac = 0.0;
            } else {
                double deltaLonAP = scale * (double)(pLon - aLon);
                frac = (deltaLonAP * deltaLon + (double)(pLat - aLat) * deltaLat) / (deltaLon * deltaLon + deltaLat * deltaLat);
            }
        }
        double distance = frac <= 0.0 ? a.distance(this) : (frac >= 1.0 ? b.distance(this) : this.distToLineSegment(a, b));
        return distance;
    }

    public Coord offset(double bearingInDegrees, double distanceInMetres) {
        double bearing = Math.toRadians(bearingInDegrees);
        double angularDistance = distanceInMetres / 6371000.0;
        double lat = Math.toRadians(this.getLatDegrees());
        double lon = Math.toRadians(this.getLonDegrees());
        double newLat = Math.asin(Math.sin(lat) * Math.cos(angularDistance) + Math.cos(lat) * Math.sin(angularDistance) * Math.cos(bearing));
        double newLon = lon + Math.atan2(Math.sin(bearing) * Math.sin(angularDistance) * Math.cos(lat), Math.cos(angularDistance) - Math.sin(lat) * Math.sin(newLat));
        return new Coord(Math.toDegrees(newLat), Math.toDegrees(newLon));
    }

    public long isLeft(Coord p1, Coord p2) {
        long p1Lat = p1.getHighPrecLat();
        long p1Lon = p1.getHighPrecLon();
        return ((long)p2.getHighPrecLon() - p1Lon) * ((long)this.getHighPrecLat() - p1Lat) - ((long)p2.getHighPrecLat() - p1Lat) * ((long)this.getHighPrecLon() - p1Lon);
    }
}

