/*
 * Decompiled with CFR 0.152.
 */
package tornadofx.skin.tablerow;

import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableRow;
import javafx.scene.control.skin.TableRowSkin;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Polygon;
import tornadofx.TableViewEditModel;

public final class DirtyDecoratingTableRowSkin<T>
extends TableRowSkin<T> {
    private static final String KEY = "tornadofx.dirtyStatePolygon";
    private final TableViewEditModel<T> editModel;

    public DirtyDecoratingTableRowSkin(TableRow<T> tableRow, TableViewEditModel<T> editModel) {
        super(tableRow);
        this.editModel = editModel;
    }

    private Polygon getPolygon(TableCell cell) {
        ObservableMap properties2 = cell.getProperties();
        return (Polygon)properties2.computeIfAbsent((Object)KEY, x -> {
            Polygon polygon2 = new Polygon(new double[]{0.0, 0.0, 0.0, 10.0, 10.0, 0.0});
            polygon2.setFill((Paint)Color.BLUE);
            return polygon2;
        });
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        super.layoutChildren(x, y, w, h);
        ObservableList children = this.getChildren();
        children.forEach(child -> {
            boolean isDirty;
            TableCell cell = (TableCell)child;
            Object item2 = null;
            if (cell.getIndex() > -1 && cell.getTableView().getItems().size() > cell.getIndex()) {
                item2 = cell.getTableView().getItems().get(cell.getIndex());
            }
            Polygon polygon2 = this.getPolygon(cell);
            boolean bl = isDirty = item2 != null && this.editModel.getDirtyState(item2).isDirtyColumn(cell.getTableColumn());
            if (isDirty) {
                if (!children.contains((Object)polygon2)) {
                    children.add((Object)polygon2);
                }
                polygon2.relocate(cell.getLayoutX(), y);
            } else {
                children.remove((Object)polygon2);
            }
        });
    }
}

