/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.atlas.core.util;

import com.netflix.atlas.core.util.Hash$;
import com.netflix.atlas.core.util.IntIntHashMap$;
import com.netflix.atlas.core.util.PrimeFinder;
import java.io.Serializable;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.collection.immutable.Map;
import scala.collection.mutable.Builder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0005\u0005Ua\u0001B\f\u0019\u0001\rB\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\t]\u0001\u0011\t\u0011)A\u0005W!)q\u0006\u0001C\u0001a!1Q\u0007\u0001Q!\nYBa!\u000f\u0001!B\u00131\u0004B\u0002\u001e\u0001A\u0003&1\u0006\u0003\u0004<\u0001\u0001\u0006Ka\u000b\u0005\u0006y\u0001!I!\u0010\u0005\u0006\u0001\u0002!I!\u0011\u0005\u0006\u0007\u0002!I\u0001\u0012\u0005\u0006\u0011\u0002!I!\u0013\u0005\u0006\u0011\u0002!\t!\u0016\u0005\u00061\u0002!\t!\u0017\u0005\u0006;\u0002!\tA\u0018\u0005\u0006;\u0002!\t\u0001\u0019\u0005\u0006I\u0002!\t!\u001a\u0005\u0006W\u0002!\t\u0001\u001c\u0005\u0006[\u0002!\tA\\\u0004\bub\t\t\u0011#\u0001|\r\u001d9\u0002$!A\t\u0002qDQa\f\u000b\u0005\u0002uDqA \u000b\u0012\u0002\u0013\u0005qPA\u0007J]RLe\u000e\u001e%bg\"l\u0015\r\u001d\u0006\u00033i\tA!\u001e;jY*\u00111\u0004H\u0001\u0005G>\u0014XM\u0003\u0002\u001e=\u0005)\u0011\r\u001e7bg*\u0011q\u0004I\u0001\b]\u0016$h\r\\5y\u0015\u0005\t\u0013aA2p[\u000e\u00011C\u0001\u0001%!\t)\u0003&D\u0001'\u0015\u00059\u0013!B:dC2\f\u0017BA\u0015'\u0005\u0019\te.\u001f*fM\u00061an\u001c#bi\u0006\u0004\"!\n\u0017\n\u000552#aA%oi\u0006A1-\u00199bG&$\u00180\u0001\u0004=S:LGO\u0010\u000b\u0004cM\"\u0004C\u0001\u001a\u0001\u001b\u0005A\u0002\"\u0002\u0016\u0004\u0001\u0004Y\u0003b\u0002\u0018\u0004!\u0003\u0005\raK\u0001\u0005W\u0016L8\u000fE\u0002&o-J!\u0001\u000f\u0014\u0003\u000b\u0005\u0013(/Y=\u0002\rY\fG.^3t\u0003\u0011)8/\u001a3\u0002\r\r,Ho\u001c4g\u00035\u0019w.\u001c9vi\u0016\u001cU\u000f^8gMR\u00111F\u0010\u0005\u0006\u007f!\u0001\raK\u0001\u0002]\u0006Aa.Z<BeJ\f\u0017\u0010\u0006\u00027\u0005\")q(\u0003a\u0001W\u00051!/Z:ju\u0016$\u0012!\u0012\t\u0003K\u0019K!a\u0012\u0014\u0003\tUs\u0017\u000e^\u0001\u0004aV$H#\u0002&N\u001fF\u001b\u0006CA\u0013L\u0013\taeEA\u0004C_>dW-\u00198\t\u000b9[\u0001\u0019\u0001\u001c\u0002\u0005-\u001c\b\"\u0002)\f\u0001\u00041\u0014A\u0001<t\u0011\u0015\u00116\u00021\u0001,\u0003\u0005Y\u0007\"\u0002+\f\u0001\u0004Y\u0013!\u0001<\u0015\u0007\u00153v\u000bC\u0003S\u0019\u0001\u00071\u0006C\u0003U\u0019\u0001\u00071&A\u0002hKR$2a\u000b.\\\u0011\u0015\u0011V\u00021\u0001,\u0011\u0015aV\u00021\u0001,\u0003\u0011!g\r\u001c;\u0002\u0013%t7M]3nK:$HCA#`\u0011\u0015\u0011f\u00021\u0001,)\r)\u0015M\u0019\u0005\u0006%>\u0001\ra\u000b\u0005\u0006G>\u0001\raK\u0001\u0007C6|WO\u001c;\u0002\u000f\u0019|'/Z1dQR\u0011QI\u001a\u0005\u0006OB\u0001\r\u0001[\u0001\u0002MB)Q%[\u0016,\u000b&\u0011!N\n\u0002\n\rVt7\r^5p]J\nAa]5{KV\t1&A\u0003u_6\u000b\u0007/F\u0001p!\u0011\u0001xoK\u0016\u000f\u0005E,\bC\u0001:'\u001b\u0005\u0019(B\u0001;#\u0003\u0019a$o\\8u}%\u0011aOJ\u0001\u0007!J,G-\u001a4\n\u0005aL(aA'ba*\u0011aOJ\u0001\u000e\u0013:$\u0018J\u001c;ICNDW*\u00199\u0011\u0005I\"2C\u0001\u000b%)\u0005Y\u0018a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'\u0006\u0002\u0002\u0002)\u001a1&a\u0001,\u0005\u0005\u0015\u0001\u0003BA\u0004\u0003#i!!!\u0003\u000b\t\u0005-\u0011QB\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0004'\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003'\tIAA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class IntIntHashMap {
    private final int noData;
    private int[] keys;
    private int[] values;
    private int used;
    private int cutoff;

    public static int $lessinit$greater$default$2() {
        return IntIntHashMap$.MODULE$.$lessinit$greater$default$2();
    }

    private int computeCutoff(int n) {
        return package$.MODULE$.max(3, n / 2);
    }

    /*
     * WARNING - void declaration
     */
    private int[] newArray(int n) {
        void var2_2;
        int[] tmp = new int[PrimeFinder.nextPrime(n)];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = this.noData;
        }
        return var2_2;
    }

    private void resize() {
        int[] tmpKS = this.newArray(this.keys.length * 2);
        int[] tmpVS = new int[tmpKS.length];
        for (int i = 0; i < this.keys.length; ++i) {
            int k = this.keys[i];
            Object object = k != this.noData ? BoxesRunTime.boxToBoolean((boolean)this.put(tmpKS, tmpVS, k, this.values[i])) : BoxedUnit.UNIT;
        }
        this.keys = tmpKS;
        this.values = tmpVS;
        this.cutoff = this.computeCutoff(tmpKS.length);
    }

    private boolean put(int[] ks, int[] vs, int k, int v) {
        int pos = Hash$.MODULE$.absOrZero(k) % ks.length;
        int posV = ks[pos];
        while (posV != this.noData && posV != k) {
            pos = (pos + 1) % ks.length;
            posV = ks[pos];
        }
        ks[pos] = k;
        vs[pos] = v;
        return posV == this.noData;
    }

    public void put(int k, int v) {
        block1: {
            if (this.used >= this.cutoff) {
                this.resize();
            }
            if (!this.put(this.keys, this.values, k, v)) break block1;
            ++this.used;
        }
    }

    public int get(int k, int dflt) {
        int pos = Hash$.MODULE$.absOrZero(k) % this.keys.length;
        int prev;
        while ((prev = this.keys[pos]) != this.noData) {
            if (prev == k) {
                return this.values[pos];
            }
            pos = (pos + 1) % this.keys.length;
        }
        return dflt;
    }

    public void increment(int k) {
        this.increment(k, 1);
    }

    public void increment(int k, int amount) {
        block2: {
            if (this.used >= this.cutoff) {
                this.resize();
            }
            int pos = Hash$.MODULE$.absOrZero(k) % this.keys.length;
            int prev = this.keys[pos];
            while (prev != this.noData && prev != k) {
                pos = (pos + 1) % this.keys.length;
                prev = this.keys[pos];
            }
            this.keys[pos] = k;
            int[] nArray = this.values;
            int n = pos;
            nArray[n] = nArray[n] + amount;
            if (prev != this.noData) break block2;
            ++this.used;
        }
    }

    public void foreach(Function2<Object, Object, BoxedUnit> f) {
        for (int i = 0; i < this.keys.length; ++i) {
            int k = this.keys[i];
            if (k == this.noData) continue;
            f.apply$mcVII$sp(k, this.values[i]);
        }
    }

    public int size() {
        return this.used;
    }

    public Map<Object, Object> toMap() {
        Builder builder = Predef$.MODULE$.Map().newBuilder();
        this.foreach((Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable)(k, v) -> builder.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k)), (Object)BoxesRunTime.boxToInteger((int)v))));
        return (Map)builder.result();
    }

    public IntIntHashMap(int noData, int capacity) {
        this.noData = noData;
        this.keys = this.newArray(capacity);
        this.values = new int[this.keys.length];
        this.used = 0;
        this.cutoff = this.computeCutoff(this.keys.length);
    }
}

