/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.atlas.core.util;

import com.netflix.atlas.core.util.InternMap;
import java.io.Serializable;
import java.util.concurrent.locks.ReentrantLock;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005Y4A!\u0004\b\u00013!AQ\u0006\u0001B\u0001J\u0003%a\u0006\u0003\u00052\u0001\t\u0005\t\u0015!\u00033\u0011\u0015)\u0004\u0001\"\u00017\u0011\u001dQ\u0004A1A\u0005\nmBaa\u0010\u0001!\u0002\u0013a\u0004b\u0002!\u0001\u0005\u0004%I!\u0011\u0005\u0007\u001b\u0002\u0001\u000b\u0011\u0002\"\t\u000b9\u0003A\u0011B(\t\u000bI\u0003A\u0011B*\t\u000b\r\u0004A\u0011\u00013\t\u000b\u001d\u0004A\u0011\u00015\t\u000bQ\u0004A\u0011A;\u0003'\r{gnY;se\u0016tG/\u00138uKJtW*\u00199\u000b\u0005=\u0001\u0012\u0001B;uS2T!!\u0005\n\u0002\t\r|'/\u001a\u0006\u0003'Q\tQ!\u0019;mCNT!!\u0006\f\u0002\u000f9,GO\u001a7jq*\tq#A\u0002d_6\u001c\u0001!\u0006\u0002\u001bOM\u0019\u0001aG\u0011\u0011\u0005qyR\"A\u000f\u000b\u0003y\tQa]2bY\u0006L!\u0001I\u000f\u0003\r\u0005s\u0017PU3g!\r\u00113%J\u0007\u0002\u001d%\u0011AE\u0004\u0002\n\u0013:$XM\u001d8NCB\u0004\"AJ\u0014\r\u0001\u0011)\u0001\u0006\u0001b\u0001S\t\t1*\u0005\u0002+7A\u0011AdK\u0005\u0003Yu\u0011qAT8uQ&tw-\u0001\u0004oK^l\u0015\r\u001d\t\u00049=\n\u0013B\u0001\u0019\u001e\u0005!a$-\u001f8b[\u0016t\u0014\u0001E2p]\u000e,(O]3oGfdUM^3m!\ta2'\u0003\u00025;\t\u0019\u0011J\u001c;\u0002\rqJg.\u001b;?)\r9\u0004(\u000f\t\u0004E\u0001)\u0003BB\u0017\u0004\t\u0003\u0007a\u0006C\u00032\u0007\u0001\u0007!'\u0001\u0005tK\u001elWM\u001c;t+\u0005a\u0004c\u0001\u000f>C%\u0011a(\b\u0002\u0006\u0003J\u0014\u0018-_\u0001\ng\u0016<W.\u001a8ug\u0002\nQ\u0001\\8dWN,\u0012A\u0011\t\u00049u\u001a\u0005C\u0001#L\u001b\u0005)%B\u0001!G\u0015\t9\u0005*\u0001\u0006d_:\u001cWO\u001d:f]RT!aD%\u000b\u0003)\u000bAA[1wC&\u0011A*\u0012\u0002\u000e%\u0016,g\u000e\u001e:b]RdunY6\u0002\r1|7m[:!\u0003\u0015Ig\u000eZ3y)\t\u0011\u0004\u000bC\u0003R\u0011\u0001\u0007Q%A\u0002lKf\fA\u0001\\8dWV\u0011Ak\u0016\u000b\u0003+\n$\"AV/\u0011\u0005\u0019:F!\u0002-\n\u0005\u0004I&!\u0001*\u0012\u0005)R\u0006C\u0001\u000f\\\u0013\taVDA\u0002B]fDQAX\u0005A\u0002}\u000b\u0011A\u001a\t\u00059\u0001\fc+\u0003\u0002b;\tIa)\u001e8di&|g.\r\u0005\u0006#&\u0001\r!J\u0001\u0007S:$XM\u001d8\u0015\u0005\u0015*\u0007\"\u00024\u000b\u0001\u0004)\u0013!A6\u0002\rI,G/Y5o)\tIG\u000e\u0005\u0002\u001dU&\u00111.\b\u0002\u0005+:LG\u000fC\u0003_\u0017\u0001\u0007Q\u000e\u0005\u0003\u001dA:\f\bC\u0001\u000fp\u0013\t\u0001XD\u0001\u0003M_:<\u0007C\u0001\u000fs\u0013\t\u0019XDA\u0004C_>dW-\u00198\u0002\tML'0Z\u000b\u0002e\u0001")
public class ConcurrentInternMap<K>
implements InternMap<K> {
    private final Function0<InternMap<K>> newMap;
    private final int concurrencyLevel;
    private final InternMap<K>[] segments;
    private final ReentrantLock[] locks;

    private InternMap<K>[] segments() {
        return this.segments;
    }

    private ReentrantLock[] locks() {
        return this.locks;
    }

    /*
     * WARNING - void declaration
     */
    private int index(K key) {
        void var3_3;
        int k = key.hashCode();
        int i = k % this.concurrencyLevel;
        return i < 0 ? -1 * i : var3_3;
    }

    private <R> R lock(K key, Function1<InternMap<K>, R> f) {
        Object object;
        int i = this.index(key);
        this.locks()[i].lock();
        try {
            object = f.apply(this.segments()[i]);
        }
        finally {
            this.locks()[i].unlock();
        }
        return (R)object;
    }

    @Override
    public K intern(K k) {
        return (K)this.lock(k, (Function1 & Serializable)m -> m.intern(k));
    }

    @Override
    public void retain(Function1<Object, Object> f) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.concurrencyLevel).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            this.locks()[i].lock();
            try {
                this.segments()[i].retain(f);
            }
            finally {
                this.locks()[i].unlock();
            }
        });
    }

    @Override
    public int size() {
        IntRef totalSize = IntRef.create((int)0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.concurrencyLevel).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            this.locks()[i].lock();
            try {
                totalSize$1.elem += this.segments()[i].size();
            }
            finally {
                this.locks()[i].unlock();
            }
        });
        return totalSize.elem;
    }

    public ConcurrentInternMap(Function0<InternMap<K>> newMap, int concurrencyLevel) {
        this.newMap = newMap;
        this.concurrencyLevel = concurrencyLevel;
        this.segments = new InternMap[concurrencyLevel];
        this.locks = new ReentrantLock[concurrencyLevel];
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), concurrencyLevel).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            $this.segments()[i] = (InternMap)$this.newMap.apply();
            $this.locks()[i] = new ReentrantLock();
        });
    }
}

